package software.amazon.awscdk.services.ec2;

/**
 * This creates a linux bastion host you can use to connect to other instances or services in your VPC.
 * <p>
 * The recommended way to connect to the bastion host is by using AWS Systems Manager Session Manager.
 * <p>
 * The operating system is Amazon Linux 2 with the latest SSM agent installed
 * <p>
 * You can also configure this bastion host to allow connections via SSH
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.8.0 (build 4a047ac)", date = "2020-07-07T13:18:17.008Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.BastionHostLinux")
public class BastionHostLinux extends software.amazon.awscdk.core.Construct implements software.amazon.awscdk.services.ec2.IInstance {

    protected BastionHostLinux(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BastionHostLinux(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * EXPERIMENTAL
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public BastionHostLinux(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.BastionHostLinuxProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Allow SSH access from the given peer or peers.
     * <p>
     * Necessary if you want to connect to the instance using ssh. If not
     * called, you should use SSM Session Manager to connect to the instance.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param peer This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void allowSshAccessFrom(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer... peer) {
        this.jsiiCall("allowSshAccessFrom", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(peer).toArray(Object[]::new));
    }

    /**
     * Allows specify security group connections for the instance.
     * <p>
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return this.jsiiGet("connections", software.amazon.awscdk.services.ec2.Connections.class);
    }

    /**
     * The principal to grant permissions to.
     * <p>
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return this.jsiiGet("grantPrincipal", software.amazon.awscdk.services.iam.IPrincipal.class);
    }

    /**
     * The underlying instance resource.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Instance getInstance() {
        return this.jsiiGet("instance", software.amazon.awscdk.services.ec2.Instance.class);
    }

    /**
     * The availability zone the instance was launched in.
     * <p>
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstanceAvailabilityZone() {
        return this.jsiiGet("instanceAvailabilityZone", java.lang.String.class);
    }

    /**
     * The instance's ID.
     * <p>
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstanceId() {
        return this.jsiiGet("instanceId", java.lang.String.class);
    }

    /**
     * Private DNS name for this instance.
     * <p>
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstancePrivateDnsName() {
        return this.jsiiGet("instancePrivateDnsName", java.lang.String.class);
    }

    /**
     * Private IP for this instance.
     * <p>
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstancePrivateIp() {
        return this.jsiiGet("instancePrivateIp", java.lang.String.class);
    }

    /**
     * Publicly-routable DNS name for this instance.
     * <p>
     * (May be an empty string if the instance does not have a public name).
     * <p>
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstancePublicDnsName() {
        return this.jsiiGet("instancePublicDnsName", java.lang.String.class);
    }

    /**
     * Publicly-routable IP  address for this instance.
     * <p>
     * (May be an empty string if the instance does not have a public IP).
     * <p>
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstancePublicIp() {
        return this.jsiiGet("instancePublicIp", java.lang.String.class);
    }

    /**
     * The IAM role assumed by the instance.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getRole() {
        return this.jsiiGet("role", software.amazon.awscdk.services.iam.IRole.class);
    }

    /**
     * The stack in which this resource is defined.
     * <p>
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack getStack() {
        return this.jsiiGet("stack", software.amazon.awscdk.core.Stack.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.BastionHostLinux}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.BastionHostLinux> {
        /**
         * EXPERIMENTAL
         * <p>
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.BastionHostLinuxProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.BastionHostLinuxProps.Builder();
        }

        /**
         * VPC to launch the instance in.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param vpc VPC to launch the instance in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * In which AZ to place the instance within the VPC.
         * <p>
         * Default: - Random zone.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param availabilityZone In which AZ to place the instance within the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder availabilityZone(final java.lang.String availabilityZone) {
            this.props.availabilityZone(availabilityZone);
            return this;
        }

        /**
         * Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes.
         * <p>
         * Each instance that is launched has an associated root device volume,
         * either an Amazon EBS volume or an instance store volume.
         * You can use block device mappings to specify additional EBS volumes or
         * instance store volumes to attach to an instance when it is launched.
         * <p>
         * Default: - Uses the block device mapping of the AMI
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html
         * @param blockDevices Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder blockDevices(final java.util.List<software.amazon.awscdk.services.ec2.BlockDevice> blockDevices) {
            this.props.blockDevices(blockDevices);
            return this;
        }

        /**
         * The name of the instance.
         * <p>
         * Default: 'BastionHost'
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param instanceName The name of the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceName(final java.lang.String instanceName) {
            this.props.instanceName(instanceName);
            return this;
        }

        /**
         * Type of instance to launch.
         * <p>
         * Default: 't3.nano'
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param instanceType Type of instance to launch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceType(final software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        /**
         * The machine image to use.
         * <p>
         * Default: - An Amazon Linux 2 image which is kept up-to-date automatically (the instance
         * may be replaced on every deployment).
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param machineImage The machine image to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder machineImage(final software.amazon.awscdk.services.ec2.IMachineImage machineImage) {
            this.props.machineImage(machineImage);
            return this;
        }

        /**
         * Security Group to assign to this instance.
         * <p>
         * Default: - create new security group with no inbound and all outbound traffic allowed
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param securityGroup Security Group to assign to this instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder securityGroup(final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        /**
         * Select the subnets to run the bastion host in.
         * <p>
         * Set this to PUBLIC if you need to connect to this instance via the internet and cannot use SSM.
         * You have to allow port 22 manually by using the connections field
         * <p>
         * Default: - private subnets of the supplied VPC
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param subnetSelection Select the subnets to run the bastion host in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder subnetSelection(final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.props.subnetSelection(subnetSelection);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.BastionHostLinux}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.ec2.BastionHostLinux build() {
            return new software.amazon.awscdk.services.ec2.BastionHostLinux(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
