package software.amazon.awscdk.services.ec2;

/**
 * Options when downloading files from S3.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.8.0 (build 4a047ac)", date = "2020-07-07T13:18:17.190Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.S3DownloadOptions")
@software.amazon.jsii.Jsii.Proxy(S3DownloadOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface S3DownloadOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Name of the S3 bucket to download from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getBucket();

    /**
     * The key of the file to download.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBucketKey();

    /**
     * The name of the local file.
     * <p>
     * Default: Linux   - /tmp/bucketKey
     * Windows - %TEMP%/bucketKey
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLocalFile() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link S3DownloadOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link S3DownloadOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<S3DownloadOptions> {
        private software.amazon.awscdk.services.s3.IBucket bucket;
        private java.lang.String bucketKey;
        private java.lang.String localFile;

        /**
         * Sets the value of {@link S3DownloadOptions#getBucket}
         * @param bucket Name of the S3 bucket to download from. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucket(software.amazon.awscdk.services.s3.IBucket bucket) {
            this.bucket = bucket;
            return this;
        }

        /**
         * Sets the value of {@link S3DownloadOptions#getBucketKey}
         * @param bucketKey The key of the file to download. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketKey(java.lang.String bucketKey) {
            this.bucketKey = bucketKey;
            return this;
        }

        /**
         * Sets the value of {@link S3DownloadOptions#getLocalFile}
         * @param localFile The name of the local file.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder localFile(java.lang.String localFile) {
            this.localFile = localFile;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link S3DownloadOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public S3DownloadOptions build() {
            return new Jsii$Proxy(bucket, bucketKey, localFile);
        }
    }

    /**
     * An implementation for {@link S3DownloadOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3DownloadOptions {
        private final software.amazon.awscdk.services.s3.IBucket bucket;
        private final java.lang.String bucketKey;
        private final java.lang.String localFile;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bucket = this.jsiiGet("bucket", software.amazon.awscdk.services.s3.IBucket.class);
            this.bucketKey = this.jsiiGet("bucketKey", java.lang.String.class);
            this.localFile = this.jsiiGet("localFile", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.s3.IBucket bucket, final java.lang.String bucketKey, final java.lang.String localFile) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bucket = java.util.Objects.requireNonNull(bucket, "bucket is required");
            this.bucketKey = java.util.Objects.requireNonNull(bucketKey, "bucketKey is required");
            this.localFile = localFile;
        }

        @Override
        public software.amazon.awscdk.services.s3.IBucket getBucket() {
            return this.bucket;
        }

        @Override
        public java.lang.String getBucketKey() {
            return this.bucketKey;
        }

        @Override
        public java.lang.String getLocalFile() {
            return this.localFile;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("bucket", om.valueToTree(this.getBucket()));
            data.set("bucketKey", om.valueToTree(this.getBucketKey()));
            if (this.getLocalFile() != null) {
                data.set("localFile", om.valueToTree(this.getLocalFile()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.S3DownloadOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            S3DownloadOptions.Jsii$Proxy that = (S3DownloadOptions.Jsii$Proxy) o;

            if (!bucket.equals(that.bucket)) return false;
            if (!bucketKey.equals(that.bucketKey)) return false;
            return this.localFile != null ? this.localFile.equals(that.localFile) : that.localFile == null;
        }

        @Override
        public int hashCode() {
            int result = this.bucket.hashCode();
            result = 31 * result + (this.bucketKey.hashCode());
            result = 31 * result + (this.localFile != null ? this.localFile.hashCode() : 0);
            return result;
        }
    }
}
