package software.amazon.awscdk.services.ec2;

/**
 * Represents a new VPC subnet resource.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.8.0 (build 4a047ac)", date = "2020-07-07T13:18:17.192Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.Subnet")
public class Subnet extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.ec2.ISubnet {

    protected Subnet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Subnet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Subnet(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.SubnetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ISubnet fromSubnetAttributes(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.SubnetAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Subnet.class, "fromSubnetAttributes", software.amazon.awscdk.services.ec2.ISubnet.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Import existing subnet from id.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param subnetId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ISubnet fromSubnetId(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String subnetId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Subnet.class, "fromSubnetId", software.amazon.awscdk.services.ec2.ISubnet.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(subnetId, "subnetId is required") });
    }

    /**
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isVpcSubnet(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Subnet.class, "isVpcSubnet", java.lang.Boolean.class, new Object[] { x });
    }

    /**
     * Create a default route that points to a passed IGW, with a dependency on the IGW's attachment to the VPC.
     * <p>
     * @param gatewayId the logical ID (ref) of the gateway attached to your VPC. This parameter is required.
     * @param gatewayAttachment the gateway attachment construct to be added as a dependency. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addDefaultInternetRoute(final @org.jetbrains.annotations.NotNull java.lang.String gatewayId, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IDependable gatewayAttachment) {
        this.jsiiCall("addDefaultInternetRoute", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(gatewayId, "gatewayId is required"), java.util.Objects.requireNonNull(gatewayAttachment, "gatewayAttachment is required") });
    }

    /**
     * Adds an entry to this subnets route table that points to the passed NATGatwayId.
     * <p>
     * @param natGatewayId The ID of the NAT gateway. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addDefaultNatRoute(final @org.jetbrains.annotations.NotNull java.lang.String natGatewayId) {
        this.jsiiCall("addDefaultNatRoute", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(natGatewayId, "natGatewayId is required") });
    }

    /**
     * Adds an entry to this subnets route table.
     * <p>
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addRoute(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.AddRouteOptions options) {
        this.jsiiCall("addRoute", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Associate a Network ACL with this subnet.
     * <p>
     * @param id This parameter is required.
     * @param networkAcl This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void associateNetworkAcl(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.INetworkAcl networkAcl) {
        this.jsiiCall("associateNetworkAcl", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(networkAcl, "networkAcl is required") });
    }

    /**
     * The Availability Zone the subnet is located in.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAvailabilityZone() {
        return this.jsiiGet("availabilityZone", java.lang.String.class);
    }

    /**
     * Parts of this VPC subnet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.core.IDependable> getDependencyElements() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("dependencyElements", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IDependable.class))));
    }

    /**
     * Dependable that can be depended upon to force internet connectivity established on the VPC.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IDependable getInternetConnectivityEstablished() {
        return this.jsiiGet("internetConnectivityEstablished", software.amazon.awscdk.core.IDependable.class);
    }

    /**
     * Network ACL associated with this Subnet.
     * <p>
     * Upon creation, this is the default ACL which allows all traffic, except
     * explicit DENY entries that you add.
     * <p>
     * You can replace it with a custom ACL which denies all traffic except
     * the explic it ALLOW entries that you add by creating a <code>NetworkAcl</code>
     * object and calling <code>associateNetworkAcl()</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.INetworkAcl getNetworkAcl() {
        return this.jsiiGet("networkAcl", software.amazon.awscdk.services.ec2.INetworkAcl.class);
    }

    /**
     * The routeTableId attached to this subnet.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IRouteTable getRouteTable() {
        return this.jsiiGet("routeTable", software.amazon.awscdk.services.ec2.IRouteTable.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSubnetAvailabilityZone() {
        return this.jsiiGet("subnetAvailabilityZone", java.lang.String.class);
    }

    /**
     * The subnetId for this particular subnet.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSubnetId() {
        return this.jsiiGet("subnetId", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnetIpv6CidrBlocks() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("subnetIpv6CidrBlocks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSubnetNetworkAclAssociationId() {
        return this.jsiiGet("subnetNetworkAclAssociationId", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSubnetVpcId() {
        return this.jsiiGet("subnetVpcId", java.lang.String.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.Subnet}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.Subnet> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.SubnetProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.SubnetProps.Builder();
        }

        /**
         * The availability zone for the subnet.
         * <p>
         * @return {@code this}
         * @param availabilityZone The availability zone for the subnet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(final java.lang.String availabilityZone) {
            this.props.availabilityZone(availabilityZone);
            return this;
        }

        /**
         * The CIDR notation for this subnet.
         * <p>
         * @return {@code this}
         * @param cidrBlock The CIDR notation for this subnet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidrBlock(final java.lang.String cidrBlock) {
            this.props.cidrBlock(cidrBlock);
            return this;
        }

        /**
         * The VPC which this subnet is part of.
         * <p>
         * @return {@code this}
         * @param vpcId The VPC which this subnet is part of. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(final java.lang.String vpcId) {
            this.props.vpcId(vpcId);
            return this;
        }

        /**
         * Controls if a public IP is associated to an instance at launch.
         * <p>
         * Default: true in Subnet.Public, false in Subnet.Private or Subnet.Isolated.
         * <p>
         * @return {@code this}
         * @param mapPublicIpOnLaunch Controls if a public IP is associated to an instance at launch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mapPublicIpOnLaunch(final java.lang.Boolean mapPublicIpOnLaunch) {
            this.props.mapPublicIpOnLaunch(mapPublicIpOnLaunch);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.Subnet}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.Subnet build() {
            return new software.amazon.awscdk.services.ec2.Subnet(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
