package software.amazon.awscdk.services.ec2;

/**
 * Selects the latest version of Amazon Linux.
 * <p>
 * This Machine Image automatically updates to the latest version on every
 * deployment. Be aware this will cause your instances to be replaced when a
 * new version of the image becomes available. Do not store stateful information
 * on the instance if you are using this image.
 * <p>
 * The AMI ID is selected using the values published to the SSM parameter store.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-07-20T10:46:36.398Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.AmazonLinuxImage")
public class AmazonLinuxImage extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.IMachineImage {

    protected AmazonLinuxImage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AmazonLinuxImage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AmazonLinuxImage(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.AmazonLinuxImageProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AmazonLinuxImage() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Return the image to use in the given context.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.MachineImageConfig getImage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope) {
        return this.jsiiCall("getImage", software.amazon.awscdk.services.ec2.MachineImageConfig.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.AmazonLinuxImage}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.AmazonLinuxImage> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.services.ec2.AmazonLinuxImageProps.Builder props;

        private Builder() {
        }

        /**
         * What edition of Amazon Linux to use.
         * <p>
         * Default: Standard
         * <p>
         * @return {@code this}
         * @param edition What edition of Amazon Linux to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder edition(final software.amazon.awscdk.services.ec2.AmazonLinuxEdition edition) {
            this.props().edition(edition);
            return this;
        }

        /**
         * What generation of Amazon Linux to use.
         * <p>
         * Default: AmazonLinux
         * <p>
         * @return {@code this}
         * @param generation What generation of Amazon Linux to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder generation(final software.amazon.awscdk.services.ec2.AmazonLinuxGeneration generation) {
            this.props().generation(generation);
            return this;
        }

        /**
         * What storage backed image to use.
         * <p>
         * Default: GeneralPurpose
         * <p>
         * @return {@code this}
         * @param storage What storage backed image to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storage(final software.amazon.awscdk.services.ec2.AmazonLinuxStorage storage) {
            this.props().storage(storage);
            return this;
        }

        /**
         * Initial user data.
         * <p>
         * Default: - Empty UserData for Linux machines
         * <p>
         * @return {@code this}
         * @param userData Initial user data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userData(final software.amazon.awscdk.services.ec2.UserData userData) {
            this.props().userData(userData);
            return this;
        }

        /**
         * Virtualization type.
         * <p>
         * Default: HVM
         * <p>
         * @return {@code this}
         * @param virtualization Virtualization type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualization(final software.amazon.awscdk.services.ec2.AmazonLinuxVirt virtualization) {
            this.props().virtualization(virtualization);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.AmazonLinuxImage}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.AmazonLinuxImage build() {
            return new software.amazon.awscdk.services.ec2.AmazonLinuxImage(
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ec2.AmazonLinuxImageProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ec2.AmazonLinuxImageProps.Builder();
            }
            return this.props;
        }
    }
}
