package software.amazon.awscdk.services.ec2;

/**
 * Construction properties for a VpcEndpointService.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-07-22T09:50:04.689Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.VpcEndpointServiceProps")
@software.amazon.jsii.Jsii.Proxy(VpcEndpointServiceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface VpcEndpointServiceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * One or more load balancers to host the VPC Endpoint Service.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.IVpcEndpointServiceLoadBalancer> getVpcEndpointServiceLoadBalancers();

    /**
     * Whether requests from service consumers to connect to the service through an endpoint must be accepted.
     * <p>
     * Default: true
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAcceptanceRequired() {
        return null;
    }

    /**
     * Name of the Vpc Endpoint Service.
     * <p>
     * Default: - CDK generated name
     * <p>
     * @deprecated This property is not used
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getVpcEndpointServiceName() {
        return null;
    }

    /**
     * IAM users, IAM roles, or AWS accounts to allow inbound connections from.
     * <p>
     * These principals can connect to your service using VPC endpoints. Takes a
     * list of one or more ArnPrincipal.
     * <p>
     * Default: - no principals
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.ArnPrincipal> getWhitelistedPrincipals() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link VpcEndpointServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VpcEndpointServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<VpcEndpointServiceProps> {
        private java.util.List<software.amazon.awscdk.services.ec2.IVpcEndpointServiceLoadBalancer> vpcEndpointServiceLoadBalancers;
        private java.lang.Boolean acceptanceRequired;
        private java.lang.String vpcEndpointServiceName;
        private java.util.List<software.amazon.awscdk.services.iam.ArnPrincipal> whitelistedPrincipals;

        /**
         * Sets the value of {@link VpcEndpointServiceProps#getVpcEndpointServiceLoadBalancers}
         * @param vpcEndpointServiceLoadBalancers One or more load balancers to host the VPC Endpoint Service. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpcEndpointServiceLoadBalancers(java.util.List<software.amazon.awscdk.services.ec2.IVpcEndpointServiceLoadBalancer> vpcEndpointServiceLoadBalancers) {
            this.vpcEndpointServiceLoadBalancers = vpcEndpointServiceLoadBalancers;
            return this;
        }

        /**
         * Sets the value of {@link VpcEndpointServiceProps#getAcceptanceRequired}
         * @param acceptanceRequired Whether requests from service consumers to connect to the service through an endpoint must be accepted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder acceptanceRequired(java.lang.Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
            return this;
        }

        /**
         * Sets the value of {@link VpcEndpointServiceProps#getVpcEndpointServiceName}
         * @param vpcEndpointServiceName Name of the Vpc Endpoint Service.
         * @return {@code this}
         * @deprecated This property is not used
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder vpcEndpointServiceName(java.lang.String vpcEndpointServiceName) {
            this.vpcEndpointServiceName = vpcEndpointServiceName;
            return this;
        }

        /**
         * Sets the value of {@link VpcEndpointServiceProps#getWhitelistedPrincipals}
         * @param whitelistedPrincipals IAM users, IAM roles, or AWS accounts to allow inbound connections from.
         *                              These principals can connect to your service using VPC endpoints. Takes a
         *                              list of one or more ArnPrincipal.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder whitelistedPrincipals(java.util.List<software.amazon.awscdk.services.iam.ArnPrincipal> whitelistedPrincipals) {
            this.whitelistedPrincipals = whitelistedPrincipals;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpcEndpointServiceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public VpcEndpointServiceProps build() {
            return new Jsii$Proxy(vpcEndpointServiceLoadBalancers, acceptanceRequired, vpcEndpointServiceName, whitelistedPrincipals);
        }
    }

    /**
     * An implementation for {@link VpcEndpointServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcEndpointServiceProps {
        private final java.util.List<software.amazon.awscdk.services.ec2.IVpcEndpointServiceLoadBalancer> vpcEndpointServiceLoadBalancers;
        private final java.lang.Boolean acceptanceRequired;
        private final java.lang.String vpcEndpointServiceName;
        private final java.util.List<software.amazon.awscdk.services.iam.ArnPrincipal> whitelistedPrincipals;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.vpcEndpointServiceLoadBalancers = this.jsiiGet("vpcEndpointServiceLoadBalancers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpcEndpointServiceLoadBalancer.class)));
            this.acceptanceRequired = this.jsiiGet("acceptanceRequired", java.lang.Boolean.class);
            this.vpcEndpointServiceName = this.jsiiGet("vpcEndpointServiceName", java.lang.String.class);
            this.whitelistedPrincipals = this.jsiiGet("whitelistedPrincipals", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.ArnPrincipal.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.util.List<software.amazon.awscdk.services.ec2.IVpcEndpointServiceLoadBalancer> vpcEndpointServiceLoadBalancers, final java.lang.Boolean acceptanceRequired, final java.lang.String vpcEndpointServiceName, final java.util.List<software.amazon.awscdk.services.iam.ArnPrincipal> whitelistedPrincipals) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.vpcEndpointServiceLoadBalancers = java.util.Objects.requireNonNull(vpcEndpointServiceLoadBalancers, "vpcEndpointServiceLoadBalancers is required");
            this.acceptanceRequired = acceptanceRequired;
            this.vpcEndpointServiceName = vpcEndpointServiceName;
            this.whitelistedPrincipals = whitelistedPrincipals;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.ec2.IVpcEndpointServiceLoadBalancer> getVpcEndpointServiceLoadBalancers() {
            return this.vpcEndpointServiceLoadBalancers;
        }

        @Override
        public java.lang.Boolean getAcceptanceRequired() {
            return this.acceptanceRequired;
        }

        @Override
        public java.lang.String getVpcEndpointServiceName() {
            return this.vpcEndpointServiceName;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.iam.ArnPrincipal> getWhitelistedPrincipals() {
            return this.whitelistedPrincipals;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("vpcEndpointServiceLoadBalancers", om.valueToTree(this.getVpcEndpointServiceLoadBalancers()));
            if (this.getAcceptanceRequired() != null) {
                data.set("acceptanceRequired", om.valueToTree(this.getAcceptanceRequired()));
            }
            if (this.getVpcEndpointServiceName() != null) {
                data.set("vpcEndpointServiceName", om.valueToTree(this.getVpcEndpointServiceName()));
            }
            if (this.getWhitelistedPrincipals() != null) {
                data.set("whitelistedPrincipals", om.valueToTree(this.getWhitelistedPrincipals()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.VpcEndpointServiceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VpcEndpointServiceProps.Jsii$Proxy that = (VpcEndpointServiceProps.Jsii$Proxy) o;

            if (!vpcEndpointServiceLoadBalancers.equals(that.vpcEndpointServiceLoadBalancers)) return false;
            if (this.acceptanceRequired != null ? !this.acceptanceRequired.equals(that.acceptanceRequired) : that.acceptanceRequired != null) return false;
            if (this.vpcEndpointServiceName != null ? !this.vpcEndpointServiceName.equals(that.vpcEndpointServiceName) : that.vpcEndpointServiceName != null) return false;
            return this.whitelistedPrincipals != null ? this.whitelistedPrincipals.equals(that.whitelistedPrincipals) : that.whitelistedPrincipals == null;
        }

        @Override
        public int hashCode() {
            int result = this.vpcEndpointServiceLoadBalancers.hashCode();
            result = 31 * result + (this.acceptanceRequired != null ? this.acceptanceRequired.hashCode() : 0);
            result = 31 * result + (this.vpcEndpointServiceName != null ? this.vpcEndpointServiceName.hashCode() : 0);
            result = 31 * result + (this.whitelistedPrincipals != null ? this.whitelistedPrincipals.hashCode() : 0);
            return result;
        }
    }
}
