package software.amazon.awscdk.services.ec2;

/**
 * Properties to intialize a new Connections object.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-07-28T21:12:25.966Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.ConnectionsProps")
@software.amazon.jsii.Jsii.Proxy(ConnectionsProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ConnectionsProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Default port range for initiating connections to and from this object.
     * <p>
     * Default: - No default port
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.Port getDefaultPort() {
        return null;
    }

    /**
     * Class that represents the rule by which others can connect to this connectable.
     * <p>
     * This object is required, but will be derived from securityGroup if that is passed.
     * <p>
     * Default: Derived from securityGroup if set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IPeer getPeer() {
        return null;
    }

    /**
     * What securityGroup(s) this object is managing connections for.
     * <p>
     * Default: No security groups
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ConnectionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ConnectionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ConnectionsProps> {
        private software.amazon.awscdk.services.ec2.Port defaultPort;
        private software.amazon.awscdk.services.ec2.IPeer peer;
        private java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;

        /**
         * Sets the value of {@link ConnectionsProps#getDefaultPort}
         * @param defaultPort Default port range for initiating connections to and from this object.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultPort(software.amazon.awscdk.services.ec2.Port defaultPort) {
            this.defaultPort = defaultPort;
            return this;
        }

        /**
         * Sets the value of {@link ConnectionsProps#getPeer}
         * @param peer Class that represents the rule by which others can connect to this connectable.
         *             This object is required, but will be derived from securityGroup if that is passed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder peer(software.amazon.awscdk.services.ec2.IPeer peer) {
            this.peer = peer;
            return this;
        }

        /**
         * Sets the value of {@link ConnectionsProps#getSecurityGroups}
         * @param securityGroups What securityGroup(s) this object is managing connections for.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ConnectionsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ConnectionsProps build() {
            return new Jsii$Proxy(defaultPort, peer, securityGroups);
        }
    }

    /**
     * An implementation for {@link ConnectionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectionsProps {
        private final software.amazon.awscdk.services.ec2.Port defaultPort;
        private final software.amazon.awscdk.services.ec2.IPeer peer;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.defaultPort = this.jsiiGet("defaultPort", software.amazon.awscdk.services.ec2.Port.class);
            this.peer = this.jsiiGet("peer", software.amazon.awscdk.services.ec2.IPeer.class);
            this.securityGroups = this.jsiiGet("securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.ec2.Port defaultPort, final software.amazon.awscdk.services.ec2.IPeer peer, final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.defaultPort = defaultPort;
            this.peer = peer;
            this.securityGroups = securityGroups;
        }

        @Override
        public software.amazon.awscdk.services.ec2.Port getDefaultPort() {
            return this.defaultPort;
        }

        @Override
        public software.amazon.awscdk.services.ec2.IPeer getPeer() {
            return this.peer;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDefaultPort() != null) {
                data.set("defaultPort", om.valueToTree(this.getDefaultPort()));
            }
            if (this.getPeer() != null) {
                data.set("peer", om.valueToTree(this.getPeer()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.ConnectionsProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ConnectionsProps.Jsii$Proxy that = (ConnectionsProps.Jsii$Proxy) o;

            if (this.defaultPort != null ? !this.defaultPort.equals(that.defaultPort) : that.defaultPort != null) return false;
            if (this.peer != null ? !this.peer.equals(that.peer) : that.peer != null) return false;
            return this.securityGroups != null ? this.securityGroups.equals(that.securityGroups) : that.securityGroups == null;
        }

        @Override
        public int hashCode() {
            int result = this.defaultPort != null ? this.defaultPort.hashCode() : 0;
            result = 31 * result + (this.peer != null ? this.peer.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            return result;
        }
    }
}
