package software.amazon.awscdk.services.ec2;

/**
 * Properties that reference an external Vpc.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-07-28T21:12:26.026Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.VpcAttributes")
@software.amazon.jsii.Jsii.Proxy(VpcAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VpcAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * List of availability zones for the subnets in this VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAvailabilityZones();

    /**
     * VPC's identifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVpcId();

    /**
     * List of isolated subnet IDs.
     * <p>
     * Must be undefined or match the availability zones in length and order.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIsolatedSubnetIds() {
        return null;
    }

    /**
     * List of names for the isolated subnets.
     * <p>
     * Must be undefined or have a name for every isolated subnet group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIsolatedSubnetNames() {
        return null;
    }

    /**
     * List of IDs of routing tables for the isolated subnets.
     * <p>
     * Must be undefined or have a name for every isolated subnet group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIsolatedSubnetRouteTableIds() {
        return null;
    }

    /**
     * List of private subnet IDs.
     * <p>
     * Must be undefined or match the availability zones in length and order.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPrivateSubnetIds() {
        return null;
    }

    /**
     * List of names for the private subnets.
     * <p>
     * Must be undefined or have a name for every private subnet group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPrivateSubnetNames() {
        return null;
    }

    /**
     * List of IDs of routing tables for the private subnets.
     * <p>
     * Must be undefined or have a name for every private subnet group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPrivateSubnetRouteTableIds() {
        return null;
    }

    /**
     * List of public subnet IDs.
     * <p>
     * Must be undefined or match the availability zones in length and order.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPublicSubnetIds() {
        return null;
    }

    /**
     * List of names for the public subnets.
     * <p>
     * Must be undefined or have a name for every public subnet group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPublicSubnetNames() {
        return null;
    }

    /**
     * List of IDs of routing tables for the public subnets.
     * <p>
     * Must be undefined or have a name for every public subnet group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPublicSubnetRouteTableIds() {
        return null;
    }

    /**
     * VPC's CIDR range.
     * <p>
     * Default: - Retrieving the CIDR from the VPC will fail
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVpcCidrBlock() {
        return null;
    }

    /**
     * VPN gateway's identifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVpnGatewayId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link VpcAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VpcAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VpcAttributes> {
        private java.util.List<java.lang.String> availabilityZones;
        private java.lang.String vpcId;
        private java.util.List<java.lang.String> isolatedSubnetIds;
        private java.util.List<java.lang.String> isolatedSubnetNames;
        private java.util.List<java.lang.String> isolatedSubnetRouteTableIds;
        private java.util.List<java.lang.String> privateSubnetIds;
        private java.util.List<java.lang.String> privateSubnetNames;
        private java.util.List<java.lang.String> privateSubnetRouteTableIds;
        private java.util.List<java.lang.String> publicSubnetIds;
        private java.util.List<java.lang.String> publicSubnetNames;
        private java.util.List<java.lang.String> publicSubnetRouteTableIds;
        private java.lang.String vpcCidrBlock;
        private java.lang.String vpnGatewayId;

        /**
         * Sets the value of {@link VpcAttributes#getAvailabilityZones}
         * @param availabilityZones List of availability zones for the subnets in this VPC. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZones(java.util.List<java.lang.String> availabilityZones) {
            this.availabilityZones = availabilityZones;
            return this;
        }

        /**
         * Sets the value of {@link VpcAttributes#getVpcId}
         * @param vpcId VPC's identifier. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(java.lang.String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        /**
         * Sets the value of {@link VpcAttributes#getIsolatedSubnetIds}
         * @param isolatedSubnetIds List of isolated subnet IDs.
         *                          Must be undefined or match the availability zones in length and order.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isolatedSubnetIds(java.util.List<java.lang.String> isolatedSubnetIds) {
            this.isolatedSubnetIds = isolatedSubnetIds;
            return this;
        }

        /**
         * Sets the value of {@link VpcAttributes#getIsolatedSubnetNames}
         * @param isolatedSubnetNames List of names for the isolated subnets.
         *                            Must be undefined or have a name for every isolated subnet group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isolatedSubnetNames(java.util.List<java.lang.String> isolatedSubnetNames) {
            this.isolatedSubnetNames = isolatedSubnetNames;
            return this;
        }

        /**
         * Sets the value of {@link VpcAttributes#getIsolatedSubnetRouteTableIds}
         * @param isolatedSubnetRouteTableIds List of IDs of routing tables for the isolated subnets.
         *                                    Must be undefined or have a name for every isolated subnet group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isolatedSubnetRouteTableIds(java.util.List<java.lang.String> isolatedSubnetRouteTableIds) {
            this.isolatedSubnetRouteTableIds = isolatedSubnetRouteTableIds;
            return this;
        }

        /**
         * Sets the value of {@link VpcAttributes#getPrivateSubnetIds}
         * @param privateSubnetIds List of private subnet IDs.
         *                         Must be undefined or match the availability zones in length and order.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateSubnetIds(java.util.List<java.lang.String> privateSubnetIds) {
            this.privateSubnetIds = privateSubnetIds;
            return this;
        }

        /**
         * Sets the value of {@link VpcAttributes#getPrivateSubnetNames}
         * @param privateSubnetNames List of names for the private subnets.
         *                           Must be undefined or have a name for every private subnet group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateSubnetNames(java.util.List<java.lang.String> privateSubnetNames) {
            this.privateSubnetNames = privateSubnetNames;
            return this;
        }

        /**
         * Sets the value of {@link VpcAttributes#getPrivateSubnetRouteTableIds}
         * @param privateSubnetRouteTableIds List of IDs of routing tables for the private subnets.
         *                                   Must be undefined or have a name for every private subnet group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateSubnetRouteTableIds(java.util.List<java.lang.String> privateSubnetRouteTableIds) {
            this.privateSubnetRouteTableIds = privateSubnetRouteTableIds;
            return this;
        }

        /**
         * Sets the value of {@link VpcAttributes#getPublicSubnetIds}
         * @param publicSubnetIds List of public subnet IDs.
         *                        Must be undefined or match the availability zones in length and order.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicSubnetIds(java.util.List<java.lang.String> publicSubnetIds) {
            this.publicSubnetIds = publicSubnetIds;
            return this;
        }

        /**
         * Sets the value of {@link VpcAttributes#getPublicSubnetNames}
         * @param publicSubnetNames List of names for the public subnets.
         *                          Must be undefined or have a name for every public subnet group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicSubnetNames(java.util.List<java.lang.String> publicSubnetNames) {
            this.publicSubnetNames = publicSubnetNames;
            return this;
        }

        /**
         * Sets the value of {@link VpcAttributes#getPublicSubnetRouteTableIds}
         * @param publicSubnetRouteTableIds List of IDs of routing tables for the public subnets.
         *                                  Must be undefined or have a name for every public subnet group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicSubnetRouteTableIds(java.util.List<java.lang.String> publicSubnetRouteTableIds) {
            this.publicSubnetRouteTableIds = publicSubnetRouteTableIds;
            return this;
        }

        /**
         * Sets the value of {@link VpcAttributes#getVpcCidrBlock}
         * @param vpcCidrBlock VPC's CIDR range.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcCidrBlock(java.lang.String vpcCidrBlock) {
            this.vpcCidrBlock = vpcCidrBlock;
            return this;
        }

        /**
         * Sets the value of {@link VpcAttributes#getVpnGatewayId}
         * @param vpnGatewayId VPN gateway's identifier.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpnGatewayId(java.lang.String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpcAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VpcAttributes build() {
            return new Jsii$Proxy(availabilityZones, vpcId, isolatedSubnetIds, isolatedSubnetNames, isolatedSubnetRouteTableIds, privateSubnetIds, privateSubnetNames, privateSubnetRouteTableIds, publicSubnetIds, publicSubnetNames, publicSubnetRouteTableIds, vpcCidrBlock, vpnGatewayId);
        }
    }

    /**
     * An implementation for {@link VpcAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcAttributes {
        private final java.util.List<java.lang.String> availabilityZones;
        private final java.lang.String vpcId;
        private final java.util.List<java.lang.String> isolatedSubnetIds;
        private final java.util.List<java.lang.String> isolatedSubnetNames;
        private final java.util.List<java.lang.String> isolatedSubnetRouteTableIds;
        private final java.util.List<java.lang.String> privateSubnetIds;
        private final java.util.List<java.lang.String> privateSubnetNames;
        private final java.util.List<java.lang.String> privateSubnetRouteTableIds;
        private final java.util.List<java.lang.String> publicSubnetIds;
        private final java.util.List<java.lang.String> publicSubnetNames;
        private final java.util.List<java.lang.String> publicSubnetRouteTableIds;
        private final java.lang.String vpcCidrBlock;
        private final java.lang.String vpnGatewayId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.availabilityZones = this.jsiiGet("availabilityZones", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.vpcId = this.jsiiGet("vpcId", java.lang.String.class);
            this.isolatedSubnetIds = this.jsiiGet("isolatedSubnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.isolatedSubnetNames = this.jsiiGet("isolatedSubnetNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.isolatedSubnetRouteTableIds = this.jsiiGet("isolatedSubnetRouteTableIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.privateSubnetIds = this.jsiiGet("privateSubnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.privateSubnetNames = this.jsiiGet("privateSubnetNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.privateSubnetRouteTableIds = this.jsiiGet("privateSubnetRouteTableIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.publicSubnetIds = this.jsiiGet("publicSubnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.publicSubnetNames = this.jsiiGet("publicSubnetNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.publicSubnetRouteTableIds = this.jsiiGet("publicSubnetRouteTableIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.vpcCidrBlock = this.jsiiGet("vpcCidrBlock", java.lang.String.class);
            this.vpnGatewayId = this.jsiiGet("vpnGatewayId", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.util.List<java.lang.String> availabilityZones, final java.lang.String vpcId, final java.util.List<java.lang.String> isolatedSubnetIds, final java.util.List<java.lang.String> isolatedSubnetNames, final java.util.List<java.lang.String> isolatedSubnetRouteTableIds, final java.util.List<java.lang.String> privateSubnetIds, final java.util.List<java.lang.String> privateSubnetNames, final java.util.List<java.lang.String> privateSubnetRouteTableIds, final java.util.List<java.lang.String> publicSubnetIds, final java.util.List<java.lang.String> publicSubnetNames, final java.util.List<java.lang.String> publicSubnetRouteTableIds, final java.lang.String vpcCidrBlock, final java.lang.String vpnGatewayId) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.availabilityZones = java.util.Objects.requireNonNull(availabilityZones, "availabilityZones is required");
            this.vpcId = java.util.Objects.requireNonNull(vpcId, "vpcId is required");
            this.isolatedSubnetIds = isolatedSubnetIds;
            this.isolatedSubnetNames = isolatedSubnetNames;
            this.isolatedSubnetRouteTableIds = isolatedSubnetRouteTableIds;
            this.privateSubnetIds = privateSubnetIds;
            this.privateSubnetNames = privateSubnetNames;
            this.privateSubnetRouteTableIds = privateSubnetRouteTableIds;
            this.publicSubnetIds = publicSubnetIds;
            this.publicSubnetNames = publicSubnetNames;
            this.publicSubnetRouteTableIds = publicSubnetRouteTableIds;
            this.vpcCidrBlock = vpcCidrBlock;
            this.vpnGatewayId = vpnGatewayId;
        }

        @Override
        public java.util.List<java.lang.String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public java.lang.String getVpcId() {
            return this.vpcId;
        }

        @Override
        public java.util.List<java.lang.String> getIsolatedSubnetIds() {
            return this.isolatedSubnetIds;
        }

        @Override
        public java.util.List<java.lang.String> getIsolatedSubnetNames() {
            return this.isolatedSubnetNames;
        }

        @Override
        public java.util.List<java.lang.String> getIsolatedSubnetRouteTableIds() {
            return this.isolatedSubnetRouteTableIds;
        }

        @Override
        public java.util.List<java.lang.String> getPrivateSubnetIds() {
            return this.privateSubnetIds;
        }

        @Override
        public java.util.List<java.lang.String> getPrivateSubnetNames() {
            return this.privateSubnetNames;
        }

        @Override
        public java.util.List<java.lang.String> getPrivateSubnetRouteTableIds() {
            return this.privateSubnetRouteTableIds;
        }

        @Override
        public java.util.List<java.lang.String> getPublicSubnetIds() {
            return this.publicSubnetIds;
        }

        @Override
        public java.util.List<java.lang.String> getPublicSubnetNames() {
            return this.publicSubnetNames;
        }

        @Override
        public java.util.List<java.lang.String> getPublicSubnetRouteTableIds() {
            return this.publicSubnetRouteTableIds;
        }

        @Override
        public java.lang.String getVpcCidrBlock() {
            return this.vpcCidrBlock;
        }

        @Override
        public java.lang.String getVpnGatewayId() {
            return this.vpnGatewayId;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("availabilityZones", om.valueToTree(this.getAvailabilityZones()));
            data.set("vpcId", om.valueToTree(this.getVpcId()));
            if (this.getIsolatedSubnetIds() != null) {
                data.set("isolatedSubnetIds", om.valueToTree(this.getIsolatedSubnetIds()));
            }
            if (this.getIsolatedSubnetNames() != null) {
                data.set("isolatedSubnetNames", om.valueToTree(this.getIsolatedSubnetNames()));
            }
            if (this.getIsolatedSubnetRouteTableIds() != null) {
                data.set("isolatedSubnetRouteTableIds", om.valueToTree(this.getIsolatedSubnetRouteTableIds()));
            }
            if (this.getPrivateSubnetIds() != null) {
                data.set("privateSubnetIds", om.valueToTree(this.getPrivateSubnetIds()));
            }
            if (this.getPrivateSubnetNames() != null) {
                data.set("privateSubnetNames", om.valueToTree(this.getPrivateSubnetNames()));
            }
            if (this.getPrivateSubnetRouteTableIds() != null) {
                data.set("privateSubnetRouteTableIds", om.valueToTree(this.getPrivateSubnetRouteTableIds()));
            }
            if (this.getPublicSubnetIds() != null) {
                data.set("publicSubnetIds", om.valueToTree(this.getPublicSubnetIds()));
            }
            if (this.getPublicSubnetNames() != null) {
                data.set("publicSubnetNames", om.valueToTree(this.getPublicSubnetNames()));
            }
            if (this.getPublicSubnetRouteTableIds() != null) {
                data.set("publicSubnetRouteTableIds", om.valueToTree(this.getPublicSubnetRouteTableIds()));
            }
            if (this.getVpcCidrBlock() != null) {
                data.set("vpcCidrBlock", om.valueToTree(this.getVpcCidrBlock()));
            }
            if (this.getVpnGatewayId() != null) {
                data.set("vpnGatewayId", om.valueToTree(this.getVpnGatewayId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.VpcAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VpcAttributes.Jsii$Proxy that = (VpcAttributes.Jsii$Proxy) o;

            if (!availabilityZones.equals(that.availabilityZones)) return false;
            if (!vpcId.equals(that.vpcId)) return false;
            if (this.isolatedSubnetIds != null ? !this.isolatedSubnetIds.equals(that.isolatedSubnetIds) : that.isolatedSubnetIds != null) return false;
            if (this.isolatedSubnetNames != null ? !this.isolatedSubnetNames.equals(that.isolatedSubnetNames) : that.isolatedSubnetNames != null) return false;
            if (this.isolatedSubnetRouteTableIds != null ? !this.isolatedSubnetRouteTableIds.equals(that.isolatedSubnetRouteTableIds) : that.isolatedSubnetRouteTableIds != null) return false;
            if (this.privateSubnetIds != null ? !this.privateSubnetIds.equals(that.privateSubnetIds) : that.privateSubnetIds != null) return false;
            if (this.privateSubnetNames != null ? !this.privateSubnetNames.equals(that.privateSubnetNames) : that.privateSubnetNames != null) return false;
            if (this.privateSubnetRouteTableIds != null ? !this.privateSubnetRouteTableIds.equals(that.privateSubnetRouteTableIds) : that.privateSubnetRouteTableIds != null) return false;
            if (this.publicSubnetIds != null ? !this.publicSubnetIds.equals(that.publicSubnetIds) : that.publicSubnetIds != null) return false;
            if (this.publicSubnetNames != null ? !this.publicSubnetNames.equals(that.publicSubnetNames) : that.publicSubnetNames != null) return false;
            if (this.publicSubnetRouteTableIds != null ? !this.publicSubnetRouteTableIds.equals(that.publicSubnetRouteTableIds) : that.publicSubnetRouteTableIds != null) return false;
            if (this.vpcCidrBlock != null ? !this.vpcCidrBlock.equals(that.vpcCidrBlock) : that.vpcCidrBlock != null) return false;
            return this.vpnGatewayId != null ? this.vpnGatewayId.equals(that.vpnGatewayId) : that.vpnGatewayId == null;
        }

        @Override
        public int hashCode() {
            int result = this.availabilityZones.hashCode();
            result = 31 * result + (this.vpcId.hashCode());
            result = 31 * result + (this.isolatedSubnetIds != null ? this.isolatedSubnetIds.hashCode() : 0);
            result = 31 * result + (this.isolatedSubnetNames != null ? this.isolatedSubnetNames.hashCode() : 0);
            result = 31 * result + (this.isolatedSubnetRouteTableIds != null ? this.isolatedSubnetRouteTableIds.hashCode() : 0);
            result = 31 * result + (this.privateSubnetIds != null ? this.privateSubnetIds.hashCode() : 0);
            result = 31 * result + (this.privateSubnetNames != null ? this.privateSubnetNames.hashCode() : 0);
            result = 31 * result + (this.privateSubnetRouteTableIds != null ? this.privateSubnetRouteTableIds.hashCode() : 0);
            result = 31 * result + (this.publicSubnetIds != null ? this.publicSubnetIds.hashCode() : 0);
            result = 31 * result + (this.publicSubnetNames != null ? this.publicSubnetNames.hashCode() : 0);
            result = 31 * result + (this.publicSubnetRouteTableIds != null ? this.publicSubnetRouteTableIds.hashCode() : 0);
            result = 31 * result + (this.vpcCidrBlock != null ? this.vpcCidrBlock.hashCode() : 0);
            result = 31 * result + (this.vpnGatewayId != null ? this.vpnGatewayId.hashCode() : 0);
            return result;
        }
    }
}
