package software.amazon.awscdk.services.ec2;

/**
 * Acl Configuration for traffic.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-07-31T23:31:34.996Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.AclTrafficConfig")
@software.amazon.jsii.Jsii.Proxy(AclTrafficConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface AclTrafficConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The protocol number.
     * <p>
     * A value of "-1" means all protocols.
     * <p>
     * If you specify "-1" or a protocol number other than "6" (TCP), "17" (UDP),
     * or "1" (ICMP), traffic on all ports is allowed, regardless of any ports or
     * ICMP types or codes that you specify.
     * <p>
     * If you specify protocol "58" (ICMPv6) and specify an IPv4 CIDR
     * block, traffic for all ICMP types and codes allowed, regardless of any that
     * you specify. If you specify protocol "58" (ICMPv6) and specify an IPv6 CIDR
     * block, you must specify an ICMP type and code.
     * <p>
     * Default: 17
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.Number getProtocol();

    /**
     * The Internet Control Message Protocol (ICMP) code and type.
     * <p>
     * Default: - Required if specifying 1 (ICMP) for the protocol parameter.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.AclIcmp getIcmp() {
        return null;
    }

    /**
     * The range of port numbers for the UDP/TCP protocol.
     * <p>
     * Default: - Required if specifying 6 (TCP) or 17 (UDP) for the protocol parameter
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.AclPortRange getPortRange() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AclTrafficConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AclTrafficConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<AclTrafficConfig> {
        private java.lang.Number protocol;
        private software.amazon.awscdk.services.ec2.AclIcmp icmp;
        private software.amazon.awscdk.services.ec2.AclPortRange portRange;

        /**
         * Sets the value of {@link AclTrafficConfig#getProtocol}
         * @param protocol The protocol number. This parameter is required.
         *                 A value of "-1" means all protocols.
         *                 <p>
         *                 If you specify "-1" or a protocol number other than "6" (TCP), "17" (UDP),
         *                 or "1" (ICMP), traffic on all ports is allowed, regardless of any ports or
         *                 ICMP types or codes that you specify.
         *                 <p>
         *                 If you specify protocol "58" (ICMPv6) and specify an IPv4 CIDR
         *                 block, traffic for all ICMP types and codes allowed, regardless of any that
         *                 you specify. If you specify protocol "58" (ICMPv6) and specify an IPv6 CIDR
         *                 block, you must specify an ICMP type and code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder protocol(java.lang.Number protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of {@link AclTrafficConfig#getIcmp}
         * @param icmp The Internet Control Message Protocol (ICMP) code and type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder icmp(software.amazon.awscdk.services.ec2.AclIcmp icmp) {
            this.icmp = icmp;
            return this;
        }

        /**
         * Sets the value of {@link AclTrafficConfig#getPortRange}
         * @param portRange The range of port numbers for the UDP/TCP protocol.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder portRange(software.amazon.awscdk.services.ec2.AclPortRange portRange) {
            this.portRange = portRange;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AclTrafficConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public AclTrafficConfig build() {
            return new Jsii$Proxy(protocol, icmp, portRange);
        }
    }

    /**
     * An implementation for {@link AclTrafficConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AclTrafficConfig {
        private final java.lang.Number protocol;
        private final software.amazon.awscdk.services.ec2.AclIcmp icmp;
        private final software.amazon.awscdk.services.ec2.AclPortRange portRange;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.protocol = this.jsiiGet("protocol", java.lang.Number.class);
            this.icmp = this.jsiiGet("icmp", software.amazon.awscdk.services.ec2.AclIcmp.class);
            this.portRange = this.jsiiGet("portRange", software.amazon.awscdk.services.ec2.AclPortRange.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Number protocol, final software.amazon.awscdk.services.ec2.AclIcmp icmp, final software.amazon.awscdk.services.ec2.AclPortRange portRange) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.protocol = java.util.Objects.requireNonNull(protocol, "protocol is required");
            this.icmp = icmp;
            this.portRange = portRange;
        }

        @Override
        public java.lang.Number getProtocol() {
            return this.protocol;
        }

        @Override
        public software.amazon.awscdk.services.ec2.AclIcmp getIcmp() {
            return this.icmp;
        }

        @Override
        public software.amazon.awscdk.services.ec2.AclPortRange getPortRange() {
            return this.portRange;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("protocol", om.valueToTree(this.getProtocol()));
            if (this.getIcmp() != null) {
                data.set("icmp", om.valueToTree(this.getIcmp()));
            }
            if (this.getPortRange() != null) {
                data.set("portRange", om.valueToTree(this.getPortRange()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.AclTrafficConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AclTrafficConfig.Jsii$Proxy that = (AclTrafficConfig.Jsii$Proxy) o;

            if (!protocol.equals(that.protocol)) return false;
            if (this.icmp != null ? !this.icmp.equals(that.icmp) : that.icmp != null) return false;
            return this.portRange != null ? this.portRange.equals(that.portRange) : that.portRange == null;
        }

        @Override
        public int hashCode() {
            int result = this.protocol.hashCode();
            result = 31 * result + (this.icmp != null ? this.icmp.hashCode() : 0);
            result = 31 * result + (this.portRange != null ? this.portRange.hashCode() : 0);
            return result;
        }
    }
}
