package software.amazon.awscdk.services.ec2;

/**
 * Define an entry in a Network ACL table.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-14T23:36:09.271Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.NetworkAclEntry")
public class NetworkAclEntry extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.ec2.INetworkAclEntry {

    protected NetworkAclEntry(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NetworkAclEntry(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * EXPERIMENTAL
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public NetworkAclEntry(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.NetworkAclEntryProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The network ACL.
     * <p>
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.INetworkAcl getNetworkAcl() {
        return this.jsiiGet("networkAcl", software.amazon.awscdk.services.ec2.INetworkAcl.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.NetworkAclEntry}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.NetworkAclEntry> {
        /**
         * EXPERIMENTAL
         * <p>
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.NetworkAclEntryProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.NetworkAclEntryProps.Builder();
        }

        /**
         * The CIDR range to allow or deny.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param cidr The CIDR range to allow or deny. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cidr(final software.amazon.awscdk.services.ec2.AclCidr cidr) {
            this.props.cidr(cidr);
            return this;
        }

        /**
         * Rule number to assign to the entry, such as 100.
         * <p>
         * ACL entries are processed in ascending order by rule number.
         * Entries can't use the same rule number unless one is an egress rule and the other is an ingress rule.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param ruleNumber Rule number to assign to the entry, such as 100. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder ruleNumber(final java.lang.Number ruleNumber) {
            this.props.ruleNumber(ruleNumber);
            return this;
        }

        /**
         * What kind of traffic this ACL rule applies to.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param traffic What kind of traffic this ACL rule applies to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder traffic(final software.amazon.awscdk.services.ec2.AclTraffic traffic) {
            this.props.traffic(traffic);
            return this;
        }

        /**
         * Traffic direction, with respect to the subnet, this rule applies to.
         * <p>
         * Default: TrafficDirection.INGRESS
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param direction Traffic direction, with respect to the subnet, this rule applies to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder direction(final software.amazon.awscdk.services.ec2.TrafficDirection direction) {
            this.props.direction(direction);
            return this;
        }

        /**
         * The name of the NetworkAclEntry.
         * <p>
         * It is not recommended to use an explicit group name.
         * <p>
         * Default: If you don't specify a NetworkAclName, AWS CloudFormation generates a
         * unique physical ID and uses that ID for the group name.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param networkAclEntryName The name of the NetworkAclEntry. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder networkAclEntryName(final java.lang.String networkAclEntryName) {
            this.props.networkAclEntryName(networkAclEntryName);
            return this;
        }

        /**
         * Whether to allow or deny traffic that matches the rule; valid values are "allow" or "deny".
         * <p>
         * Any traffic that is not explicitly allowed is automatically denied in a custom
         * ACL, all traffic is automatically allowed in a default ACL.
         * <p>
         * Default: ALLOW
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param ruleAction Whether to allow or deny traffic that matches the rule; valid values are "allow" or "deny". This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder ruleAction(final software.amazon.awscdk.services.ec2.Action ruleAction) {
            this.props.ruleAction(ruleAction);
            return this;
        }

        /**
         * The network ACL this entry applies to.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param networkAcl The network ACL this entry applies to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder networkAcl(final software.amazon.awscdk.services.ec2.INetworkAcl networkAcl) {
            this.props.networkAcl(networkAcl);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.NetworkAclEntry}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.ec2.NetworkAclEntry build() {
            return new software.amazon.awscdk.services.ec2.NetworkAclEntry(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
