package software.amazon.awscdk.services.ec2;

/**
 * Properties to create NetworkAclEntry.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-14T23:36:09.272Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.NetworkAclEntryProps")
@software.amazon.jsii.Jsii.Proxy(NetworkAclEntryProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface NetworkAclEntryProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ec2.CommonNetworkAclEntryOptions {

    /**
     * The network ACL this entry applies to.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.INetworkAcl getNetworkAcl();

    /**
     * @return a {@link Builder} of {@link NetworkAclEntryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NetworkAclEntryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<NetworkAclEntryProps> {
        private software.amazon.awscdk.services.ec2.INetworkAcl networkAcl;
        private software.amazon.awscdk.services.ec2.AclCidr cidr;
        private java.lang.Number ruleNumber;
        private software.amazon.awscdk.services.ec2.AclTraffic traffic;
        private software.amazon.awscdk.services.ec2.TrafficDirection direction;
        private java.lang.String networkAclEntryName;
        private software.amazon.awscdk.services.ec2.Action ruleAction;

        /**
         * Sets the value of {@link NetworkAclEntryProps#getNetworkAcl}
         * @param networkAcl The network ACL this entry applies to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder networkAcl(software.amazon.awscdk.services.ec2.INetworkAcl networkAcl) {
            this.networkAcl = networkAcl;
            return this;
        }

        /**
         * Sets the value of {@link NetworkAclEntryProps#getCidr}
         * @param cidr The CIDR range to allow or deny. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cidr(software.amazon.awscdk.services.ec2.AclCidr cidr) {
            this.cidr = cidr;
            return this;
        }

        /**
         * Sets the value of {@link NetworkAclEntryProps#getRuleNumber}
         * @param ruleNumber Rule number to assign to the entry, such as 100. This parameter is required.
         *                   ACL entries are processed in ascending order by rule number.
         *                   Entries can't use the same rule number unless one is an egress rule and the other is an ingress rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder ruleNumber(java.lang.Number ruleNumber) {
            this.ruleNumber = ruleNumber;
            return this;
        }

        /**
         * Sets the value of {@link NetworkAclEntryProps#getTraffic}
         * @param traffic What kind of traffic this ACL rule applies to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder traffic(software.amazon.awscdk.services.ec2.AclTraffic traffic) {
            this.traffic = traffic;
            return this;
        }

        /**
         * Sets the value of {@link NetworkAclEntryProps#getDirection}
         * @param direction Traffic direction, with respect to the subnet, this rule applies to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder direction(software.amazon.awscdk.services.ec2.TrafficDirection direction) {
            this.direction = direction;
            return this;
        }

        /**
         * Sets the value of {@link NetworkAclEntryProps#getNetworkAclEntryName}
         * @param networkAclEntryName The name of the NetworkAclEntry.
         *                            It is not recommended to use an explicit group name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder networkAclEntryName(java.lang.String networkAclEntryName) {
            this.networkAclEntryName = networkAclEntryName;
            return this;
        }

        /**
         * Sets the value of {@link NetworkAclEntryProps#getRuleAction}
         * @param ruleAction Whether to allow or deny traffic that matches the rule; valid values are "allow" or "deny".
         *                   Any traffic that is not explicitly allowed is automatically denied in a custom
         *                   ACL, all traffic is automatically allowed in a default ACL.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder ruleAction(software.amazon.awscdk.services.ec2.Action ruleAction) {
            this.ruleAction = ruleAction;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NetworkAclEntryProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public NetworkAclEntryProps build() {
            return new Jsii$Proxy(networkAcl, cidr, ruleNumber, traffic, direction, networkAclEntryName, ruleAction);
        }
    }

    /**
     * An implementation for {@link NetworkAclEntryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkAclEntryProps {
        private final software.amazon.awscdk.services.ec2.INetworkAcl networkAcl;
        private final software.amazon.awscdk.services.ec2.AclCidr cidr;
        private final java.lang.Number ruleNumber;
        private final software.amazon.awscdk.services.ec2.AclTraffic traffic;
        private final software.amazon.awscdk.services.ec2.TrafficDirection direction;
        private final java.lang.String networkAclEntryName;
        private final software.amazon.awscdk.services.ec2.Action ruleAction;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.networkAcl = this.jsiiGet("networkAcl", software.amazon.awscdk.services.ec2.INetworkAcl.class);
            this.cidr = this.jsiiGet("cidr", software.amazon.awscdk.services.ec2.AclCidr.class);
            this.ruleNumber = this.jsiiGet("ruleNumber", java.lang.Number.class);
            this.traffic = this.jsiiGet("traffic", software.amazon.awscdk.services.ec2.AclTraffic.class);
            this.direction = this.jsiiGet("direction", software.amazon.awscdk.services.ec2.TrafficDirection.class);
            this.networkAclEntryName = this.jsiiGet("networkAclEntryName", java.lang.String.class);
            this.ruleAction = this.jsiiGet("ruleAction", software.amazon.awscdk.services.ec2.Action.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.ec2.INetworkAcl networkAcl, final software.amazon.awscdk.services.ec2.AclCidr cidr, final java.lang.Number ruleNumber, final software.amazon.awscdk.services.ec2.AclTraffic traffic, final software.amazon.awscdk.services.ec2.TrafficDirection direction, final java.lang.String networkAclEntryName, final software.amazon.awscdk.services.ec2.Action ruleAction) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.networkAcl = java.util.Objects.requireNonNull(networkAcl, "networkAcl is required");
            this.cidr = java.util.Objects.requireNonNull(cidr, "cidr is required");
            this.ruleNumber = java.util.Objects.requireNonNull(ruleNumber, "ruleNumber is required");
            this.traffic = java.util.Objects.requireNonNull(traffic, "traffic is required");
            this.direction = direction;
            this.networkAclEntryName = networkAclEntryName;
            this.ruleAction = ruleAction;
        }

        @Override
        public software.amazon.awscdk.services.ec2.INetworkAcl getNetworkAcl() {
            return this.networkAcl;
        }

        @Override
        public software.amazon.awscdk.services.ec2.AclCidr getCidr() {
            return this.cidr;
        }

        @Override
        public java.lang.Number getRuleNumber() {
            return this.ruleNumber;
        }

        @Override
        public software.amazon.awscdk.services.ec2.AclTraffic getTraffic() {
            return this.traffic;
        }

        @Override
        public software.amazon.awscdk.services.ec2.TrafficDirection getDirection() {
            return this.direction;
        }

        @Override
        public java.lang.String getNetworkAclEntryName() {
            return this.networkAclEntryName;
        }

        @Override
        public software.amazon.awscdk.services.ec2.Action getRuleAction() {
            return this.ruleAction;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("networkAcl", om.valueToTree(this.getNetworkAcl()));
            data.set("cidr", om.valueToTree(this.getCidr()));
            data.set("ruleNumber", om.valueToTree(this.getRuleNumber()));
            data.set("traffic", om.valueToTree(this.getTraffic()));
            if (this.getDirection() != null) {
                data.set("direction", om.valueToTree(this.getDirection()));
            }
            if (this.getNetworkAclEntryName() != null) {
                data.set("networkAclEntryName", om.valueToTree(this.getNetworkAclEntryName()));
            }
            if (this.getRuleAction() != null) {
                data.set("ruleAction", om.valueToTree(this.getRuleAction()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.NetworkAclEntryProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NetworkAclEntryProps.Jsii$Proxy that = (NetworkAclEntryProps.Jsii$Proxy) o;

            if (!networkAcl.equals(that.networkAcl)) return false;
            if (!cidr.equals(that.cidr)) return false;
            if (!ruleNumber.equals(that.ruleNumber)) return false;
            if (!traffic.equals(that.traffic)) return false;
            if (this.direction != null ? !this.direction.equals(that.direction) : that.direction != null) return false;
            if (this.networkAclEntryName != null ? !this.networkAclEntryName.equals(that.networkAclEntryName) : that.networkAclEntryName != null) return false;
            return this.ruleAction != null ? this.ruleAction.equals(that.ruleAction) : that.ruleAction == null;
        }

        @Override
        public int hashCode() {
            int result = this.networkAcl.hashCode();
            result = 31 * result + (this.cidr.hashCode());
            result = 31 * result + (this.ruleNumber.hashCode());
            result = 31 * result + (this.traffic.hashCode());
            result = 31 * result + (this.direction != null ? this.direction.hashCode() : 0);
            result = 31 * result + (this.networkAclEntryName != null ? this.networkAclEntryName.hashCode() : 0);
            result = 31 * result + (this.ruleAction != null ? this.ruleAction.hashCode() : 0);
            return result;
        }
    }
}
