package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::NetworkAclEntry`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.15.1 (build ceff2ca)", date = "2019-08-27T17:28:38.641Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnNetworkAclEntryProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::EC2::NetworkAclEntry.NetworkAclId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-networkaclid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getNetworkAclId();

    /**
     * `AWS::EC2::NetworkAclEntry.Protocol`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-protocol
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Number getProtocol();

    /**
     * `AWS::EC2::NetworkAclEntry.RuleAction`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-ruleaction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getRuleAction();

    /**
     * `AWS::EC2::NetworkAclEntry.RuleNumber`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-rulenumber
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Number getRuleNumber();

    /**
     * `AWS::EC2::NetworkAclEntry.CidrBlock`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-cidrblock
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getCidrBlock();

    /**
     * `AWS::EC2::NetworkAclEntry.Egress`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-egress
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getEgress();

    /**
     * `AWS::EC2::NetworkAclEntry.Icmp`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-icmp
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getIcmp();

    /**
     * `AWS::EC2::NetworkAclEntry.Ipv6CidrBlock`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-ipv6cidrblock
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getIpv6CidrBlock();

    /**
     * `AWS::EC2::NetworkAclEntry.PortRange`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-portrange
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getPortRange();

    /**
     * @return a {@link Builder} of {@link CfnNetworkAclEntryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnNetworkAclEntryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Builder {
        private java.lang.String networkAclId;
        private java.lang.Number protocol;
        private java.lang.String ruleAction;
        private java.lang.Number ruleNumber;
        private java.lang.String cidrBlock;
        private java.lang.Object egress;
        private java.lang.Object icmp;
        private java.lang.String ipv6CidrBlock;
        private java.lang.Object portRange;

        /**
         * Sets the value of NetworkAclId
         * @param networkAclId `AWS::EC2::NetworkAclEntry.NetworkAclId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder networkAclId(java.lang.String networkAclId) {
            this.networkAclId = networkAclId;
            return this;
        }

        /**
         * Sets the value of Protocol
         * @param protocol `AWS::EC2::NetworkAclEntry.Protocol`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder protocol(java.lang.Number protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of RuleAction
         * @param ruleAction `AWS::EC2::NetworkAclEntry.RuleAction`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder ruleAction(java.lang.String ruleAction) {
            this.ruleAction = ruleAction;
            return this;
        }

        /**
         * Sets the value of RuleNumber
         * @param ruleNumber `AWS::EC2::NetworkAclEntry.RuleNumber`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder ruleNumber(java.lang.Number ruleNumber) {
            this.ruleNumber = ruleNumber;
            return this;
        }

        /**
         * Sets the value of CidrBlock
         * @param cidrBlock `AWS::EC2::NetworkAclEntry.CidrBlock`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder cidrBlock(java.lang.String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        /**
         * Sets the value of Egress
         * @param egress `AWS::EC2::NetworkAclEntry.Egress`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder egress(java.lang.Boolean egress) {
            this.egress = egress;
            return this;
        }

        /**
         * Sets the value of Egress
         * @param egress `AWS::EC2::NetworkAclEntry.Egress`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder egress(software.amazon.awscdk.core.IResolvable egress) {
            this.egress = egress;
            return this;
        }

        /**
         * Sets the value of Icmp
         * @param icmp `AWS::EC2::NetworkAclEntry.Icmp`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder icmp(software.amazon.awscdk.core.IResolvable icmp) {
            this.icmp = icmp;
            return this;
        }

        /**
         * Sets the value of Icmp
         * @param icmp `AWS::EC2::NetworkAclEntry.Icmp`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder icmp(software.amazon.awscdk.services.ec2.CfnNetworkAclEntry.IcmpProperty icmp) {
            this.icmp = icmp;
            return this;
        }

        /**
         * Sets the value of Ipv6CidrBlock
         * @param ipv6CidrBlock `AWS::EC2::NetworkAclEntry.Ipv6CidrBlock`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder ipv6CidrBlock(java.lang.String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        /**
         * Sets the value of PortRange
         * @param portRange `AWS::EC2::NetworkAclEntry.PortRange`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder portRange(software.amazon.awscdk.core.IResolvable portRange) {
            this.portRange = portRange;
            return this;
        }

        /**
         * Sets the value of PortRange
         * @param portRange `AWS::EC2::NetworkAclEntry.PortRange`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder portRange(software.amazon.awscdk.services.ec2.CfnNetworkAclEntry.PortRangeProperty portRange) {
            this.portRange = portRange;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnNetworkAclEntryProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnNetworkAclEntryProps build() {
            return new Jsii$Proxy(networkAclId, protocol, ruleAction, ruleNumber, cidrBlock, egress, icmp, ipv6CidrBlock, portRange);
        }

    }

    /**
     * An implementation for {@link CfnNetworkAclEntryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnNetworkAclEntryProps {
        private final java.lang.String networkAclId;
        private final java.lang.Number protocol;
        private final java.lang.String ruleAction;
        private final java.lang.Number ruleNumber;
        private final java.lang.String cidrBlock;
        private final java.lang.Object egress;
        private final java.lang.Object icmp;
        private final java.lang.String ipv6CidrBlock;
        private final java.lang.Object portRange;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.networkAclId = this.jsiiGet("networkAclId", java.lang.String.class);
            this.protocol = this.jsiiGet("protocol", java.lang.Number.class);
            this.ruleAction = this.jsiiGet("ruleAction", java.lang.String.class);
            this.ruleNumber = this.jsiiGet("ruleNumber", java.lang.Number.class);
            this.cidrBlock = this.jsiiGet("cidrBlock", java.lang.String.class);
            this.egress = this.jsiiGet("egress", java.lang.Object.class);
            this.icmp = this.jsiiGet("icmp", java.lang.Object.class);
            this.ipv6CidrBlock = this.jsiiGet("ipv6CidrBlock", java.lang.String.class);
            this.portRange = this.jsiiGet("portRange", java.lang.Object.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String networkAclId, java.lang.Number protocol, java.lang.String ruleAction, java.lang.Number ruleNumber, java.lang.String cidrBlock, java.lang.Object egress, java.lang.Object icmp, java.lang.String ipv6CidrBlock, java.lang.Object portRange) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.networkAclId = java.util.Objects.requireNonNull(networkAclId, "networkAclId is required");
            this.protocol = java.util.Objects.requireNonNull(protocol, "protocol is required");
            this.ruleAction = java.util.Objects.requireNonNull(ruleAction, "ruleAction is required");
            this.ruleNumber = java.util.Objects.requireNonNull(ruleNumber, "ruleNumber is required");
            this.cidrBlock = cidrBlock;
            this.egress = egress;
            this.icmp = icmp;
            this.ipv6CidrBlock = ipv6CidrBlock;
            this.portRange = portRange;
        }

        @Override
        public java.lang.String getNetworkAclId() {
            return this.networkAclId;
        }

        @Override
        public java.lang.Number getProtocol() {
            return this.protocol;
        }

        @Override
        public java.lang.String getRuleAction() {
            return this.ruleAction;
        }

        @Override
        public java.lang.Number getRuleNumber() {
            return this.ruleNumber;
        }

        @Override
        public java.lang.String getCidrBlock() {
            return this.cidrBlock;
        }

        @Override
        public java.lang.Object getEgress() {
            return this.egress;
        }

        @Override
        public java.lang.Object getIcmp() {
            return this.icmp;
        }

        @Override
        public java.lang.String getIpv6CidrBlock() {
            return this.ipv6CidrBlock;
        }

        @Override
        public java.lang.Object getPortRange() {
            return this.portRange;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("networkAclId", om.valueToTree(this.getNetworkAclId()));
            obj.set("protocol", om.valueToTree(this.getProtocol()));
            obj.set("ruleAction", om.valueToTree(this.getRuleAction()));
            obj.set("ruleNumber", om.valueToTree(this.getRuleNumber()));
            if (this.getCidrBlock() != null) {
                obj.set("cidrBlock", om.valueToTree(this.getCidrBlock()));
            }
            if (this.getEgress() != null) {
                obj.set("egress", om.valueToTree(this.getEgress()));
            }
            if (this.getIcmp() != null) {
                obj.set("icmp", om.valueToTree(this.getIcmp()));
            }
            if (this.getIpv6CidrBlock() != null) {
                obj.set("ipv6CidrBlock", om.valueToTree(this.getIpv6CidrBlock()));
            }
            if (this.getPortRange() != null) {
                obj.set("portRange", om.valueToTree(this.getPortRange()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnNetworkAclEntryProps.Jsii$Proxy that = (CfnNetworkAclEntryProps.Jsii$Proxy) o;

            if (!networkAclId.equals(that.networkAclId)) return false;
            if (!protocol.equals(that.protocol)) return false;
            if (!ruleAction.equals(that.ruleAction)) return false;
            if (!ruleNumber.equals(that.ruleNumber)) return false;
            if (this.cidrBlock != null ? !this.cidrBlock.equals(that.cidrBlock) : that.cidrBlock != null) return false;
            if (this.egress != null ? !this.egress.equals(that.egress) : that.egress != null) return false;
            if (this.icmp != null ? !this.icmp.equals(that.icmp) : that.icmp != null) return false;
            if (this.ipv6CidrBlock != null ? !this.ipv6CidrBlock.equals(that.ipv6CidrBlock) : that.ipv6CidrBlock != null) return false;
            return this.portRange != null ? this.portRange.equals(that.portRange) : that.portRange == null;
        }

        @Override
        public int hashCode() {
            int result = this.networkAclId.hashCode();
            result = 31 * result + (this.protocol.hashCode());
            result = 31 * result + (this.ruleAction.hashCode());
            result = 31 * result + (this.ruleNumber.hashCode());
            result = 31 * result + (this.cidrBlock != null ? this.cidrBlock.hashCode() : 0);
            result = 31 * result + (this.egress != null ? this.egress.hashCode() : 0);
            result = 31 * result + (this.icmp != null ? this.icmp.hashCode() : 0);
            result = 31 * result + (this.ipv6CidrBlock != null ? this.ipv6CidrBlock.hashCode() : 0);
            result = 31 * result + (this.portRange != null ? this.portRange.hashCode() : 0);
            return result;
        }

    }
}
