/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.services.ec2.;
import software.amazon.awscdk.services.ec2.CfnEC2Fleet;
import software.amazon.awscdk.services.ec2.CfnEC2FleetProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.CfnEC2Fleet")
public class CfnEC2Fleet
extends CfnResource {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnEC2Fleet.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnEC2Fleet(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEC2Fleet(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnEC2Fleet(Construct scope, String id, CfnEC2FleetProps props) {
        super(JsiiObject.InitializationMode.JSII);
        this.setObjRef(JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")}));
    }

    protected Map<String, Object> renderProperties(Map<String, Object> props) {
        return (Map)this.jsiiCall("renderProperties", Map.class, new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    protected Map<String, Object> getCfnProperties() {
        return (Map)this.jsiiGet("cfnProperties", Map.class);
    }

    public Object getLaunchTemplateConfigs() {
        return this.jsiiGet("launchTemplateConfigs", Object.class);
    }

    public void setLaunchTemplateConfigs(IResolvable value) {
        this.jsiiSet("launchTemplateConfigs", Objects.requireNonNull(value, "launchTemplateConfigs is required"));
    }

    public void setLaunchTemplateConfigs(List<Object> value) {
        this.jsiiSet("launchTemplateConfigs", Objects.requireNonNull(value, "launchTemplateConfigs is required"));
    }

    public Object getTargetCapacitySpecification() {
        return this.jsiiGet("targetCapacitySpecification", Object.class);
    }

    public void setTargetCapacitySpecification(IResolvable value) {
        this.jsiiSet("targetCapacitySpecification", Objects.requireNonNull(value, "targetCapacitySpecification is required"));
    }

    public void setTargetCapacitySpecification(TargetCapacitySpecificationRequestProperty value) {
        this.jsiiSet("targetCapacitySpecification", Objects.requireNonNull(value, "targetCapacitySpecification is required"));
    }

    public String getExcessCapacityTerminationPolicy() {
        return (String)this.jsiiGet("excessCapacityTerminationPolicy", String.class);
    }

    public void setExcessCapacityTerminationPolicy(String value) {
        this.jsiiSet("excessCapacityTerminationPolicy", value);
    }

    public Object getOnDemandOptions() {
        return this.jsiiGet("onDemandOptions", Object.class);
    }

    public void setOnDemandOptions(IResolvable value) {
        this.jsiiSet("onDemandOptions", value);
    }

    public void setOnDemandOptions(OnDemandOptionsRequestProperty value) {
        this.jsiiSet("onDemandOptions", value);
    }

    public Object getReplaceUnhealthyInstances() {
        return this.jsiiGet("replaceUnhealthyInstances", Object.class);
    }

    public void setReplaceUnhealthyInstances(Boolean value) {
        this.jsiiSet("replaceUnhealthyInstances", value);
    }

    public void setReplaceUnhealthyInstances(IResolvable value) {
        this.jsiiSet("replaceUnhealthyInstances", value);
    }

    public Object getSpotOptions() {
        return this.jsiiGet("spotOptions", Object.class);
    }

    public void setSpotOptions(IResolvable value) {
        this.jsiiSet("spotOptions", value);
    }

    public void setSpotOptions(SpotOptionsRequestProperty value) {
        this.jsiiSet("spotOptions", value);
    }

    public Object getTagSpecifications() {
        return this.jsiiGet("tagSpecifications", Object.class);
    }

    public void setTagSpecifications(IResolvable value) {
        this.jsiiSet("tagSpecifications", value);
    }

    public void setTagSpecifications(List<Object> value) {
        this.jsiiSet("tagSpecifications", value);
    }

    public Object getTerminateInstancesWithExpiration() {
        return this.jsiiGet("terminateInstancesWithExpiration", Object.class);
    }

    public void setTerminateInstancesWithExpiration(Boolean value) {
        this.jsiiSet("terminateInstancesWithExpiration", value);
    }

    public void setTerminateInstancesWithExpiration(IResolvable value) {
        this.jsiiSet("terminateInstancesWithExpiration", value);
    }

    public String getType() {
        return (String)this.jsiiGet("type", String.class);
    }

    public void setType(String value) {
        this.jsiiSet("type", value);
    }

    public String getValidFrom() {
        return (String)this.jsiiGet("validFrom", String.class);
    }

    public void setValidFrom(String value) {
        this.jsiiSet("validFrom", value);
    }

    public String getValidUntil() {
        return (String)this.jsiiGet("validUntil", String.class);
    }

    public void setValidUntil(String value) {
        this.jsiiSet("validUntil", value);
    }

    public static interface TargetCapacitySpecificationRequestProperty
    extends JsiiSerializable {
        public Number getTotalTargetCapacity();

        public String getDefaultTargetCapacityType();

        public Number getOnDemandTargetCapacity();

        public Number getSpotTargetCapacity();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Number totalTargetCapacity;
            private String defaultTargetCapacityType;
            private Number onDemandTargetCapacity;
            private Number spotTargetCapacity;

            public Builder totalTargetCapacity(Number totalTargetCapacity) {
                this.totalTargetCapacity = totalTargetCapacity;
                return this;
            }

            public Builder defaultTargetCapacityType(String defaultTargetCapacityType) {
                this.defaultTargetCapacityType = defaultTargetCapacityType;
                return this;
            }

            public Builder onDemandTargetCapacity(Number onDemandTargetCapacity) {
                this.onDemandTargetCapacity = onDemandTargetCapacity;
                return this;
            }

            public Builder spotTargetCapacity(Number spotTargetCapacity) {
                this.spotTargetCapacity = spotTargetCapacity;
                return this;
            }

            public TargetCapacitySpecificationRequestProperty build() {
                return new Jsii.Proxy(this.totalTargetCapacity, this.defaultTargetCapacityType, this.onDemandTargetCapacity, this.spotTargetCapacity, null);
            }
        }
    }

    public static interface TagSpecificationProperty
    extends JsiiSerializable {
        public String getResourceType();

        public List<TagRequestProperty> getTags();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String resourceType;
            private List<TagRequestProperty> tags;

            public Builder resourceType(String resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            public Builder tags(List<TagRequestProperty> tags) {
                this.tags = tags;
                return this;
            }

            public TagSpecificationProperty build() {
                return new Jsii.Proxy(this.resourceType, this.tags, null);
            }
        }
    }

    public static interface TagRequestProperty
    extends JsiiSerializable {
        public String getKey();

        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String key;
            private String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public TagRequestProperty build() {
                return new Jsii.Proxy(this.key, this.value, null);
            }
        }
    }

    public static interface SpotOptionsRequestProperty
    extends JsiiSerializable {
        public String getAllocationStrategy();

        public String getInstanceInterruptionBehavior();

        public Number getInstancePoolsToUseCount();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String allocationStrategy;
            private String instanceInterruptionBehavior;
            private Number instancePoolsToUseCount;

            public Builder allocationStrategy(String allocationStrategy) {
                this.allocationStrategy = allocationStrategy;
                return this;
            }

            public Builder instanceInterruptionBehavior(String instanceInterruptionBehavior) {
                this.instanceInterruptionBehavior = instanceInterruptionBehavior;
                return this;
            }

            public Builder instancePoolsToUseCount(Number instancePoolsToUseCount) {
                this.instancePoolsToUseCount = instancePoolsToUseCount;
                return this;
            }

            public SpotOptionsRequestProperty build() {
                return new Jsii.Proxy(this.allocationStrategy, this.instanceInterruptionBehavior, this.instancePoolsToUseCount, null);
            }
        }
    }

    public static interface OnDemandOptionsRequestProperty
    extends JsiiSerializable {
        public String getAllocationStrategy();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String allocationStrategy;

            public Builder allocationStrategy(String allocationStrategy) {
                this.allocationStrategy = allocationStrategy;
                return this;
            }

            public OnDemandOptionsRequestProperty build() {
                return new Jsii.Proxy(this.allocationStrategy, null);
            }
        }
    }

    public static interface FleetLaunchTemplateSpecificationRequestProperty
    extends JsiiSerializable {
        public String getLaunchTemplateId();

        public String getLaunchTemplateName();

        public String getVersion();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String launchTemplateId;
            private String launchTemplateName;
            private String version;

            public Builder launchTemplateId(String launchTemplateId) {
                this.launchTemplateId = launchTemplateId;
                return this;
            }

            public Builder launchTemplateName(String launchTemplateName) {
                this.launchTemplateName = launchTemplateName;
                return this;
            }

            public Builder version(String version) {
                this.version = version;
                return this;
            }

            public FleetLaunchTemplateSpecificationRequestProperty build() {
                return new Jsii.Proxy(this.launchTemplateId, this.launchTemplateName, this.version, null);
            }
        }
    }

    public static interface FleetLaunchTemplateOverridesRequestProperty
    extends JsiiSerializable {
        public String getAvailabilityZone();

        public String getInstanceType();

        public String getMaxPrice();

        public Number getPriority();

        public String getSubnetId();

        public Number getWeightedCapacity();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String availabilityZone;
            private String instanceType;
            private String maxPrice;
            private Number priority;
            private String subnetId;
            private Number weightedCapacity;

            public Builder availabilityZone(String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            public Builder instanceType(String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            public Builder maxPrice(String maxPrice) {
                this.maxPrice = maxPrice;
                return this;
            }

            public Builder priority(Number priority) {
                this.priority = priority;
                return this;
            }

            public Builder subnetId(String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            public Builder weightedCapacity(Number weightedCapacity) {
                this.weightedCapacity = weightedCapacity;
                return this;
            }

            public FleetLaunchTemplateOverridesRequestProperty build() {
                return new Jsii.Proxy(this.availabilityZone, this.instanceType, this.maxPrice, this.priority, this.subnetId, this.weightedCapacity, null);
            }
        }
    }

    public static interface FleetLaunchTemplateConfigRequestProperty
    extends JsiiSerializable {
        public Object getLaunchTemplateSpecification();

        public Object getOverrides();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object launchTemplateSpecification;
            private Object overrides;

            public Builder launchTemplateSpecification(IResolvable launchTemplateSpecification) {
                this.launchTemplateSpecification = launchTemplateSpecification;
                return this;
            }

            public Builder launchTemplateSpecification(FleetLaunchTemplateSpecificationRequestProperty launchTemplateSpecification) {
                this.launchTemplateSpecification = launchTemplateSpecification;
                return this;
            }

            public Builder overrides(IResolvable overrides) {
                this.overrides = overrides;
                return this;
            }

            public Builder overrides(List<Object> overrides) {
                this.overrides = overrides;
                return this;
            }

            public FleetLaunchTemplateConfigRequestProperty build() {
                return new Jsii.Proxy(this.launchTemplateSpecification, this.overrides, null);
            }
        }
    }
}

