/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.List;
import software.amazon.awscdk.services.ec2.ConnectionsProps;
import software.amazon.awscdk.services.ec2.IPeer;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.Port;
import software.amazon.jsii.JsiiSerializable;

public interface ConnectionsProps
extends JsiiSerializable {
    public Port getDefaultPort();

    public IPeer getPeer();

    public List<ISecurityGroup> getSecurityGroups();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Port defaultPort;
        private IPeer peer;
        private List<ISecurityGroup> securityGroups;

        public Builder defaultPort(Port defaultPort) {
            this.defaultPort = defaultPort;
            return this;
        }

        public Builder peer(IPeer peer) {
            this.peer = peer;
            return this;
        }

        public Builder securityGroups(List<ISecurityGroup> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        public ConnectionsProps build() {
            return new Jsii.Proxy(this.defaultPort, this.peer, this.securityGroups, null);
        }
    }
}

