package software.amazon.awscdk.services.ec2;

/**
 * Factory functions for standard Amazon Machine Image objects.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.11.0 (build 1e9b8e1)", date = "2020-08-27T08:37:45.036Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.MachineImage")
public abstract class MachineImage extends software.amazon.jsii.JsiiObject {

    protected MachineImage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected MachineImage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected MachineImage() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * A Linux image where you specify the AMI ID for every region.
     * <p>
     * @param amiMap For every region where you are deploying the stack, specify the AMI ID for that region. This parameter is required.
     * @param props Customize the image by supplying additional props.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage genericLinux(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> amiMap, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.GenericLinuxImageProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "genericLinux", software.amazon.awscdk.services.ec2.IMachineImage.class, new Object[] { java.util.Objects.requireNonNull(amiMap, "amiMap is required"), props });
    }

    /**
     * A Linux image where you specify the AMI ID for every region.
     * <p>
     * @param amiMap For every region where you are deploying the stack, specify the AMI ID for that region. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage genericLinux(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> amiMap) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "genericLinux", software.amazon.awscdk.services.ec2.IMachineImage.class, new Object[] { java.util.Objects.requireNonNull(amiMap, "amiMap is required") });
    }

    /**
     * A Windows image where you specify the AMI ID for every region.
     * <p>
     * @param amiMap For every region where you are deploying the stack, specify the AMI ID for that region. This parameter is required.
     * @param props Customize the image by supplying additional props.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage genericWindows(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> amiMap, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.GenericWindowsImageProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "genericWindows", software.amazon.awscdk.services.ec2.IMachineImage.class, new Object[] { java.util.Objects.requireNonNull(amiMap, "amiMap is required"), props });
    }

    /**
     * A Windows image where you specify the AMI ID for every region.
     * <p>
     * @param amiMap For every region where you are deploying the stack, specify the AMI ID for that region. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage genericWindows(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> amiMap) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "genericWindows", software.amazon.awscdk.services.ec2.IMachineImage.class, new Object[] { java.util.Objects.requireNonNull(amiMap, "amiMap is required") });
    }

    /**
     * An Amazon Linux image that is automatically kept up-to-date.
     * <p>
     * This Machine Image automatically updates to the latest version on every
     * deployment. Be aware this will cause your instances to be replaced when a
     * new version of the image becomes available. Do not store stateful information
     * on the instance if you are using this image.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage latestAmazonLinux(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.AmazonLinuxImageProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "latestAmazonLinux", software.amazon.awscdk.services.ec2.IMachineImage.class, new Object[] { props });
    }

    /**
     * An Amazon Linux image that is automatically kept up-to-date.
     * <p>
     * This Machine Image automatically updates to the latest version on every
     * deployment. Be aware this will cause your instances to be replaced when a
     * new version of the image becomes available. Do not store stateful information
     * on the instance if you are using this image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage latestAmazonLinux() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "latestAmazonLinux", software.amazon.awscdk.services.ec2.IMachineImage.class);
    }

    /**
     * A Windows image that is automatically kept up-to-date.
     * <p>
     * This Machine Image automatically updates to the latest version on every
     * deployment. Be aware this will cause your instances to be replaced when a
     * new version of the image becomes available. Do not store stateful information
     * on the instance if you are using this image.
     * <p>
     * @param version This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage latestWindows(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.WindowsVersion version, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.WindowsImageProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "latestWindows", software.amazon.awscdk.services.ec2.IMachineImage.class, new Object[] { java.util.Objects.requireNonNull(version, "version is required"), props });
    }

    /**
     * A Windows image that is automatically kept up-to-date.
     * <p>
     * This Machine Image automatically updates to the latest version on every
     * deployment. Be aware this will cause your instances to be replaced when a
     * new version of the image becomes available. Do not store stateful information
     * on the instance if you are using this image.
     * <p>
     * @param version This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage latestWindows(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.WindowsVersion version) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "latestWindows", software.amazon.awscdk.services.ec2.IMachineImage.class, new Object[] { java.util.Objects.requireNonNull(version, "version is required") });
    }

    /**
     * Look up a shared Machine Image using DescribeImages.
     * <p>
     * The most recent, available, launchable image matching the given filter
     * criteria will be used. Looking up AMIs may take a long time; specify
     * as many filter criteria as possible to narrow down the search.
     * <p>
     * The AMI selected will be cached in <code>cdk.context.json</code> and the same value
     * will be used on future runs. To refresh the AMI lookup, you will have to
     * evict the value from the cache using the <code>cdk context</code> command. See
     * https://docs.aws.amazon.com/cdk/latest/guide/context.html for more information.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage lookup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.LookupMachineImageProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "lookup", software.amazon.awscdk.services.ec2.IMachineImage.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.awscdk.services.ec2.MachineImage {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
