package software.amazon.awscdk.services.ec2;

/**
 * Options for applying CloudFormation init to an instance or instance group.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.11.0 (build 1e9b8e1)", date = "2020-08-28T10:19:21.038Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.ApplyCloudFormationInitOptions")
@software.amazon.jsii.Jsii.Proxy(ApplyCloudFormationInitOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApplyCloudFormationInitOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * ConfigSet to activate.
     * <p>
     * Default: ['default']
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getConfigSets() {
        return null;
    }

    /**
     * Force instance replacement by embedding a config fingerprint.
     * <p>
     * If <code>true</code> (the default), a hash of the config will be embedded into the
     * UserData, so that if the config changes, the UserData changes.
     * <p>
     * <ul>
     * <li>If the EC2 instance is instance-store backed or
     * <code>userDataCausesReplacement</code> is set, this will cause the instance to be
     * replaced and the new configuration to be applied.</li>
     * <li>If the instance is EBS-backed and <code>userDataCausesReplacement</code> is not
     * set, the change of UserData will make the instance restart but not be
     * replaced, and the configuration will not be applied automatically.</li>
     * </ul>
     * <p>
     * If <code>false</code>, no hash will be embedded, and if the CloudFormation Init
     * config changes nothing will happen to the running instance. If a
     * config update introduces errors, you will not notice until after the
     * CloudFormation deployment successfully finishes and the next instance
     * fails to launch.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEmbedFingerprint() {
        return null;
    }

    /**
     * Don't fail the instance creation when cfn-init fails.
     * <p>
     * You can use this to prevent CloudFormation from rolling back when
     * instances fail to start up, to help in debugging.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIgnoreFailures() {
        return null;
    }

    /**
     * Print the results of running cfn-init to the Instance System Log.
     * <p>
     * By default, the output of running cfn-init is written to a log file
     * on the instance. Set this to <code>true</code> to print it to the System Log
     * (visible from the EC2 Console), <code>false</code> to not print it.
     * <p>
     * (Be aware that the system log is refreshed at certain points in
     * time of the instance life cycle, and successful execution may
     * not always show up).
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPrintLog() {
        return null;
    }

    /**
     * Timeout waiting for the configuration to be applied.
     * <p>
     * Default: Duration.minutes(5)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getTimeout() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ApplyCloudFormationInitOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApplyCloudFormationInitOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ApplyCloudFormationInitOptions> {
        private java.util.List<java.lang.String> configSets;
        private java.lang.Boolean embedFingerprint;
        private java.lang.Boolean ignoreFailures;
        private java.lang.Boolean printLog;
        private software.amazon.awscdk.core.Duration timeout;

        /**
         * Sets the value of {@link ApplyCloudFormationInitOptions#getConfigSets}
         * @param configSets ConfigSet to activate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configSets(java.util.List<java.lang.String> configSets) {
            this.configSets = configSets;
            return this;
        }

        /**
         * Sets the value of {@link ApplyCloudFormationInitOptions#getEmbedFingerprint}
         * @param embedFingerprint Force instance replacement by embedding a config fingerprint.
         *                         If <code>true</code> (the default), a hash of the config will be embedded into the
         *                         UserData, so that if the config changes, the UserData changes.
         *                         <p>
         *                         <ul>
         *                         <li>If the EC2 instance is instance-store backed or
         *                         <code>userDataCausesReplacement</code> is set, this will cause the instance to be
         *                         replaced and the new configuration to be applied.</li>
         *                         <li>If the instance is EBS-backed and <code>userDataCausesReplacement</code> is not
         *                         set, the change of UserData will make the instance restart but not be
         *                         replaced, and the configuration will not be applied automatically.</li>
         *                         </ul>
         *                         <p>
         *                         If <code>false</code>, no hash will be embedded, and if the CloudFormation Init
         *                         config changes nothing will happen to the running instance. If a
         *                         config update introduces errors, you will not notice until after the
         *                         CloudFormation deployment successfully finishes and the next instance
         *                         fails to launch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder embedFingerprint(java.lang.Boolean embedFingerprint) {
            this.embedFingerprint = embedFingerprint;
            return this;
        }

        /**
         * Sets the value of {@link ApplyCloudFormationInitOptions#getIgnoreFailures}
         * @param ignoreFailures Don't fail the instance creation when cfn-init fails.
         *                       You can use this to prevent CloudFormation from rolling back when
         *                       instances fail to start up, to help in debugging.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreFailures(java.lang.Boolean ignoreFailures) {
            this.ignoreFailures = ignoreFailures;
            return this;
        }

        /**
         * Sets the value of {@link ApplyCloudFormationInitOptions#getPrintLog}
         * @param printLog Print the results of running cfn-init to the Instance System Log.
         *                 By default, the output of running cfn-init is written to a log file
         *                 on the instance. Set this to <code>true</code> to print it to the System Log
         *                 (visible from the EC2 Console), <code>false</code> to not print it.
         *                 <p>
         *                 (Be aware that the system log is refreshed at certain points in
         *                 time of the instance life cycle, and successful execution may
         *                 not always show up).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder printLog(java.lang.Boolean printLog) {
            this.printLog = printLog;
            return this;
        }

        /**
         * Sets the value of {@link ApplyCloudFormationInitOptions#getTimeout}
         * @param timeout Timeout waiting for the configuration to be applied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.core.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplyCloudFormationInitOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ApplyCloudFormationInitOptions build() {
            return new Jsii$Proxy(configSets, embedFingerprint, ignoreFailures, printLog, timeout);
        }
    }

    /**
     * An implementation for {@link ApplyCloudFormationInitOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplyCloudFormationInitOptions {
        private final java.util.List<java.lang.String> configSets;
        private final java.lang.Boolean embedFingerprint;
        private final java.lang.Boolean ignoreFailures;
        private final java.lang.Boolean printLog;
        private final software.amazon.awscdk.core.Duration timeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.configSets = this.jsiiGet("configSets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.embedFingerprint = this.jsiiGet("embedFingerprint", java.lang.Boolean.class);
            this.ignoreFailures = this.jsiiGet("ignoreFailures", java.lang.Boolean.class);
            this.printLog = this.jsiiGet("printLog", java.lang.Boolean.class);
            this.timeout = this.jsiiGet("timeout", software.amazon.awscdk.core.Duration.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.util.List<java.lang.String> configSets, final java.lang.Boolean embedFingerprint, final java.lang.Boolean ignoreFailures, final java.lang.Boolean printLog, final software.amazon.awscdk.core.Duration timeout) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.configSets = configSets;
            this.embedFingerprint = embedFingerprint;
            this.ignoreFailures = ignoreFailures;
            this.printLog = printLog;
            this.timeout = timeout;
        }

        @Override
        public java.util.List<java.lang.String> getConfigSets() {
            return this.configSets;
        }

        @Override
        public java.lang.Boolean getEmbedFingerprint() {
            return this.embedFingerprint;
        }

        @Override
        public java.lang.Boolean getIgnoreFailures() {
            return this.ignoreFailures;
        }

        @Override
        public java.lang.Boolean getPrintLog() {
            return this.printLog;
        }

        @Override
        public software.amazon.awscdk.core.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getConfigSets() != null) {
                data.set("configSets", om.valueToTree(this.getConfigSets()));
            }
            if (this.getEmbedFingerprint() != null) {
                data.set("embedFingerprint", om.valueToTree(this.getEmbedFingerprint()));
            }
            if (this.getIgnoreFailures() != null) {
                data.set("ignoreFailures", om.valueToTree(this.getIgnoreFailures()));
            }
            if (this.getPrintLog() != null) {
                data.set("printLog", om.valueToTree(this.getPrintLog()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.ApplyCloudFormationInitOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApplyCloudFormationInitOptions.Jsii$Proxy that = (ApplyCloudFormationInitOptions.Jsii$Proxy) o;

            if (this.configSets != null ? !this.configSets.equals(that.configSets) : that.configSets != null) return false;
            if (this.embedFingerprint != null ? !this.embedFingerprint.equals(that.embedFingerprint) : that.embedFingerprint != null) return false;
            if (this.ignoreFailures != null ? !this.ignoreFailures.equals(that.ignoreFailures) : that.ignoreFailures != null) return false;
            if (this.printLog != null ? !this.printLog.equals(that.printLog) : that.printLog != null) return false;
            return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
        }

        @Override
        public int hashCode() {
            int result = this.configSets != null ? this.configSets.hashCode() : 0;
            result = 31 * result + (this.embedFingerprint != null ? this.embedFingerprint.hashCode() : 0);
            result = 31 * result + (this.ignoreFailures != null ? this.ignoreFailures.hashCode() : 0);
            result = 31 * result + (this.printLog != null ? this.printLog.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            return result;
        }
    }
}
