package software.amazon.awscdk.services.ec2;

/**
 * Additional options for an InitSource that builds an asset from local files.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.11.0 (build 1e9b8e1)", date = "2020-08-28T10:19:21.201Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.InitSourceAssetOptions")
@software.amazon.jsii.Jsii.Proxy(InitSourceAssetOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface InitSourceAssetOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ec2.InitSourceOptions, software.amazon.awscdk.services.s3.assets.AssetOptions {

    /**
     * @return a {@link Builder} of {@link InitSourceAssetOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link InitSourceAssetOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<InitSourceAssetOptions> {
        private java.util.List<software.amazon.awscdk.services.ec2.InitServiceRestartHandle> serviceRestartHandles;
        private java.util.List<software.amazon.awscdk.services.iam.IGrantable> readers;
        private java.lang.String sourceHash;
        private java.util.List<java.lang.String> exclude;
        private software.amazon.awscdk.assets.FollowMode follow;
        private java.lang.String assetHash;
        private software.amazon.awscdk.core.AssetHashType assetHashType;
        private software.amazon.awscdk.core.BundlingOptions bundling;

        /**
         * Sets the value of {@link InitSourceAssetOptions#getServiceRestartHandles}
         * @param serviceRestartHandles Restart the given services after this archive has been extracted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRestartHandles(java.util.List<software.amazon.awscdk.services.ec2.InitServiceRestartHandle> serviceRestartHandles) {
            this.serviceRestartHandles = serviceRestartHandles;
            return this;
        }

        /**
         * Sets the value of {@link InitSourceAssetOptions#getReaders}
         * @param readers A list of principals that should be able to read this asset from S3.
         *                You can use <code>asset.grantRead(principal)</code> to grant read permissions later.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder readers(java.util.List<software.amazon.awscdk.services.iam.IGrantable> readers) {
            this.readers = readers;
            return this;
        }

        /**
         * Sets the value of {@link InitSourceAssetOptions#getSourceHash}
         * @param sourceHash Custom hash to use when identifying the specific version of the asset.
         *                   For consistency,
         *                   this custom hash will be SHA256 hashed and encoded as hex. The resulting hash will be
         *                   the asset hash.
         *                   <p>
         *                   NOTE: the source hash is used in order to identify a specific revision of the asset,
         *                   and used for optimizing and caching deployment activities related to this asset such as
         *                   packaging, uploading to Amazon S3, etc. If you chose to customize the source hash,
         *                   you will need to make sure it is updated every time the source changes, or otherwise
         *                   it is possible that some deployments will not be invalidated.
         * @return {@code this}
         * @deprecated see `assetHash` and `assetHashType`
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder sourceHash(java.lang.String sourceHash) {
            this.sourceHash = sourceHash;
            return this;
        }

        /**
         * Sets the value of {@link InitSourceAssetOptions#getExclude}
         * @param exclude Glob patterns to exclude from the copy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder exclude(java.util.List<java.lang.String> exclude) {
            this.exclude = exclude;
            return this;
        }

        /**
         * Sets the value of {@link InitSourceAssetOptions#getFollow}
         * @param follow A strategy for how to handle symlinks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder follow(software.amazon.awscdk.assets.FollowMode follow) {
            this.follow = follow;
            return this;
        }

        /**
         * Sets the value of {@link InitSourceAssetOptions#getAssetHash}
         * @param assetHash Specify a custom hash for this asset.
         *                  If <code>assetHashType</code> is set it must
         *                  be set to <code>AssetHashType.CUSTOM</code>. For consistency, this custom hash will
         *                  be SHA256 hashed and encoded as hex. The resulting hash will be the asset
         *                  hash.
         *                  <p>
         *                  NOTE: the hash is used in order to identify a specific revision of the asset, and
         *                  used for optimizing and caching deployment activities related to this asset such as
         *                  packaging, uploading to Amazon S3, etc. If you chose to customize the hash, you will
         *                  need to make sure it is updated every time the asset changes, or otherwise it is
         *                  possible that some deployments will not be invalidated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetHash(java.lang.String assetHash) {
            this.assetHash = assetHash;
            return this;
        }

        /**
         * Sets the value of {@link InitSourceAssetOptions#getAssetHashType}
         * @param assetHashType Specifies the type of hash to calculate for this asset.
         *                      If <code>assetHash</code> is configured, this option must be <code>undefined</code> or
         *                      <code>AssetHashType.CUSTOM</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetHashType(software.amazon.awscdk.core.AssetHashType assetHashType) {
            this.assetHashType = assetHashType;
            return this;
        }

        /**
         * Sets the value of {@link InitSourceAssetOptions#getBundling}
         * @param bundling Bundle the asset by executing a command in a Docker container.
         *                 The asset path will be mounted at <code>/asset-input</code>. The Docker
         *                 container is responsible for putting content at <code>/asset-output</code>.
         *                 The content at <code>/asset-output</code> will be zipped and used as the
         *                 final asset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bundling(software.amazon.awscdk.core.BundlingOptions bundling) {
            this.bundling = bundling;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InitSourceAssetOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public InitSourceAssetOptions build() {
            return new Jsii$Proxy(serviceRestartHandles, readers, sourceHash, exclude, follow, assetHash, assetHashType, bundling);
        }
    }

    /**
     * An implementation for {@link InitSourceAssetOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InitSourceAssetOptions {
        private final java.util.List<software.amazon.awscdk.services.ec2.InitServiceRestartHandle> serviceRestartHandles;
        private final java.util.List<software.amazon.awscdk.services.iam.IGrantable> readers;
        private final java.lang.String sourceHash;
        private final java.util.List<java.lang.String> exclude;
        private final software.amazon.awscdk.assets.FollowMode follow;
        private final java.lang.String assetHash;
        private final software.amazon.awscdk.core.AssetHashType assetHashType;
        private final software.amazon.awscdk.core.BundlingOptions bundling;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.serviceRestartHandles = this.jsiiGet("serviceRestartHandles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InitServiceRestartHandle.class)));
            this.readers = this.jsiiGet("readers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IGrantable.class)));
            this.sourceHash = this.jsiiGet("sourceHash", java.lang.String.class);
            this.exclude = this.jsiiGet("exclude", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.follow = this.jsiiGet("follow", software.amazon.awscdk.assets.FollowMode.class);
            this.assetHash = this.jsiiGet("assetHash", java.lang.String.class);
            this.assetHashType = this.jsiiGet("assetHashType", software.amazon.awscdk.core.AssetHashType.class);
            this.bundling = this.jsiiGet("bundling", software.amazon.awscdk.core.BundlingOptions.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.util.List<software.amazon.awscdk.services.ec2.InitServiceRestartHandle> serviceRestartHandles, final java.util.List<software.amazon.awscdk.services.iam.IGrantable> readers, final java.lang.String sourceHash, final java.util.List<java.lang.String> exclude, final software.amazon.awscdk.assets.FollowMode follow, final java.lang.String assetHash, final software.amazon.awscdk.core.AssetHashType assetHashType, final software.amazon.awscdk.core.BundlingOptions bundling) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.serviceRestartHandles = serviceRestartHandles;
            this.readers = readers;
            this.sourceHash = sourceHash;
            this.exclude = exclude;
            this.follow = follow;
            this.assetHash = assetHash;
            this.assetHashType = assetHashType;
            this.bundling = bundling;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.ec2.InitServiceRestartHandle> getServiceRestartHandles() {
            return this.serviceRestartHandles;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.iam.IGrantable> getReaders() {
            return this.readers;
        }

        @Override
        public java.lang.String getSourceHash() {
            return this.sourceHash;
        }

        @Override
        public java.util.List<java.lang.String> getExclude() {
            return this.exclude;
        }

        @Override
        public software.amazon.awscdk.assets.FollowMode getFollow() {
            return this.follow;
        }

        @Override
        public java.lang.String getAssetHash() {
            return this.assetHash;
        }

        @Override
        public software.amazon.awscdk.core.AssetHashType getAssetHashType() {
            return this.assetHashType;
        }

        @Override
        public software.amazon.awscdk.core.BundlingOptions getBundling() {
            return this.bundling;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getServiceRestartHandles() != null) {
                data.set("serviceRestartHandles", om.valueToTree(this.getServiceRestartHandles()));
            }
            if (this.getReaders() != null) {
                data.set("readers", om.valueToTree(this.getReaders()));
            }
            if (this.getSourceHash() != null) {
                data.set("sourceHash", om.valueToTree(this.getSourceHash()));
            }
            if (this.getExclude() != null) {
                data.set("exclude", om.valueToTree(this.getExclude()));
            }
            if (this.getFollow() != null) {
                data.set("follow", om.valueToTree(this.getFollow()));
            }
            if (this.getAssetHash() != null) {
                data.set("assetHash", om.valueToTree(this.getAssetHash()));
            }
            if (this.getAssetHashType() != null) {
                data.set("assetHashType", om.valueToTree(this.getAssetHashType()));
            }
            if (this.getBundling() != null) {
                data.set("bundling", om.valueToTree(this.getBundling()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.InitSourceAssetOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            InitSourceAssetOptions.Jsii$Proxy that = (InitSourceAssetOptions.Jsii$Proxy) o;

            if (this.serviceRestartHandles != null ? !this.serviceRestartHandles.equals(that.serviceRestartHandles) : that.serviceRestartHandles != null) return false;
            if (this.readers != null ? !this.readers.equals(that.readers) : that.readers != null) return false;
            if (this.sourceHash != null ? !this.sourceHash.equals(that.sourceHash) : that.sourceHash != null) return false;
            if (this.exclude != null ? !this.exclude.equals(that.exclude) : that.exclude != null) return false;
            if (this.follow != null ? !this.follow.equals(that.follow) : that.follow != null) return false;
            if (this.assetHash != null ? !this.assetHash.equals(that.assetHash) : that.assetHash != null) return false;
            if (this.assetHashType != null ? !this.assetHashType.equals(that.assetHashType) : that.assetHashType != null) return false;
            return this.bundling != null ? this.bundling.equals(that.bundling) : that.bundling == null;
        }

        @Override
        public int hashCode() {
            int result = this.serviceRestartHandles != null ? this.serviceRestartHandles.hashCode() : 0;
            result = 31 * result + (this.readers != null ? this.readers.hashCode() : 0);
            result = 31 * result + (this.sourceHash != null ? this.sourceHash.hashCode() : 0);
            result = 31 * result + (this.exclude != null ? this.exclude.hashCode() : 0);
            result = 31 * result + (this.follow != null ? this.follow.hashCode() : 0);
            result = 31 * result + (this.assetHash != null ? this.assetHash.hashCode() : 0);
            result = 31 * result + (this.assetHashType != null ? this.assetHashType.hashCode() : 0);
            result = 31 * result + (this.bundling != null ? this.bundling.hashCode() : 0);
            return result;
        }
    }
}
