package software.amazon.awscdk.services.ec2;

/**
 * Options for InitCommand.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.11.0 (build 1e9b8e1)", date = "2020-09-03T17:04:20.052Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.InitCommandOptions")
@software.amazon.jsii.Jsii.Proxy(InitCommandOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface InitCommandOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The working directory.
     * <p>
     * Default: - Use default working directory
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCwd() {
        return null;
    }

    /**
     * Sets environment variables for the command.
     * <p>
     * This property overwrites, rather than appends, the existing environment.
     * <p>
     * Default: - Use current environment
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnv() {
        return null;
    }

    /**
     * Continue running if this command fails.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIgnoreErrors() {
        return null;
    }

    /**
     * Identifier key for this command.
     * <p>
     * Commands are executed in lexicographical order of their key names.
     * <p>
     * Default: - Automatically generated based on index
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
        return null;
    }

    /**
     * Restart the given service(s) after this command has run.
     * <p>
     * Default: - Do not restart any service
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.InitServiceRestartHandle> getServiceRestartHandles() {
        return null;
    }

    /**
     * Command to determine whether this command should be run.
     * <p>
     * If the test passes (exits with error code of 0), the command is run.
     * <p>
     * Default: - Always run the command
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTestCmd() {
        return null;
    }

    /**
     * The duration to wait after a command has finished in case the command causes a reboot.
     * <p>
     * Set this value to <code>InitCommandWaitDuration.none()</code> if you do not want to wait for every command;
     * <code>InitCommandWaitDuration.forever()</code> directs cfn-init to exit and resume only after the reboot is complete.
     * <p>
     * For Windows systems only.
     * <p>
     * Default: - 60 seconds
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.InitCommandWaitDuration getWaitAfterCompletion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link InitCommandOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link InitCommandOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<InitCommandOptions> {
        private java.lang.String cwd;
        private java.util.Map<java.lang.String, java.lang.String> env;
        private java.lang.Boolean ignoreErrors;
        private java.lang.String key;
        private java.util.List<software.amazon.awscdk.services.ec2.InitServiceRestartHandle> serviceRestartHandles;
        private java.lang.String testCmd;
        private software.amazon.awscdk.services.ec2.InitCommandWaitDuration waitAfterCompletion;

        /**
         * Sets the value of {@link InitCommandOptions#getCwd}
         * @param cwd The working directory.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cwd(java.lang.String cwd) {
            this.cwd = cwd;
            return this;
        }

        /**
         * Sets the value of {@link InitCommandOptions#getEnv}
         * @param env Sets environment variables for the command.
         *            This property overwrites, rather than appends, the existing environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder env(java.util.Map<java.lang.String, java.lang.String> env) {
            this.env = env;
            return this;
        }

        /**
         * Sets the value of {@link InitCommandOptions#getIgnoreErrors}
         * @param ignoreErrors Continue running if this command fails.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreErrors(java.lang.Boolean ignoreErrors) {
            this.ignoreErrors = ignoreErrors;
            return this;
        }

        /**
         * Sets the value of {@link InitCommandOptions#getKey}
         * @param key Identifier key for this command.
         *            Commands are executed in lexicographical order of their key names.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder key(java.lang.String key) {
            this.key = key;
            return this;
        }

        /**
         * Sets the value of {@link InitCommandOptions#getServiceRestartHandles}
         * @param serviceRestartHandles Restart the given service(s) after this command has run.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRestartHandles(java.util.List<software.amazon.awscdk.services.ec2.InitServiceRestartHandle> serviceRestartHandles) {
            this.serviceRestartHandles = serviceRestartHandles;
            return this;
        }

        /**
         * Sets the value of {@link InitCommandOptions#getTestCmd}
         * @param testCmd Command to determine whether this command should be run.
         *                If the test passes (exits with error code of 0), the command is run.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder testCmd(java.lang.String testCmd) {
            this.testCmd = testCmd;
            return this;
        }

        /**
         * Sets the value of {@link InitCommandOptions#getWaitAfterCompletion}
         * @param waitAfterCompletion The duration to wait after a command has finished in case the command causes a reboot.
         *                            Set this value to <code>InitCommandWaitDuration.none()</code> if you do not want to wait for every command;
         *                            <code>InitCommandWaitDuration.forever()</code> directs cfn-init to exit and resume only after the reboot is complete.
         *                            <p>
         *                            For Windows systems only.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder waitAfterCompletion(software.amazon.awscdk.services.ec2.InitCommandWaitDuration waitAfterCompletion) {
            this.waitAfterCompletion = waitAfterCompletion;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InitCommandOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public InitCommandOptions build() {
            return new Jsii$Proxy(cwd, env, ignoreErrors, key, serviceRestartHandles, testCmd, waitAfterCompletion);
        }
    }

    /**
     * An implementation for {@link InitCommandOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InitCommandOptions {
        private final java.lang.String cwd;
        private final java.util.Map<java.lang.String, java.lang.String> env;
        private final java.lang.Boolean ignoreErrors;
        private final java.lang.String key;
        private final java.util.List<software.amazon.awscdk.services.ec2.InitServiceRestartHandle> serviceRestartHandles;
        private final java.lang.String testCmd;
        private final software.amazon.awscdk.services.ec2.InitCommandWaitDuration waitAfterCompletion;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cwd = this.jsiiGet("cwd", java.lang.String.class);
            this.env = this.jsiiGet("env", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.ignoreErrors = this.jsiiGet("ignoreErrors", java.lang.Boolean.class);
            this.key = this.jsiiGet("key", java.lang.String.class);
            this.serviceRestartHandles = this.jsiiGet("serviceRestartHandles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InitServiceRestartHandle.class)));
            this.testCmd = this.jsiiGet("testCmd", java.lang.String.class);
            this.waitAfterCompletion = this.jsiiGet("waitAfterCompletion", software.amazon.awscdk.services.ec2.InitCommandWaitDuration.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String cwd, final java.util.Map<java.lang.String, java.lang.String> env, final java.lang.Boolean ignoreErrors, final java.lang.String key, final java.util.List<software.amazon.awscdk.services.ec2.InitServiceRestartHandle> serviceRestartHandles, final java.lang.String testCmd, final software.amazon.awscdk.services.ec2.InitCommandWaitDuration waitAfterCompletion) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cwd = cwd;
            this.env = env;
            this.ignoreErrors = ignoreErrors;
            this.key = key;
            this.serviceRestartHandles = serviceRestartHandles;
            this.testCmd = testCmd;
            this.waitAfterCompletion = waitAfterCompletion;
        }

        @Override
        public java.lang.String getCwd() {
            return this.cwd;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getEnv() {
            return this.env;
        }

        @Override
        public java.lang.Boolean getIgnoreErrors() {
            return this.ignoreErrors;
        }

        @Override
        public java.lang.String getKey() {
            return this.key;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.ec2.InitServiceRestartHandle> getServiceRestartHandles() {
            return this.serviceRestartHandles;
        }

        @Override
        public java.lang.String getTestCmd() {
            return this.testCmd;
        }

        @Override
        public software.amazon.awscdk.services.ec2.InitCommandWaitDuration getWaitAfterCompletion() {
            return this.waitAfterCompletion;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCwd() != null) {
                data.set("cwd", om.valueToTree(this.getCwd()));
            }
            if (this.getEnv() != null) {
                data.set("env", om.valueToTree(this.getEnv()));
            }
            if (this.getIgnoreErrors() != null) {
                data.set("ignoreErrors", om.valueToTree(this.getIgnoreErrors()));
            }
            if (this.getKey() != null) {
                data.set("key", om.valueToTree(this.getKey()));
            }
            if (this.getServiceRestartHandles() != null) {
                data.set("serviceRestartHandles", om.valueToTree(this.getServiceRestartHandles()));
            }
            if (this.getTestCmd() != null) {
                data.set("testCmd", om.valueToTree(this.getTestCmd()));
            }
            if (this.getWaitAfterCompletion() != null) {
                data.set("waitAfterCompletion", om.valueToTree(this.getWaitAfterCompletion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.InitCommandOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            InitCommandOptions.Jsii$Proxy that = (InitCommandOptions.Jsii$Proxy) o;

            if (this.cwd != null ? !this.cwd.equals(that.cwd) : that.cwd != null) return false;
            if (this.env != null ? !this.env.equals(that.env) : that.env != null) return false;
            if (this.ignoreErrors != null ? !this.ignoreErrors.equals(that.ignoreErrors) : that.ignoreErrors != null) return false;
            if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
            if (this.serviceRestartHandles != null ? !this.serviceRestartHandles.equals(that.serviceRestartHandles) : that.serviceRestartHandles != null) return false;
            if (this.testCmd != null ? !this.testCmd.equals(that.testCmd) : that.testCmd != null) return false;
            return this.waitAfterCompletion != null ? this.waitAfterCompletion.equals(that.waitAfterCompletion) : that.waitAfterCompletion == null;
        }

        @Override
        public int hashCode() {
            int result = this.cwd != null ? this.cwd.hashCode() : 0;
            result = 31 * result + (this.env != null ? this.env.hashCode() : 0);
            result = 31 * result + (this.ignoreErrors != null ? this.ignoreErrors.hashCode() : 0);
            result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
            result = 31 * result + (this.serviceRestartHandles != null ? this.serviceRestartHandles.hashCode() : 0);
            result = 31 * result + (this.testCmd != null ? this.testCmd.hashCode() : 0);
            result = 31 * result + (this.waitAfterCompletion != null ? this.waitAfterCompletion.hashCode() : 0);
            return result;
        }
    }
}
