package software.amazon.awscdk.services.ec2;

/**
 * Options for an InitService.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.11.0 (build 1e9b8e1)", date = "2020-09-13T06:02:54.560Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.InitServiceOptions")
@software.amazon.jsii.Jsii.Proxy(InitServiceOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface InitServiceOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Enable or disable this service.
     * <p>
     * Set to true to ensure that the service will be started automatically upon boot.
     * <p>
     * Set to false to ensure that the service will not be started automatically upon boot.
     * <p>
     * Default: - true if used in `InitService.enable()`, no change to service
     * state if used in `InitService.fromOptions()`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnabled() {
        return null;
    }

    /**
     * Make sure this service is running or not running after cfn-init finishes.
     * <p>
     * Set to true to ensure that the service is running after cfn-init finishes.
     * <p>
     * Set to false to ensure that the service is not running after cfn-init finishes.
     * <p>
     * Default: - same value as `enabled`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnsureRunning() {
        return null;
    }

    /**
     * Restart service when the actions registered into the restartHandle have been performed.
     * <p>
     * Register actions into the restartHandle by passing it to <code>InitFile</code>, <code>InitCommand</code>,
     * <code>InitPackage</code> and <code>InitSource</code> objects.
     * <p>
     * Default: - No files trigger restart
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.InitServiceRestartHandle getServiceRestartHandle() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link InitServiceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link InitServiceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<InitServiceOptions> {
        private java.lang.Boolean enabled;
        private java.lang.Boolean ensureRunning;
        private software.amazon.awscdk.services.ec2.InitServiceRestartHandle serviceRestartHandle;

        /**
         * Sets the value of {@link InitServiceOptions#getEnabled}
         * @param enabled Enable or disable this service.
         *                Set to true to ensure that the service will be started automatically upon boot.
         *                <p>
         *                Set to false to ensure that the service will not be started automatically upon boot.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link InitServiceOptions#getEnsureRunning}
         * @param ensureRunning Make sure this service is running or not running after cfn-init finishes.
         *                      Set to true to ensure that the service is running after cfn-init finishes.
         *                      <p>
         *                      Set to false to ensure that the service is not running after cfn-init finishes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ensureRunning(java.lang.Boolean ensureRunning) {
            this.ensureRunning = ensureRunning;
            return this;
        }

        /**
         * Sets the value of {@link InitServiceOptions#getServiceRestartHandle}
         * @param serviceRestartHandle Restart service when the actions registered into the restartHandle have been performed.
         *                             Register actions into the restartHandle by passing it to <code>InitFile</code>, <code>InitCommand</code>,
         *                             <code>InitPackage</code> and <code>InitSource</code> objects.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRestartHandle(software.amazon.awscdk.services.ec2.InitServiceRestartHandle serviceRestartHandle) {
            this.serviceRestartHandle = serviceRestartHandle;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InitServiceOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public InitServiceOptions build() {
            return new Jsii$Proxy(enabled, ensureRunning, serviceRestartHandle);
        }
    }

    /**
     * An implementation for {@link InitServiceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InitServiceOptions {
        private final java.lang.Boolean enabled;
        private final java.lang.Boolean ensureRunning;
        private final software.amazon.awscdk.services.ec2.InitServiceRestartHandle serviceRestartHandle;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.enabled = this.jsiiGet("enabled", java.lang.Boolean.class);
            this.ensureRunning = this.jsiiGet("ensureRunning", java.lang.Boolean.class);
            this.serviceRestartHandle = this.jsiiGet("serviceRestartHandle", software.amazon.awscdk.services.ec2.InitServiceRestartHandle.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Boolean enabled, final java.lang.Boolean ensureRunning, final software.amazon.awscdk.services.ec2.InitServiceRestartHandle serviceRestartHandle) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.enabled = enabled;
            this.ensureRunning = ensureRunning;
            this.serviceRestartHandle = serviceRestartHandle;
        }

        @Override
        public java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public java.lang.Boolean getEnsureRunning() {
            return this.ensureRunning;
        }

        @Override
        public software.amazon.awscdk.services.ec2.InitServiceRestartHandle getServiceRestartHandle() {
            return this.serviceRestartHandle;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getEnsureRunning() != null) {
                data.set("ensureRunning", om.valueToTree(this.getEnsureRunning()));
            }
            if (this.getServiceRestartHandle() != null) {
                data.set("serviceRestartHandle", om.valueToTree(this.getServiceRestartHandle()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.InitServiceOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            InitServiceOptions.Jsii$Proxy that = (InitServiceOptions.Jsii$Proxy) o;

            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.ensureRunning != null ? !this.ensureRunning.equals(that.ensureRunning) : that.ensureRunning != null) return false;
            return this.serviceRestartHandle != null ? this.serviceRestartHandle.equals(that.serviceRestartHandle) : that.serviceRestartHandle == null;
        }

        @Override
        public int hashCode() {
            int result = this.enabled != null ? this.enabled.hashCode() : 0;
            result = 31 * result + (this.ensureRunning != null ? this.ensureRunning.hashCode() : 0);
            result = 31 * result + (this.serviceRestartHandle != null ? this.serviceRestartHandle.hashCode() : 0);
            return result;
        }
    }
}
