package software.amazon.awscdk.services.ec2;

/**
 * Additional options for imported security groups.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.11.0 (build 1e9b8e1)", date = "2020-09-13T06:02:54.578Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.SecurityGroupImportOptions")
@software.amazon.jsii.Jsii.Proxy(SecurityGroupImportOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SecurityGroupImportOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Mark the SecurityGroup as having been created allowing all outbound traffic.
     * <p>
     * Only if this is set to false will egress rules be added to this security
     * group. Be aware, this would undo any potential "all outbound traffic"
     * default.
     * <p>
     * Default: true
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAllowAllOutbound() {
        return null;
    }

    /**
     * If a SecurityGroup is mutable CDK can add rules to existing groups.
     * <p>
     * Beware that making a SecurityGroup immutable might lead to issue
     * due to missing ingress/egress rules for new resources.
     * <p>
     * Default: true
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getMutable() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SecurityGroupImportOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SecurityGroupImportOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SecurityGroupImportOptions> {
        private java.lang.Boolean allowAllOutbound;
        private java.lang.Boolean mutable;

        /**
         * Sets the value of {@link SecurityGroupImportOptions#getAllowAllOutbound}
         * @param allowAllOutbound Mark the SecurityGroup as having been created allowing all outbound traffic.
         *                         Only if this is set to false will egress rules be added to this security
         *                         group. Be aware, this would undo any potential "all outbound traffic"
         *                         default.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder allowAllOutbound(java.lang.Boolean allowAllOutbound) {
            this.allowAllOutbound = allowAllOutbound;
            return this;
        }

        /**
         * Sets the value of {@link SecurityGroupImportOptions#getMutable}
         * @param mutable If a SecurityGroup is mutable CDK can add rules to existing groups.
         *                Beware that making a SecurityGroup immutable might lead to issue
         *                due to missing ingress/egress rules for new resources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder mutable(java.lang.Boolean mutable) {
            this.mutable = mutable;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SecurityGroupImportOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SecurityGroupImportOptions build() {
            return new Jsii$Proxy(allowAllOutbound, mutable);
        }
    }

    /**
     * An implementation for {@link SecurityGroupImportOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SecurityGroupImportOptions {
        private final java.lang.Boolean allowAllOutbound;
        private final java.lang.Boolean mutable;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allowAllOutbound = this.jsiiGet("allowAllOutbound", java.lang.Boolean.class);
            this.mutable = this.jsiiGet("mutable", java.lang.Boolean.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Boolean allowAllOutbound, final java.lang.Boolean mutable) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allowAllOutbound = allowAllOutbound;
            this.mutable = mutable;
        }

        @Override
        public java.lang.Boolean getAllowAllOutbound() {
            return this.allowAllOutbound;
        }

        @Override
        public java.lang.Boolean getMutable() {
            return this.mutable;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAllowAllOutbound() != null) {
                data.set("allowAllOutbound", om.valueToTree(this.getAllowAllOutbound()));
            }
            if (this.getMutable() != null) {
                data.set("mutable", om.valueToTree(this.getMutable()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.SecurityGroupImportOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SecurityGroupImportOptions.Jsii$Proxy that = (SecurityGroupImportOptions.Jsii$Proxy) o;

            if (this.allowAllOutbound != null ? !this.allowAllOutbound.equals(that.allowAllOutbound) : that.allowAllOutbound != null) return false;
            return this.mutable != null ? this.mutable.equals(that.mutable) : that.mutable == null;
        }

        @Override
        public int hashCode() {
            int result = this.allowAllOutbound != null ? this.allowAllOutbound.hashCode() : 0;
            result = 31 * result + (this.mutable != null ? this.mutable.hashCode() : 0);
            return result;
        }
    }
}
