package software.amazon.awscdk.services.ec2;

/**
 * An EBS Volume in AWS EC2.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.12.0 (build 5ddc9f2)", date = "2020-09-25T17:39:12.580Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.IVolume")
@software.amazon.jsii.Jsii.Proxy(IVolume.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IVolume extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.core.IResource {

    /**
     * The availability zone that the EBS Volume is contained within (ex: us-west-2a).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAvailabilityZone();

    /**
     * The EBS Volume's ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVolumeId();

    /**
     * The customer-managed encryption key that is used to encrypt the Volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return null;
    }

    /**
     * Grants permission to attach this Volume to an instance.
     * <p>
     * CAUTION: Granting an instance permission to attach to itself using this method will lead to
     * an unresolvable circular reference between the instance role and the instance.
     * Use {&#64;link IVolume.grantAttachVolumeToSelf} to grant an instance permission to attach this
     * volume to itself.
     * <p>
     * @param grantee the principal being granted permission. This parameter is required.
     * @param instances the instances to which permission is being granted to attach this volume to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantAttachVolume(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.IInstance> instances);

    /**
     * Grants permission to attach this Volume to an instance.
     * <p>
     * CAUTION: Granting an instance permission to attach to itself using this method will lead to
     * an unresolvable circular reference between the instance role and the instance.
     * Use {&#64;link IVolume.grantAttachVolumeToSelf} to grant an instance permission to attach this
     * volume to itself.
     * <p>
     * @param grantee the principal being granted permission. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantAttachVolume(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee);

    /**
     * Grants permission to attach the Volume by a ResourceTag condition.
     * <p>
     * If you are looking to
     * grant an Instance, AutoScalingGroup, EC2-Fleet, SpotFleet, ECS host, etc the ability to attach
     * this volume to <strong>itself</strong> then this is the method you want to use.
     * <p>
     * This is implemented by adding a Tag with key <code>VolumeGrantAttach-&lt;suffix&gt;</code> to the given
     * constructs and this Volume, and then conditioning the Grant such that the grantee is only
     * given the ability to AttachVolume if both the Volume and the destination Instance have that
     * tag applied to them.
     * <p>
     * @param grantee the principal being granted permission. This parameter is required.
     * @param constructs The list of constructs that will have the generated resource tag applied to them. This parameter is required.
     * @param tagKeySuffix A suffix to use on the generated Tag key in place of the generated hash value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantAttachVolumeByResourceTag(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.core.Construct> constructs, final @org.jetbrains.annotations.Nullable java.lang.String tagKeySuffix);

    /**
     * Grants permission to attach the Volume by a ResourceTag condition.
     * <p>
     * If you are looking to
     * grant an Instance, AutoScalingGroup, EC2-Fleet, SpotFleet, ECS host, etc the ability to attach
     * this volume to <strong>itself</strong> then this is the method you want to use.
     * <p>
     * This is implemented by adding a Tag with key <code>VolumeGrantAttach-&lt;suffix&gt;</code> to the given
     * constructs and this Volume, and then conditioning the Grant such that the grantee is only
     * given the ability to AttachVolume if both the Volume and the destination Instance have that
     * tag applied to them.
     * <p>
     * @param grantee the principal being granted permission. This parameter is required.
     * @param constructs The list of constructs that will have the generated resource tag applied to them. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantAttachVolumeByResourceTag(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.core.Construct> constructs);

    /**
     * Grants permission to detach this Volume from an instance CAUTION: Granting an instance permission to detach from itself using this method will lead to an unresolvable circular reference between the instance role and the instance.
     * <p>
     * Use {&#64;link IVolume.grantDetachVolumeFromSelf} to grant an instance permission to detach this
     * volume from itself.
     * <p>
     * @param grantee the principal being granted permission. This parameter is required.
     * @param instances the instances to which permission is being granted to detach this volume from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantDetachVolume(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.IInstance> instances);

    /**
     * Grants permission to detach this Volume from an instance CAUTION: Granting an instance permission to detach from itself using this method will lead to an unresolvable circular reference between the instance role and the instance.
     * <p>
     * Use {&#64;link IVolume.grantDetachVolumeFromSelf} to grant an instance permission to detach this
     * volume from itself.
     * <p>
     * @param grantee the principal being granted permission. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantDetachVolume(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee);

    /**
     * Grants permission to detach the Volume by a ResourceTag condition.
     * <p>
     * This is implemented via the same mechanism as {&#64;link IVolume.grantAttachVolumeByResourceTag},
     * and is subject to the same conditions.
     * <p>
     * @param grantee the principal being granted permission. This parameter is required.
     * @param constructs The list of constructs that will have the generated resource tag applied to them. This parameter is required.
     * @param tagKeySuffix A suffix to use on the generated Tag key in place of the generated hash value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantDetachVolumeByResourceTag(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.core.Construct> constructs, final @org.jetbrains.annotations.Nullable java.lang.String tagKeySuffix);

    /**
     * Grants permission to detach the Volume by a ResourceTag condition.
     * <p>
     * This is implemented via the same mechanism as {&#64;link IVolume.grantAttachVolumeByResourceTag},
     * and is subject to the same conditions.
     * <p>
     * @param grantee the principal being granted permission. This parameter is required.
     * @param constructs The list of constructs that will have the generated resource tag applied to them. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantDetachVolumeByResourceTag(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.core.Construct> constructs);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.IVolume {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The availability zone that the EBS Volume is contained within (ex: us-west-2a).
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getAvailabilityZone() {
            return this.jsiiGet("availabilityZone", java.lang.String.class);
        }

        /**
         * The EBS Volume's ID.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getVolumeId() {
            return this.jsiiGet("volumeId", java.lang.String.class);
        }

        /**
         * The customer-managed encryption key that is used to encrypt the Volume.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.IKey.class);
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ResourceEnvironment getEnv() {
            return this.jsiiGet("env", software.amazon.awscdk.core.ResourceEnvironment.class);
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack getStack() {
            return this.jsiiGet("stack", software.amazon.awscdk.core.Stack.class);
        }

        /**
         * The construct tree node for this construct.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.core.ConstructNode.class);
        }

        /**
         * Grants permission to attach this Volume to an instance.
         * <p>
         * CAUTION: Granting an instance permission to attach to itself using this method will lead to
         * an unresolvable circular reference between the instance role and the instance.
         * Use {&#64;link IVolume.grantAttachVolumeToSelf} to grant an instance permission to attach this
         * volume to itself.
         * <p>
         * @param grantee the principal being granted permission. This parameter is required.
         * @param instances the instances to which permission is being granted to attach this volume to.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantAttachVolume(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.IInstance> instances) {
            return this.jsiiCall("grantAttachVolume", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required"), instances });
        }

        /**
         * Grants permission to attach this Volume to an instance.
         * <p>
         * CAUTION: Granting an instance permission to attach to itself using this method will lead to
         * an unresolvable circular reference between the instance role and the instance.
         * Use {&#64;link IVolume.grantAttachVolumeToSelf} to grant an instance permission to attach this
         * volume to itself.
         * <p>
         * @param grantee the principal being granted permission. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantAttachVolume(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return this.jsiiCall("grantAttachVolume", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Grants permission to attach the Volume by a ResourceTag condition.
         * <p>
         * If you are looking to
         * grant an Instance, AutoScalingGroup, EC2-Fleet, SpotFleet, ECS host, etc the ability to attach
         * this volume to <strong>itself</strong> then this is the method you want to use.
         * <p>
         * This is implemented by adding a Tag with key <code>VolumeGrantAttach-&lt;suffix&gt;</code> to the given
         * constructs and this Volume, and then conditioning the Grant such that the grantee is only
         * given the ability to AttachVolume if both the Volume and the destination Instance have that
         * tag applied to them.
         * <p>
         * @param grantee the principal being granted permission. This parameter is required.
         * @param constructs The list of constructs that will have the generated resource tag applied to them. This parameter is required.
         * @param tagKeySuffix A suffix to use on the generated Tag key in place of the generated hash value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantAttachVolumeByResourceTag(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.core.Construct> constructs, final @org.jetbrains.annotations.Nullable java.lang.String tagKeySuffix) {
            return this.jsiiCall("grantAttachVolumeByResourceTag", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required"), java.util.Objects.requireNonNull(constructs, "constructs is required"), tagKeySuffix });
        }

        /**
         * Grants permission to attach the Volume by a ResourceTag condition.
         * <p>
         * If you are looking to
         * grant an Instance, AutoScalingGroup, EC2-Fleet, SpotFleet, ECS host, etc the ability to attach
         * this volume to <strong>itself</strong> then this is the method you want to use.
         * <p>
         * This is implemented by adding a Tag with key <code>VolumeGrantAttach-&lt;suffix&gt;</code> to the given
         * constructs and this Volume, and then conditioning the Grant such that the grantee is only
         * given the ability to AttachVolume if both the Volume and the destination Instance have that
         * tag applied to them.
         * <p>
         * @param grantee the principal being granted permission. This parameter is required.
         * @param constructs The list of constructs that will have the generated resource tag applied to them. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantAttachVolumeByResourceTag(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.core.Construct> constructs) {
            return this.jsiiCall("grantAttachVolumeByResourceTag", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required"), java.util.Objects.requireNonNull(constructs, "constructs is required") });
        }

        /**
         * Grants permission to detach this Volume from an instance CAUTION: Granting an instance permission to detach from itself using this method will lead to an unresolvable circular reference between the instance role and the instance.
         * <p>
         * Use {&#64;link IVolume.grantDetachVolumeFromSelf} to grant an instance permission to detach this
         * volume from itself.
         * <p>
         * @param grantee the principal being granted permission. This parameter is required.
         * @param instances the instances to which permission is being granted to detach this volume from.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantDetachVolume(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.IInstance> instances) {
            return this.jsiiCall("grantDetachVolume", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required"), instances });
        }

        /**
         * Grants permission to detach this Volume from an instance CAUTION: Granting an instance permission to detach from itself using this method will lead to an unresolvable circular reference between the instance role and the instance.
         * <p>
         * Use {&#64;link IVolume.grantDetachVolumeFromSelf} to grant an instance permission to detach this
         * volume from itself.
         * <p>
         * @param grantee the principal being granted permission. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantDetachVolume(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return this.jsiiCall("grantDetachVolume", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Grants permission to detach the Volume by a ResourceTag condition.
         * <p>
         * This is implemented via the same mechanism as {&#64;link IVolume.grantAttachVolumeByResourceTag},
         * and is subject to the same conditions.
         * <p>
         * @param grantee the principal being granted permission. This parameter is required.
         * @param constructs The list of constructs that will have the generated resource tag applied to them. This parameter is required.
         * @param tagKeySuffix A suffix to use on the generated Tag key in place of the generated hash value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantDetachVolumeByResourceTag(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.core.Construct> constructs, final @org.jetbrains.annotations.Nullable java.lang.String tagKeySuffix) {
            return this.jsiiCall("grantDetachVolumeByResourceTag", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required"), java.util.Objects.requireNonNull(constructs, "constructs is required"), tagKeySuffix });
        }

        /**
         * Grants permission to detach the Volume by a ResourceTag condition.
         * <p>
         * This is implemented via the same mechanism as {&#64;link IVolume.grantAttachVolumeByResourceTag},
         * and is subject to the same conditions.
         * <p>
         * @param grantee the principal being granted permission. This parameter is required.
         * @param constructs The list of constructs that will have the generated resource tag applied to them. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantDetachVolumeByResourceTag(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.core.Construct> constructs) {
            return this.jsiiCall("grantDetachVolumeByResourceTag", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required"), java.util.Objects.requireNonNull(constructs, "constructs is required") });
        }
    }
}
