/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.services.ec2.$Module;
import software.amazon.awscdk.services.ec2.ConnectionsProps;
import software.amazon.awscdk.services.ec2.IConnectable;
import software.amazon.awscdk.services.ec2.IPeer;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.Port;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.Connections")
public class Connections
extends JsiiObject
implements IConnectable {
    protected Connections(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Connections(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Connections(@Nullable ConnectionsProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{props});
    }

    public Connections() {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[0]);
    }

    public void addSecurityGroup(ISecurityGroup ... securityGroups) {
        this.jsiiCall("addSecurityGroup", NativeType.VOID, Arrays.stream(securityGroups).toArray(Object[]::new));
    }

    public void allowDefaultPortFrom(@NotNull IConnectable other, @Nullable String description) {
        this.jsiiCall("allowDefaultPortFrom", NativeType.VOID, new Object[]{Objects.requireNonNull(other, "other is required"), description});
    }

    public void allowDefaultPortFrom(@NotNull IConnectable other) {
        this.jsiiCall("allowDefaultPortFrom", NativeType.VOID, new Object[]{Objects.requireNonNull(other, "other is required")});
    }

    public void allowDefaultPortFromAnyIpv4(@Nullable String description) {
        this.jsiiCall("allowDefaultPortFromAnyIpv4", NativeType.VOID, new Object[]{description});
    }

    public void allowDefaultPortFromAnyIpv4() {
        this.jsiiCall("allowDefaultPortFromAnyIpv4", NativeType.VOID, new Object[0]);
    }

    public void allowDefaultPortInternally(@Nullable String description) {
        this.jsiiCall("allowDefaultPortInternally", NativeType.VOID, new Object[]{description});
    }

    public void allowDefaultPortInternally() {
        this.jsiiCall("allowDefaultPortInternally", NativeType.VOID, new Object[0]);
    }

    public void allowDefaultPortTo(@NotNull IConnectable other, @Nullable String description) {
        this.jsiiCall("allowDefaultPortTo", NativeType.VOID, new Object[]{Objects.requireNonNull(other, "other is required"), description});
    }

    public void allowDefaultPortTo(@NotNull IConnectable other) {
        this.jsiiCall("allowDefaultPortTo", NativeType.VOID, new Object[]{Objects.requireNonNull(other, "other is required")});
    }

    public void allowFrom(@NotNull IConnectable other, @NotNull Port portRange, @Nullable String description) {
        this.jsiiCall("allowFrom", NativeType.VOID, new Object[]{Objects.requireNonNull(other, "other is required"), Objects.requireNonNull(portRange, "portRange is required"), description});
    }

    public void allowFrom(@NotNull IConnectable other, @NotNull Port portRange) {
        this.jsiiCall("allowFrom", NativeType.VOID, new Object[]{Objects.requireNonNull(other, "other is required"), Objects.requireNonNull(portRange, "portRange is required")});
    }

    public void allowFromAnyIpv4(@NotNull Port portRange, @Nullable String description) {
        this.jsiiCall("allowFromAnyIpv4", NativeType.VOID, new Object[]{Objects.requireNonNull(portRange, "portRange is required"), description});
    }

    public void allowFromAnyIpv4(@NotNull Port portRange) {
        this.jsiiCall("allowFromAnyIpv4", NativeType.VOID, new Object[]{Objects.requireNonNull(portRange, "portRange is required")});
    }

    public void allowInternally(@NotNull Port portRange, @Nullable String description) {
        this.jsiiCall("allowInternally", NativeType.VOID, new Object[]{Objects.requireNonNull(portRange, "portRange is required"), description});
    }

    public void allowInternally(@NotNull Port portRange) {
        this.jsiiCall("allowInternally", NativeType.VOID, new Object[]{Objects.requireNonNull(portRange, "portRange is required")});
    }

    public void allowTo(@NotNull IConnectable other, @NotNull Port portRange, @Nullable String description) {
        this.jsiiCall("allowTo", NativeType.VOID, new Object[]{Objects.requireNonNull(other, "other is required"), Objects.requireNonNull(portRange, "portRange is required"), description});
    }

    public void allowTo(@NotNull IConnectable other, @NotNull Port portRange) {
        this.jsiiCall("allowTo", NativeType.VOID, new Object[]{Objects.requireNonNull(other, "other is required"), Objects.requireNonNull(portRange, "portRange is required")});
    }

    public void allowToAnyIpv4(@NotNull Port portRange, @Nullable String description) {
        this.jsiiCall("allowToAnyIpv4", NativeType.VOID, new Object[]{Objects.requireNonNull(portRange, "portRange is required"), description});
    }

    public void allowToAnyIpv4(@NotNull Port portRange) {
        this.jsiiCall("allowToAnyIpv4", NativeType.VOID, new Object[]{Objects.requireNonNull(portRange, "portRange is required")});
    }

    public void allowToDefaultPort(@NotNull IConnectable other, @Nullable String description) {
        this.jsiiCall("allowToDefaultPort", NativeType.VOID, new Object[]{Objects.requireNonNull(other, "other is required"), description});
    }

    public void allowToDefaultPort(@NotNull IConnectable other) {
        this.jsiiCall("allowToDefaultPort", NativeType.VOID, new Object[]{Objects.requireNonNull(other, "other is required")});
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)this.jsiiGet("connections", Connections.class);
    }

    @NotNull
    public List<ISecurityGroup> getSecurityGroups() {
        return Collections.unmodifiableList((List)this.jsiiGet("securityGroups", NativeType.listOf((NativeType)NativeType.forClass(ISecurityGroup.class))));
    }

    @Nullable
    public Port getDefaultPort() {
        return (Port)((Object)this.jsiiGet("defaultPort", Port.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Connections> {
        private ConnectionsProps.Builder props;

        public static Builder create() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder defaultPort(Port defaultPort) {
            this.props().defaultPort(defaultPort);
            return this;
        }

        public Builder peer(IPeer peer) {
            this.props().peer(peer);
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.props().securityGroups(securityGroups);
            return this;
        }

        public Connections build() {
            return new Connections(this.props != null ? this.props.build() : null);
        }

        private ConnectionsProps.Builder props() {
            if (this.props == null) {
                this.props = new ConnectionsProps.Builder();
            }
            return this.props;
        }
    }
}

