package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation-init configuration.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.12.0 (build 5ddc9f2)", date = "2020-10-01T01:49:43.673Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CloudFormationInit")
public class CloudFormationInit extends software.amazon.jsii.JsiiObject {

    protected CloudFormationInit(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CloudFormationInit(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Use an existing InitConfig object as the default and only config.
     * <p>
     * @param config This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CloudFormationInit fromConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InitConfig config) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.CloudFormationInit.class, "fromConfig", software.amazon.awscdk.services.ec2.CloudFormationInit.class, new Object[] { java.util.Objects.requireNonNull(config, "config is required") });
    }

    /**
     * Build a CloudFormationInit from config sets.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CloudFormationInit fromConfigSets(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ConfigSetProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.CloudFormationInit.class, "fromConfigSets", software.amazon.awscdk.services.ec2.CloudFormationInit.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Build a new config from a set of Init Elements.
     * <p>
     * @param elements This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CloudFormationInit fromElements(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InitElement... elements) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.CloudFormationInit.class, "fromElements", software.amazon.awscdk.services.ec2.CloudFormationInit.class, java.util.Arrays.<Object>stream(elements).toArray(Object[]::new));
    }

    /**
     * Add a config with the given name to this CloudFormationInit object.
     * <p>
     * @param configName This parameter is required.
     * @param config This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addConfig(final @org.jetbrains.annotations.NotNull java.lang.String configName, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InitConfig config) {
        this.jsiiCall("addConfig", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(configName, "configName is required"), java.util.Objects.requireNonNull(config, "config is required") });
    }

    /**
     * Add a config set with the given name to this CloudFormationInit object.
     * <p>
     * The new configset will reference the given configs in the given order.
     * <p>
     * @param configSetName This parameter is required.
     * @param configNames
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addConfigSet(final @org.jetbrains.annotations.NotNull java.lang.String configSetName, final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> configNames) {
        this.jsiiCall("addConfigSet", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(configSetName, "configSetName is required"), configNames });
    }

    /**
     * Add a config set with the given name to this CloudFormationInit object.
     * <p>
     * The new configset will reference the given configs in the given order.
     * <p>
     * @param configSetName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addConfigSet(final @org.jetbrains.annotations.NotNull java.lang.String configSetName) {
        this.jsiiCall("addConfigSet", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(configSetName, "configSetName is required") });
    }
}
