package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.13.0 (build 385c325)", date = "2020-10-02T20:11:05.032Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet")
public class CfnSpotFleet extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnSpotFleet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSpotFleet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnSpotFleet.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::EC2::SpotFleet`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSpotFleet(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnSpotFleetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::EC2::SpotFleet.SpotFleetRequestConfigData`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSpotFleetRequestConfigData() {
        return this.jsiiGet("spotFleetRequestConfigData", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::SpotFleet.SpotFleetRequestConfigData`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSpotFleetRequestConfigData(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("spotFleetRequestConfigData", java.util.Objects.requireNonNull(value, "spotFleetRequestConfigData is required"));
    }

    /**
     * `AWS::EC2::SpotFleet.SpotFleetRequestConfigData`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSpotFleetRequestConfigData(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotFleetRequestConfigDataProperty value) {
        this.jsiiSet("spotFleetRequestConfigData", java.util.Objects.requireNonNull(value, "spotFleetRequestConfigData is required"));
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.BlockDeviceMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(BlockDeviceMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BlockDeviceMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSpotFleet.BlockDeviceMappingProperty.DeviceName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-devicename
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDeviceName();

        /**
         * `CfnSpotFleet.BlockDeviceMappingProperty.Ebs`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-ebs
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEbs() {
            return null;
        }

        /**
         * `CfnSpotFleet.BlockDeviceMappingProperty.NoDevice`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-nodevice
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNoDevice() {
            return null;
        }

        /**
         * `CfnSpotFleet.BlockDeviceMappingProperty.VirtualName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-virtualname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVirtualName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BlockDeviceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BlockDeviceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BlockDeviceMappingProperty> {
            private java.lang.String deviceName;
            private java.lang.Object ebs;
            private java.lang.String noDevice;
            private java.lang.String virtualName;

            /**
             * Sets the value of {@link BlockDeviceMappingProperty#getDeviceName}
             * @param deviceName `CfnSpotFleet.BlockDeviceMappingProperty.DeviceName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deviceName(java.lang.String deviceName) {
                this.deviceName = deviceName;
                return this;
            }

            /**
             * Sets the value of {@link BlockDeviceMappingProperty#getEbs}
             * @param ebs `CfnSpotFleet.BlockDeviceMappingProperty.Ebs`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebs(software.amazon.awscdk.core.IResolvable ebs) {
                this.ebs = ebs;
                return this;
            }

            /**
             * Sets the value of {@link BlockDeviceMappingProperty#getEbs}
             * @param ebs `CfnSpotFleet.BlockDeviceMappingProperty.Ebs`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebs(software.amazon.awscdk.services.ec2.CfnSpotFleet.EbsBlockDeviceProperty ebs) {
                this.ebs = ebs;
                return this;
            }

            /**
             * Sets the value of {@link BlockDeviceMappingProperty#getNoDevice}
             * @param noDevice `CfnSpotFleet.BlockDeviceMappingProperty.NoDevice`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noDevice(java.lang.String noDevice) {
                this.noDevice = noDevice;
                return this;
            }

            /**
             * Sets the value of {@link BlockDeviceMappingProperty#getVirtualName}
             * @param virtualName `CfnSpotFleet.BlockDeviceMappingProperty.VirtualName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder virtualName(java.lang.String virtualName) {
                this.virtualName = virtualName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BlockDeviceMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BlockDeviceMappingProperty build() {
                return new Jsii$Proxy(deviceName, ebs, noDevice, virtualName);
            }
        }

        /**
         * An implementation for {@link BlockDeviceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BlockDeviceMappingProperty {
            private final java.lang.String deviceName;
            private final java.lang.Object ebs;
            private final java.lang.String noDevice;
            private final java.lang.String virtualName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deviceName = this.jsiiGet("deviceName", java.lang.String.class);
                this.ebs = this.jsiiGet("ebs", java.lang.Object.class);
                this.noDevice = this.jsiiGet("noDevice", java.lang.String.class);
                this.virtualName = this.jsiiGet("virtualName", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String deviceName, final java.lang.Object ebs, final java.lang.String noDevice, final java.lang.String virtualName) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deviceName = java.util.Objects.requireNonNull(deviceName, "deviceName is required");
                this.ebs = ebs;
                this.noDevice = noDevice;
                this.virtualName = virtualName;
            }

            @Override
            public java.lang.String getDeviceName() {
                return this.deviceName;
            }

            @Override
            public java.lang.Object getEbs() {
                return this.ebs;
            }

            @Override
            public java.lang.String getNoDevice() {
                return this.noDevice;
            }

            @Override
            public java.lang.String getVirtualName() {
                return this.virtualName;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("deviceName", om.valueToTree(this.getDeviceName()));
                if (this.getEbs() != null) {
                    data.set("ebs", om.valueToTree(this.getEbs()));
                }
                if (this.getNoDevice() != null) {
                    data.set("noDevice", om.valueToTree(this.getNoDevice()));
                }
                if (this.getVirtualName() != null) {
                    data.set("virtualName", om.valueToTree(this.getVirtualName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.BlockDeviceMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BlockDeviceMappingProperty.Jsii$Proxy that = (BlockDeviceMappingProperty.Jsii$Proxy) o;

                if (!deviceName.equals(that.deviceName)) return false;
                if (this.ebs != null ? !this.ebs.equals(that.ebs) : that.ebs != null) return false;
                if (this.noDevice != null ? !this.noDevice.equals(that.noDevice) : that.noDevice != null) return false;
                return this.virtualName != null ? this.virtualName.equals(that.virtualName) : that.virtualName == null;
            }

            @Override
            public int hashCode() {
                int result = this.deviceName.hashCode();
                result = 31 * result + (this.ebs != null ? this.ebs.hashCode() : 0);
                result = 31 * result + (this.noDevice != null ? this.noDevice.hashCode() : 0);
                result = 31 * result + (this.virtualName != null ? this.virtualName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancer.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.ClassicLoadBalancerProperty")
    @software.amazon.jsii.Jsii.Proxy(ClassicLoadBalancerProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClassicLoadBalancerProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSpotFleet.ClassicLoadBalancerProperty.Name`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancer.html#cfn-ec2-spotfleet-classicloadbalancer-name
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * @return a {@link Builder} of {@link ClassicLoadBalancerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClassicLoadBalancerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClassicLoadBalancerProperty> {
            private java.lang.String name;

            /**
             * Sets the value of {@link ClassicLoadBalancerProperty#getName}
             * @param name `CfnSpotFleet.ClassicLoadBalancerProperty.Name`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClassicLoadBalancerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClassicLoadBalancerProperty build() {
                return new Jsii$Proxy(name);
            }
        }

        /**
         * An implementation for {@link ClassicLoadBalancerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClassicLoadBalancerProperty {
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = this.jsiiGet("name", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String name) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(name, "name is required");
            }

            @Override
            public java.lang.String getName() {
                return this.name;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.ClassicLoadBalancerProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClassicLoadBalancerProperty.Jsii$Proxy that = (ClassicLoadBalancerProperty.Jsii$Proxy) o;

                return this.name.equals(that.name);
            }

            @Override
            public int hashCode() {
                int result = this.name.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancersconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.ClassicLoadBalancersConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ClassicLoadBalancersConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClassicLoadBalancersConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSpotFleet.ClassicLoadBalancersConfigProperty.ClassicLoadBalancers`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancersconfig.html#cfn-ec2-spotfleet-classicloadbalancersconfig-classicloadbalancers
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getClassicLoadBalancers();

        /**
         * @return a {@link Builder} of {@link ClassicLoadBalancersConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClassicLoadBalancersConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClassicLoadBalancersConfigProperty> {
            private java.lang.Object classicLoadBalancers;

            /**
             * Sets the value of {@link ClassicLoadBalancersConfigProperty#getClassicLoadBalancers}
             * @param classicLoadBalancers `CfnSpotFleet.ClassicLoadBalancersConfigProperty.ClassicLoadBalancers`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder classicLoadBalancers(software.amazon.awscdk.core.IResolvable classicLoadBalancers) {
                this.classicLoadBalancers = classicLoadBalancers;
                return this;
            }

            /**
             * Sets the value of {@link ClassicLoadBalancersConfigProperty#getClassicLoadBalancers}
             * @param classicLoadBalancers `CfnSpotFleet.ClassicLoadBalancersConfigProperty.ClassicLoadBalancers`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder classicLoadBalancers(java.util.List<? extends java.lang.Object> classicLoadBalancers) {
                this.classicLoadBalancers = classicLoadBalancers;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClassicLoadBalancersConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClassicLoadBalancersConfigProperty build() {
                return new Jsii$Proxy(classicLoadBalancers);
            }
        }

        /**
         * An implementation for {@link ClassicLoadBalancersConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClassicLoadBalancersConfigProperty {
            private final java.lang.Object classicLoadBalancers;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.classicLoadBalancers = this.jsiiGet("classicLoadBalancers", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object classicLoadBalancers) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.classicLoadBalancers = java.util.Objects.requireNonNull(classicLoadBalancers, "classicLoadBalancers is required");
            }

            @Override
            public java.lang.Object getClassicLoadBalancers() {
                return this.classicLoadBalancers;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("classicLoadBalancers", om.valueToTree(this.getClassicLoadBalancers()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.ClassicLoadBalancersConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClassicLoadBalancersConfigProperty.Jsii$Proxy that = (ClassicLoadBalancersConfigProperty.Jsii$Proxy) o;

                return this.classicLoadBalancers.equals(that.classicLoadBalancers);
            }

            @Override
            public int hashCode() {
                int result = this.classicLoadBalancers.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.EbsBlockDeviceProperty")
    @software.amazon.jsii.Jsii.Proxy(EbsBlockDeviceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EbsBlockDeviceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSpotFleet.EbsBlockDeviceProperty.DeleteOnTermination`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-deleteontermination
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeleteOnTermination() {
            return null;
        }

        /**
         * `CfnSpotFleet.EbsBlockDeviceProperty.Encrypted`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-encrypted
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncrypted() {
            return null;
        }

        /**
         * `CfnSpotFleet.EbsBlockDeviceProperty.Iops`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-iops
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIops() {
            return null;
        }

        /**
         * `CfnSpotFleet.EbsBlockDeviceProperty.SnapshotId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-snapshotid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSnapshotId() {
            return null;
        }

        /**
         * `CfnSpotFleet.EbsBlockDeviceProperty.VolumeSize`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumesize
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getVolumeSize() {
            return null;
        }

        /**
         * `CfnSpotFleet.EbsBlockDeviceProperty.VolumeType`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVolumeType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EbsBlockDeviceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EbsBlockDeviceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EbsBlockDeviceProperty> {
            private java.lang.Object deleteOnTermination;
            private java.lang.Object encrypted;
            private java.lang.Number iops;
            private java.lang.String snapshotId;
            private java.lang.Number volumeSize;
            private java.lang.String volumeType;

            /**
             * Sets the value of {@link EbsBlockDeviceProperty#getDeleteOnTermination}
             * @param deleteOnTermination `CfnSpotFleet.EbsBlockDeviceProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteOnTermination(java.lang.Boolean deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            /**
             * Sets the value of {@link EbsBlockDeviceProperty#getDeleteOnTermination}
             * @param deleteOnTermination `CfnSpotFleet.EbsBlockDeviceProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteOnTermination(software.amazon.awscdk.core.IResolvable deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            /**
             * Sets the value of {@link EbsBlockDeviceProperty#getEncrypted}
             * @param encrypted `CfnSpotFleet.EbsBlockDeviceProperty.Encrypted`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encrypted(java.lang.Boolean encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            /**
             * Sets the value of {@link EbsBlockDeviceProperty#getEncrypted}
             * @param encrypted `CfnSpotFleet.EbsBlockDeviceProperty.Encrypted`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encrypted(software.amazon.awscdk.core.IResolvable encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            /**
             * Sets the value of {@link EbsBlockDeviceProperty#getIops}
             * @param iops `CfnSpotFleet.EbsBlockDeviceProperty.Iops`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iops(java.lang.Number iops) {
                this.iops = iops;
                return this;
            }

            /**
             * Sets the value of {@link EbsBlockDeviceProperty#getSnapshotId}
             * @param snapshotId `CfnSpotFleet.EbsBlockDeviceProperty.SnapshotId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snapshotId(java.lang.String snapshotId) {
                this.snapshotId = snapshotId;
                return this;
            }

            /**
             * Sets the value of {@link EbsBlockDeviceProperty#getVolumeSize}
             * @param volumeSize `CfnSpotFleet.EbsBlockDeviceProperty.VolumeSize`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeSize(java.lang.Number volumeSize) {
                this.volumeSize = volumeSize;
                return this;
            }

            /**
             * Sets the value of {@link EbsBlockDeviceProperty#getVolumeType}
             * @param volumeType `CfnSpotFleet.EbsBlockDeviceProperty.VolumeType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeType(java.lang.String volumeType) {
                this.volumeType = volumeType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EbsBlockDeviceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EbsBlockDeviceProperty build() {
                return new Jsii$Proxy(deleteOnTermination, encrypted, iops, snapshotId, volumeSize, volumeType);
            }
        }

        /**
         * An implementation for {@link EbsBlockDeviceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EbsBlockDeviceProperty {
            private final java.lang.Object deleteOnTermination;
            private final java.lang.Object encrypted;
            private final java.lang.Number iops;
            private final java.lang.String snapshotId;
            private final java.lang.Number volumeSize;
            private final java.lang.String volumeType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deleteOnTermination = this.jsiiGet("deleteOnTermination", java.lang.Object.class);
                this.encrypted = this.jsiiGet("encrypted", java.lang.Object.class);
                this.iops = this.jsiiGet("iops", java.lang.Number.class);
                this.snapshotId = this.jsiiGet("snapshotId", java.lang.String.class);
                this.volumeSize = this.jsiiGet("volumeSize", java.lang.Number.class);
                this.volumeType = this.jsiiGet("volumeType", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object deleteOnTermination, final java.lang.Object encrypted, final java.lang.Number iops, final java.lang.String snapshotId, final java.lang.Number volumeSize, final java.lang.String volumeType) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deleteOnTermination = deleteOnTermination;
                this.encrypted = encrypted;
                this.iops = iops;
                this.snapshotId = snapshotId;
                this.volumeSize = volumeSize;
                this.volumeType = volumeType;
            }

            @Override
            public java.lang.Object getDeleteOnTermination() {
                return this.deleteOnTermination;
            }

            @Override
            public java.lang.Object getEncrypted() {
                return this.encrypted;
            }

            @Override
            public java.lang.Number getIops() {
                return this.iops;
            }

            @Override
            public java.lang.String getSnapshotId() {
                return this.snapshotId;
            }

            @Override
            public java.lang.Number getVolumeSize() {
                return this.volumeSize;
            }

            @Override
            public java.lang.String getVolumeType() {
                return this.volumeType;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDeleteOnTermination() != null) {
                    data.set("deleteOnTermination", om.valueToTree(this.getDeleteOnTermination()));
                }
                if (this.getEncrypted() != null) {
                    data.set("encrypted", om.valueToTree(this.getEncrypted()));
                }
                if (this.getIops() != null) {
                    data.set("iops", om.valueToTree(this.getIops()));
                }
                if (this.getSnapshotId() != null) {
                    data.set("snapshotId", om.valueToTree(this.getSnapshotId()));
                }
                if (this.getVolumeSize() != null) {
                    data.set("volumeSize", om.valueToTree(this.getVolumeSize()));
                }
                if (this.getVolumeType() != null) {
                    data.set("volumeType", om.valueToTree(this.getVolumeType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.EbsBlockDeviceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EbsBlockDeviceProperty.Jsii$Proxy that = (EbsBlockDeviceProperty.Jsii$Proxy) o;

                if (this.deleteOnTermination != null ? !this.deleteOnTermination.equals(that.deleteOnTermination) : that.deleteOnTermination != null) return false;
                if (this.encrypted != null ? !this.encrypted.equals(that.encrypted) : that.encrypted != null) return false;
                if (this.iops != null ? !this.iops.equals(that.iops) : that.iops != null) return false;
                if (this.snapshotId != null ? !this.snapshotId.equals(that.snapshotId) : that.snapshotId != null) return false;
                if (this.volumeSize != null ? !this.volumeSize.equals(that.volumeSize) : that.volumeSize != null) return false;
                return this.volumeType != null ? this.volumeType.equals(that.volumeType) : that.volumeType == null;
            }

            @Override
            public int hashCode() {
                int result = this.deleteOnTermination != null ? this.deleteOnTermination.hashCode() : 0;
                result = 31 * result + (this.encrypted != null ? this.encrypted.hashCode() : 0);
                result = 31 * result + (this.iops != null ? this.iops.hashCode() : 0);
                result = 31 * result + (this.snapshotId != null ? this.snapshotId.hashCode() : 0);
                result = 31 * result + (this.volumeSize != null ? this.volumeSize.hashCode() : 0);
                result = 31 * result + (this.volumeType != null ? this.volumeType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.FleetLaunchTemplateSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(FleetLaunchTemplateSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FleetLaunchTemplateSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.Version`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-version
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVersion();

        /**
         * `CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.LaunchTemplateId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-launchtemplateid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLaunchTemplateId() {
            return null;
        }

        /**
         * `CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.LaunchTemplateName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-launchtemplatename
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLaunchTemplateName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FleetLaunchTemplateSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FleetLaunchTemplateSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FleetLaunchTemplateSpecificationProperty> {
            private java.lang.String version;
            private java.lang.String launchTemplateId;
            private java.lang.String launchTemplateName;

            /**
             * Sets the value of {@link FleetLaunchTemplateSpecificationProperty#getVersion}
             * @param version `CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.Version`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateSpecificationProperty#getLaunchTemplateId}
             * @param launchTemplateId `CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.LaunchTemplateId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplateId(java.lang.String launchTemplateId) {
                this.launchTemplateId = launchTemplateId;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateSpecificationProperty#getLaunchTemplateName}
             * @param launchTemplateName `CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.LaunchTemplateName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplateName(java.lang.String launchTemplateName) {
                this.launchTemplateName = launchTemplateName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FleetLaunchTemplateSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FleetLaunchTemplateSpecificationProperty build() {
                return new Jsii$Proxy(version, launchTemplateId, launchTemplateName);
            }
        }

        /**
         * An implementation for {@link FleetLaunchTemplateSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FleetLaunchTemplateSpecificationProperty {
            private final java.lang.String version;
            private final java.lang.String launchTemplateId;
            private final java.lang.String launchTemplateName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.version = this.jsiiGet("version", java.lang.String.class);
                this.launchTemplateId = this.jsiiGet("launchTemplateId", java.lang.String.class);
                this.launchTemplateName = this.jsiiGet("launchTemplateName", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String version, final java.lang.String launchTemplateId, final java.lang.String launchTemplateName) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.version = java.util.Objects.requireNonNull(version, "version is required");
                this.launchTemplateId = launchTemplateId;
                this.launchTemplateName = launchTemplateName;
            }

            @Override
            public java.lang.String getVersion() {
                return this.version;
            }

            @Override
            public java.lang.String getLaunchTemplateId() {
                return this.launchTemplateId;
            }

            @Override
            public java.lang.String getLaunchTemplateName() {
                return this.launchTemplateName;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("version", om.valueToTree(this.getVersion()));
                if (this.getLaunchTemplateId() != null) {
                    data.set("launchTemplateId", om.valueToTree(this.getLaunchTemplateId()));
                }
                if (this.getLaunchTemplateName() != null) {
                    data.set("launchTemplateName", om.valueToTree(this.getLaunchTemplateName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.FleetLaunchTemplateSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FleetLaunchTemplateSpecificationProperty.Jsii$Proxy that = (FleetLaunchTemplateSpecificationProperty.Jsii$Proxy) o;

                if (!version.equals(that.version)) return false;
                if (this.launchTemplateId != null ? !this.launchTemplateId.equals(that.launchTemplateId) : that.launchTemplateId != null) return false;
                return this.launchTemplateName != null ? this.launchTemplateName.equals(that.launchTemplateName) : that.launchTemplateName == null;
            }

            @Override
            public int hashCode() {
                int result = this.version.hashCode();
                result = 31 * result + (this.launchTemplateId != null ? this.launchTemplateId.hashCode() : 0);
                result = 31 * result + (this.launchTemplateName != null ? this.launchTemplateName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-securitygroups.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.GroupIdentifierProperty")
    @software.amazon.jsii.Jsii.Proxy(GroupIdentifierProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GroupIdentifierProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSpotFleet.GroupIdentifierProperty.GroupId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-securitygroups.html#cfn-ec2-spotfleet-groupidentifier-groupid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getGroupId();

        /**
         * @return a {@link Builder} of {@link GroupIdentifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GroupIdentifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GroupIdentifierProperty> {
            private java.lang.String groupId;

            /**
             * Sets the value of {@link GroupIdentifierProperty#getGroupId}
             * @param groupId `CfnSpotFleet.GroupIdentifierProperty.GroupId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupId(java.lang.String groupId) {
                this.groupId = groupId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GroupIdentifierProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GroupIdentifierProperty build() {
                return new Jsii$Proxy(groupId);
            }
        }

        /**
         * An implementation for {@link GroupIdentifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GroupIdentifierProperty {
            private final java.lang.String groupId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.groupId = this.jsiiGet("groupId", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String groupId) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.groupId = java.util.Objects.requireNonNull(groupId, "groupId is required");
            }

            @Override
            public java.lang.String getGroupId() {
                return this.groupId;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("groupId", om.valueToTree(this.getGroupId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.GroupIdentifierProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GroupIdentifierProperty.Jsii$Proxy that = (GroupIdentifierProperty.Jsii$Proxy) o;

                return this.groupId.equals(that.groupId);
            }

            @Override
            public int hashCode() {
                int result = this.groupId.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-iaminstanceprofile.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.IamInstanceProfileSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(IamInstanceProfileSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IamInstanceProfileSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSpotFleet.IamInstanceProfileSpecificationProperty.Arn`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-iaminstanceprofile.html#cfn-ec2-spotfleet-iaminstanceprofilespecification-arn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IamInstanceProfileSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IamInstanceProfileSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IamInstanceProfileSpecificationProperty> {
            private java.lang.String arn;

            /**
             * Sets the value of {@link IamInstanceProfileSpecificationProperty#getArn}
             * @param arn `CfnSpotFleet.IamInstanceProfileSpecificationProperty.Arn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IamInstanceProfileSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IamInstanceProfileSpecificationProperty build() {
                return new Jsii$Proxy(arn);
            }
        }

        /**
         * An implementation for {@link IamInstanceProfileSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IamInstanceProfileSpecificationProperty {
            private final java.lang.String arn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = this.jsiiGet("arn", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String arn) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = arn;
            }

            @Override
            public java.lang.String getArn() {
                return this.arn;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getArn() != null) {
                    data.set("arn", om.valueToTree(this.getArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.IamInstanceProfileSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IamInstanceProfileSpecificationProperty.Jsii$Proxy that = (IamInstanceProfileSpecificationProperty.Jsii$Proxy) o;

                return this.arn != null ? this.arn.equals(that.arn) : that.arn == null;
            }

            @Override
            public int hashCode() {
                int result = this.arn != null ? this.arn.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instanceipv6address.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.InstanceIpv6AddressProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceIpv6AddressProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InstanceIpv6AddressProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSpotFleet.InstanceIpv6AddressProperty.Ipv6Address`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instanceipv6address.html#cfn-ec2-spotfleet-instanceipv6address-ipv6address
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIpv6Address();

        /**
         * @return a {@link Builder} of {@link InstanceIpv6AddressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceIpv6AddressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceIpv6AddressProperty> {
            private java.lang.String ipv6Address;

            /**
             * Sets the value of {@link InstanceIpv6AddressProperty#getIpv6Address}
             * @param ipv6Address `CfnSpotFleet.InstanceIpv6AddressProperty.Ipv6Address`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv6Address(java.lang.String ipv6Address) {
                this.ipv6Address = ipv6Address;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceIpv6AddressProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InstanceIpv6AddressProperty build() {
                return new Jsii$Proxy(ipv6Address);
            }
        }

        /**
         * An implementation for {@link InstanceIpv6AddressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceIpv6AddressProperty {
            private final java.lang.String ipv6Address;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ipv6Address = this.jsiiGet("ipv6Address", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String ipv6Address) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ipv6Address = java.util.Objects.requireNonNull(ipv6Address, "ipv6Address is required");
            }

            @Override
            public java.lang.String getIpv6Address() {
                return this.ipv6Address;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("ipv6Address", om.valueToTree(this.getIpv6Address()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.InstanceIpv6AddressProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceIpv6AddressProperty.Jsii$Proxy that = (InstanceIpv6AddressProperty.Jsii$Proxy) o;

                return this.ipv6Address.equals(that.ipv6Address);
            }

            @Override
            public int hashCode() {
                int result = this.ipv6Address.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceNetworkInterfaceSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InstanceNetworkInterfaceSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.AssociatePublicIpAddress`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-associatepublicipaddress
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAssociatePublicIpAddress() {
            return null;
        }

        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeleteOnTermination`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deleteontermination
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeleteOnTermination() {
            return null;
        }

        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Description`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-description
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeviceIndex`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deviceindex
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDeviceIndex() {
            return null;
        }

        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Groups`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-groups
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getGroups() {
            return null;
        }

        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6AddressCount`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresscount
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIpv6AddressCount() {
            return null;
        }

        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6Addresses`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresses
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIpv6Addresses() {
            return null;
        }

        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.NetworkInterfaceId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-networkinterfaceid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNetworkInterfaceId() {
            return null;
        }

        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.PrivateIpAddresses`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-privateipaddresses
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrivateIpAddresses() {
            return null;
        }

        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SecondaryPrivateIpAddressCount`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-secondaryprivateipaddresscount
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSecondaryPrivateIpAddressCount() {
            return null;
        }

        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SubnetId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-subnetid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubnetId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceNetworkInterfaceSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceNetworkInterfaceSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceNetworkInterfaceSpecificationProperty> {
            private java.lang.Object associatePublicIpAddress;
            private java.lang.Object deleteOnTermination;
            private java.lang.String description;
            private java.lang.Number deviceIndex;
            private java.util.List<java.lang.String> groups;
            private java.lang.Number ipv6AddressCount;
            private java.lang.Object ipv6Addresses;
            private java.lang.String networkInterfaceId;
            private java.lang.Object privateIpAddresses;
            private java.lang.Number secondaryPrivateIpAddressCount;
            private java.lang.String subnetId;

            /**
             * Sets the value of {@link InstanceNetworkInterfaceSpecificationProperty#getAssociatePublicIpAddress}
             * @param associatePublicIpAddress `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.AssociatePublicIpAddress`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder associatePublicIpAddress(java.lang.Boolean associatePublicIpAddress) {
                this.associatePublicIpAddress = associatePublicIpAddress;
                return this;
            }

            /**
             * Sets the value of {@link InstanceNetworkInterfaceSpecificationProperty#getAssociatePublicIpAddress}
             * @param associatePublicIpAddress `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.AssociatePublicIpAddress`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder associatePublicIpAddress(software.amazon.awscdk.core.IResolvable associatePublicIpAddress) {
                this.associatePublicIpAddress = associatePublicIpAddress;
                return this;
            }

            /**
             * Sets the value of {@link InstanceNetworkInterfaceSpecificationProperty#getDeleteOnTermination}
             * @param deleteOnTermination `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteOnTermination(java.lang.Boolean deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            /**
             * Sets the value of {@link InstanceNetworkInterfaceSpecificationProperty#getDeleteOnTermination}
             * @param deleteOnTermination `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteOnTermination(software.amazon.awscdk.core.IResolvable deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            /**
             * Sets the value of {@link InstanceNetworkInterfaceSpecificationProperty#getDescription}
             * @param description `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Description`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link InstanceNetworkInterfaceSpecificationProperty#getDeviceIndex}
             * @param deviceIndex `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeviceIndex`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deviceIndex(java.lang.Number deviceIndex) {
                this.deviceIndex = deviceIndex;
                return this;
            }

            /**
             * Sets the value of {@link InstanceNetworkInterfaceSpecificationProperty#getGroups}
             * @param groups `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Groups`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groups(java.util.List<java.lang.String> groups) {
                this.groups = groups;
                return this;
            }

            /**
             * Sets the value of {@link InstanceNetworkInterfaceSpecificationProperty#getIpv6AddressCount}
             * @param ipv6AddressCount `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6AddressCount`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv6AddressCount(java.lang.Number ipv6AddressCount) {
                this.ipv6AddressCount = ipv6AddressCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceNetworkInterfaceSpecificationProperty#getIpv6Addresses}
             * @param ipv6Addresses `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6Addresses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv6Addresses(software.amazon.awscdk.core.IResolvable ipv6Addresses) {
                this.ipv6Addresses = ipv6Addresses;
                return this;
            }

            /**
             * Sets the value of {@link InstanceNetworkInterfaceSpecificationProperty#getIpv6Addresses}
             * @param ipv6Addresses `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6Addresses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv6Addresses(java.util.List<? extends java.lang.Object> ipv6Addresses) {
                this.ipv6Addresses = ipv6Addresses;
                return this;
            }

            /**
             * Sets the value of {@link InstanceNetworkInterfaceSpecificationProperty#getNetworkInterfaceId}
             * @param networkInterfaceId `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.NetworkInterfaceId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkInterfaceId(java.lang.String networkInterfaceId) {
                this.networkInterfaceId = networkInterfaceId;
                return this;
            }

            /**
             * Sets the value of {@link InstanceNetworkInterfaceSpecificationProperty#getPrivateIpAddresses}
             * @param privateIpAddresses `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.PrivateIpAddresses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateIpAddresses(software.amazon.awscdk.core.IResolvable privateIpAddresses) {
                this.privateIpAddresses = privateIpAddresses;
                return this;
            }

            /**
             * Sets the value of {@link InstanceNetworkInterfaceSpecificationProperty#getPrivateIpAddresses}
             * @param privateIpAddresses `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.PrivateIpAddresses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateIpAddresses(java.util.List<? extends java.lang.Object> privateIpAddresses) {
                this.privateIpAddresses = privateIpAddresses;
                return this;
            }

            /**
             * Sets the value of {@link InstanceNetworkInterfaceSpecificationProperty#getSecondaryPrivateIpAddressCount}
             * @param secondaryPrivateIpAddressCount `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SecondaryPrivateIpAddressCount`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secondaryPrivateIpAddressCount(java.lang.Number secondaryPrivateIpAddressCount) {
                this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceNetworkInterfaceSpecificationProperty#getSubnetId}
             * @param subnetId `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SubnetId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetId(java.lang.String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceNetworkInterfaceSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InstanceNetworkInterfaceSpecificationProperty build() {
                return new Jsii$Proxy(associatePublicIpAddress, deleteOnTermination, description, deviceIndex, groups, ipv6AddressCount, ipv6Addresses, networkInterfaceId, privateIpAddresses, secondaryPrivateIpAddressCount, subnetId);
            }
        }

        /**
         * An implementation for {@link InstanceNetworkInterfaceSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceNetworkInterfaceSpecificationProperty {
            private final java.lang.Object associatePublicIpAddress;
            private final java.lang.Object deleteOnTermination;
            private final java.lang.String description;
            private final java.lang.Number deviceIndex;
            private final java.util.List<java.lang.String> groups;
            private final java.lang.Number ipv6AddressCount;
            private final java.lang.Object ipv6Addresses;
            private final java.lang.String networkInterfaceId;
            private final java.lang.Object privateIpAddresses;
            private final java.lang.Number secondaryPrivateIpAddressCount;
            private final java.lang.String subnetId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.associatePublicIpAddress = this.jsiiGet("associatePublicIpAddress", java.lang.Object.class);
                this.deleteOnTermination = this.jsiiGet("deleteOnTermination", java.lang.Object.class);
                this.description = this.jsiiGet("description", java.lang.String.class);
                this.deviceIndex = this.jsiiGet("deviceIndex", java.lang.Number.class);
                this.groups = this.jsiiGet("groups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.ipv6AddressCount = this.jsiiGet("ipv6AddressCount", java.lang.Number.class);
                this.ipv6Addresses = this.jsiiGet("ipv6Addresses", java.lang.Object.class);
                this.networkInterfaceId = this.jsiiGet("networkInterfaceId", java.lang.String.class);
                this.privateIpAddresses = this.jsiiGet("privateIpAddresses", java.lang.Object.class);
                this.secondaryPrivateIpAddressCount = this.jsiiGet("secondaryPrivateIpAddressCount", java.lang.Number.class);
                this.subnetId = this.jsiiGet("subnetId", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object associatePublicIpAddress, final java.lang.Object deleteOnTermination, final java.lang.String description, final java.lang.Number deviceIndex, final java.util.List<java.lang.String> groups, final java.lang.Number ipv6AddressCount, final java.lang.Object ipv6Addresses, final java.lang.String networkInterfaceId, final java.lang.Object privateIpAddresses, final java.lang.Number secondaryPrivateIpAddressCount, final java.lang.String subnetId) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.associatePublicIpAddress = associatePublicIpAddress;
                this.deleteOnTermination = deleteOnTermination;
                this.description = description;
                this.deviceIndex = deviceIndex;
                this.groups = groups;
                this.ipv6AddressCount = ipv6AddressCount;
                this.ipv6Addresses = ipv6Addresses;
                this.networkInterfaceId = networkInterfaceId;
                this.privateIpAddresses = privateIpAddresses;
                this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
                this.subnetId = subnetId;
            }

            @Override
            public java.lang.Object getAssociatePublicIpAddress() {
                return this.associatePublicIpAddress;
            }

            @Override
            public java.lang.Object getDeleteOnTermination() {
                return this.deleteOnTermination;
            }

            @Override
            public java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public java.lang.Number getDeviceIndex() {
                return this.deviceIndex;
            }

            @Override
            public java.util.List<java.lang.String> getGroups() {
                return this.groups;
            }

            @Override
            public java.lang.Number getIpv6AddressCount() {
                return this.ipv6AddressCount;
            }

            @Override
            public java.lang.Object getIpv6Addresses() {
                return this.ipv6Addresses;
            }

            @Override
            public java.lang.String getNetworkInterfaceId() {
                return this.networkInterfaceId;
            }

            @Override
            public java.lang.Object getPrivateIpAddresses() {
                return this.privateIpAddresses;
            }

            @Override
            public java.lang.Number getSecondaryPrivateIpAddressCount() {
                return this.secondaryPrivateIpAddressCount;
            }

            @Override
            public java.lang.String getSubnetId() {
                return this.subnetId;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAssociatePublicIpAddress() != null) {
                    data.set("associatePublicIpAddress", om.valueToTree(this.getAssociatePublicIpAddress()));
                }
                if (this.getDeleteOnTermination() != null) {
                    data.set("deleteOnTermination", om.valueToTree(this.getDeleteOnTermination()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getDeviceIndex() != null) {
                    data.set("deviceIndex", om.valueToTree(this.getDeviceIndex()));
                }
                if (this.getGroups() != null) {
                    data.set("groups", om.valueToTree(this.getGroups()));
                }
                if (this.getIpv6AddressCount() != null) {
                    data.set("ipv6AddressCount", om.valueToTree(this.getIpv6AddressCount()));
                }
                if (this.getIpv6Addresses() != null) {
                    data.set("ipv6Addresses", om.valueToTree(this.getIpv6Addresses()));
                }
                if (this.getNetworkInterfaceId() != null) {
                    data.set("networkInterfaceId", om.valueToTree(this.getNetworkInterfaceId()));
                }
                if (this.getPrivateIpAddresses() != null) {
                    data.set("privateIpAddresses", om.valueToTree(this.getPrivateIpAddresses()));
                }
                if (this.getSecondaryPrivateIpAddressCount() != null) {
                    data.set("secondaryPrivateIpAddressCount", om.valueToTree(this.getSecondaryPrivateIpAddressCount()));
                }
                if (this.getSubnetId() != null) {
                    data.set("subnetId", om.valueToTree(this.getSubnetId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceNetworkInterfaceSpecificationProperty.Jsii$Proxy that = (InstanceNetworkInterfaceSpecificationProperty.Jsii$Proxy) o;

                if (this.associatePublicIpAddress != null ? !this.associatePublicIpAddress.equals(that.associatePublicIpAddress) : that.associatePublicIpAddress != null) return false;
                if (this.deleteOnTermination != null ? !this.deleteOnTermination.equals(that.deleteOnTermination) : that.deleteOnTermination != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.deviceIndex != null ? !this.deviceIndex.equals(that.deviceIndex) : that.deviceIndex != null) return false;
                if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) return false;
                if (this.ipv6AddressCount != null ? !this.ipv6AddressCount.equals(that.ipv6AddressCount) : that.ipv6AddressCount != null) return false;
                if (this.ipv6Addresses != null ? !this.ipv6Addresses.equals(that.ipv6Addresses) : that.ipv6Addresses != null) return false;
                if (this.networkInterfaceId != null ? !this.networkInterfaceId.equals(that.networkInterfaceId) : that.networkInterfaceId != null) return false;
                if (this.privateIpAddresses != null ? !this.privateIpAddresses.equals(that.privateIpAddresses) : that.privateIpAddresses != null) return false;
                if (this.secondaryPrivateIpAddressCount != null ? !this.secondaryPrivateIpAddressCount.equals(that.secondaryPrivateIpAddressCount) : that.secondaryPrivateIpAddressCount != null) return false;
                return this.subnetId != null ? this.subnetId.equals(that.subnetId) : that.subnetId == null;
            }

            @Override
            public int hashCode() {
                int result = this.associatePublicIpAddress != null ? this.associatePublicIpAddress.hashCode() : 0;
                result = 31 * result + (this.deleteOnTermination != null ? this.deleteOnTermination.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.deviceIndex != null ? this.deviceIndex.hashCode() : 0);
                result = 31 * result + (this.groups != null ? this.groups.hashCode() : 0);
                result = 31 * result + (this.ipv6AddressCount != null ? this.ipv6AddressCount.hashCode() : 0);
                result = 31 * result + (this.ipv6Addresses != null ? this.ipv6Addresses.hashCode() : 0);
                result = 31 * result + (this.networkInterfaceId != null ? this.networkInterfaceId.hashCode() : 0);
                result = 31 * result + (this.privateIpAddresses != null ? this.privateIpAddresses.hashCode() : 0);
                result = 31 * result + (this.secondaryPrivateIpAddressCount != null ? this.secondaryPrivateIpAddressCount.hashCode() : 0);
                result = 31 * result + (this.subnetId != null ? this.subnetId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.LaunchTemplateConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(LaunchTemplateConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LaunchTemplateConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSpotFleet.LaunchTemplateConfigProperty.LaunchTemplateSpecification`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html#cfn-ec2-spotfleet-launchtemplateconfig-launchtemplatespecification
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLaunchTemplateSpecification() {
            return null;
        }

        /**
         * `CfnSpotFleet.LaunchTemplateConfigProperty.Overrides`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html#cfn-ec2-spotfleet-launchtemplateconfig-overrides
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOverrides() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LaunchTemplateConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LaunchTemplateConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LaunchTemplateConfigProperty> {
            private java.lang.Object launchTemplateSpecification;
            private java.lang.Object overrides;

            /**
             * Sets the value of {@link LaunchTemplateConfigProperty#getLaunchTemplateSpecification}
             * @param launchTemplateSpecification `CfnSpotFleet.LaunchTemplateConfigProperty.LaunchTemplateSpecification`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplateSpecification(software.amazon.awscdk.core.IResolvable launchTemplateSpecification) {
                this.launchTemplateSpecification = launchTemplateSpecification;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateConfigProperty#getLaunchTemplateSpecification}
             * @param launchTemplateSpecification `CfnSpotFleet.LaunchTemplateConfigProperty.LaunchTemplateSpecification`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplateSpecification(software.amazon.awscdk.services.ec2.CfnSpotFleet.FleetLaunchTemplateSpecificationProperty launchTemplateSpecification) {
                this.launchTemplateSpecification = launchTemplateSpecification;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateConfigProperty#getOverrides}
             * @param overrides `CfnSpotFleet.LaunchTemplateConfigProperty.Overrides`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrides(software.amazon.awscdk.core.IResolvable overrides) {
                this.overrides = overrides;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateConfigProperty#getOverrides}
             * @param overrides `CfnSpotFleet.LaunchTemplateConfigProperty.Overrides`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrides(java.util.List<? extends java.lang.Object> overrides) {
                this.overrides = overrides;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LaunchTemplateConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LaunchTemplateConfigProperty build() {
                return new Jsii$Proxy(launchTemplateSpecification, overrides);
            }
        }

        /**
         * An implementation for {@link LaunchTemplateConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LaunchTemplateConfigProperty {
            private final java.lang.Object launchTemplateSpecification;
            private final java.lang.Object overrides;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.launchTemplateSpecification = this.jsiiGet("launchTemplateSpecification", java.lang.Object.class);
                this.overrides = this.jsiiGet("overrides", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object launchTemplateSpecification, final java.lang.Object overrides) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.launchTemplateSpecification = launchTemplateSpecification;
                this.overrides = overrides;
            }

            @Override
            public java.lang.Object getLaunchTemplateSpecification() {
                return this.launchTemplateSpecification;
            }

            @Override
            public java.lang.Object getOverrides() {
                return this.overrides;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLaunchTemplateSpecification() != null) {
                    data.set("launchTemplateSpecification", om.valueToTree(this.getLaunchTemplateSpecification()));
                }
                if (this.getOverrides() != null) {
                    data.set("overrides", om.valueToTree(this.getOverrides()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.LaunchTemplateConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LaunchTemplateConfigProperty.Jsii$Proxy that = (LaunchTemplateConfigProperty.Jsii$Proxy) o;

                if (this.launchTemplateSpecification != null ? !this.launchTemplateSpecification.equals(that.launchTemplateSpecification) : that.launchTemplateSpecification != null) return false;
                return this.overrides != null ? this.overrides.equals(that.overrides) : that.overrides == null;
            }

            @Override
            public int hashCode() {
                int result = this.launchTemplateSpecification != null ? this.launchTemplateSpecification.hashCode() : 0;
                result = 31 * result + (this.overrides != null ? this.overrides.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.LaunchTemplateOverridesProperty")
    @software.amazon.jsii.Jsii.Proxy(LaunchTemplateOverridesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LaunchTemplateOverridesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSpotFleet.LaunchTemplateOverridesProperty.AvailabilityZone`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-availabilityzone
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
            return null;
        }

        /**
         * `CfnSpotFleet.LaunchTemplateOverridesProperty.InstanceType`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-instancetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceType() {
            return null;
        }

        /**
         * `CfnSpotFleet.LaunchTemplateOverridesProperty.SpotPrice`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-spotprice
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSpotPrice() {
            return null;
        }

        /**
         * `CfnSpotFleet.LaunchTemplateOverridesProperty.SubnetId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-subnetid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubnetId() {
            return null;
        }

        /**
         * `CfnSpotFleet.LaunchTemplateOverridesProperty.WeightedCapacity`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-weightedcapacity
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWeightedCapacity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LaunchTemplateOverridesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LaunchTemplateOverridesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LaunchTemplateOverridesProperty> {
            private java.lang.String availabilityZone;
            private java.lang.String instanceType;
            private java.lang.String spotPrice;
            private java.lang.String subnetId;
            private java.lang.Number weightedCapacity;

            /**
             * Sets the value of {@link LaunchTemplateOverridesProperty#getAvailabilityZone}
             * @param availabilityZone `CfnSpotFleet.LaunchTemplateOverridesProperty.AvailabilityZone`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityZone(java.lang.String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateOverridesProperty#getInstanceType}
             * @param instanceType `CfnSpotFleet.LaunchTemplateOverridesProperty.InstanceType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateOverridesProperty#getSpotPrice}
             * @param spotPrice `CfnSpotFleet.LaunchTemplateOverridesProperty.SpotPrice`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spotPrice(java.lang.String spotPrice) {
                this.spotPrice = spotPrice;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateOverridesProperty#getSubnetId}
             * @param subnetId `CfnSpotFleet.LaunchTemplateOverridesProperty.SubnetId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetId(java.lang.String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateOverridesProperty#getWeightedCapacity}
             * @param weightedCapacity `CfnSpotFleet.LaunchTemplateOverridesProperty.WeightedCapacity`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weightedCapacity(java.lang.Number weightedCapacity) {
                this.weightedCapacity = weightedCapacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LaunchTemplateOverridesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LaunchTemplateOverridesProperty build() {
                return new Jsii$Proxy(availabilityZone, instanceType, spotPrice, subnetId, weightedCapacity);
            }
        }

        /**
         * An implementation for {@link LaunchTemplateOverridesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LaunchTemplateOverridesProperty {
            private final java.lang.String availabilityZone;
            private final java.lang.String instanceType;
            private final java.lang.String spotPrice;
            private final java.lang.String subnetId;
            private final java.lang.Number weightedCapacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.availabilityZone = this.jsiiGet("availabilityZone", java.lang.String.class);
                this.instanceType = this.jsiiGet("instanceType", java.lang.String.class);
                this.spotPrice = this.jsiiGet("spotPrice", java.lang.String.class);
                this.subnetId = this.jsiiGet("subnetId", java.lang.String.class);
                this.weightedCapacity = this.jsiiGet("weightedCapacity", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String availabilityZone, final java.lang.String instanceType, final java.lang.String spotPrice, final java.lang.String subnetId, final java.lang.Number weightedCapacity) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.availabilityZone = availabilityZone;
                this.instanceType = instanceType;
                this.spotPrice = spotPrice;
                this.subnetId = subnetId;
                this.weightedCapacity = weightedCapacity;
            }

            @Override
            public java.lang.String getAvailabilityZone() {
                return this.availabilityZone;
            }

            @Override
            public java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public java.lang.String getSpotPrice() {
                return this.spotPrice;
            }

            @Override
            public java.lang.String getSubnetId() {
                return this.subnetId;
            }

            @Override
            public java.lang.Number getWeightedCapacity() {
                return this.weightedCapacity;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAvailabilityZone() != null) {
                    data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                }
                if (this.getInstanceType() != null) {
                    data.set("instanceType", om.valueToTree(this.getInstanceType()));
                }
                if (this.getSpotPrice() != null) {
                    data.set("spotPrice", om.valueToTree(this.getSpotPrice()));
                }
                if (this.getSubnetId() != null) {
                    data.set("subnetId", om.valueToTree(this.getSubnetId()));
                }
                if (this.getWeightedCapacity() != null) {
                    data.set("weightedCapacity", om.valueToTree(this.getWeightedCapacity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.LaunchTemplateOverridesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LaunchTemplateOverridesProperty.Jsii$Proxy that = (LaunchTemplateOverridesProperty.Jsii$Proxy) o;

                if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
                if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
                if (this.spotPrice != null ? !this.spotPrice.equals(that.spotPrice) : that.spotPrice != null) return false;
                if (this.subnetId != null ? !this.subnetId.equals(that.subnetId) : that.subnetId != null) return false;
                return this.weightedCapacity != null ? this.weightedCapacity.equals(that.weightedCapacity) : that.weightedCapacity == null;
            }

            @Override
            public int hashCode() {
                int result = this.availabilityZone != null ? this.availabilityZone.hashCode() : 0;
                result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
                result = 31 * result + (this.spotPrice != null ? this.spotPrice.hashCode() : 0);
                result = 31 * result + (this.subnetId != null ? this.subnetId.hashCode() : 0);
                result = 31 * result + (this.weightedCapacity != null ? this.weightedCapacity.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.LoadBalancersConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(LoadBalancersConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoadBalancersConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSpotFleet.LoadBalancersConfigProperty.ClassicLoadBalancersConfig`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html#cfn-ec2-spotfleet-loadbalancersconfig-classicloadbalancersconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getClassicLoadBalancersConfig() {
            return null;
        }

        /**
         * `CfnSpotFleet.LoadBalancersConfigProperty.TargetGroupsConfig`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html#cfn-ec2-spotfleet-loadbalancersconfig-targetgroupsconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTargetGroupsConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LoadBalancersConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoadBalancersConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoadBalancersConfigProperty> {
            private java.lang.Object classicLoadBalancersConfig;
            private java.lang.Object targetGroupsConfig;

            /**
             * Sets the value of {@link LoadBalancersConfigProperty#getClassicLoadBalancersConfig}
             * @param classicLoadBalancersConfig `CfnSpotFleet.LoadBalancersConfigProperty.ClassicLoadBalancersConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder classicLoadBalancersConfig(software.amazon.awscdk.core.IResolvable classicLoadBalancersConfig) {
                this.classicLoadBalancersConfig = classicLoadBalancersConfig;
                return this;
            }

            /**
             * Sets the value of {@link LoadBalancersConfigProperty#getClassicLoadBalancersConfig}
             * @param classicLoadBalancersConfig `CfnSpotFleet.LoadBalancersConfigProperty.ClassicLoadBalancersConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder classicLoadBalancersConfig(software.amazon.awscdk.services.ec2.CfnSpotFleet.ClassicLoadBalancersConfigProperty classicLoadBalancersConfig) {
                this.classicLoadBalancersConfig = classicLoadBalancersConfig;
                return this;
            }

            /**
             * Sets the value of {@link LoadBalancersConfigProperty#getTargetGroupsConfig}
             * @param targetGroupsConfig `CfnSpotFleet.LoadBalancersConfigProperty.TargetGroupsConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetGroupsConfig(software.amazon.awscdk.core.IResolvable targetGroupsConfig) {
                this.targetGroupsConfig = targetGroupsConfig;
                return this;
            }

            /**
             * Sets the value of {@link LoadBalancersConfigProperty#getTargetGroupsConfig}
             * @param targetGroupsConfig `CfnSpotFleet.LoadBalancersConfigProperty.TargetGroupsConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetGroupsConfig(software.amazon.awscdk.services.ec2.CfnSpotFleet.TargetGroupsConfigProperty targetGroupsConfig) {
                this.targetGroupsConfig = targetGroupsConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoadBalancersConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoadBalancersConfigProperty build() {
                return new Jsii$Proxy(classicLoadBalancersConfig, targetGroupsConfig);
            }
        }

        /**
         * An implementation for {@link LoadBalancersConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoadBalancersConfigProperty {
            private final java.lang.Object classicLoadBalancersConfig;
            private final java.lang.Object targetGroupsConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.classicLoadBalancersConfig = this.jsiiGet("classicLoadBalancersConfig", java.lang.Object.class);
                this.targetGroupsConfig = this.jsiiGet("targetGroupsConfig", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object classicLoadBalancersConfig, final java.lang.Object targetGroupsConfig) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.classicLoadBalancersConfig = classicLoadBalancersConfig;
                this.targetGroupsConfig = targetGroupsConfig;
            }

            @Override
            public java.lang.Object getClassicLoadBalancersConfig() {
                return this.classicLoadBalancersConfig;
            }

            @Override
            public java.lang.Object getTargetGroupsConfig() {
                return this.targetGroupsConfig;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getClassicLoadBalancersConfig() != null) {
                    data.set("classicLoadBalancersConfig", om.valueToTree(this.getClassicLoadBalancersConfig()));
                }
                if (this.getTargetGroupsConfig() != null) {
                    data.set("targetGroupsConfig", om.valueToTree(this.getTargetGroupsConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.LoadBalancersConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoadBalancersConfigProperty.Jsii$Proxy that = (LoadBalancersConfigProperty.Jsii$Proxy) o;

                if (this.classicLoadBalancersConfig != null ? !this.classicLoadBalancersConfig.equals(that.classicLoadBalancersConfig) : that.classicLoadBalancersConfig != null) return false;
                return this.targetGroupsConfig != null ? this.targetGroupsConfig.equals(that.targetGroupsConfig) : that.targetGroupsConfig == null;
            }

            @Override
            public int hashCode() {
                int result = this.classicLoadBalancersConfig != null ? this.classicLoadBalancersConfig.hashCode() : 0;
                result = 31 * result + (this.targetGroupsConfig != null ? this.targetGroupsConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.PrivateIpAddressSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(PrivateIpAddressSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PrivateIpAddressSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSpotFleet.PrivateIpAddressSpecificationProperty.PrivateIpAddress`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-privateipaddress
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPrivateIpAddress();

        /**
         * `CfnSpotFleet.PrivateIpAddressSpecificationProperty.Primary`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-primary
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrimary() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PrivateIpAddressSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PrivateIpAddressSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PrivateIpAddressSpecificationProperty> {
            private java.lang.String privateIpAddress;
            private java.lang.Object primary;

            /**
             * Sets the value of {@link PrivateIpAddressSpecificationProperty#getPrivateIpAddress}
             * @param privateIpAddress `CfnSpotFleet.PrivateIpAddressSpecificationProperty.PrivateIpAddress`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateIpAddress(java.lang.String privateIpAddress) {
                this.privateIpAddress = privateIpAddress;
                return this;
            }

            /**
             * Sets the value of {@link PrivateIpAddressSpecificationProperty#getPrimary}
             * @param primary `CfnSpotFleet.PrivateIpAddressSpecificationProperty.Primary`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primary(java.lang.Boolean primary) {
                this.primary = primary;
                return this;
            }

            /**
             * Sets the value of {@link PrivateIpAddressSpecificationProperty#getPrimary}
             * @param primary `CfnSpotFleet.PrivateIpAddressSpecificationProperty.Primary`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primary(software.amazon.awscdk.core.IResolvable primary) {
                this.primary = primary;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PrivateIpAddressSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PrivateIpAddressSpecificationProperty build() {
                return new Jsii$Proxy(privateIpAddress, primary);
            }
        }

        /**
         * An implementation for {@link PrivateIpAddressSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PrivateIpAddressSpecificationProperty {
            private final java.lang.String privateIpAddress;
            private final java.lang.Object primary;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.privateIpAddress = this.jsiiGet("privateIpAddress", java.lang.String.class);
                this.primary = this.jsiiGet("primary", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String privateIpAddress, final java.lang.Object primary) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.privateIpAddress = java.util.Objects.requireNonNull(privateIpAddress, "privateIpAddress is required");
                this.primary = primary;
            }

            @Override
            public java.lang.String getPrivateIpAddress() {
                return this.privateIpAddress;
            }

            @Override
            public java.lang.Object getPrimary() {
                return this.primary;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("privateIpAddress", om.valueToTree(this.getPrivateIpAddress()));
                if (this.getPrimary() != null) {
                    data.set("primary", om.valueToTree(this.getPrimary()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.PrivateIpAddressSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PrivateIpAddressSpecificationProperty.Jsii$Proxy that = (PrivateIpAddressSpecificationProperty.Jsii$Proxy) o;

                if (!privateIpAddress.equals(that.privateIpAddress)) return false;
                return this.primary != null ? this.primary.equals(that.primary) : that.primary == null;
            }

            @Override
            public int hashCode() {
                int result = this.privateIpAddress.hashCode();
                result = 31 * result + (this.primary != null ? this.primary.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.SpotFleetLaunchSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(SpotFleetLaunchSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpotFleetLaunchSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.ImageId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-imageid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getImageId();

        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.InstanceType`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-instancetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceType();

        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.BlockDeviceMappings`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-blockdevicemappings
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBlockDeviceMappings() {
            return null;
        }

        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.EbsOptimized`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ebsoptimized
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEbsOptimized() {
            return null;
        }

        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.IamInstanceProfile`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-iaminstanceprofile
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIamInstanceProfile() {
            return null;
        }

        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.KernelId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-kernelid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKernelId() {
            return null;
        }

        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.KeyName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-keyname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKeyName() {
            return null;
        }

        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Monitoring`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-monitoring
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMonitoring() {
            return null;
        }

        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.NetworkInterfaces`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-networkinterfaces
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkInterfaces() {
            return null;
        }

        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Placement`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-placement
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPlacement() {
            return null;
        }

        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.RamdiskId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ramdiskid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRamdiskId() {
            return null;
        }

        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SecurityGroups`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-securitygroups
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecurityGroups() {
            return null;
        }

        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SpotPrice`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-spotprice
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSpotPrice() {
            return null;
        }

        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SubnetId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-subnetid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubnetId() {
            return null;
        }

        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.TagSpecifications`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-tagspecifications
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTagSpecifications() {
            return null;
        }

        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.UserData`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-userdata
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUserData() {
            return null;
        }

        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.WeightedCapacity`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-weightedcapacity
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWeightedCapacity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SpotFleetLaunchSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SpotFleetLaunchSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SpotFleetLaunchSpecificationProperty> {
            private java.lang.String imageId;
            private java.lang.String instanceType;
            private java.lang.Object blockDeviceMappings;
            private java.lang.Object ebsOptimized;
            private java.lang.Object iamInstanceProfile;
            private java.lang.String kernelId;
            private java.lang.String keyName;
            private java.lang.Object monitoring;
            private java.lang.Object networkInterfaces;
            private java.lang.Object placement;
            private java.lang.String ramdiskId;
            private java.lang.Object securityGroups;
            private java.lang.String spotPrice;
            private java.lang.String subnetId;
            private java.lang.Object tagSpecifications;
            private java.lang.String userData;
            private java.lang.Number weightedCapacity;

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getImageId}
             * @param imageId `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.ImageId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageId(java.lang.String imageId) {
                this.imageId = imageId;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getInstanceType}
             * @param instanceType `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.InstanceType`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getBlockDeviceMappings}
             * @param blockDeviceMappings `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.BlockDeviceMappings`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockDeviceMappings(software.amazon.awscdk.core.IResolvable blockDeviceMappings) {
                this.blockDeviceMappings = blockDeviceMappings;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getBlockDeviceMappings}
             * @param blockDeviceMappings `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.BlockDeviceMappings`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockDeviceMappings(java.util.List<? extends java.lang.Object> blockDeviceMappings) {
                this.blockDeviceMappings = blockDeviceMappings;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getEbsOptimized}
             * @param ebsOptimized `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.EbsOptimized`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsOptimized(java.lang.Boolean ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getEbsOptimized}
             * @param ebsOptimized `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.EbsOptimized`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsOptimized(software.amazon.awscdk.core.IResolvable ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getIamInstanceProfile}
             * @param iamInstanceProfile `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.IamInstanceProfile`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iamInstanceProfile(software.amazon.awscdk.core.IResolvable iamInstanceProfile) {
                this.iamInstanceProfile = iamInstanceProfile;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getIamInstanceProfile}
             * @param iamInstanceProfile `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.IamInstanceProfile`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iamInstanceProfile(software.amazon.awscdk.services.ec2.CfnSpotFleet.IamInstanceProfileSpecificationProperty iamInstanceProfile) {
                this.iamInstanceProfile = iamInstanceProfile;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getKernelId}
             * @param kernelId `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.KernelId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kernelId(java.lang.String kernelId) {
                this.kernelId = kernelId;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getKeyName}
             * @param keyName `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.KeyName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyName(java.lang.String keyName) {
                this.keyName = keyName;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getMonitoring}
             * @param monitoring `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Monitoring`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoring(software.amazon.awscdk.core.IResolvable monitoring) {
                this.monitoring = monitoring;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getMonitoring}
             * @param monitoring `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Monitoring`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoring(software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotFleetMonitoringProperty monitoring) {
                this.monitoring = monitoring;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getNetworkInterfaces}
             * @param networkInterfaces `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.NetworkInterfaces`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkInterfaces(software.amazon.awscdk.core.IResolvable networkInterfaces) {
                this.networkInterfaces = networkInterfaces;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getNetworkInterfaces}
             * @param networkInterfaces `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.NetworkInterfaces`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkInterfaces(java.util.List<? extends java.lang.Object> networkInterfaces) {
                this.networkInterfaces = networkInterfaces;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getPlacement}
             * @param placement `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Placement`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder placement(software.amazon.awscdk.core.IResolvable placement) {
                this.placement = placement;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getPlacement}
             * @param placement `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Placement`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder placement(software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotPlacementProperty placement) {
                this.placement = placement;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getRamdiskId}
             * @param ramdiskId `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.RamdiskId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ramdiskId(java.lang.String ramdiskId) {
                this.ramdiskId = ramdiskId;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getSecurityGroups}
             * @param securityGroups `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SecurityGroups`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroups(software.amazon.awscdk.core.IResolvable securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getSecurityGroups}
             * @param securityGroups `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SecurityGroups`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroups(java.util.List<? extends java.lang.Object> securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getSpotPrice}
             * @param spotPrice `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SpotPrice`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spotPrice(java.lang.String spotPrice) {
                this.spotPrice = spotPrice;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getSubnetId}
             * @param subnetId `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SubnetId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetId(java.lang.String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getTagSpecifications}
             * @param tagSpecifications `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.TagSpecifications`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagSpecifications(software.amazon.awscdk.core.IResolvable tagSpecifications) {
                this.tagSpecifications = tagSpecifications;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getTagSpecifications}
             * @param tagSpecifications `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.TagSpecifications`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagSpecifications(java.util.List<? extends java.lang.Object> tagSpecifications) {
                this.tagSpecifications = tagSpecifications;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getUserData}
             * @param userData `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.UserData`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userData(java.lang.String userData) {
                this.userData = userData;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getWeightedCapacity}
             * @param weightedCapacity `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.WeightedCapacity`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weightedCapacity(java.lang.Number weightedCapacity) {
                this.weightedCapacity = weightedCapacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotFleetLaunchSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SpotFleetLaunchSpecificationProperty build() {
                return new Jsii$Proxy(imageId, instanceType, blockDeviceMappings, ebsOptimized, iamInstanceProfile, kernelId, keyName, monitoring, networkInterfaces, placement, ramdiskId, securityGroups, spotPrice, subnetId, tagSpecifications, userData, weightedCapacity);
            }
        }

        /**
         * An implementation for {@link SpotFleetLaunchSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpotFleetLaunchSpecificationProperty {
            private final java.lang.String imageId;
            private final java.lang.String instanceType;
            private final java.lang.Object blockDeviceMappings;
            private final java.lang.Object ebsOptimized;
            private final java.lang.Object iamInstanceProfile;
            private final java.lang.String kernelId;
            private final java.lang.String keyName;
            private final java.lang.Object monitoring;
            private final java.lang.Object networkInterfaces;
            private final java.lang.Object placement;
            private final java.lang.String ramdiskId;
            private final java.lang.Object securityGroups;
            private final java.lang.String spotPrice;
            private final java.lang.String subnetId;
            private final java.lang.Object tagSpecifications;
            private final java.lang.String userData;
            private final java.lang.Number weightedCapacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.imageId = this.jsiiGet("imageId", java.lang.String.class);
                this.instanceType = this.jsiiGet("instanceType", java.lang.String.class);
                this.blockDeviceMappings = this.jsiiGet("blockDeviceMappings", java.lang.Object.class);
                this.ebsOptimized = this.jsiiGet("ebsOptimized", java.lang.Object.class);
                this.iamInstanceProfile = this.jsiiGet("iamInstanceProfile", java.lang.Object.class);
                this.kernelId = this.jsiiGet("kernelId", java.lang.String.class);
                this.keyName = this.jsiiGet("keyName", java.lang.String.class);
                this.monitoring = this.jsiiGet("monitoring", java.lang.Object.class);
                this.networkInterfaces = this.jsiiGet("networkInterfaces", java.lang.Object.class);
                this.placement = this.jsiiGet("placement", java.lang.Object.class);
                this.ramdiskId = this.jsiiGet("ramdiskId", java.lang.String.class);
                this.securityGroups = this.jsiiGet("securityGroups", java.lang.Object.class);
                this.spotPrice = this.jsiiGet("spotPrice", java.lang.String.class);
                this.subnetId = this.jsiiGet("subnetId", java.lang.String.class);
                this.tagSpecifications = this.jsiiGet("tagSpecifications", java.lang.Object.class);
                this.userData = this.jsiiGet("userData", java.lang.String.class);
                this.weightedCapacity = this.jsiiGet("weightedCapacity", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String imageId, final java.lang.String instanceType, final java.lang.Object blockDeviceMappings, final java.lang.Object ebsOptimized, final java.lang.Object iamInstanceProfile, final java.lang.String kernelId, final java.lang.String keyName, final java.lang.Object monitoring, final java.lang.Object networkInterfaces, final java.lang.Object placement, final java.lang.String ramdiskId, final java.lang.Object securityGroups, final java.lang.String spotPrice, final java.lang.String subnetId, final java.lang.Object tagSpecifications, final java.lang.String userData, final java.lang.Number weightedCapacity) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.imageId = java.util.Objects.requireNonNull(imageId, "imageId is required");
                this.instanceType = java.util.Objects.requireNonNull(instanceType, "instanceType is required");
                this.blockDeviceMappings = blockDeviceMappings;
                this.ebsOptimized = ebsOptimized;
                this.iamInstanceProfile = iamInstanceProfile;
                this.kernelId = kernelId;
                this.keyName = keyName;
                this.monitoring = monitoring;
                this.networkInterfaces = networkInterfaces;
                this.placement = placement;
                this.ramdiskId = ramdiskId;
                this.securityGroups = securityGroups;
                this.spotPrice = spotPrice;
                this.subnetId = subnetId;
                this.tagSpecifications = tagSpecifications;
                this.userData = userData;
                this.weightedCapacity = weightedCapacity;
            }

            @Override
            public java.lang.String getImageId() {
                return this.imageId;
            }

            @Override
            public java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public java.lang.Object getBlockDeviceMappings() {
                return this.blockDeviceMappings;
            }

            @Override
            public java.lang.Object getEbsOptimized() {
                return this.ebsOptimized;
            }

            @Override
            public java.lang.Object getIamInstanceProfile() {
                return this.iamInstanceProfile;
            }

            @Override
            public java.lang.String getKernelId() {
                return this.kernelId;
            }

            @Override
            public java.lang.String getKeyName() {
                return this.keyName;
            }

            @Override
            public java.lang.Object getMonitoring() {
                return this.monitoring;
            }

            @Override
            public java.lang.Object getNetworkInterfaces() {
                return this.networkInterfaces;
            }

            @Override
            public java.lang.Object getPlacement() {
                return this.placement;
            }

            @Override
            public java.lang.String getRamdiskId() {
                return this.ramdiskId;
            }

            @Override
            public java.lang.Object getSecurityGroups() {
                return this.securityGroups;
            }

            @Override
            public java.lang.String getSpotPrice() {
                return this.spotPrice;
            }

            @Override
            public java.lang.String getSubnetId() {
                return this.subnetId;
            }

            @Override
            public java.lang.Object getTagSpecifications() {
                return this.tagSpecifications;
            }

            @Override
            public java.lang.String getUserData() {
                return this.userData;
            }

            @Override
            public java.lang.Number getWeightedCapacity() {
                return this.weightedCapacity;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("imageId", om.valueToTree(this.getImageId()));
                data.set("instanceType", om.valueToTree(this.getInstanceType()));
                if (this.getBlockDeviceMappings() != null) {
                    data.set("blockDeviceMappings", om.valueToTree(this.getBlockDeviceMappings()));
                }
                if (this.getEbsOptimized() != null) {
                    data.set("ebsOptimized", om.valueToTree(this.getEbsOptimized()));
                }
                if (this.getIamInstanceProfile() != null) {
                    data.set("iamInstanceProfile", om.valueToTree(this.getIamInstanceProfile()));
                }
                if (this.getKernelId() != null) {
                    data.set("kernelId", om.valueToTree(this.getKernelId()));
                }
                if (this.getKeyName() != null) {
                    data.set("keyName", om.valueToTree(this.getKeyName()));
                }
                if (this.getMonitoring() != null) {
                    data.set("monitoring", om.valueToTree(this.getMonitoring()));
                }
                if (this.getNetworkInterfaces() != null) {
                    data.set("networkInterfaces", om.valueToTree(this.getNetworkInterfaces()));
                }
                if (this.getPlacement() != null) {
                    data.set("placement", om.valueToTree(this.getPlacement()));
                }
                if (this.getRamdiskId() != null) {
                    data.set("ramdiskId", om.valueToTree(this.getRamdiskId()));
                }
                if (this.getSecurityGroups() != null) {
                    data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
                }
                if (this.getSpotPrice() != null) {
                    data.set("spotPrice", om.valueToTree(this.getSpotPrice()));
                }
                if (this.getSubnetId() != null) {
                    data.set("subnetId", om.valueToTree(this.getSubnetId()));
                }
                if (this.getTagSpecifications() != null) {
                    data.set("tagSpecifications", om.valueToTree(this.getTagSpecifications()));
                }
                if (this.getUserData() != null) {
                    data.set("userData", om.valueToTree(this.getUserData()));
                }
                if (this.getWeightedCapacity() != null) {
                    data.set("weightedCapacity", om.valueToTree(this.getWeightedCapacity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.SpotFleetLaunchSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SpotFleetLaunchSpecificationProperty.Jsii$Proxy that = (SpotFleetLaunchSpecificationProperty.Jsii$Proxy) o;

                if (!imageId.equals(that.imageId)) return false;
                if (!instanceType.equals(that.instanceType)) return false;
                if (this.blockDeviceMappings != null ? !this.blockDeviceMappings.equals(that.blockDeviceMappings) : that.blockDeviceMappings != null) return false;
                if (this.ebsOptimized != null ? !this.ebsOptimized.equals(that.ebsOptimized) : that.ebsOptimized != null) return false;
                if (this.iamInstanceProfile != null ? !this.iamInstanceProfile.equals(that.iamInstanceProfile) : that.iamInstanceProfile != null) return false;
                if (this.kernelId != null ? !this.kernelId.equals(that.kernelId) : that.kernelId != null) return false;
                if (this.keyName != null ? !this.keyName.equals(that.keyName) : that.keyName != null) return false;
                if (this.monitoring != null ? !this.monitoring.equals(that.monitoring) : that.monitoring != null) return false;
                if (this.networkInterfaces != null ? !this.networkInterfaces.equals(that.networkInterfaces) : that.networkInterfaces != null) return false;
                if (this.placement != null ? !this.placement.equals(that.placement) : that.placement != null) return false;
                if (this.ramdiskId != null ? !this.ramdiskId.equals(that.ramdiskId) : that.ramdiskId != null) return false;
                if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
                if (this.spotPrice != null ? !this.spotPrice.equals(that.spotPrice) : that.spotPrice != null) return false;
                if (this.subnetId != null ? !this.subnetId.equals(that.subnetId) : that.subnetId != null) return false;
                if (this.tagSpecifications != null ? !this.tagSpecifications.equals(that.tagSpecifications) : that.tagSpecifications != null) return false;
                if (this.userData != null ? !this.userData.equals(that.userData) : that.userData != null) return false;
                return this.weightedCapacity != null ? this.weightedCapacity.equals(that.weightedCapacity) : that.weightedCapacity == null;
            }

            @Override
            public int hashCode() {
                int result = this.imageId.hashCode();
                result = 31 * result + (this.instanceType.hashCode());
                result = 31 * result + (this.blockDeviceMappings != null ? this.blockDeviceMappings.hashCode() : 0);
                result = 31 * result + (this.ebsOptimized != null ? this.ebsOptimized.hashCode() : 0);
                result = 31 * result + (this.iamInstanceProfile != null ? this.iamInstanceProfile.hashCode() : 0);
                result = 31 * result + (this.kernelId != null ? this.kernelId.hashCode() : 0);
                result = 31 * result + (this.keyName != null ? this.keyName.hashCode() : 0);
                result = 31 * result + (this.monitoring != null ? this.monitoring.hashCode() : 0);
                result = 31 * result + (this.networkInterfaces != null ? this.networkInterfaces.hashCode() : 0);
                result = 31 * result + (this.placement != null ? this.placement.hashCode() : 0);
                result = 31 * result + (this.ramdiskId != null ? this.ramdiskId.hashCode() : 0);
                result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
                result = 31 * result + (this.spotPrice != null ? this.spotPrice.hashCode() : 0);
                result = 31 * result + (this.subnetId != null ? this.subnetId.hashCode() : 0);
                result = 31 * result + (this.tagSpecifications != null ? this.tagSpecifications.hashCode() : 0);
                result = 31 * result + (this.userData != null ? this.userData.hashCode() : 0);
                result = 31 * result + (this.weightedCapacity != null ? this.weightedCapacity.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-monitoring.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.SpotFleetMonitoringProperty")
    @software.amazon.jsii.Jsii.Proxy(SpotFleetMonitoringProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpotFleetMonitoringProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSpotFleet.SpotFleetMonitoringProperty.Enabled`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-monitoring.html#cfn-ec2-spotfleet-spotfleetmonitoring-enabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SpotFleetMonitoringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SpotFleetMonitoringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SpotFleetMonitoringProperty> {
            private java.lang.Object enabled;

            /**
             * Sets the value of {@link SpotFleetMonitoringProperty#getEnabled}
             * @param enabled `CfnSpotFleet.SpotFleetMonitoringProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetMonitoringProperty#getEnabled}
             * @param enabled `CfnSpotFleet.SpotFleetMonitoringProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotFleetMonitoringProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SpotFleetMonitoringProperty build() {
                return new Jsii$Proxy(enabled);
            }
        }

        /**
         * An implementation for {@link SpotFleetMonitoringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpotFleetMonitoringProperty {
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = this.jsiiGet("enabled", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object enabled) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = enabled;
            }

            @Override
            public java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.SpotFleetMonitoringProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SpotFleetMonitoringProperty.Jsii$Proxy that = (SpotFleetMonitoringProperty.Jsii$Proxy) o;

                return this.enabled != null ? this.enabled.equals(that.enabled) : that.enabled == null;
            }

            @Override
            public int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.SpotFleetRequestConfigDataProperty")
    @software.amazon.jsii.Jsii.Proxy(SpotFleetRequestConfigDataProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpotFleetRequestConfigDataProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.IamFleetRole`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-iamfleetrole
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIamFleetRole();

        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.TargetCapacity`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-targetcapacity
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getTargetCapacity();

        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.AllocationStrategy`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-allocationstrategy
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAllocationStrategy() {
            return null;
        }

        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ExcessCapacityTerminationPolicy`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-excesscapacityterminationpolicy
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExcessCapacityTerminationPolicy() {
            return null;
        }

        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.InstanceInterruptionBehavior`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-instanceinterruptionbehavior
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceInterruptionBehavior() {
            return null;
        }

        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchSpecifications`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLaunchSpecifications() {
            return null;
        }

        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchTemplateConfigs`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchtemplateconfigs
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLaunchTemplateConfigs() {
            return null;
        }

        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LoadBalancersConfig`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-loadbalancersconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLoadBalancersConfig() {
            return null;
        }

        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ReplaceUnhealthyInstances`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-replaceunhealthyinstances
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReplaceUnhealthyInstances() {
            return null;
        }

        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.SpotPrice`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-spotprice
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSpotPrice() {
            return null;
        }

        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.TerminateInstancesWithExpiration`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-terminateinstanceswithexpiration
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTerminateInstancesWithExpiration() {
            return null;
        }

        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.Type`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ValidFrom`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validfrom
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValidFrom() {
            return null;
        }

        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ValidUntil`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validuntil
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValidUntil() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SpotFleetRequestConfigDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SpotFleetRequestConfigDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SpotFleetRequestConfigDataProperty> {
            private java.lang.String iamFleetRole;
            private java.lang.Number targetCapacity;
            private java.lang.String allocationStrategy;
            private java.lang.String excessCapacityTerminationPolicy;
            private java.lang.String instanceInterruptionBehavior;
            private java.lang.Object launchSpecifications;
            private java.lang.Object launchTemplateConfigs;
            private java.lang.Object loadBalancersConfig;
            private java.lang.Object replaceUnhealthyInstances;
            private java.lang.String spotPrice;
            private java.lang.Object terminateInstancesWithExpiration;
            private java.lang.String type;
            private java.lang.String validFrom;
            private java.lang.String validUntil;

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getIamFleetRole}
             * @param iamFleetRole `CfnSpotFleet.SpotFleetRequestConfigDataProperty.IamFleetRole`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iamFleetRole(java.lang.String iamFleetRole) {
                this.iamFleetRole = iamFleetRole;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getTargetCapacity}
             * @param targetCapacity `CfnSpotFleet.SpotFleetRequestConfigDataProperty.TargetCapacity`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetCapacity(java.lang.Number targetCapacity) {
                this.targetCapacity = targetCapacity;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getAllocationStrategy}
             * @param allocationStrategy `CfnSpotFleet.SpotFleetRequestConfigDataProperty.AllocationStrategy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allocationStrategy(java.lang.String allocationStrategy) {
                this.allocationStrategy = allocationStrategy;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getExcessCapacityTerminationPolicy}
             * @param excessCapacityTerminationPolicy `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ExcessCapacityTerminationPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excessCapacityTerminationPolicy(java.lang.String excessCapacityTerminationPolicy) {
                this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getInstanceInterruptionBehavior}
             * @param instanceInterruptionBehavior `CfnSpotFleet.SpotFleetRequestConfigDataProperty.InstanceInterruptionBehavior`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceInterruptionBehavior(java.lang.String instanceInterruptionBehavior) {
                this.instanceInterruptionBehavior = instanceInterruptionBehavior;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getLaunchSpecifications}
             * @param launchSpecifications `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchSpecifications`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchSpecifications(software.amazon.awscdk.core.IResolvable launchSpecifications) {
                this.launchSpecifications = launchSpecifications;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getLaunchSpecifications}
             * @param launchSpecifications `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchSpecifications`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchSpecifications(java.util.List<? extends java.lang.Object> launchSpecifications) {
                this.launchSpecifications = launchSpecifications;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getLaunchTemplateConfigs}
             * @param launchTemplateConfigs `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchTemplateConfigs`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplateConfigs(software.amazon.awscdk.core.IResolvable launchTemplateConfigs) {
                this.launchTemplateConfigs = launchTemplateConfigs;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getLaunchTemplateConfigs}
             * @param launchTemplateConfigs `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchTemplateConfigs`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplateConfigs(java.util.List<? extends java.lang.Object> launchTemplateConfigs) {
                this.launchTemplateConfigs = launchTemplateConfigs;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getLoadBalancersConfig}
             * @param loadBalancersConfig `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LoadBalancersConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loadBalancersConfig(software.amazon.awscdk.core.IResolvable loadBalancersConfig) {
                this.loadBalancersConfig = loadBalancersConfig;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getLoadBalancersConfig}
             * @param loadBalancersConfig `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LoadBalancersConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loadBalancersConfig(software.amazon.awscdk.services.ec2.CfnSpotFleet.LoadBalancersConfigProperty loadBalancersConfig) {
                this.loadBalancersConfig = loadBalancersConfig;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getReplaceUnhealthyInstances}
             * @param replaceUnhealthyInstances `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ReplaceUnhealthyInstances`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replaceUnhealthyInstances(java.lang.Boolean replaceUnhealthyInstances) {
                this.replaceUnhealthyInstances = replaceUnhealthyInstances;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getReplaceUnhealthyInstances}
             * @param replaceUnhealthyInstances `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ReplaceUnhealthyInstances`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replaceUnhealthyInstances(software.amazon.awscdk.core.IResolvable replaceUnhealthyInstances) {
                this.replaceUnhealthyInstances = replaceUnhealthyInstances;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getSpotPrice}
             * @param spotPrice `CfnSpotFleet.SpotFleetRequestConfigDataProperty.SpotPrice`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spotPrice(java.lang.String spotPrice) {
                this.spotPrice = spotPrice;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getTerminateInstancesWithExpiration}
             * @param terminateInstancesWithExpiration `CfnSpotFleet.SpotFleetRequestConfigDataProperty.TerminateInstancesWithExpiration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder terminateInstancesWithExpiration(java.lang.Boolean terminateInstancesWithExpiration) {
                this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getTerminateInstancesWithExpiration}
             * @param terminateInstancesWithExpiration `CfnSpotFleet.SpotFleetRequestConfigDataProperty.TerminateInstancesWithExpiration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder terminateInstancesWithExpiration(software.amazon.awscdk.core.IResolvable terminateInstancesWithExpiration) {
                this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getType}
             * @param type `CfnSpotFleet.SpotFleetRequestConfigDataProperty.Type`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getValidFrom}
             * @param validFrom `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ValidFrom`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validFrom(java.lang.String validFrom) {
                this.validFrom = validFrom;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getValidUntil}
             * @param validUntil `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ValidUntil`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validUntil(java.lang.String validUntil) {
                this.validUntil = validUntil;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotFleetRequestConfigDataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SpotFleetRequestConfigDataProperty build() {
                return new Jsii$Proxy(iamFleetRole, targetCapacity, allocationStrategy, excessCapacityTerminationPolicy, instanceInterruptionBehavior, launchSpecifications, launchTemplateConfigs, loadBalancersConfig, replaceUnhealthyInstances, spotPrice, terminateInstancesWithExpiration, type, validFrom, validUntil);
            }
        }

        /**
         * An implementation for {@link SpotFleetRequestConfigDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpotFleetRequestConfigDataProperty {
            private final java.lang.String iamFleetRole;
            private final java.lang.Number targetCapacity;
            private final java.lang.String allocationStrategy;
            private final java.lang.String excessCapacityTerminationPolicy;
            private final java.lang.String instanceInterruptionBehavior;
            private final java.lang.Object launchSpecifications;
            private final java.lang.Object launchTemplateConfigs;
            private final java.lang.Object loadBalancersConfig;
            private final java.lang.Object replaceUnhealthyInstances;
            private final java.lang.String spotPrice;
            private final java.lang.Object terminateInstancesWithExpiration;
            private final java.lang.String type;
            private final java.lang.String validFrom;
            private final java.lang.String validUntil;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.iamFleetRole = this.jsiiGet("iamFleetRole", java.lang.String.class);
                this.targetCapacity = this.jsiiGet("targetCapacity", java.lang.Number.class);
                this.allocationStrategy = this.jsiiGet("allocationStrategy", java.lang.String.class);
                this.excessCapacityTerminationPolicy = this.jsiiGet("excessCapacityTerminationPolicy", java.lang.String.class);
                this.instanceInterruptionBehavior = this.jsiiGet("instanceInterruptionBehavior", java.lang.String.class);
                this.launchSpecifications = this.jsiiGet("launchSpecifications", java.lang.Object.class);
                this.launchTemplateConfigs = this.jsiiGet("launchTemplateConfigs", java.lang.Object.class);
                this.loadBalancersConfig = this.jsiiGet("loadBalancersConfig", java.lang.Object.class);
                this.replaceUnhealthyInstances = this.jsiiGet("replaceUnhealthyInstances", java.lang.Object.class);
                this.spotPrice = this.jsiiGet("spotPrice", java.lang.String.class);
                this.terminateInstancesWithExpiration = this.jsiiGet("terminateInstancesWithExpiration", java.lang.Object.class);
                this.type = this.jsiiGet("type", java.lang.String.class);
                this.validFrom = this.jsiiGet("validFrom", java.lang.String.class);
                this.validUntil = this.jsiiGet("validUntil", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String iamFleetRole, final java.lang.Number targetCapacity, final java.lang.String allocationStrategy, final java.lang.String excessCapacityTerminationPolicy, final java.lang.String instanceInterruptionBehavior, final java.lang.Object launchSpecifications, final java.lang.Object launchTemplateConfigs, final java.lang.Object loadBalancersConfig, final java.lang.Object replaceUnhealthyInstances, final java.lang.String spotPrice, final java.lang.Object terminateInstancesWithExpiration, final java.lang.String type, final java.lang.String validFrom, final java.lang.String validUntil) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.iamFleetRole = java.util.Objects.requireNonNull(iamFleetRole, "iamFleetRole is required");
                this.targetCapacity = java.util.Objects.requireNonNull(targetCapacity, "targetCapacity is required");
                this.allocationStrategy = allocationStrategy;
                this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
                this.instanceInterruptionBehavior = instanceInterruptionBehavior;
                this.launchSpecifications = launchSpecifications;
                this.launchTemplateConfigs = launchTemplateConfigs;
                this.loadBalancersConfig = loadBalancersConfig;
                this.replaceUnhealthyInstances = replaceUnhealthyInstances;
                this.spotPrice = spotPrice;
                this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
                this.type = type;
                this.validFrom = validFrom;
                this.validUntil = validUntil;
            }

            @Override
            public java.lang.String getIamFleetRole() {
                return this.iamFleetRole;
            }

            @Override
            public java.lang.Number getTargetCapacity() {
                return this.targetCapacity;
            }

            @Override
            public java.lang.String getAllocationStrategy() {
                return this.allocationStrategy;
            }

            @Override
            public java.lang.String getExcessCapacityTerminationPolicy() {
                return this.excessCapacityTerminationPolicy;
            }

            @Override
            public java.lang.String getInstanceInterruptionBehavior() {
                return this.instanceInterruptionBehavior;
            }

            @Override
            public java.lang.Object getLaunchSpecifications() {
                return this.launchSpecifications;
            }

            @Override
            public java.lang.Object getLaunchTemplateConfigs() {
                return this.launchTemplateConfigs;
            }

            @Override
            public java.lang.Object getLoadBalancersConfig() {
                return this.loadBalancersConfig;
            }

            @Override
            public java.lang.Object getReplaceUnhealthyInstances() {
                return this.replaceUnhealthyInstances;
            }

            @Override
            public java.lang.String getSpotPrice() {
                return this.spotPrice;
            }

            @Override
            public java.lang.Object getTerminateInstancesWithExpiration() {
                return this.terminateInstancesWithExpiration;
            }

            @Override
            public java.lang.String getType() {
                return this.type;
            }

            @Override
            public java.lang.String getValidFrom() {
                return this.validFrom;
            }

            @Override
            public java.lang.String getValidUntil() {
                return this.validUntil;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("iamFleetRole", om.valueToTree(this.getIamFleetRole()));
                data.set("targetCapacity", om.valueToTree(this.getTargetCapacity()));
                if (this.getAllocationStrategy() != null) {
                    data.set("allocationStrategy", om.valueToTree(this.getAllocationStrategy()));
                }
                if (this.getExcessCapacityTerminationPolicy() != null) {
                    data.set("excessCapacityTerminationPolicy", om.valueToTree(this.getExcessCapacityTerminationPolicy()));
                }
                if (this.getInstanceInterruptionBehavior() != null) {
                    data.set("instanceInterruptionBehavior", om.valueToTree(this.getInstanceInterruptionBehavior()));
                }
                if (this.getLaunchSpecifications() != null) {
                    data.set("launchSpecifications", om.valueToTree(this.getLaunchSpecifications()));
                }
                if (this.getLaunchTemplateConfigs() != null) {
                    data.set("launchTemplateConfigs", om.valueToTree(this.getLaunchTemplateConfigs()));
                }
                if (this.getLoadBalancersConfig() != null) {
                    data.set("loadBalancersConfig", om.valueToTree(this.getLoadBalancersConfig()));
                }
                if (this.getReplaceUnhealthyInstances() != null) {
                    data.set("replaceUnhealthyInstances", om.valueToTree(this.getReplaceUnhealthyInstances()));
                }
                if (this.getSpotPrice() != null) {
                    data.set("spotPrice", om.valueToTree(this.getSpotPrice()));
                }
                if (this.getTerminateInstancesWithExpiration() != null) {
                    data.set("terminateInstancesWithExpiration", om.valueToTree(this.getTerminateInstancesWithExpiration()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }
                if (this.getValidFrom() != null) {
                    data.set("validFrom", om.valueToTree(this.getValidFrom()));
                }
                if (this.getValidUntil() != null) {
                    data.set("validUntil", om.valueToTree(this.getValidUntil()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.SpotFleetRequestConfigDataProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SpotFleetRequestConfigDataProperty.Jsii$Proxy that = (SpotFleetRequestConfigDataProperty.Jsii$Proxy) o;

                if (!iamFleetRole.equals(that.iamFleetRole)) return false;
                if (!targetCapacity.equals(that.targetCapacity)) return false;
                if (this.allocationStrategy != null ? !this.allocationStrategy.equals(that.allocationStrategy) : that.allocationStrategy != null) return false;
                if (this.excessCapacityTerminationPolicy != null ? !this.excessCapacityTerminationPolicy.equals(that.excessCapacityTerminationPolicy) : that.excessCapacityTerminationPolicy != null) return false;
                if (this.instanceInterruptionBehavior != null ? !this.instanceInterruptionBehavior.equals(that.instanceInterruptionBehavior) : that.instanceInterruptionBehavior != null) return false;
                if (this.launchSpecifications != null ? !this.launchSpecifications.equals(that.launchSpecifications) : that.launchSpecifications != null) return false;
                if (this.launchTemplateConfigs != null ? !this.launchTemplateConfigs.equals(that.launchTemplateConfigs) : that.launchTemplateConfigs != null) return false;
                if (this.loadBalancersConfig != null ? !this.loadBalancersConfig.equals(that.loadBalancersConfig) : that.loadBalancersConfig != null) return false;
                if (this.replaceUnhealthyInstances != null ? !this.replaceUnhealthyInstances.equals(that.replaceUnhealthyInstances) : that.replaceUnhealthyInstances != null) return false;
                if (this.spotPrice != null ? !this.spotPrice.equals(that.spotPrice) : that.spotPrice != null) return false;
                if (this.terminateInstancesWithExpiration != null ? !this.terminateInstancesWithExpiration.equals(that.terminateInstancesWithExpiration) : that.terminateInstancesWithExpiration != null) return false;
                if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
                if (this.validFrom != null ? !this.validFrom.equals(that.validFrom) : that.validFrom != null) return false;
                return this.validUntil != null ? this.validUntil.equals(that.validUntil) : that.validUntil == null;
            }

            @Override
            public int hashCode() {
                int result = this.iamFleetRole.hashCode();
                result = 31 * result + (this.targetCapacity.hashCode());
                result = 31 * result + (this.allocationStrategy != null ? this.allocationStrategy.hashCode() : 0);
                result = 31 * result + (this.excessCapacityTerminationPolicy != null ? this.excessCapacityTerminationPolicy.hashCode() : 0);
                result = 31 * result + (this.instanceInterruptionBehavior != null ? this.instanceInterruptionBehavior.hashCode() : 0);
                result = 31 * result + (this.launchSpecifications != null ? this.launchSpecifications.hashCode() : 0);
                result = 31 * result + (this.launchTemplateConfigs != null ? this.launchTemplateConfigs.hashCode() : 0);
                result = 31 * result + (this.loadBalancersConfig != null ? this.loadBalancersConfig.hashCode() : 0);
                result = 31 * result + (this.replaceUnhealthyInstances != null ? this.replaceUnhealthyInstances.hashCode() : 0);
                result = 31 * result + (this.spotPrice != null ? this.spotPrice.hashCode() : 0);
                result = 31 * result + (this.terminateInstancesWithExpiration != null ? this.terminateInstancesWithExpiration.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                result = 31 * result + (this.validFrom != null ? this.validFrom.hashCode() : 0);
                result = 31 * result + (this.validUntil != null ? this.validUntil.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.SpotFleetTagSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(SpotFleetTagSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpotFleetTagSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSpotFleet.SpotFleetTagSpecificationProperty.ResourceType`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html#cfn-ec2-spotfleet-spotfleettagspecification-resourcetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceType() {
            return null;
        }

        /**
         * `CfnSpotFleet.SpotFleetTagSpecificationProperty.Tags`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html#cfn-ec2-spotfleet-tags
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SpotFleetTagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SpotFleetTagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SpotFleetTagSpecificationProperty> {
            private java.lang.String resourceType;
            private java.util.List<software.amazon.awscdk.core.CfnTag> tags;

            /**
             * Sets the value of {@link SpotFleetTagSpecificationProperty#getResourceType}
             * @param resourceType `CfnSpotFleet.SpotFleetTagSpecificationProperty.ResourceType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceType(java.lang.String resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetTagSpecificationProperty#getTags}
             * @param tags `CfnSpotFleet.SpotFleetTagSpecificationProperty.Tags`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @SuppressWarnings("unchecked")
            public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
                this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotFleetTagSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SpotFleetTagSpecificationProperty build() {
                return new Jsii$Proxy(resourceType, tags);
            }
        }

        /**
         * An implementation for {@link SpotFleetTagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpotFleetTagSpecificationProperty {
            private final java.lang.String resourceType;
            private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceType = this.jsiiGet("resourceType", java.lang.String.class);
                this.tags = this.jsiiGet("tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            private Jsii$Proxy(final java.lang.String resourceType, final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceType = resourceType;
                this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            }

            @Override
            public java.lang.String getResourceType() {
                return this.resourceType;
            }

            @Override
            public java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
                return this.tags;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getResourceType() != null) {
                    data.set("resourceType", om.valueToTree(this.getResourceType()));
                }
                if (this.getTags() != null) {
                    data.set("tags", om.valueToTree(this.getTags()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.SpotFleetTagSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SpotFleetTagSpecificationProperty.Jsii$Proxy that = (SpotFleetTagSpecificationProperty.Jsii$Proxy) o;

                if (this.resourceType != null ? !this.resourceType.equals(that.resourceType) : that.resourceType != null) return false;
                return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
            }

            @Override
            public int hashCode() {
                int result = this.resourceType != null ? this.resourceType.hashCode() : 0;
                result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.SpotPlacementProperty")
    @software.amazon.jsii.Jsii.Proxy(SpotPlacementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpotPlacementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSpotFleet.SpotPlacementProperty.AvailabilityZone`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-availabilityzone
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
            return null;
        }

        /**
         * `CfnSpotFleet.SpotPlacementProperty.GroupName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-groupname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGroupName() {
            return null;
        }

        /**
         * `CfnSpotFleet.SpotPlacementProperty.Tenancy`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-tenancy
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTenancy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SpotPlacementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SpotPlacementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SpotPlacementProperty> {
            private java.lang.String availabilityZone;
            private java.lang.String groupName;
            private java.lang.String tenancy;

            /**
             * Sets the value of {@link SpotPlacementProperty#getAvailabilityZone}
             * @param availabilityZone `CfnSpotFleet.SpotPlacementProperty.AvailabilityZone`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityZone(java.lang.String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link SpotPlacementProperty#getGroupName}
             * @param groupName `CfnSpotFleet.SpotPlacementProperty.GroupName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupName(java.lang.String groupName) {
                this.groupName = groupName;
                return this;
            }

            /**
             * Sets the value of {@link SpotPlacementProperty#getTenancy}
             * @param tenancy `CfnSpotFleet.SpotPlacementProperty.Tenancy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tenancy(java.lang.String tenancy) {
                this.tenancy = tenancy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotPlacementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SpotPlacementProperty build() {
                return new Jsii$Proxy(availabilityZone, groupName, tenancy);
            }
        }

        /**
         * An implementation for {@link SpotPlacementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpotPlacementProperty {
            private final java.lang.String availabilityZone;
            private final java.lang.String groupName;
            private final java.lang.String tenancy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.availabilityZone = this.jsiiGet("availabilityZone", java.lang.String.class);
                this.groupName = this.jsiiGet("groupName", java.lang.String.class);
                this.tenancy = this.jsiiGet("tenancy", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String availabilityZone, final java.lang.String groupName, final java.lang.String tenancy) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.availabilityZone = availabilityZone;
                this.groupName = groupName;
                this.tenancy = tenancy;
            }

            @Override
            public java.lang.String getAvailabilityZone() {
                return this.availabilityZone;
            }

            @Override
            public java.lang.String getGroupName() {
                return this.groupName;
            }

            @Override
            public java.lang.String getTenancy() {
                return this.tenancy;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAvailabilityZone() != null) {
                    data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                }
                if (this.getGroupName() != null) {
                    data.set("groupName", om.valueToTree(this.getGroupName()));
                }
                if (this.getTenancy() != null) {
                    data.set("tenancy", om.valueToTree(this.getTenancy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.SpotPlacementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SpotPlacementProperty.Jsii$Proxy that = (SpotPlacementProperty.Jsii$Proxy) o;

                if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
                if (this.groupName != null ? !this.groupName.equals(that.groupName) : that.groupName != null) return false;
                return this.tenancy != null ? this.tenancy.equals(that.tenancy) : that.tenancy == null;
            }

            @Override
            public int hashCode() {
                int result = this.availabilityZone != null ? this.availabilityZone.hashCode() : 0;
                result = 31 * result + (this.groupName != null ? this.groupName.hashCode() : 0);
                result = 31 * result + (this.tenancy != null ? this.tenancy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroup.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.TargetGroupProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetGroupProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetGroupProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSpotFleet.TargetGroupProperty.Arn`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroup.html#cfn-ec2-spotfleet-targetgroup-arn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getArn();

        /**
         * @return a {@link Builder} of {@link TargetGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetGroupProperty> {
            private java.lang.String arn;

            /**
             * Sets the value of {@link TargetGroupProperty#getArn}
             * @param arn `CfnSpotFleet.TargetGroupProperty.Arn`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetGroupProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetGroupProperty build() {
                return new Jsii$Proxy(arn);
            }
        }

        /**
         * An implementation for {@link TargetGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetGroupProperty {
            private final java.lang.String arn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = this.jsiiGet("arn", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String arn) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = java.util.Objects.requireNonNull(arn, "arn is required");
            }

            @Override
            public java.lang.String getArn() {
                return this.arn;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("arn", om.valueToTree(this.getArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.TargetGroupProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetGroupProperty.Jsii$Proxy that = (TargetGroupProperty.Jsii$Proxy) o;

                return this.arn.equals(that.arn);
            }

            @Override
            public int hashCode() {
                int result = this.arn.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroupsconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.TargetGroupsConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetGroupsConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetGroupsConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSpotFleet.TargetGroupsConfigProperty.TargetGroups`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroupsconfig.html#cfn-ec2-spotfleet-targetgroupsconfig-targetgroups
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTargetGroups();

        /**
         * @return a {@link Builder} of {@link TargetGroupsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetGroupsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetGroupsConfigProperty> {
            private java.lang.Object targetGroups;

            /**
             * Sets the value of {@link TargetGroupsConfigProperty#getTargetGroups}
             * @param targetGroups `CfnSpotFleet.TargetGroupsConfigProperty.TargetGroups`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetGroups(software.amazon.awscdk.core.IResolvable targetGroups) {
                this.targetGroups = targetGroups;
                return this;
            }

            /**
             * Sets the value of {@link TargetGroupsConfigProperty#getTargetGroups}
             * @param targetGroups `CfnSpotFleet.TargetGroupsConfigProperty.TargetGroups`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetGroups(java.util.List<? extends java.lang.Object> targetGroups) {
                this.targetGroups = targetGroups;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetGroupsConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetGroupsConfigProperty build() {
                return new Jsii$Proxy(targetGroups);
            }
        }

        /**
         * An implementation for {@link TargetGroupsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetGroupsConfigProperty {
            private final java.lang.Object targetGroups;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetGroups = this.jsiiGet("targetGroups", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object targetGroups) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetGroups = java.util.Objects.requireNonNull(targetGroups, "targetGroups is required");
            }

            @Override
            public java.lang.Object getTargetGroups() {
                return this.targetGroups;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("targetGroups", om.valueToTree(this.getTargetGroups()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.TargetGroupsConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetGroupsConfigProperty.Jsii$Proxy that = (TargetGroupsConfigProperty.Jsii$Proxy) o;

                return this.targetGroups.equals(that.targetGroups);
            }

            @Override
            public int hashCode() {
                int result = this.targetGroups.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnSpotFleet}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.CfnSpotFleet> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.CfnSpotFleetProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.CfnSpotFleetProps.Builder();
        }

        /**
         * `AWS::EC2::SpotFleet.SpotFleetRequestConfigData`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata
         * @param spotFleetRequestConfigData `AWS::EC2::SpotFleet.SpotFleetRequestConfigData`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotFleetRequestConfigData(final software.amazon.awscdk.core.IResolvable spotFleetRequestConfigData) {
            this.props.spotFleetRequestConfigData(spotFleetRequestConfigData);
            return this;
        }
        /**
         * `AWS::EC2::SpotFleet.SpotFleetRequestConfigData`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata
         * @param spotFleetRequestConfigData `AWS::EC2::SpotFleet.SpotFleetRequestConfigData`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotFleetRequestConfigData(final software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotFleetRequestConfigDataProperty spotFleetRequestConfigData) {
            this.props.spotFleetRequestConfigData(spotFleetRequestConfigData);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnSpotFleet}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.CfnSpotFleet build() {
            return new software.amazon.awscdk.services.ec2.CfnSpotFleet(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
