package software.amazon.awscdk.services.ec2;

/**
 * Select the image based on a given SSM parameter.
 * <p>
 * This Machine Image automatically updates to the latest version on every
 * deployment. Be aware this will cause your instances to be replaced when a
 * new version of the image becomes available. Do not store stateful information
 * on the instance if you are using this image.
 * <p>
 * The AMI ID is selected using the values published to the SSM parameter store.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.13.0 (build 385c325)", date = "2020-10-02T20:11:05.080Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.GenericSSMParameterImage")
public class GenericSSMParameterImage extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.IMachineImage {

    protected GenericSSMParameterImage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected GenericSSMParameterImage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param parameterName This parameter is required.
     * @param os This parameter is required.
     * @param userData
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public GenericSSMParameterImage(final @org.jetbrains.annotations.NotNull java.lang.String parameterName, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.OperatingSystemType os, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.UserData userData) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(parameterName, "parameterName is required"), java.util.Objects.requireNonNull(os, "os is required"), userData });
    }

    /**
     * @param parameterName This parameter is required.
     * @param os This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public GenericSSMParameterImage(final @org.jetbrains.annotations.NotNull java.lang.String parameterName, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.OperatingSystemType os) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(parameterName, "parameterName is required"), java.util.Objects.requireNonNull(os, "os is required") });
    }

    /**
     * Return the image to use in the given context.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.MachineImageConfig getImage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope) {
        return this.jsiiCall("getImage", software.amazon.awscdk.services.ec2.MachineImageConfig.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }
}
