package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::ClientVpnEndpoint`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.13.0 (build 385c325)", date = "2020-10-07T19:57:38.475Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnClientVpnEndpointProps")
@software.amazon.jsii.Jsii.Proxy(CfnClientVpnEndpointProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnClientVpnEndpointProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::EC2::ClientVpnEndpoint.AuthenticationOptions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-authenticationoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getAuthenticationOptions();

    /**
     * `AWS::EC2::ClientVpnEndpoint.ClientCidrBlock`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-clientcidrblock
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClientCidrBlock();

    /**
     * `AWS::EC2::ClientVpnEndpoint.ConnectionLogOptions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-connectionlogoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getConnectionLogOptions();

    /**
     * `AWS::EC2::ClientVpnEndpoint.ServerCertificateArn`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-servercertificatearn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServerCertificateArn();

    /**
     * `AWS::EC2::ClientVpnEndpoint.Description`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.DnsServers`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-dnsservers
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDnsServers() {
        return null;
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.SecurityGroupIds`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-securitygroupids
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
        return null;
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.SplitTunnel`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-splittunnel
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSplitTunnel() {
        return null;
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.TagSpecifications`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-tagspecifications
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTagSpecifications() {
        return null;
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.TransportProtocol`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-transportprotocol
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTransportProtocol() {
        return null;
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.VpcId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-vpcid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVpcId() {
        return null;
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.VpnPort`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-vpnport
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getVpnPort() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnClientVpnEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnClientVpnEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnClientVpnEndpointProps> {
        private java.lang.Object authenticationOptions;
        private java.lang.String clientCidrBlock;
        private java.lang.Object connectionLogOptions;
        private java.lang.String serverCertificateArn;
        private java.lang.String description;
        private java.util.List<java.lang.String> dnsServers;
        private java.util.List<java.lang.String> securityGroupIds;
        private java.lang.Object splitTunnel;
        private java.lang.Object tagSpecifications;
        private java.lang.String transportProtocol;
        private java.lang.String vpcId;
        private java.lang.Number vpnPort;

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getAuthenticationOptions}
         * @param authenticationOptions `AWS::EC2::ClientVpnEndpoint.AuthenticationOptions`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationOptions(software.amazon.awscdk.core.IResolvable authenticationOptions) {
            this.authenticationOptions = authenticationOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getAuthenticationOptions}
         * @param authenticationOptions `AWS::EC2::ClientVpnEndpoint.AuthenticationOptions`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationOptions(java.util.List<? extends java.lang.Object> authenticationOptions) {
            this.authenticationOptions = authenticationOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getClientCidrBlock}
         * @param clientCidrBlock `AWS::EC2::ClientVpnEndpoint.ClientCidrBlock`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientCidrBlock(java.lang.String clientCidrBlock) {
            this.clientCidrBlock = clientCidrBlock;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getConnectionLogOptions}
         * @param connectionLogOptions `AWS::EC2::ClientVpnEndpoint.ConnectionLogOptions`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionLogOptions(software.amazon.awscdk.core.IResolvable connectionLogOptions) {
            this.connectionLogOptions = connectionLogOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getConnectionLogOptions}
         * @param connectionLogOptions `AWS::EC2::ClientVpnEndpoint.ConnectionLogOptions`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionLogOptions(software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint.ConnectionLogOptionsProperty connectionLogOptions) {
            this.connectionLogOptions = connectionLogOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getServerCertificateArn}
         * @param serverCertificateArn `AWS::EC2::ClientVpnEndpoint.ServerCertificateArn`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverCertificateArn(java.lang.String serverCertificateArn) {
            this.serverCertificateArn = serverCertificateArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getDescription}
         * @param description `AWS::EC2::ClientVpnEndpoint.Description`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getDnsServers}
         * @param dnsServers `AWS::EC2::ClientVpnEndpoint.DnsServers`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dnsServers(java.util.List<java.lang.String> dnsServers) {
            this.dnsServers = dnsServers;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getSecurityGroupIds}
         * @param securityGroupIds `AWS::EC2::ClientVpnEndpoint.SecurityGroupIds`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
            this.securityGroupIds = securityGroupIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getSplitTunnel}
         * @param splitTunnel `AWS::EC2::ClientVpnEndpoint.SplitTunnel`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder splitTunnel(java.lang.Boolean splitTunnel) {
            this.splitTunnel = splitTunnel;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getSplitTunnel}
         * @param splitTunnel `AWS::EC2::ClientVpnEndpoint.SplitTunnel`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder splitTunnel(software.amazon.awscdk.core.IResolvable splitTunnel) {
            this.splitTunnel = splitTunnel;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getTagSpecifications}
         * @param tagSpecifications `AWS::EC2::ClientVpnEndpoint.TagSpecifications`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagSpecifications(software.amazon.awscdk.core.IResolvable tagSpecifications) {
            this.tagSpecifications = tagSpecifications;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getTagSpecifications}
         * @param tagSpecifications `AWS::EC2::ClientVpnEndpoint.TagSpecifications`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagSpecifications(java.util.List<? extends java.lang.Object> tagSpecifications) {
            this.tagSpecifications = tagSpecifications;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getTransportProtocol}
         * @param transportProtocol `AWS::EC2::ClientVpnEndpoint.TransportProtocol`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transportProtocol(java.lang.String transportProtocol) {
            this.transportProtocol = transportProtocol;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getVpcId}
         * @param vpcId `AWS::EC2::ClientVpnEndpoint.VpcId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(java.lang.String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getVpnPort}
         * @param vpnPort `AWS::EC2::ClientVpnEndpoint.VpnPort`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpnPort(java.lang.Number vpnPort) {
            this.vpnPort = vpnPort;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnClientVpnEndpointProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnClientVpnEndpointProps build() {
            return new Jsii$Proxy(authenticationOptions, clientCidrBlock, connectionLogOptions, serverCertificateArn, description, dnsServers, securityGroupIds, splitTunnel, tagSpecifications, transportProtocol, vpcId, vpnPort);
        }
    }

    /**
     * An implementation for {@link CfnClientVpnEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnClientVpnEndpointProps {
        private final java.lang.Object authenticationOptions;
        private final java.lang.String clientCidrBlock;
        private final java.lang.Object connectionLogOptions;
        private final java.lang.String serverCertificateArn;
        private final java.lang.String description;
        private final java.util.List<java.lang.String> dnsServers;
        private final java.util.List<java.lang.String> securityGroupIds;
        private final java.lang.Object splitTunnel;
        private final java.lang.Object tagSpecifications;
        private final java.lang.String transportProtocol;
        private final java.lang.String vpcId;
        private final java.lang.Number vpnPort;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authenticationOptions = this.jsiiGet("authenticationOptions", java.lang.Object.class);
            this.clientCidrBlock = this.jsiiGet("clientCidrBlock", java.lang.String.class);
            this.connectionLogOptions = this.jsiiGet("connectionLogOptions", java.lang.Object.class);
            this.serverCertificateArn = this.jsiiGet("serverCertificateArn", java.lang.String.class);
            this.description = this.jsiiGet("description", java.lang.String.class);
            this.dnsServers = this.jsiiGet("dnsServers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.securityGroupIds = this.jsiiGet("securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.splitTunnel = this.jsiiGet("splitTunnel", java.lang.Object.class);
            this.tagSpecifications = this.jsiiGet("tagSpecifications", java.lang.Object.class);
            this.transportProtocol = this.jsiiGet("transportProtocol", java.lang.String.class);
            this.vpcId = this.jsiiGet("vpcId", java.lang.String.class);
            this.vpnPort = this.jsiiGet("vpnPort", java.lang.Number.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Object authenticationOptions, final java.lang.String clientCidrBlock, final java.lang.Object connectionLogOptions, final java.lang.String serverCertificateArn, final java.lang.String description, final java.util.List<java.lang.String> dnsServers, final java.util.List<java.lang.String> securityGroupIds, final java.lang.Object splitTunnel, final java.lang.Object tagSpecifications, final java.lang.String transportProtocol, final java.lang.String vpcId, final java.lang.Number vpnPort) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authenticationOptions = java.util.Objects.requireNonNull(authenticationOptions, "authenticationOptions is required");
            this.clientCidrBlock = java.util.Objects.requireNonNull(clientCidrBlock, "clientCidrBlock is required");
            this.connectionLogOptions = java.util.Objects.requireNonNull(connectionLogOptions, "connectionLogOptions is required");
            this.serverCertificateArn = java.util.Objects.requireNonNull(serverCertificateArn, "serverCertificateArn is required");
            this.description = description;
            this.dnsServers = dnsServers;
            this.securityGroupIds = securityGroupIds;
            this.splitTunnel = splitTunnel;
            this.tagSpecifications = tagSpecifications;
            this.transportProtocol = transportProtocol;
            this.vpcId = vpcId;
            this.vpnPort = vpnPort;
        }

        @Override
        public java.lang.Object getAuthenticationOptions() {
            return this.authenticationOptions;
        }

        @Override
        public java.lang.String getClientCidrBlock() {
            return this.clientCidrBlock;
        }

        @Override
        public java.lang.Object getConnectionLogOptions() {
            return this.connectionLogOptions;
        }

        @Override
        public java.lang.String getServerCertificateArn() {
            return this.serverCertificateArn;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public java.util.List<java.lang.String> getDnsServers() {
            return this.dnsServers;
        }

        @Override
        public java.util.List<java.lang.String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public java.lang.Object getSplitTunnel() {
            return this.splitTunnel;
        }

        @Override
        public java.lang.Object getTagSpecifications() {
            return this.tagSpecifications;
        }

        @Override
        public java.lang.String getTransportProtocol() {
            return this.transportProtocol;
        }

        @Override
        public java.lang.String getVpcId() {
            return this.vpcId;
        }

        @Override
        public java.lang.Number getVpnPort() {
            return this.vpnPort;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("authenticationOptions", om.valueToTree(this.getAuthenticationOptions()));
            data.set("clientCidrBlock", om.valueToTree(this.getClientCidrBlock()));
            data.set("connectionLogOptions", om.valueToTree(this.getConnectionLogOptions()));
            data.set("serverCertificateArn", om.valueToTree(this.getServerCertificateArn()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDnsServers() != null) {
                data.set("dnsServers", om.valueToTree(this.getDnsServers()));
            }
            if (this.getSecurityGroupIds() != null) {
                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
            }
            if (this.getSplitTunnel() != null) {
                data.set("splitTunnel", om.valueToTree(this.getSplitTunnel()));
            }
            if (this.getTagSpecifications() != null) {
                data.set("tagSpecifications", om.valueToTree(this.getTagSpecifications()));
            }
            if (this.getTransportProtocol() != null) {
                data.set("transportProtocol", om.valueToTree(this.getTransportProtocol()));
            }
            if (this.getVpcId() != null) {
                data.set("vpcId", om.valueToTree(this.getVpcId()));
            }
            if (this.getVpnPort() != null) {
                data.set("vpnPort", om.valueToTree(this.getVpnPort()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnClientVpnEndpointProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnClientVpnEndpointProps.Jsii$Proxy that = (CfnClientVpnEndpointProps.Jsii$Proxy) o;

            if (!authenticationOptions.equals(that.authenticationOptions)) return false;
            if (!clientCidrBlock.equals(that.clientCidrBlock)) return false;
            if (!connectionLogOptions.equals(that.connectionLogOptions)) return false;
            if (!serverCertificateArn.equals(that.serverCertificateArn)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.dnsServers != null ? !this.dnsServers.equals(that.dnsServers) : that.dnsServers != null) return false;
            if (this.securityGroupIds != null ? !this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds != null) return false;
            if (this.splitTunnel != null ? !this.splitTunnel.equals(that.splitTunnel) : that.splitTunnel != null) return false;
            if (this.tagSpecifications != null ? !this.tagSpecifications.equals(that.tagSpecifications) : that.tagSpecifications != null) return false;
            if (this.transportProtocol != null ? !this.transportProtocol.equals(that.transportProtocol) : that.transportProtocol != null) return false;
            if (this.vpcId != null ? !this.vpcId.equals(that.vpcId) : that.vpcId != null) return false;
            return this.vpnPort != null ? this.vpnPort.equals(that.vpnPort) : that.vpnPort == null;
        }

        @Override
        public int hashCode() {
            int result = this.authenticationOptions.hashCode();
            result = 31 * result + (this.clientCidrBlock.hashCode());
            result = 31 * result + (this.connectionLogOptions.hashCode());
            result = 31 * result + (this.serverCertificateArn.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.dnsServers != null ? this.dnsServers.hashCode() : 0);
            result = 31 * result + (this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0);
            result = 31 * result + (this.splitTunnel != null ? this.splitTunnel.hashCode() : 0);
            result = 31 * result + (this.tagSpecifications != null ? this.tagSpecifications.hashCode() : 0);
            result = 31 * result + (this.transportProtocol != null ? this.transportProtocol.hashCode() : 0);
            result = 31 * result + (this.vpcId != null ? this.vpcId.hashCode() : 0);
            result = 31 * result + (this.vpnPort != null ? this.vpnPort.hashCode() : 0);
            return result;
        }
    }
}
