package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::VPNConnection`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.13.0 (build 385c325)", date = "2020-10-19T20:38:22.485Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnVPNConnectionProps")
@software.amazon.jsii.Jsii.Proxy(CfnVPNConnectionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnVPNConnectionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::EC2::VPNConnection.CustomerGatewayId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-customergatewayid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCustomerGatewayId();

    /**
     * `AWS::EC2::VPNConnection.Type`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-type
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * `AWS::EC2::VPNConnection.StaticRoutesOnly`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-StaticRoutesOnly
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStaticRoutesOnly() {
        return null;
    }

    /**
     * `AWS::EC2::VPNConnection.Tags`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * `AWS::EC2::VPNConnection.TransitGatewayId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-transitgatewayid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTransitGatewayId() {
        return null;
    }

    /**
     * `AWS::EC2::VPNConnection.VpnGatewayId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-vpngatewayid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVpnGatewayId() {
        return null;
    }

    /**
     * `AWS::EC2::VPNConnection.VpnTunnelOptionsSpecifications`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-vpntunneloptionsspecifications
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVpnTunnelOptionsSpecifications() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnVPNConnectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVPNConnectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnVPNConnectionProps> {
        private java.lang.String customerGatewayId;
        private java.lang.String type;
        private java.lang.Object staticRoutesOnly;
        private java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private java.lang.String transitGatewayId;
        private java.lang.String vpnGatewayId;
        private java.lang.Object vpnTunnelOptionsSpecifications;

        /**
         * Sets the value of {@link CfnVPNConnectionProps#getCustomerGatewayId}
         * @param customerGatewayId `AWS::EC2::VPNConnection.CustomerGatewayId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customerGatewayId(java.lang.String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPNConnectionProps#getType}
         * @param type `AWS::EC2::VPNConnection.Type`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPNConnectionProps#getStaticRoutesOnly}
         * @param staticRoutesOnly `AWS::EC2::VPNConnection.StaticRoutesOnly`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder staticRoutesOnly(java.lang.Boolean staticRoutesOnly) {
            this.staticRoutesOnly = staticRoutesOnly;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPNConnectionProps#getStaticRoutesOnly}
         * @param staticRoutesOnly `AWS::EC2::VPNConnection.StaticRoutesOnly`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder staticRoutesOnly(software.amazon.awscdk.core.IResolvable staticRoutesOnly) {
            this.staticRoutesOnly = staticRoutesOnly;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPNConnectionProps#getTags}
         * @param tags `AWS::EC2::VPNConnection.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPNConnectionProps#getTransitGatewayId}
         * @param transitGatewayId `AWS::EC2::VPNConnection.TransitGatewayId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitGatewayId(java.lang.String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPNConnectionProps#getVpnGatewayId}
         * @param vpnGatewayId `AWS::EC2::VPNConnection.VpnGatewayId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpnGatewayId(java.lang.String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPNConnectionProps#getVpnTunnelOptionsSpecifications}
         * @param vpnTunnelOptionsSpecifications `AWS::EC2::VPNConnection.VpnTunnelOptionsSpecifications`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpnTunnelOptionsSpecifications(software.amazon.awscdk.core.IResolvable vpnTunnelOptionsSpecifications) {
            this.vpnTunnelOptionsSpecifications = vpnTunnelOptionsSpecifications;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPNConnectionProps#getVpnTunnelOptionsSpecifications}
         * @param vpnTunnelOptionsSpecifications `AWS::EC2::VPNConnection.VpnTunnelOptionsSpecifications`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpnTunnelOptionsSpecifications(java.util.List<? extends java.lang.Object> vpnTunnelOptionsSpecifications) {
            this.vpnTunnelOptionsSpecifications = vpnTunnelOptionsSpecifications;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVPNConnectionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnVPNConnectionProps build() {
            return new Jsii$Proxy(customerGatewayId, type, staticRoutesOnly, tags, transitGatewayId, vpnGatewayId, vpnTunnelOptionsSpecifications);
        }
    }

    /**
     * An implementation for {@link CfnVPNConnectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVPNConnectionProps {
        private final java.lang.String customerGatewayId;
        private final java.lang.String type;
        private final java.lang.Object staticRoutesOnly;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private final java.lang.String transitGatewayId;
        private final java.lang.String vpnGatewayId;
        private final java.lang.Object vpnTunnelOptionsSpecifications;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.customerGatewayId = this.jsiiGet("customerGatewayId", java.lang.String.class);
            this.type = this.jsiiGet("type", java.lang.String.class);
            this.staticRoutesOnly = this.jsiiGet("staticRoutesOnly", java.lang.Object.class);
            this.tags = this.jsiiGet("tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            this.transitGatewayId = this.jsiiGet("transitGatewayId", java.lang.String.class);
            this.vpnGatewayId = this.jsiiGet("vpnGatewayId", java.lang.String.class);
            this.vpnTunnelOptionsSpecifications = this.jsiiGet("vpnTunnelOptionsSpecifications", java.lang.Object.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        private Jsii$Proxy(final java.lang.String customerGatewayId, final java.lang.String type, final java.lang.Object staticRoutesOnly, final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags, final java.lang.String transitGatewayId, final java.lang.String vpnGatewayId, final java.lang.Object vpnTunnelOptionsSpecifications) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.customerGatewayId = java.util.Objects.requireNonNull(customerGatewayId, "customerGatewayId is required");
            this.type = java.util.Objects.requireNonNull(type, "type is required");
            this.staticRoutesOnly = staticRoutesOnly;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            this.transitGatewayId = transitGatewayId;
            this.vpnGatewayId = vpnGatewayId;
            this.vpnTunnelOptionsSpecifications = vpnTunnelOptionsSpecifications;
        }

        @Override
        public java.lang.String getCustomerGatewayId() {
            return this.customerGatewayId;
        }

        @Override
        public java.lang.String getType() {
            return this.type;
        }

        @Override
        public java.lang.Object getStaticRoutesOnly() {
            return this.staticRoutesOnly;
        }

        @Override
        public java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public java.lang.String getTransitGatewayId() {
            return this.transitGatewayId;
        }

        @Override
        public java.lang.String getVpnGatewayId() {
            return this.vpnGatewayId;
        }

        @Override
        public java.lang.Object getVpnTunnelOptionsSpecifications() {
            return this.vpnTunnelOptionsSpecifications;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("customerGatewayId", om.valueToTree(this.getCustomerGatewayId()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getStaticRoutesOnly() != null) {
                data.set("staticRoutesOnly", om.valueToTree(this.getStaticRoutesOnly()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTransitGatewayId() != null) {
                data.set("transitGatewayId", om.valueToTree(this.getTransitGatewayId()));
            }
            if (this.getVpnGatewayId() != null) {
                data.set("vpnGatewayId", om.valueToTree(this.getVpnGatewayId()));
            }
            if (this.getVpnTunnelOptionsSpecifications() != null) {
                data.set("vpnTunnelOptionsSpecifications", om.valueToTree(this.getVpnTunnelOptionsSpecifications()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnVPNConnectionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVPNConnectionProps.Jsii$Proxy that = (CfnVPNConnectionProps.Jsii$Proxy) o;

            if (!customerGatewayId.equals(that.customerGatewayId)) return false;
            if (!type.equals(that.type)) return false;
            if (this.staticRoutesOnly != null ? !this.staticRoutesOnly.equals(that.staticRoutesOnly) : that.staticRoutesOnly != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.transitGatewayId != null ? !this.transitGatewayId.equals(that.transitGatewayId) : that.transitGatewayId != null) return false;
            if (this.vpnGatewayId != null ? !this.vpnGatewayId.equals(that.vpnGatewayId) : that.vpnGatewayId != null) return false;
            return this.vpnTunnelOptionsSpecifications != null ? this.vpnTunnelOptionsSpecifications.equals(that.vpnTunnelOptionsSpecifications) : that.vpnTunnelOptionsSpecifications == null;
        }

        @Override
        public int hashCode() {
            int result = this.customerGatewayId.hashCode();
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.staticRoutesOnly != null ? this.staticRoutesOnly.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.transitGatewayId != null ? this.transitGatewayId.hashCode() : 0);
            result = 31 * result + (this.vpnGatewayId != null ? this.vpnGatewayId.hashCode() : 0);
            result = 31 * result + (this.vpnTunnelOptionsSpecifications != null ? this.vpnTunnelOptionsSpecifications.hashCode() : 0);
            return result;
        }
    }
}
