/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.ec2.;
import software.amazon.awscdk.services.ec2.ApplyCloudFormationInitOptions;
import software.amazon.awscdk.services.ec2.BlockDevice;
import software.amazon.awscdk.services.ec2.CloudFormationInit;
import software.amazon.awscdk.services.ec2.IMachineImage;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.InstanceProps;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.ec2.UserData;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.InstanceProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface InstanceProps
extends JsiiSerializable {
    @NotNull
    public InstanceType getInstanceType();

    @NotNull
    public IMachineImage getMachineImage();

    @NotNull
    public IVpc getVpc();

    @Nullable
    default public Boolean getAllowAllOutbound() {
        return null;
    }

    @Nullable
    default public String getAvailabilityZone() {
        return null;
    }

    @Nullable
    default public List<BlockDevice> getBlockDevices() {
        return null;
    }

    @Nullable
    default public CloudFormationInit getInit() {
        return null;
    }

    @Nullable
    default public ApplyCloudFormationInitOptions getInitOptions() {
        return null;
    }

    @Nullable
    default public String getInstanceName() {
        return null;
    }

    @Nullable
    default public String getKeyName() {
        return null;
    }

    @Nullable
    default public String getPrivateIpAddress() {
        return null;
    }

    @Nullable
    default public Duration getResourceSignalTimeout() {
        return null;
    }

    @Nullable
    default public IRole getRole() {
        return null;
    }

    @Nullable
    default public ISecurityGroup getSecurityGroup() {
        return null;
    }

    @Nullable
    default public Boolean getSourceDestCheck() {
        return null;
    }

    @Nullable
    default public UserData getUserData() {
        return null;
    }

    @Nullable
    default public Boolean getUserDataCausesReplacement() {
        return null;
    }

    @Nullable
    default public SubnetSelection getVpcSubnets() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<InstanceProps> {
        private InstanceType instanceType;
        private IMachineImage machineImage;
        private IVpc vpc;
        private Boolean allowAllOutbound;
        private String availabilityZone;
        private List<BlockDevice> blockDevices;
        private CloudFormationInit init;
        private ApplyCloudFormationInitOptions initOptions;
        private String instanceName;
        private String keyName;
        private String privateIpAddress;
        private Duration resourceSignalTimeout;
        private IRole role;
        private ISecurityGroup securityGroup;
        private Boolean sourceDestCheck;
        private UserData userData;
        private Boolean userDataCausesReplacement;
        private SubnetSelection vpcSubnets;

        public Builder instanceType(InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public Builder machineImage(IMachineImage machineImage) {
            this.machineImage = machineImage;
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public Builder allowAllOutbound(Boolean allowAllOutbound) {
            this.allowAllOutbound = allowAllOutbound;
            return this;
        }

        public Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public Builder blockDevices(List<? extends BlockDevice> blockDevices) {
            this.blockDevices = blockDevices;
            return this;
        }

        public Builder init(CloudFormationInit init) {
            this.init = init;
            return this;
        }

        public Builder initOptions(ApplyCloudFormationInitOptions initOptions) {
            this.initOptions = initOptions;
            return this;
        }

        public Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public Builder resourceSignalTimeout(Duration resourceSignalTimeout) {
            this.resourceSignalTimeout = resourceSignalTimeout;
            return this;
        }

        public Builder role(IRole role) {
            this.role = role;
            return this;
        }

        public Builder securityGroup(ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        public Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public Builder userData(UserData userData) {
            this.userData = userData;
            return this;
        }

        public Builder userDataCausesReplacement(Boolean userDataCausesReplacement) {
            this.userDataCausesReplacement = userDataCausesReplacement;
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        public InstanceProps build() {
            return new Jsii.Proxy(this.instanceType, this.machineImage, this.vpc, this.allowAllOutbound, this.availabilityZone, this.blockDevices, this.init, this.initOptions, this.instanceName, this.keyName, this.privateIpAddress, this.resourceSignalTimeout, this.role, this.securityGroup, this.sourceDestCheck, this.userData, this.userDataCausesReplacement, this.vpcSubnets, null);
        }
    }
}

