package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::DHCPOptions`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.16.0 (build 98909b5)", date = "2019-09-06T01:04:14.391Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnDHCPOptionsProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::EC2::DHCPOptions.DomainName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-domainname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getDomainName();

    /**
     * `AWS::EC2::DHCPOptions.DomainNameServers`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-domainnameservers
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.util.List<java.lang.String> getDomainNameServers();

    /**
     * `AWS::EC2::DHCPOptions.NetbiosNameServers`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-netbiosnameservers
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.util.List<java.lang.String> getNetbiosNameServers();

    /**
     * `AWS::EC2::DHCPOptions.NetbiosNodeType`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-netbiosnodetype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Number getNetbiosNodeType();

    /**
     * `AWS::EC2::DHCPOptions.NtpServers`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-ntpservers
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.util.List<java.lang.String> getNtpServers();

    /**
     * `AWS::EC2::DHCPOptions.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.util.List<software.amazon.awscdk.core.CfnTag> getTags();

    /**
     * @return a {@link Builder} of {@link CfnDHCPOptionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnDHCPOptionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Builder {
        private java.lang.String domainName;
        private java.util.List<java.lang.String> domainNameServers;
        private java.util.List<java.lang.String> netbiosNameServers;
        private java.lang.Number netbiosNodeType;
        private java.util.List<java.lang.String> ntpServers;
        private java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of DomainName
         * @param domainName `AWS::EC2::DHCPOptions.DomainName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of DomainNameServers
         * @param domainNameServers `AWS::EC2::DHCPOptions.DomainNameServers`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder domainNameServers(java.util.List<java.lang.String> domainNameServers) {
            this.domainNameServers = domainNameServers;
            return this;
        }

        /**
         * Sets the value of NetbiosNameServers
         * @param netbiosNameServers `AWS::EC2::DHCPOptions.NetbiosNameServers`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder netbiosNameServers(java.util.List<java.lang.String> netbiosNameServers) {
            this.netbiosNameServers = netbiosNameServers;
            return this;
        }

        /**
         * Sets the value of NetbiosNodeType
         * @param netbiosNodeType `AWS::EC2::DHCPOptions.NetbiosNodeType`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder netbiosNodeType(java.lang.Number netbiosNodeType) {
            this.netbiosNodeType = netbiosNodeType;
            return this;
        }

        /**
         * Sets the value of NtpServers
         * @param ntpServers `AWS::EC2::DHCPOptions.NtpServers`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder ntpServers(java.util.List<java.lang.String> ntpServers) {
            this.ntpServers = ntpServers;
            return this;
        }

        /**
         * Sets the value of Tags
         * @param tags `AWS::EC2::DHCPOptions.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tags(java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDHCPOptionsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnDHCPOptionsProps build() {
            return new Jsii$Proxy(domainName, domainNameServers, netbiosNameServers, netbiosNodeType, ntpServers, tags);
        }

    }

    /**
     * An implementation for {@link CfnDHCPOptionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDHCPOptionsProps {
        private final java.lang.String domainName;
        private final java.util.List<java.lang.String> domainNameServers;
        private final java.util.List<java.lang.String> netbiosNameServers;
        private final java.lang.Number netbiosNodeType;
        private final java.util.List<java.lang.String> ntpServers;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.domainName = this.jsiiGet("domainName", java.lang.String.class);
            this.domainNameServers = this.jsiiGet("domainNameServers", java.util.List.class);
            this.netbiosNameServers = this.jsiiGet("netbiosNameServers", java.util.List.class);
            this.netbiosNodeType = this.jsiiGet("netbiosNodeType", java.lang.Number.class);
            this.ntpServers = this.jsiiGet("ntpServers", java.util.List.class);
            this.tags = this.jsiiGet("tags", java.util.List.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String domainName, java.util.List<java.lang.String> domainNameServers, java.util.List<java.lang.String> netbiosNameServers, java.lang.Number netbiosNodeType, java.util.List<java.lang.String> ntpServers, java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainName = domainName;
            this.domainNameServers = domainNameServers;
            this.netbiosNameServers = netbiosNameServers;
            this.netbiosNodeType = netbiosNodeType;
            this.ntpServers = ntpServers;
            this.tags = tags;
        }

        @Override
        public java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public java.util.List<java.lang.String> getDomainNameServers() {
            return this.domainNameServers;
        }

        @Override
        public java.util.List<java.lang.String> getNetbiosNameServers() {
            return this.netbiosNameServers;
        }

        @Override
        public java.lang.Number getNetbiosNodeType() {
            return this.netbiosNodeType;
        }

        @Override
        public java.util.List<java.lang.String> getNtpServers() {
            return this.ntpServers;
        }

        @Override
        public java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            if (this.getDomainName() != null) {
                obj.set("domainName", om.valueToTree(this.getDomainName()));
            }
            if (this.getDomainNameServers() != null) {
                obj.set("domainNameServers", om.valueToTree(this.getDomainNameServers()));
            }
            if (this.getNetbiosNameServers() != null) {
                obj.set("netbiosNameServers", om.valueToTree(this.getNetbiosNameServers()));
            }
            if (this.getNetbiosNodeType() != null) {
                obj.set("netbiosNodeType", om.valueToTree(this.getNetbiosNodeType()));
            }
            if (this.getNtpServers() != null) {
                obj.set("ntpServers", om.valueToTree(this.getNtpServers()));
            }
            if (this.getTags() != null) {
                obj.set("tags", om.valueToTree(this.getTags()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDHCPOptionsProps.Jsii$Proxy that = (CfnDHCPOptionsProps.Jsii$Proxy) o;

            if (this.domainName != null ? !this.domainName.equals(that.domainName) : that.domainName != null) return false;
            if (this.domainNameServers != null ? !this.domainNameServers.equals(that.domainNameServers) : that.domainNameServers != null) return false;
            if (this.netbiosNameServers != null ? !this.netbiosNameServers.equals(that.netbiosNameServers) : that.netbiosNameServers != null) return false;
            if (this.netbiosNodeType != null ? !this.netbiosNodeType.equals(that.netbiosNodeType) : that.netbiosNodeType != null) return false;
            if (this.ntpServers != null ? !this.ntpServers.equals(that.ntpServers) : that.ntpServers != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public int hashCode() {
            int result = this.domainName != null ? this.domainName.hashCode() : 0;
            result = 31 * result + (this.domainNameServers != null ? this.domainNameServers.hashCode() : 0);
            result = 31 * result + (this.netbiosNameServers != null ? this.netbiosNameServers.hashCode() : 0);
            result = 31 * result + (this.netbiosNodeType != null ? this.netbiosNodeType.hashCode() : 0);
            result = 31 * result + (this.ntpServers != null ? this.ntpServers.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }

    }
}
