package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::Instance`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.16.0 (build 98909b5)", date = "2019-09-06T01:04:14.409Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnInstanceProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::EC2::Instance.AdditionalInfo`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-additionalinfo
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getAdditionalInfo();

    /**
     * `AWS::EC2::Instance.Affinity`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-affinity
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getAffinity();

    /**
     * `AWS::EC2::Instance.AvailabilityZone`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-availabilityzone
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getAvailabilityZone();

    /**
     * `AWS::EC2::Instance.BlockDeviceMappings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-blockdevicemappings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getBlockDeviceMappings();

    /**
     * `AWS::EC2::Instance.CpuOptions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-cpuoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getCpuOptions();

    /**
     * `AWS::EC2::Instance.CreditSpecification`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-creditspecification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getCreditSpecification();

    /**
     * `AWS::EC2::Instance.DisableApiTermination`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-disableapitermination
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getDisableApiTermination();

    /**
     * `AWS::EC2::Instance.EbsOptimized`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ebsoptimized
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getEbsOptimized();

    /**
     * `AWS::EC2::Instance.ElasticGpuSpecifications`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-elasticgpuspecifications
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getElasticGpuSpecifications();

    /**
     * `AWS::EC2::Instance.ElasticInferenceAccelerators`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-elasticinferenceaccelerators
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getElasticInferenceAccelerators();

    /**
     * `AWS::EC2::Instance.HostId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-hostid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getHostId();

    /**
     * `AWS::EC2::Instance.IamInstanceProfile`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-iaminstanceprofile
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getIamInstanceProfile();

    /**
     * `AWS::EC2::Instance.ImageId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-imageid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getImageId();

    /**
     * `AWS::EC2::Instance.InstanceInitiatedShutdownBehavior`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-instanceinitiatedshutdownbehavior
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getInstanceInitiatedShutdownBehavior();

    /**
     * `AWS::EC2::Instance.InstanceType`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-instancetype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getInstanceType();

    /**
     * `AWS::EC2::Instance.Ipv6AddressCount`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ipv6addresscount
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Number getIpv6AddressCount();

    /**
     * `AWS::EC2::Instance.Ipv6Addresses`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ipv6addresses
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getIpv6Addresses();

    /**
     * `AWS::EC2::Instance.KernelId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-kernelid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getKernelId();

    /**
     * `AWS::EC2::Instance.KeyName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-keyname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getKeyName();

    /**
     * `AWS::EC2::Instance.LaunchTemplate`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-launchtemplate
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getLaunchTemplate();

    /**
     * `AWS::EC2::Instance.LicenseSpecifications`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-licensespecifications
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getLicenseSpecifications();

    /**
     * `AWS::EC2::Instance.Monitoring`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-monitoring
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getMonitoring();

    /**
     * `AWS::EC2::Instance.NetworkInterfaces`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-networkinterfaces
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getNetworkInterfaces();

    /**
     * `AWS::EC2::Instance.PlacementGroupName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-placementgroupname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getPlacementGroupName();

    /**
     * `AWS::EC2::Instance.PrivateIpAddress`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-privateipaddress
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getPrivateIpAddress();

    /**
     * `AWS::EC2::Instance.RamdiskId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ramdiskid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getRamdiskId();

    /**
     * `AWS::EC2::Instance.SecurityGroupIds`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-securitygroupids
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.util.List<java.lang.String> getSecurityGroupIds();

    /**
     * `AWS::EC2::Instance.SecurityGroups`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-securitygroups
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.util.List<java.lang.String> getSecurityGroups();

    /**
     * `AWS::EC2::Instance.SourceDestCheck`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-sourcedestcheck
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getSourceDestCheck();

    /**
     * `AWS::EC2::Instance.SsmAssociations`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ssmassociations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getSsmAssociations();

    /**
     * `AWS::EC2::Instance.SubnetId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-subnetid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getSubnetId();

    /**
     * `AWS::EC2::Instance.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.util.List<software.amazon.awscdk.core.CfnTag> getTags();

    /**
     * `AWS::EC2::Instance.Tenancy`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-tenancy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getTenancy();

    /**
     * `AWS::EC2::Instance.UserData`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-userdata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getUserData();

    /**
     * `AWS::EC2::Instance.Volumes`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-volumes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getVolumes();

    /**
     * @return a {@link Builder} of {@link CfnInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Builder {
        private java.lang.String additionalInfo;
        private java.lang.String affinity;
        private java.lang.String availabilityZone;
        private java.lang.Object blockDeviceMappings;
        private java.lang.Object cpuOptions;
        private java.lang.Object creditSpecification;
        private java.lang.Object disableApiTermination;
        private java.lang.Object ebsOptimized;
        private java.lang.Object elasticGpuSpecifications;
        private java.lang.Object elasticInferenceAccelerators;
        private java.lang.String hostId;
        private java.lang.String iamInstanceProfile;
        private java.lang.String imageId;
        private java.lang.String instanceInitiatedShutdownBehavior;
        private java.lang.String instanceType;
        private java.lang.Number ipv6AddressCount;
        private java.lang.Object ipv6Addresses;
        private java.lang.String kernelId;
        private java.lang.String keyName;
        private java.lang.Object launchTemplate;
        private java.lang.Object licenseSpecifications;
        private java.lang.Object monitoring;
        private java.lang.Object networkInterfaces;
        private java.lang.String placementGroupName;
        private java.lang.String privateIpAddress;
        private java.lang.String ramdiskId;
        private java.util.List<java.lang.String> securityGroupIds;
        private java.util.List<java.lang.String> securityGroups;
        private java.lang.Object sourceDestCheck;
        private java.lang.Object ssmAssociations;
        private java.lang.String subnetId;
        private java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private java.lang.String tenancy;
        private java.lang.String userData;
        private java.lang.Object volumes;

        /**
         * Sets the value of AdditionalInfo
         * @param additionalInfo `AWS::EC2::Instance.AdditionalInfo`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder additionalInfo(java.lang.String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        /**
         * Sets the value of Affinity
         * @param affinity `AWS::EC2::Instance.Affinity`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder affinity(java.lang.String affinity) {
            this.affinity = affinity;
            return this;
        }

        /**
         * Sets the value of AvailabilityZone
         * @param availabilityZone `AWS::EC2::Instance.AvailabilityZone`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder availabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * Sets the value of BlockDeviceMappings
         * @param blockDeviceMappings `AWS::EC2::Instance.BlockDeviceMappings`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder blockDeviceMappings(software.amazon.awscdk.core.IResolvable blockDeviceMappings) {
            this.blockDeviceMappings = blockDeviceMappings;
            return this;
        }

        /**
         * Sets the value of BlockDeviceMappings
         * @param blockDeviceMappings `AWS::EC2::Instance.BlockDeviceMappings`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder blockDeviceMappings(java.util.List<java.lang.Object> blockDeviceMappings) {
            this.blockDeviceMappings = blockDeviceMappings;
            return this;
        }

        /**
         * Sets the value of CpuOptions
         * @param cpuOptions `AWS::EC2::Instance.CpuOptions`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder cpuOptions(software.amazon.awscdk.core.IResolvable cpuOptions) {
            this.cpuOptions = cpuOptions;
            return this;
        }

        /**
         * Sets the value of CpuOptions
         * @param cpuOptions `AWS::EC2::Instance.CpuOptions`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder cpuOptions(software.amazon.awscdk.services.ec2.CfnInstance.CpuOptionsProperty cpuOptions) {
            this.cpuOptions = cpuOptions;
            return this;
        }

        /**
         * Sets the value of CreditSpecification
         * @param creditSpecification `AWS::EC2::Instance.CreditSpecification`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder creditSpecification(software.amazon.awscdk.core.IResolvable creditSpecification) {
            this.creditSpecification = creditSpecification;
            return this;
        }

        /**
         * Sets the value of CreditSpecification
         * @param creditSpecification `AWS::EC2::Instance.CreditSpecification`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder creditSpecification(software.amazon.awscdk.services.ec2.CfnInstance.CreditSpecificationProperty creditSpecification) {
            this.creditSpecification = creditSpecification;
            return this;
        }

        /**
         * Sets the value of DisableApiTermination
         * @param disableApiTermination `AWS::EC2::Instance.DisableApiTermination`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder disableApiTermination(java.lang.Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
            return this;
        }

        /**
         * Sets the value of DisableApiTermination
         * @param disableApiTermination `AWS::EC2::Instance.DisableApiTermination`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder disableApiTermination(software.amazon.awscdk.core.IResolvable disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
            return this;
        }

        /**
         * Sets the value of EbsOptimized
         * @param ebsOptimized `AWS::EC2::Instance.EbsOptimized`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder ebsOptimized(java.lang.Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        /**
         * Sets the value of EbsOptimized
         * @param ebsOptimized `AWS::EC2::Instance.EbsOptimized`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder ebsOptimized(software.amazon.awscdk.core.IResolvable ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        /**
         * Sets the value of ElasticGpuSpecifications
         * @param elasticGpuSpecifications `AWS::EC2::Instance.ElasticGpuSpecifications`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder elasticGpuSpecifications(software.amazon.awscdk.core.IResolvable elasticGpuSpecifications) {
            this.elasticGpuSpecifications = elasticGpuSpecifications;
            return this;
        }

        /**
         * Sets the value of ElasticGpuSpecifications
         * @param elasticGpuSpecifications `AWS::EC2::Instance.ElasticGpuSpecifications`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder elasticGpuSpecifications(java.util.List<java.lang.Object> elasticGpuSpecifications) {
            this.elasticGpuSpecifications = elasticGpuSpecifications;
            return this;
        }

        /**
         * Sets the value of ElasticInferenceAccelerators
         * @param elasticInferenceAccelerators `AWS::EC2::Instance.ElasticInferenceAccelerators`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder elasticInferenceAccelerators(software.amazon.awscdk.core.IResolvable elasticInferenceAccelerators) {
            this.elasticInferenceAccelerators = elasticInferenceAccelerators;
            return this;
        }

        /**
         * Sets the value of ElasticInferenceAccelerators
         * @param elasticInferenceAccelerators `AWS::EC2::Instance.ElasticInferenceAccelerators`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder elasticInferenceAccelerators(java.util.List<java.lang.Object> elasticInferenceAccelerators) {
            this.elasticInferenceAccelerators = elasticInferenceAccelerators;
            return this;
        }

        /**
         * Sets the value of HostId
         * @param hostId `AWS::EC2::Instance.HostId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder hostId(java.lang.String hostId) {
            this.hostId = hostId;
            return this;
        }

        /**
         * Sets the value of IamInstanceProfile
         * @param iamInstanceProfile `AWS::EC2::Instance.IamInstanceProfile`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder iamInstanceProfile(java.lang.String iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        /**
         * Sets the value of ImageId
         * @param imageId `AWS::EC2::Instance.ImageId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder imageId(java.lang.String imageId) {
            this.imageId = imageId;
            return this;
        }

        /**
         * Sets the value of InstanceInitiatedShutdownBehavior
         * @param instanceInitiatedShutdownBehavior `AWS::EC2::Instance.InstanceInitiatedShutdownBehavior`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder instanceInitiatedShutdownBehavior(java.lang.String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            return this;
        }

        /**
         * Sets the value of InstanceType
         * @param instanceType `AWS::EC2::Instance.InstanceType`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder instanceType(java.lang.String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of Ipv6AddressCount
         * @param ipv6AddressCount `AWS::EC2::Instance.Ipv6AddressCount`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder ipv6AddressCount(java.lang.Number ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
            return this;
        }

        /**
         * Sets the value of Ipv6Addresses
         * @param ipv6Addresses `AWS::EC2::Instance.Ipv6Addresses`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder ipv6Addresses(software.amazon.awscdk.core.IResolvable ipv6Addresses) {
            this.ipv6Addresses = ipv6Addresses;
            return this;
        }

        /**
         * Sets the value of Ipv6Addresses
         * @param ipv6Addresses `AWS::EC2::Instance.Ipv6Addresses`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder ipv6Addresses(java.util.List<java.lang.Object> ipv6Addresses) {
            this.ipv6Addresses = ipv6Addresses;
            return this;
        }

        /**
         * Sets the value of KernelId
         * @param kernelId `AWS::EC2::Instance.KernelId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder kernelId(java.lang.String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        /**
         * Sets the value of KeyName
         * @param keyName `AWS::EC2::Instance.KeyName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder keyName(java.lang.String keyName) {
            this.keyName = keyName;
            return this;
        }

        /**
         * Sets the value of LaunchTemplate
         * @param launchTemplate `AWS::EC2::Instance.LaunchTemplate`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder launchTemplate(software.amazon.awscdk.core.IResolvable launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        /**
         * Sets the value of LaunchTemplate
         * @param launchTemplate `AWS::EC2::Instance.LaunchTemplate`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder launchTemplate(software.amazon.awscdk.services.ec2.CfnInstance.LaunchTemplateSpecificationProperty launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        /**
         * Sets the value of LicenseSpecifications
         * @param licenseSpecifications `AWS::EC2::Instance.LicenseSpecifications`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder licenseSpecifications(software.amazon.awscdk.core.IResolvable licenseSpecifications) {
            this.licenseSpecifications = licenseSpecifications;
            return this;
        }

        /**
         * Sets the value of LicenseSpecifications
         * @param licenseSpecifications `AWS::EC2::Instance.LicenseSpecifications`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder licenseSpecifications(java.util.List<java.lang.Object> licenseSpecifications) {
            this.licenseSpecifications = licenseSpecifications;
            return this;
        }

        /**
         * Sets the value of Monitoring
         * @param monitoring `AWS::EC2::Instance.Monitoring`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder monitoring(java.lang.Boolean monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        /**
         * Sets the value of Monitoring
         * @param monitoring `AWS::EC2::Instance.Monitoring`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder monitoring(software.amazon.awscdk.core.IResolvable monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        /**
         * Sets the value of NetworkInterfaces
         * @param networkInterfaces `AWS::EC2::Instance.NetworkInterfaces`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder networkInterfaces(software.amazon.awscdk.core.IResolvable networkInterfaces) {
            this.networkInterfaces = networkInterfaces;
            return this;
        }

        /**
         * Sets the value of NetworkInterfaces
         * @param networkInterfaces `AWS::EC2::Instance.NetworkInterfaces`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder networkInterfaces(java.util.List<java.lang.Object> networkInterfaces) {
            this.networkInterfaces = networkInterfaces;
            return this;
        }

        /**
         * Sets the value of PlacementGroupName
         * @param placementGroupName `AWS::EC2::Instance.PlacementGroupName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder placementGroupName(java.lang.String placementGroupName) {
            this.placementGroupName = placementGroupName;
            return this;
        }

        /**
         * Sets the value of PrivateIpAddress
         * @param privateIpAddress `AWS::EC2::Instance.PrivateIpAddress`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder privateIpAddress(java.lang.String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        /**
         * Sets the value of RamdiskId
         * @param ramdiskId `AWS::EC2::Instance.RamdiskId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder ramdiskId(java.lang.String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        /**
         * Sets the value of SecurityGroupIds
         * @param securityGroupIds `AWS::EC2::Instance.SecurityGroupIds`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
            this.securityGroupIds = securityGroupIds;
            return this;
        }

        /**
         * Sets the value of SecurityGroups
         * @param securityGroups `AWS::EC2::Instance.SecurityGroups`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder securityGroups(java.util.List<java.lang.String> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        /**
         * Sets the value of SourceDestCheck
         * @param sourceDestCheck `AWS::EC2::Instance.SourceDestCheck`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder sourceDestCheck(java.lang.Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        /**
         * Sets the value of SourceDestCheck
         * @param sourceDestCheck `AWS::EC2::Instance.SourceDestCheck`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder sourceDestCheck(software.amazon.awscdk.core.IResolvable sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        /**
         * Sets the value of SsmAssociations
         * @param ssmAssociations `AWS::EC2::Instance.SsmAssociations`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder ssmAssociations(software.amazon.awscdk.core.IResolvable ssmAssociations) {
            this.ssmAssociations = ssmAssociations;
            return this;
        }

        /**
         * Sets the value of SsmAssociations
         * @param ssmAssociations `AWS::EC2::Instance.SsmAssociations`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder ssmAssociations(java.util.List<java.lang.Object> ssmAssociations) {
            this.ssmAssociations = ssmAssociations;
            return this;
        }

        /**
         * Sets the value of SubnetId
         * @param subnetId `AWS::EC2::Instance.SubnetId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder subnetId(java.lang.String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        /**
         * Sets the value of Tags
         * @param tags `AWS::EC2::Instance.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tags(java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of Tenancy
         * @param tenancy `AWS::EC2::Instance.Tenancy`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tenancy(java.lang.String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        /**
         * Sets the value of UserData
         * @param userData `AWS::EC2::Instance.UserData`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder userData(java.lang.String userData) {
            this.userData = userData;
            return this;
        }

        /**
         * Sets the value of Volumes
         * @param volumes `AWS::EC2::Instance.Volumes`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder volumes(software.amazon.awscdk.core.IResolvable volumes) {
            this.volumes = volumes;
            return this;
        }

        /**
         * Sets the value of Volumes
         * @param volumes `AWS::EC2::Instance.Volumes`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder volumes(java.util.List<java.lang.Object> volumes) {
            this.volumes = volumes;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnInstanceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnInstanceProps build() {
            return new Jsii$Proxy(additionalInfo, affinity, availabilityZone, blockDeviceMappings, cpuOptions, creditSpecification, disableApiTermination, ebsOptimized, elasticGpuSpecifications, elasticInferenceAccelerators, hostId, iamInstanceProfile, imageId, instanceInitiatedShutdownBehavior, instanceType, ipv6AddressCount, ipv6Addresses, kernelId, keyName, launchTemplate, licenseSpecifications, monitoring, networkInterfaces, placementGroupName, privateIpAddress, ramdiskId, securityGroupIds, securityGroups, sourceDestCheck, ssmAssociations, subnetId, tags, tenancy, userData, volumes);
        }

    }

    /**
     * An implementation for {@link CfnInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnInstanceProps {
        private final java.lang.String additionalInfo;
        private final java.lang.String affinity;
        private final java.lang.String availabilityZone;
        private final java.lang.Object blockDeviceMappings;
        private final java.lang.Object cpuOptions;
        private final java.lang.Object creditSpecification;
        private final java.lang.Object disableApiTermination;
        private final java.lang.Object ebsOptimized;
        private final java.lang.Object elasticGpuSpecifications;
        private final java.lang.Object elasticInferenceAccelerators;
        private final java.lang.String hostId;
        private final java.lang.String iamInstanceProfile;
        private final java.lang.String imageId;
        private final java.lang.String instanceInitiatedShutdownBehavior;
        private final java.lang.String instanceType;
        private final java.lang.Number ipv6AddressCount;
        private final java.lang.Object ipv6Addresses;
        private final java.lang.String kernelId;
        private final java.lang.String keyName;
        private final java.lang.Object launchTemplate;
        private final java.lang.Object licenseSpecifications;
        private final java.lang.Object monitoring;
        private final java.lang.Object networkInterfaces;
        private final java.lang.String placementGroupName;
        private final java.lang.String privateIpAddress;
        private final java.lang.String ramdiskId;
        private final java.util.List<java.lang.String> securityGroupIds;
        private final java.util.List<java.lang.String> securityGroups;
        private final java.lang.Object sourceDestCheck;
        private final java.lang.Object ssmAssociations;
        private final java.lang.String subnetId;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private final java.lang.String tenancy;
        private final java.lang.String userData;
        private final java.lang.Object volumes;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.additionalInfo = this.jsiiGet("additionalInfo", java.lang.String.class);
            this.affinity = this.jsiiGet("affinity", java.lang.String.class);
            this.availabilityZone = this.jsiiGet("availabilityZone", java.lang.String.class);
            this.blockDeviceMappings = this.jsiiGet("blockDeviceMappings", java.lang.Object.class);
            this.cpuOptions = this.jsiiGet("cpuOptions", java.lang.Object.class);
            this.creditSpecification = this.jsiiGet("creditSpecification", java.lang.Object.class);
            this.disableApiTermination = this.jsiiGet("disableApiTermination", java.lang.Object.class);
            this.ebsOptimized = this.jsiiGet("ebsOptimized", java.lang.Object.class);
            this.elasticGpuSpecifications = this.jsiiGet("elasticGpuSpecifications", java.lang.Object.class);
            this.elasticInferenceAccelerators = this.jsiiGet("elasticInferenceAccelerators", java.lang.Object.class);
            this.hostId = this.jsiiGet("hostId", java.lang.String.class);
            this.iamInstanceProfile = this.jsiiGet("iamInstanceProfile", java.lang.String.class);
            this.imageId = this.jsiiGet("imageId", java.lang.String.class);
            this.instanceInitiatedShutdownBehavior = this.jsiiGet("instanceInitiatedShutdownBehavior", java.lang.String.class);
            this.instanceType = this.jsiiGet("instanceType", java.lang.String.class);
            this.ipv6AddressCount = this.jsiiGet("ipv6AddressCount", java.lang.Number.class);
            this.ipv6Addresses = this.jsiiGet("ipv6Addresses", java.lang.Object.class);
            this.kernelId = this.jsiiGet("kernelId", java.lang.String.class);
            this.keyName = this.jsiiGet("keyName", java.lang.String.class);
            this.launchTemplate = this.jsiiGet("launchTemplate", java.lang.Object.class);
            this.licenseSpecifications = this.jsiiGet("licenseSpecifications", java.lang.Object.class);
            this.monitoring = this.jsiiGet("monitoring", java.lang.Object.class);
            this.networkInterfaces = this.jsiiGet("networkInterfaces", java.lang.Object.class);
            this.placementGroupName = this.jsiiGet("placementGroupName", java.lang.String.class);
            this.privateIpAddress = this.jsiiGet("privateIpAddress", java.lang.String.class);
            this.ramdiskId = this.jsiiGet("ramdiskId", java.lang.String.class);
            this.securityGroupIds = this.jsiiGet("securityGroupIds", java.util.List.class);
            this.securityGroups = this.jsiiGet("securityGroups", java.util.List.class);
            this.sourceDestCheck = this.jsiiGet("sourceDestCheck", java.lang.Object.class);
            this.ssmAssociations = this.jsiiGet("ssmAssociations", java.lang.Object.class);
            this.subnetId = this.jsiiGet("subnetId", java.lang.String.class);
            this.tags = this.jsiiGet("tags", java.util.List.class);
            this.tenancy = this.jsiiGet("tenancy", java.lang.String.class);
            this.userData = this.jsiiGet("userData", java.lang.String.class);
            this.volumes = this.jsiiGet("volumes", java.lang.Object.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String additionalInfo, java.lang.String affinity, java.lang.String availabilityZone, java.lang.Object blockDeviceMappings, java.lang.Object cpuOptions, java.lang.Object creditSpecification, java.lang.Object disableApiTermination, java.lang.Object ebsOptimized, java.lang.Object elasticGpuSpecifications, java.lang.Object elasticInferenceAccelerators, java.lang.String hostId, java.lang.String iamInstanceProfile, java.lang.String imageId, java.lang.String instanceInitiatedShutdownBehavior, java.lang.String instanceType, java.lang.Number ipv6AddressCount, java.lang.Object ipv6Addresses, java.lang.String kernelId, java.lang.String keyName, java.lang.Object launchTemplate, java.lang.Object licenseSpecifications, java.lang.Object monitoring, java.lang.Object networkInterfaces, java.lang.String placementGroupName, java.lang.String privateIpAddress, java.lang.String ramdiskId, java.util.List<java.lang.String> securityGroupIds, java.util.List<java.lang.String> securityGroups, java.lang.Object sourceDestCheck, java.lang.Object ssmAssociations, java.lang.String subnetId, java.util.List<software.amazon.awscdk.core.CfnTag> tags, java.lang.String tenancy, java.lang.String userData, java.lang.Object volumes) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.additionalInfo = additionalInfo;
            this.affinity = affinity;
            this.availabilityZone = availabilityZone;
            this.blockDeviceMappings = blockDeviceMappings;
            this.cpuOptions = cpuOptions;
            this.creditSpecification = creditSpecification;
            this.disableApiTermination = disableApiTermination;
            this.ebsOptimized = ebsOptimized;
            this.elasticGpuSpecifications = elasticGpuSpecifications;
            this.elasticInferenceAccelerators = elasticInferenceAccelerators;
            this.hostId = hostId;
            this.iamInstanceProfile = iamInstanceProfile;
            this.imageId = imageId;
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            this.instanceType = instanceType;
            this.ipv6AddressCount = ipv6AddressCount;
            this.ipv6Addresses = ipv6Addresses;
            this.kernelId = kernelId;
            this.keyName = keyName;
            this.launchTemplate = launchTemplate;
            this.licenseSpecifications = licenseSpecifications;
            this.monitoring = monitoring;
            this.networkInterfaces = networkInterfaces;
            this.placementGroupName = placementGroupName;
            this.privateIpAddress = privateIpAddress;
            this.ramdiskId = ramdiskId;
            this.securityGroupIds = securityGroupIds;
            this.securityGroups = securityGroups;
            this.sourceDestCheck = sourceDestCheck;
            this.ssmAssociations = ssmAssociations;
            this.subnetId = subnetId;
            this.tags = tags;
            this.tenancy = tenancy;
            this.userData = userData;
            this.volumes = volumes;
        }

        @Override
        public java.lang.String getAdditionalInfo() {
            return this.additionalInfo;
        }

        @Override
        public java.lang.String getAffinity() {
            return this.affinity;
        }

        @Override
        public java.lang.String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public java.lang.Object getBlockDeviceMappings() {
            return this.blockDeviceMappings;
        }

        @Override
        public java.lang.Object getCpuOptions() {
            return this.cpuOptions;
        }

        @Override
        public java.lang.Object getCreditSpecification() {
            return this.creditSpecification;
        }

        @Override
        public java.lang.Object getDisableApiTermination() {
            return this.disableApiTermination;
        }

        @Override
        public java.lang.Object getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public java.lang.Object getElasticGpuSpecifications() {
            return this.elasticGpuSpecifications;
        }

        @Override
        public java.lang.Object getElasticInferenceAccelerators() {
            return this.elasticInferenceAccelerators;
        }

        @Override
        public java.lang.String getHostId() {
            return this.hostId;
        }

        @Override
        public java.lang.String getIamInstanceProfile() {
            return this.iamInstanceProfile;
        }

        @Override
        public java.lang.String getImageId() {
            return this.imageId;
        }

        @Override
        public java.lang.String getInstanceInitiatedShutdownBehavior() {
            return this.instanceInitiatedShutdownBehavior;
        }

        @Override
        public java.lang.String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public java.lang.Number getIpv6AddressCount() {
            return this.ipv6AddressCount;
        }

        @Override
        public java.lang.Object getIpv6Addresses() {
            return this.ipv6Addresses;
        }

        @Override
        public java.lang.String getKernelId() {
            return this.kernelId;
        }

        @Override
        public java.lang.String getKeyName() {
            return this.keyName;
        }

        @Override
        public java.lang.Object getLaunchTemplate() {
            return this.launchTemplate;
        }

        @Override
        public java.lang.Object getLicenseSpecifications() {
            return this.licenseSpecifications;
        }

        @Override
        public java.lang.Object getMonitoring() {
            return this.monitoring;
        }

        @Override
        public java.lang.Object getNetworkInterfaces() {
            return this.networkInterfaces;
        }

        @Override
        public java.lang.String getPlacementGroupName() {
            return this.placementGroupName;
        }

        @Override
        public java.lang.String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        @Override
        public java.lang.String getRamdiskId() {
            return this.ramdiskId;
        }

        @Override
        public java.util.List<java.lang.String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public java.util.List<java.lang.String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public java.lang.Object getSourceDestCheck() {
            return this.sourceDestCheck;
        }

        @Override
        public java.lang.Object getSsmAssociations() {
            return this.ssmAssociations;
        }

        @Override
        public java.lang.String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public java.lang.String getTenancy() {
            return this.tenancy;
        }

        @Override
        public java.lang.String getUserData() {
            return this.userData;
        }

        @Override
        public java.lang.Object getVolumes() {
            return this.volumes;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            if (this.getAdditionalInfo() != null) {
                obj.set("additionalInfo", om.valueToTree(this.getAdditionalInfo()));
            }
            if (this.getAffinity() != null) {
                obj.set("affinity", om.valueToTree(this.getAffinity()));
            }
            if (this.getAvailabilityZone() != null) {
                obj.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
            }
            if (this.getBlockDeviceMappings() != null) {
                obj.set("blockDeviceMappings", om.valueToTree(this.getBlockDeviceMappings()));
            }
            if (this.getCpuOptions() != null) {
                obj.set("cpuOptions", om.valueToTree(this.getCpuOptions()));
            }
            if (this.getCreditSpecification() != null) {
                obj.set("creditSpecification", om.valueToTree(this.getCreditSpecification()));
            }
            if (this.getDisableApiTermination() != null) {
                obj.set("disableApiTermination", om.valueToTree(this.getDisableApiTermination()));
            }
            if (this.getEbsOptimized() != null) {
                obj.set("ebsOptimized", om.valueToTree(this.getEbsOptimized()));
            }
            if (this.getElasticGpuSpecifications() != null) {
                obj.set("elasticGpuSpecifications", om.valueToTree(this.getElasticGpuSpecifications()));
            }
            if (this.getElasticInferenceAccelerators() != null) {
                obj.set("elasticInferenceAccelerators", om.valueToTree(this.getElasticInferenceAccelerators()));
            }
            if (this.getHostId() != null) {
                obj.set("hostId", om.valueToTree(this.getHostId()));
            }
            if (this.getIamInstanceProfile() != null) {
                obj.set("iamInstanceProfile", om.valueToTree(this.getIamInstanceProfile()));
            }
            if (this.getImageId() != null) {
                obj.set("imageId", om.valueToTree(this.getImageId()));
            }
            if (this.getInstanceInitiatedShutdownBehavior() != null) {
                obj.set("instanceInitiatedShutdownBehavior", om.valueToTree(this.getInstanceInitiatedShutdownBehavior()));
            }
            if (this.getInstanceType() != null) {
                obj.set("instanceType", om.valueToTree(this.getInstanceType()));
            }
            if (this.getIpv6AddressCount() != null) {
                obj.set("ipv6AddressCount", om.valueToTree(this.getIpv6AddressCount()));
            }
            if (this.getIpv6Addresses() != null) {
                obj.set("ipv6Addresses", om.valueToTree(this.getIpv6Addresses()));
            }
            if (this.getKernelId() != null) {
                obj.set("kernelId", om.valueToTree(this.getKernelId()));
            }
            if (this.getKeyName() != null) {
                obj.set("keyName", om.valueToTree(this.getKeyName()));
            }
            if (this.getLaunchTemplate() != null) {
                obj.set("launchTemplate", om.valueToTree(this.getLaunchTemplate()));
            }
            if (this.getLicenseSpecifications() != null) {
                obj.set("licenseSpecifications", om.valueToTree(this.getLicenseSpecifications()));
            }
            if (this.getMonitoring() != null) {
                obj.set("monitoring", om.valueToTree(this.getMonitoring()));
            }
            if (this.getNetworkInterfaces() != null) {
                obj.set("networkInterfaces", om.valueToTree(this.getNetworkInterfaces()));
            }
            if (this.getPlacementGroupName() != null) {
                obj.set("placementGroupName", om.valueToTree(this.getPlacementGroupName()));
            }
            if (this.getPrivateIpAddress() != null) {
                obj.set("privateIpAddress", om.valueToTree(this.getPrivateIpAddress()));
            }
            if (this.getRamdiskId() != null) {
                obj.set("ramdiskId", om.valueToTree(this.getRamdiskId()));
            }
            if (this.getSecurityGroupIds() != null) {
                obj.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
            }
            if (this.getSecurityGroups() != null) {
                obj.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getSourceDestCheck() != null) {
                obj.set("sourceDestCheck", om.valueToTree(this.getSourceDestCheck()));
            }
            if (this.getSsmAssociations() != null) {
                obj.set("ssmAssociations", om.valueToTree(this.getSsmAssociations()));
            }
            if (this.getSubnetId() != null) {
                obj.set("subnetId", om.valueToTree(this.getSubnetId()));
            }
            if (this.getTags() != null) {
                obj.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTenancy() != null) {
                obj.set("tenancy", om.valueToTree(this.getTenancy()));
            }
            if (this.getUserData() != null) {
                obj.set("userData", om.valueToTree(this.getUserData()));
            }
            if (this.getVolumes() != null) {
                obj.set("volumes", om.valueToTree(this.getVolumes()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnInstanceProps.Jsii$Proxy that = (CfnInstanceProps.Jsii$Proxy) o;

            if (this.additionalInfo != null ? !this.additionalInfo.equals(that.additionalInfo) : that.additionalInfo != null) return false;
            if (this.affinity != null ? !this.affinity.equals(that.affinity) : that.affinity != null) return false;
            if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
            if (this.blockDeviceMappings != null ? !this.blockDeviceMappings.equals(that.blockDeviceMappings) : that.blockDeviceMappings != null) return false;
            if (this.cpuOptions != null ? !this.cpuOptions.equals(that.cpuOptions) : that.cpuOptions != null) return false;
            if (this.creditSpecification != null ? !this.creditSpecification.equals(that.creditSpecification) : that.creditSpecification != null) return false;
            if (this.disableApiTermination != null ? !this.disableApiTermination.equals(that.disableApiTermination) : that.disableApiTermination != null) return false;
            if (this.ebsOptimized != null ? !this.ebsOptimized.equals(that.ebsOptimized) : that.ebsOptimized != null) return false;
            if (this.elasticGpuSpecifications != null ? !this.elasticGpuSpecifications.equals(that.elasticGpuSpecifications) : that.elasticGpuSpecifications != null) return false;
            if (this.elasticInferenceAccelerators != null ? !this.elasticInferenceAccelerators.equals(that.elasticInferenceAccelerators) : that.elasticInferenceAccelerators != null) return false;
            if (this.hostId != null ? !this.hostId.equals(that.hostId) : that.hostId != null) return false;
            if (this.iamInstanceProfile != null ? !this.iamInstanceProfile.equals(that.iamInstanceProfile) : that.iamInstanceProfile != null) return false;
            if (this.imageId != null ? !this.imageId.equals(that.imageId) : that.imageId != null) return false;
            if (this.instanceInitiatedShutdownBehavior != null ? !this.instanceInitiatedShutdownBehavior.equals(that.instanceInitiatedShutdownBehavior) : that.instanceInitiatedShutdownBehavior != null) return false;
            if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
            if (this.ipv6AddressCount != null ? !this.ipv6AddressCount.equals(that.ipv6AddressCount) : that.ipv6AddressCount != null) return false;
            if (this.ipv6Addresses != null ? !this.ipv6Addresses.equals(that.ipv6Addresses) : that.ipv6Addresses != null) return false;
            if (this.kernelId != null ? !this.kernelId.equals(that.kernelId) : that.kernelId != null) return false;
            if (this.keyName != null ? !this.keyName.equals(that.keyName) : that.keyName != null) return false;
            if (this.launchTemplate != null ? !this.launchTemplate.equals(that.launchTemplate) : that.launchTemplate != null) return false;
            if (this.licenseSpecifications != null ? !this.licenseSpecifications.equals(that.licenseSpecifications) : that.licenseSpecifications != null) return false;
            if (this.monitoring != null ? !this.monitoring.equals(that.monitoring) : that.monitoring != null) return false;
            if (this.networkInterfaces != null ? !this.networkInterfaces.equals(that.networkInterfaces) : that.networkInterfaces != null) return false;
            if (this.placementGroupName != null ? !this.placementGroupName.equals(that.placementGroupName) : that.placementGroupName != null) return false;
            if (this.privateIpAddress != null ? !this.privateIpAddress.equals(that.privateIpAddress) : that.privateIpAddress != null) return false;
            if (this.ramdiskId != null ? !this.ramdiskId.equals(that.ramdiskId) : that.ramdiskId != null) return false;
            if (this.securityGroupIds != null ? !this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            if (this.sourceDestCheck != null ? !this.sourceDestCheck.equals(that.sourceDestCheck) : that.sourceDestCheck != null) return false;
            if (this.ssmAssociations != null ? !this.ssmAssociations.equals(that.ssmAssociations) : that.ssmAssociations != null) return false;
            if (this.subnetId != null ? !this.subnetId.equals(that.subnetId) : that.subnetId != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.tenancy != null ? !this.tenancy.equals(that.tenancy) : that.tenancy != null) return false;
            if (this.userData != null ? !this.userData.equals(that.userData) : that.userData != null) return false;
            return this.volumes != null ? this.volumes.equals(that.volumes) : that.volumes == null;
        }

        @Override
        public int hashCode() {
            int result = this.additionalInfo != null ? this.additionalInfo.hashCode() : 0;
            result = 31 * result + (this.affinity != null ? this.affinity.hashCode() : 0);
            result = 31 * result + (this.availabilityZone != null ? this.availabilityZone.hashCode() : 0);
            result = 31 * result + (this.blockDeviceMappings != null ? this.blockDeviceMappings.hashCode() : 0);
            result = 31 * result + (this.cpuOptions != null ? this.cpuOptions.hashCode() : 0);
            result = 31 * result + (this.creditSpecification != null ? this.creditSpecification.hashCode() : 0);
            result = 31 * result + (this.disableApiTermination != null ? this.disableApiTermination.hashCode() : 0);
            result = 31 * result + (this.ebsOptimized != null ? this.ebsOptimized.hashCode() : 0);
            result = 31 * result + (this.elasticGpuSpecifications != null ? this.elasticGpuSpecifications.hashCode() : 0);
            result = 31 * result + (this.elasticInferenceAccelerators != null ? this.elasticInferenceAccelerators.hashCode() : 0);
            result = 31 * result + (this.hostId != null ? this.hostId.hashCode() : 0);
            result = 31 * result + (this.iamInstanceProfile != null ? this.iamInstanceProfile.hashCode() : 0);
            result = 31 * result + (this.imageId != null ? this.imageId.hashCode() : 0);
            result = 31 * result + (this.instanceInitiatedShutdownBehavior != null ? this.instanceInitiatedShutdownBehavior.hashCode() : 0);
            result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
            result = 31 * result + (this.ipv6AddressCount != null ? this.ipv6AddressCount.hashCode() : 0);
            result = 31 * result + (this.ipv6Addresses != null ? this.ipv6Addresses.hashCode() : 0);
            result = 31 * result + (this.kernelId != null ? this.kernelId.hashCode() : 0);
            result = 31 * result + (this.keyName != null ? this.keyName.hashCode() : 0);
            result = 31 * result + (this.launchTemplate != null ? this.launchTemplate.hashCode() : 0);
            result = 31 * result + (this.licenseSpecifications != null ? this.licenseSpecifications.hashCode() : 0);
            result = 31 * result + (this.monitoring != null ? this.monitoring.hashCode() : 0);
            result = 31 * result + (this.networkInterfaces != null ? this.networkInterfaces.hashCode() : 0);
            result = 31 * result + (this.placementGroupName != null ? this.placementGroupName.hashCode() : 0);
            result = 31 * result + (this.privateIpAddress != null ? this.privateIpAddress.hashCode() : 0);
            result = 31 * result + (this.ramdiskId != null ? this.ramdiskId.hashCode() : 0);
            result = 31 * result + (this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.sourceDestCheck != null ? this.sourceDestCheck.hashCode() : 0);
            result = 31 * result + (this.ssmAssociations != null ? this.ssmAssociations.hashCode() : 0);
            result = 31 * result + (this.subnetId != null ? this.subnetId.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.tenancy != null ? this.tenancy.hashCode() : 0);
            result = 31 * result + (this.userData != null ? this.userData.hashCode() : 0);
            result = 31 * result + (this.volumes != null ? this.volumes.hashCode() : 0);
            return result;
        }

    }
}
