package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::Route`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.16.0 (build 98909b5)", date = "2019-09-06T01:04:14.444Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnRouteProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::EC2::Route.RouteTableId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-routetableid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getRouteTableId();

    /**
     * `AWS::EC2::Route.DestinationCidrBlock`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationcidrblock
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getDestinationCidrBlock();

    /**
     * `AWS::EC2::Route.DestinationIpv6CidrBlock`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationipv6cidrblock
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getDestinationIpv6CidrBlock();

    /**
     * `AWS::EC2::Route.EgressOnlyInternetGatewayId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-egressonlyinternetgatewayid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getEgressOnlyInternetGatewayId();

    /**
     * `AWS::EC2::Route.GatewayId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-gatewayid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getGatewayId();

    /**
     * `AWS::EC2::Route.InstanceId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-instanceid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getInstanceId();

    /**
     * `AWS::EC2::Route.NatGatewayId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-natgatewayid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getNatGatewayId();

    /**
     * `AWS::EC2::Route.NetworkInterfaceId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-networkinterfaceid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getNetworkInterfaceId();

    /**
     * `AWS::EC2::Route.TransitGatewayId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-transitgatewayid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getTransitGatewayId();

    /**
     * `AWS::EC2::Route.VpcPeeringConnectionId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-vpcpeeringconnectionid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getVpcPeeringConnectionId();

    /**
     * @return a {@link Builder} of {@link CfnRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Builder {
        private java.lang.String routeTableId;
        private java.lang.String destinationCidrBlock;
        private java.lang.String destinationIpv6CidrBlock;
        private java.lang.String egressOnlyInternetGatewayId;
        private java.lang.String gatewayId;
        private java.lang.String instanceId;
        private java.lang.String natGatewayId;
        private java.lang.String networkInterfaceId;
        private java.lang.String transitGatewayId;
        private java.lang.String vpcPeeringConnectionId;

        /**
         * Sets the value of RouteTableId
         * @param routeTableId `AWS::EC2::Route.RouteTableId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder routeTableId(java.lang.String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        /**
         * Sets the value of DestinationCidrBlock
         * @param destinationCidrBlock `AWS::EC2::Route.DestinationCidrBlock`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder destinationCidrBlock(java.lang.String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        /**
         * Sets the value of DestinationIpv6CidrBlock
         * @param destinationIpv6CidrBlock `AWS::EC2::Route.DestinationIpv6CidrBlock`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder destinationIpv6CidrBlock(java.lang.String destinationIpv6CidrBlock) {
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
            return this;
        }

        /**
         * Sets the value of EgressOnlyInternetGatewayId
         * @param egressOnlyInternetGatewayId `AWS::EC2::Route.EgressOnlyInternetGatewayId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder egressOnlyInternetGatewayId(java.lang.String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
            return this;
        }

        /**
         * Sets the value of GatewayId
         * @param gatewayId `AWS::EC2::Route.GatewayId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder gatewayId(java.lang.String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        /**
         * Sets the value of InstanceId
         * @param instanceId `AWS::EC2::Route.InstanceId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder instanceId(java.lang.String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        /**
         * Sets the value of NatGatewayId
         * @param natGatewayId `AWS::EC2::Route.NatGatewayId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder natGatewayId(java.lang.String natGatewayId) {
            this.natGatewayId = natGatewayId;
            return this;
        }

        /**
         * Sets the value of NetworkInterfaceId
         * @param networkInterfaceId `AWS::EC2::Route.NetworkInterfaceId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder networkInterfaceId(java.lang.String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        /**
         * Sets the value of TransitGatewayId
         * @param transitGatewayId `AWS::EC2::Route.TransitGatewayId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder transitGatewayId(java.lang.String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        /**
         * Sets the value of VpcPeeringConnectionId
         * @param vpcPeeringConnectionId `AWS::EC2::Route.VpcPeeringConnectionId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder vpcPeeringConnectionId(java.lang.String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRouteProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnRouteProps build() {
            return new Jsii$Proxy(routeTableId, destinationCidrBlock, destinationIpv6CidrBlock, egressOnlyInternetGatewayId, gatewayId, instanceId, natGatewayId, networkInterfaceId, transitGatewayId, vpcPeeringConnectionId);
        }

    }

    /**
     * An implementation for {@link CfnRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRouteProps {
        private final java.lang.String routeTableId;
        private final java.lang.String destinationCidrBlock;
        private final java.lang.String destinationIpv6CidrBlock;
        private final java.lang.String egressOnlyInternetGatewayId;
        private final java.lang.String gatewayId;
        private final java.lang.String instanceId;
        private final java.lang.String natGatewayId;
        private final java.lang.String networkInterfaceId;
        private final java.lang.String transitGatewayId;
        private final java.lang.String vpcPeeringConnectionId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.routeTableId = this.jsiiGet("routeTableId", java.lang.String.class);
            this.destinationCidrBlock = this.jsiiGet("destinationCidrBlock", java.lang.String.class);
            this.destinationIpv6CidrBlock = this.jsiiGet("destinationIpv6CidrBlock", java.lang.String.class);
            this.egressOnlyInternetGatewayId = this.jsiiGet("egressOnlyInternetGatewayId", java.lang.String.class);
            this.gatewayId = this.jsiiGet("gatewayId", java.lang.String.class);
            this.instanceId = this.jsiiGet("instanceId", java.lang.String.class);
            this.natGatewayId = this.jsiiGet("natGatewayId", java.lang.String.class);
            this.networkInterfaceId = this.jsiiGet("networkInterfaceId", java.lang.String.class);
            this.transitGatewayId = this.jsiiGet("transitGatewayId", java.lang.String.class);
            this.vpcPeeringConnectionId = this.jsiiGet("vpcPeeringConnectionId", java.lang.String.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String routeTableId, java.lang.String destinationCidrBlock, java.lang.String destinationIpv6CidrBlock, java.lang.String egressOnlyInternetGatewayId, java.lang.String gatewayId, java.lang.String instanceId, java.lang.String natGatewayId, java.lang.String networkInterfaceId, java.lang.String transitGatewayId, java.lang.String vpcPeeringConnectionId) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.routeTableId = java.util.Objects.requireNonNull(routeTableId, "routeTableId is required");
            this.destinationCidrBlock = destinationCidrBlock;
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
            this.gatewayId = gatewayId;
            this.instanceId = instanceId;
            this.natGatewayId = natGatewayId;
            this.networkInterfaceId = networkInterfaceId;
            this.transitGatewayId = transitGatewayId;
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        @Override
        public java.lang.String getRouteTableId() {
            return this.routeTableId;
        }

        @Override
        public java.lang.String getDestinationCidrBlock() {
            return this.destinationCidrBlock;
        }

        @Override
        public java.lang.String getDestinationIpv6CidrBlock() {
            return this.destinationIpv6CidrBlock;
        }

        @Override
        public java.lang.String getEgressOnlyInternetGatewayId() {
            return this.egressOnlyInternetGatewayId;
        }

        @Override
        public java.lang.String getGatewayId() {
            return this.gatewayId;
        }

        @Override
        public java.lang.String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public java.lang.String getNatGatewayId() {
            return this.natGatewayId;
        }

        @Override
        public java.lang.String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public java.lang.String getTransitGatewayId() {
            return this.transitGatewayId;
        }

        @Override
        public java.lang.String getVpcPeeringConnectionId() {
            return this.vpcPeeringConnectionId;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("routeTableId", om.valueToTree(this.getRouteTableId()));
            if (this.getDestinationCidrBlock() != null) {
                obj.set("destinationCidrBlock", om.valueToTree(this.getDestinationCidrBlock()));
            }
            if (this.getDestinationIpv6CidrBlock() != null) {
                obj.set("destinationIpv6CidrBlock", om.valueToTree(this.getDestinationIpv6CidrBlock()));
            }
            if (this.getEgressOnlyInternetGatewayId() != null) {
                obj.set("egressOnlyInternetGatewayId", om.valueToTree(this.getEgressOnlyInternetGatewayId()));
            }
            if (this.getGatewayId() != null) {
                obj.set("gatewayId", om.valueToTree(this.getGatewayId()));
            }
            if (this.getInstanceId() != null) {
                obj.set("instanceId", om.valueToTree(this.getInstanceId()));
            }
            if (this.getNatGatewayId() != null) {
                obj.set("natGatewayId", om.valueToTree(this.getNatGatewayId()));
            }
            if (this.getNetworkInterfaceId() != null) {
                obj.set("networkInterfaceId", om.valueToTree(this.getNetworkInterfaceId()));
            }
            if (this.getTransitGatewayId() != null) {
                obj.set("transitGatewayId", om.valueToTree(this.getTransitGatewayId()));
            }
            if (this.getVpcPeeringConnectionId() != null) {
                obj.set("vpcPeeringConnectionId", om.valueToTree(this.getVpcPeeringConnectionId()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRouteProps.Jsii$Proxy that = (CfnRouteProps.Jsii$Proxy) o;

            if (!routeTableId.equals(that.routeTableId)) return false;
            if (this.destinationCidrBlock != null ? !this.destinationCidrBlock.equals(that.destinationCidrBlock) : that.destinationCidrBlock != null) return false;
            if (this.destinationIpv6CidrBlock != null ? !this.destinationIpv6CidrBlock.equals(that.destinationIpv6CidrBlock) : that.destinationIpv6CidrBlock != null) return false;
            if (this.egressOnlyInternetGatewayId != null ? !this.egressOnlyInternetGatewayId.equals(that.egressOnlyInternetGatewayId) : that.egressOnlyInternetGatewayId != null) return false;
            if (this.gatewayId != null ? !this.gatewayId.equals(that.gatewayId) : that.gatewayId != null) return false;
            if (this.instanceId != null ? !this.instanceId.equals(that.instanceId) : that.instanceId != null) return false;
            if (this.natGatewayId != null ? !this.natGatewayId.equals(that.natGatewayId) : that.natGatewayId != null) return false;
            if (this.networkInterfaceId != null ? !this.networkInterfaceId.equals(that.networkInterfaceId) : that.networkInterfaceId != null) return false;
            if (this.transitGatewayId != null ? !this.transitGatewayId.equals(that.transitGatewayId) : that.transitGatewayId != null) return false;
            return this.vpcPeeringConnectionId != null ? this.vpcPeeringConnectionId.equals(that.vpcPeeringConnectionId) : that.vpcPeeringConnectionId == null;
        }

        @Override
        public int hashCode() {
            int result = this.routeTableId.hashCode();
            result = 31 * result + (this.destinationCidrBlock != null ? this.destinationCidrBlock.hashCode() : 0);
            result = 31 * result + (this.destinationIpv6CidrBlock != null ? this.destinationIpv6CidrBlock.hashCode() : 0);
            result = 31 * result + (this.egressOnlyInternetGatewayId != null ? this.egressOnlyInternetGatewayId.hashCode() : 0);
            result = 31 * result + (this.gatewayId != null ? this.gatewayId.hashCode() : 0);
            result = 31 * result + (this.instanceId != null ? this.instanceId.hashCode() : 0);
            result = 31 * result + (this.natGatewayId != null ? this.natGatewayId.hashCode() : 0);
            result = 31 * result + (this.networkInterfaceId != null ? this.networkInterfaceId.hashCode() : 0);
            result = 31 * result + (this.transitGatewayId != null ? this.transitGatewayId.hashCode() : 0);
            result = 31 * result + (this.vpcPeeringConnectionId != null ? this.vpcPeeringConnectionId.hashCode() : 0);
            return result;
        }

    }
}
