package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::TransitGatewayAttachment`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.16.0 (build 98909b5)", date = "2019-09-06T01:04:14.481Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnTransitGatewayAttachmentProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::EC2::TransitGatewayAttachment.SubnetIds`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html#cfn-ec2-transitgatewayattachment-subnetids
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.util.List<java.lang.String> getSubnetIds();

    /**
     * `AWS::EC2::TransitGatewayAttachment.TransitGatewayId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html#cfn-ec2-transitgatewayattachment-transitgatewayid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getTransitGatewayId();

    /**
     * `AWS::EC2::TransitGatewayAttachment.VpcId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html#cfn-ec2-transitgatewayattachment-vpcid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getVpcId();

    /**
     * `AWS::EC2::TransitGatewayAttachment.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html#cfn-ec2-transitgatewayattachment-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.util.List<software.amazon.awscdk.core.CfnTag> getTags();

    /**
     * @return a {@link Builder} of {@link CfnTransitGatewayAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnTransitGatewayAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Builder {
        private java.util.List<java.lang.String> subnetIds;
        private java.lang.String transitGatewayId;
        private java.lang.String vpcId;
        private java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of SubnetIds
         * @param subnetIds `AWS::EC2::TransitGatewayAttachment.SubnetIds`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
            this.subnetIds = subnetIds;
            return this;
        }

        /**
         * Sets the value of TransitGatewayId
         * @param transitGatewayId `AWS::EC2::TransitGatewayAttachment.TransitGatewayId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder transitGatewayId(java.lang.String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        /**
         * Sets the value of VpcId
         * @param vpcId `AWS::EC2::TransitGatewayAttachment.VpcId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder vpcId(java.lang.String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        /**
         * Sets the value of Tags
         * @param tags `AWS::EC2::TransitGatewayAttachment.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tags(java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTransitGatewayAttachmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnTransitGatewayAttachmentProps build() {
            return new Jsii$Proxy(subnetIds, transitGatewayId, vpcId, tags);
        }

    }

    /**
     * An implementation for {@link CfnTransitGatewayAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTransitGatewayAttachmentProps {
        private final java.util.List<java.lang.String> subnetIds;
        private final java.lang.String transitGatewayId;
        private final java.lang.String vpcId;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.subnetIds = this.jsiiGet("subnetIds", java.util.List.class);
            this.transitGatewayId = this.jsiiGet("transitGatewayId", java.lang.String.class);
            this.vpcId = this.jsiiGet("vpcId", java.lang.String.class);
            this.tags = this.jsiiGet("tags", java.util.List.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.util.List<java.lang.String> subnetIds, java.lang.String transitGatewayId, java.lang.String vpcId, java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.subnetIds = java.util.Objects.requireNonNull(subnetIds, "subnetIds is required");
            this.transitGatewayId = java.util.Objects.requireNonNull(transitGatewayId, "transitGatewayId is required");
            this.vpcId = java.util.Objects.requireNonNull(vpcId, "vpcId is required");
            this.tags = tags;
        }

        @Override
        public java.util.List<java.lang.String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public java.lang.String getTransitGatewayId() {
            return this.transitGatewayId;
        }

        @Override
        public java.lang.String getVpcId() {
            return this.vpcId;
        }

        @Override
        public java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("subnetIds", om.valueToTree(this.getSubnetIds()));
            obj.set("transitGatewayId", om.valueToTree(this.getTransitGatewayId()));
            obj.set("vpcId", om.valueToTree(this.getVpcId()));
            if (this.getTags() != null) {
                obj.set("tags", om.valueToTree(this.getTags()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTransitGatewayAttachmentProps.Jsii$Proxy that = (CfnTransitGatewayAttachmentProps.Jsii$Proxy) o;

            if (!subnetIds.equals(that.subnetIds)) return false;
            if (!transitGatewayId.equals(that.transitGatewayId)) return false;
            if (!vpcId.equals(that.vpcId)) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public int hashCode() {
            int result = this.subnetIds.hashCode();
            result = 31 * result + (this.transitGatewayId.hashCode());
            result = 31 * result + (this.vpcId.hashCode());
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }

    }
}
