package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::VPCEndpointConnectionNotification`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.16.0 (build 98909b5)", date = "2019-09-06T01:04:14.487Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnVPCEndpointConnectionNotificationProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::EC2::VPCEndpointConnectionNotification.ConnectionEvents`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-connectionevents
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.util.List<java.lang.String> getConnectionEvents();

    /**
     * `AWS::EC2::VPCEndpointConnectionNotification.ConnectionNotificationArn`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-connectionnotificationarn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getConnectionNotificationArn();

    /**
     * `AWS::EC2::VPCEndpointConnectionNotification.ServiceId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-serviceid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getServiceId();

    /**
     * `AWS::EC2::VPCEndpointConnectionNotification.VPCEndpointId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-vpcendpointid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getVpcEndpointId();

    /**
     * @return a {@link Builder} of {@link CfnVPCEndpointConnectionNotificationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnVPCEndpointConnectionNotificationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Builder {
        private java.util.List<java.lang.String> connectionEvents;
        private java.lang.String connectionNotificationArn;
        private java.lang.String serviceId;
        private java.lang.String vpcEndpointId;

        /**
         * Sets the value of ConnectionEvents
         * @param connectionEvents `AWS::EC2::VPCEndpointConnectionNotification.ConnectionEvents`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder connectionEvents(java.util.List<java.lang.String> connectionEvents) {
            this.connectionEvents = connectionEvents;
            return this;
        }

        /**
         * Sets the value of ConnectionNotificationArn
         * @param connectionNotificationArn `AWS::EC2::VPCEndpointConnectionNotification.ConnectionNotificationArn`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder connectionNotificationArn(java.lang.String connectionNotificationArn) {
            this.connectionNotificationArn = connectionNotificationArn;
            return this;
        }

        /**
         * Sets the value of ServiceId
         * @param serviceId `AWS::EC2::VPCEndpointConnectionNotification.ServiceId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder serviceId(java.lang.String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        /**
         * Sets the value of VpcEndpointId
         * @param vpcEndpointId `AWS::EC2::VPCEndpointConnectionNotification.VPCEndpointId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder vpcEndpointId(java.lang.String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVPCEndpointConnectionNotificationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnVPCEndpointConnectionNotificationProps build() {
            return new Jsii$Proxy(connectionEvents, connectionNotificationArn, serviceId, vpcEndpointId);
        }

    }

    /**
     * An implementation for {@link CfnVPCEndpointConnectionNotificationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVPCEndpointConnectionNotificationProps {
        private final java.util.List<java.lang.String> connectionEvents;
        private final java.lang.String connectionNotificationArn;
        private final java.lang.String serviceId;
        private final java.lang.String vpcEndpointId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.connectionEvents = this.jsiiGet("connectionEvents", java.util.List.class);
            this.connectionNotificationArn = this.jsiiGet("connectionNotificationArn", java.lang.String.class);
            this.serviceId = this.jsiiGet("serviceId", java.lang.String.class);
            this.vpcEndpointId = this.jsiiGet("vpcEndpointId", java.lang.String.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.util.List<java.lang.String> connectionEvents, java.lang.String connectionNotificationArn, java.lang.String serviceId, java.lang.String vpcEndpointId) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.connectionEvents = java.util.Objects.requireNonNull(connectionEvents, "connectionEvents is required");
            this.connectionNotificationArn = java.util.Objects.requireNonNull(connectionNotificationArn, "connectionNotificationArn is required");
            this.serviceId = serviceId;
            this.vpcEndpointId = vpcEndpointId;
        }

        @Override
        public java.util.List<java.lang.String> getConnectionEvents() {
            return this.connectionEvents;
        }

        @Override
        public java.lang.String getConnectionNotificationArn() {
            return this.connectionNotificationArn;
        }

        @Override
        public java.lang.String getServiceId() {
            return this.serviceId;
        }

        @Override
        public java.lang.String getVpcEndpointId() {
            return this.vpcEndpointId;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("connectionEvents", om.valueToTree(this.getConnectionEvents()));
            obj.set("connectionNotificationArn", om.valueToTree(this.getConnectionNotificationArn()));
            if (this.getServiceId() != null) {
                obj.set("serviceId", om.valueToTree(this.getServiceId()));
            }
            if (this.getVpcEndpointId() != null) {
                obj.set("vpcEndpointId", om.valueToTree(this.getVpcEndpointId()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVPCEndpointConnectionNotificationProps.Jsii$Proxy that = (CfnVPCEndpointConnectionNotificationProps.Jsii$Proxy) o;

            if (!connectionEvents.equals(that.connectionEvents)) return false;
            if (!connectionNotificationArn.equals(that.connectionNotificationArn)) return false;
            if (this.serviceId != null ? !this.serviceId.equals(that.serviceId) : that.serviceId != null) return false;
            return this.vpcEndpointId != null ? this.vpcEndpointId.equals(that.vpcEndpointId) : that.vpcEndpointId == null;
        }

        @Override
        public int hashCode() {
            int result = this.connectionEvents.hashCode();
            result = 31 * result + (this.connectionNotificationArn.hashCode());
            result = 31 * result + (this.serviceId != null ? this.serviceId.hashCode() : 0);
            result = 31 * result + (this.vpcEndpointId != null ? this.vpcEndpointId.hashCode() : 0);
            return result;
        }

    }
}
