package software.amazon.awscdk.services.ec2;

/**
 * Configuration for a machine image.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.16.0 (build 98909b5)", date = "2019-09-06T01:04:14.526Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MachineImageConfig extends software.amazon.jsii.JsiiSerializable {
    /**
     * The AMI ID of the image to use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getImageId();

    /**
     * Operating system type for this image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.ec2.OperatingSystemType getOsType();

    /**
     * Initial UserData for this image.
     * 
     * Default: - Default UserData appropriate for the osType is created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.ec2.UserData getUserData();

    /**
     * @return a {@link Builder} of {@link MachineImageConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link MachineImageConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.lang.String imageId;
        private software.amazon.awscdk.services.ec2.OperatingSystemType osType;
        private software.amazon.awscdk.services.ec2.UserData userData;

        /**
         * Sets the value of ImageId
         * @param imageId The AMI ID of the image to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageId(java.lang.String imageId) {
            this.imageId = imageId;
            return this;
        }

        /**
         * Sets the value of OsType
         * @param osType Operating system type for this image.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder osType(software.amazon.awscdk.services.ec2.OperatingSystemType osType) {
            this.osType = osType;
            return this;
        }

        /**
         * Sets the value of UserData
         * @param userData Initial UserData for this image.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userData(software.amazon.awscdk.services.ec2.UserData userData) {
            this.userData = userData;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MachineImageConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public MachineImageConfig build() {
            return new Jsii$Proxy(imageId, osType, userData);
        }

    }

    /**
     * An implementation for {@link MachineImageConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MachineImageConfig {
        private final java.lang.String imageId;
        private final software.amazon.awscdk.services.ec2.OperatingSystemType osType;
        private final software.amazon.awscdk.services.ec2.UserData userData;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.imageId = this.jsiiGet("imageId", java.lang.String.class);
            this.osType = this.jsiiGet("osType", software.amazon.awscdk.services.ec2.OperatingSystemType.class);
            this.userData = this.jsiiGet("userData", software.amazon.awscdk.services.ec2.UserData.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String imageId, software.amazon.awscdk.services.ec2.OperatingSystemType osType, software.amazon.awscdk.services.ec2.UserData userData) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.imageId = java.util.Objects.requireNonNull(imageId, "imageId is required");
            this.osType = java.util.Objects.requireNonNull(osType, "osType is required");
            this.userData = userData;
        }

        @Override
        public java.lang.String getImageId() {
            return this.imageId;
        }

        @Override
        public software.amazon.awscdk.services.ec2.OperatingSystemType getOsType() {
            return this.osType;
        }

        @Override
        public software.amazon.awscdk.services.ec2.UserData getUserData() {
            return this.userData;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("imageId", om.valueToTree(this.getImageId()));
            obj.set("osType", om.valueToTree(this.getOsType()));
            if (this.getUserData() != null) {
                obj.set("userData", om.valueToTree(this.getUserData()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MachineImageConfig.Jsii$Proxy that = (MachineImageConfig.Jsii$Proxy) o;

            if (!imageId.equals(that.imageId)) return false;
            if (!osType.equals(that.osType)) return false;
            return this.userData != null ? this.userData.equals(that.userData) : that.userData == null;
        }

        @Override
        public int hashCode() {
            int result = this.imageId.hashCode();
            result = 31 * result + (this.osType.hashCode());
            result = 31 * result + (this.userData != null ? this.userData.hashCode() : 0);
            return result;
        }

    }
}
