package software.amazon.awscdk.services.ec2;

/**
 * Result of selecting a subset of subnets from a VPC.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.16.0 (build 98909b5)", date = "2019-09-06T01:04:14.530Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SelectedSubnets extends software.amazon.jsii.JsiiSerializable {
    /**
     * The respective AZs of each subnet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getAvailabilityZones();

    /**
     * Whether any of the given subnets are from the VPC's public subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getHasPublic();

    /**
     * Dependency representing internet connectivity for these subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.IDependable getInternetConnectivityEstablished();

    /**
     * The subnet IDs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getSubnetIds();

    /**
     * Selected subnet objects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.ec2.ISubnet> getSubnets();

    /**
     * @return a {@link Builder} of {@link SelectedSubnets}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link SelectedSubnets}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.util.List<java.lang.String> availabilityZones;
        private java.lang.Boolean hasPublic;
        private software.amazon.awscdk.core.IDependable internetConnectivityEstablished;
        private java.util.List<java.lang.String> subnetIds;
        private java.util.List<software.amazon.awscdk.services.ec2.ISubnet> subnets;

        /**
         * Sets the value of AvailabilityZones
         * @param availabilityZones The respective AZs of each subnet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZones(java.util.List<java.lang.String> availabilityZones) {
            this.availabilityZones = availabilityZones;
            return this;
        }

        /**
         * Sets the value of HasPublic
         * @param hasPublic Whether any of the given subnets are from the VPC's public subnets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hasPublic(java.lang.Boolean hasPublic) {
            this.hasPublic = hasPublic;
            return this;
        }

        /**
         * Sets the value of InternetConnectivityEstablished
         * @param internetConnectivityEstablished Dependency representing internet connectivity for these subnets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder internetConnectivityEstablished(software.amazon.awscdk.core.IDependable internetConnectivityEstablished) {
            this.internetConnectivityEstablished = internetConnectivityEstablished;
            return this;
        }

        /**
         * Sets the value of SubnetIds
         * @param subnetIds The subnet IDs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
            this.subnetIds = subnetIds;
            return this;
        }

        /**
         * Sets the value of Subnets
         * @param subnets Selected subnet objects.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnets(java.util.List<software.amazon.awscdk.services.ec2.ISubnet> subnets) {
            this.subnets = subnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SelectedSubnets}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public SelectedSubnets build() {
            return new Jsii$Proxy(availabilityZones, hasPublic, internetConnectivityEstablished, subnetIds, subnets);
        }

    }

    /**
     * An implementation for {@link SelectedSubnets}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SelectedSubnets {
        private final java.util.List<java.lang.String> availabilityZones;
        private final java.lang.Boolean hasPublic;
        private final software.amazon.awscdk.core.IDependable internetConnectivityEstablished;
        private final java.util.List<java.lang.String> subnetIds;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISubnet> subnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.availabilityZones = this.jsiiGet("availabilityZones", java.util.List.class);
            this.hasPublic = this.jsiiGet("hasPublic", java.lang.Boolean.class);
            this.internetConnectivityEstablished = this.jsiiGet("internetConnectivityEstablished", software.amazon.awscdk.core.IDependable.class);
            this.subnetIds = this.jsiiGet("subnetIds", java.util.List.class);
            this.subnets = this.jsiiGet("subnets", java.util.List.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.util.List<java.lang.String> availabilityZones, java.lang.Boolean hasPublic, software.amazon.awscdk.core.IDependable internetConnectivityEstablished, java.util.List<java.lang.String> subnetIds, java.util.List<software.amazon.awscdk.services.ec2.ISubnet> subnets) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.availabilityZones = java.util.Objects.requireNonNull(availabilityZones, "availabilityZones is required");
            this.hasPublic = java.util.Objects.requireNonNull(hasPublic, "hasPublic is required");
            this.internetConnectivityEstablished = java.util.Objects.requireNonNull(internetConnectivityEstablished, "internetConnectivityEstablished is required");
            this.subnetIds = java.util.Objects.requireNonNull(subnetIds, "subnetIds is required");
            this.subnets = java.util.Objects.requireNonNull(subnets, "subnets is required");
        }

        @Override
        public java.util.List<java.lang.String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public java.lang.Boolean getHasPublic() {
            return this.hasPublic;
        }

        @Override
        public software.amazon.awscdk.core.IDependable getInternetConnectivityEstablished() {
            return this.internetConnectivityEstablished;
        }

        @Override
        public java.util.List<java.lang.String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.ec2.ISubnet> getSubnets() {
            return this.subnets;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("availabilityZones", om.valueToTree(this.getAvailabilityZones()));
            obj.set("hasPublic", om.valueToTree(this.getHasPublic()));
            obj.set("internetConnectivityEstablished", om.valueToTree(this.getInternetConnectivityEstablished()));
            obj.set("subnetIds", om.valueToTree(this.getSubnetIds()));
            obj.set("subnets", om.valueToTree(this.getSubnets()));
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SelectedSubnets.Jsii$Proxy that = (SelectedSubnets.Jsii$Proxy) o;

            if (!availabilityZones.equals(that.availabilityZones)) return false;
            if (!hasPublic.equals(that.hasPublic)) return false;
            if (!internetConnectivityEstablished.equals(that.internetConnectivityEstablished)) return false;
            if (!subnetIds.equals(that.subnetIds)) return false;
            return this.subnets.equals(that.subnets);
        }

        @Override
        public int hashCode() {
            int result = this.availabilityZones.hashCode();
            result = 31 * result + (this.hasPublic.hashCode());
            result = 31 * result + (this.internetConnectivityEstablished.hashCode());
            result = 31 * result + (this.subnetIds.hashCode());
            result = 31 * result + (this.subnets.hashCode());
            return result;
        }

    }
}
