package software.amazon.awscdk.services.ec2;

/**
 * Properties that reference an external Vpc.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.16.0 (build 98909b5)", date = "2019-09-06T01:04:14.535Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VpcAttributes extends software.amazon.jsii.JsiiSerializable {
    /**
     * List of availability zones for the subnets in this VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getAvailabilityZones();

    /**
     * VPC's identifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getVpcId();

    /**
     * List of isolated subnet IDs.
     * 
     * Must be undefined or match the availability zones in length and order.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getIsolatedSubnetIds();

    /**
     * List of names for the isolated subnets.
     * 
     * Must be undefined or have a name for every isolated subnet group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getIsolatedSubnetNames();

    /**
     * List of IDs of routing tables for the isolated subnets.
     * 
     * Must be undefined or have a name for every isolated subnet group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getIsolatedSubnetRouteTableIds();

    /**
     * List of private subnet IDs.
     * 
     * Must be undefined or match the availability zones in length and order.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getPrivateSubnetIds();

    /**
     * List of names for the private subnets.
     * 
     * Must be undefined or have a name for every private subnet group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getPrivateSubnetNames();

    /**
     * List of IDs of routing tables for the private subnets.
     * 
     * Must be undefined or have a name for every private subnet group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getPrivateSubnetRouteTableIds();

    /**
     * List of public subnet IDs.
     * 
     * Must be undefined or match the availability zones in length and order.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getPublicSubnetIds();

    /**
     * List of names for the public subnets.
     * 
     * Must be undefined or have a name for every public subnet group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getPublicSubnetNames();

    /**
     * List of IDs of routing tables for the public subnets.
     * 
     * Must be undefined or have a name for every public subnet group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getPublicSubnetRouteTableIds();

    /**
     * VPN gateway's identifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getVpnGatewayId();

    /**
     * @return a {@link Builder} of {@link VpcAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link VpcAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.util.List<java.lang.String> availabilityZones;
        private java.lang.String vpcId;
        private java.util.List<java.lang.String> isolatedSubnetIds;
        private java.util.List<java.lang.String> isolatedSubnetNames;
        private java.util.List<java.lang.String> isolatedSubnetRouteTableIds;
        private java.util.List<java.lang.String> privateSubnetIds;
        private java.util.List<java.lang.String> privateSubnetNames;
        private java.util.List<java.lang.String> privateSubnetRouteTableIds;
        private java.util.List<java.lang.String> publicSubnetIds;
        private java.util.List<java.lang.String> publicSubnetNames;
        private java.util.List<java.lang.String> publicSubnetRouteTableIds;
        private java.lang.String vpnGatewayId;

        /**
         * Sets the value of AvailabilityZones
         * @param availabilityZones List of availability zones for the subnets in this VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZones(java.util.List<java.lang.String> availabilityZones) {
            this.availabilityZones = availabilityZones;
            return this;
        }

        /**
         * Sets the value of VpcId
         * @param vpcId VPC's identifier.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(java.lang.String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        /**
         * Sets the value of IsolatedSubnetIds
         * @param isolatedSubnetIds List of isolated subnet IDs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isolatedSubnetIds(java.util.List<java.lang.String> isolatedSubnetIds) {
            this.isolatedSubnetIds = isolatedSubnetIds;
            return this;
        }

        /**
         * Sets the value of IsolatedSubnetNames
         * @param isolatedSubnetNames List of names for the isolated subnets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isolatedSubnetNames(java.util.List<java.lang.String> isolatedSubnetNames) {
            this.isolatedSubnetNames = isolatedSubnetNames;
            return this;
        }

        /**
         * Sets the value of IsolatedSubnetRouteTableIds
         * @param isolatedSubnetRouteTableIds List of IDs of routing tables for the isolated subnets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isolatedSubnetRouteTableIds(java.util.List<java.lang.String> isolatedSubnetRouteTableIds) {
            this.isolatedSubnetRouteTableIds = isolatedSubnetRouteTableIds;
            return this;
        }

        /**
         * Sets the value of PrivateSubnetIds
         * @param privateSubnetIds List of private subnet IDs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateSubnetIds(java.util.List<java.lang.String> privateSubnetIds) {
            this.privateSubnetIds = privateSubnetIds;
            return this;
        }

        /**
         * Sets the value of PrivateSubnetNames
         * @param privateSubnetNames List of names for the private subnets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateSubnetNames(java.util.List<java.lang.String> privateSubnetNames) {
            this.privateSubnetNames = privateSubnetNames;
            return this;
        }

        /**
         * Sets the value of PrivateSubnetRouteTableIds
         * @param privateSubnetRouteTableIds List of IDs of routing tables for the private subnets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateSubnetRouteTableIds(java.util.List<java.lang.String> privateSubnetRouteTableIds) {
            this.privateSubnetRouteTableIds = privateSubnetRouteTableIds;
            return this;
        }

        /**
         * Sets the value of PublicSubnetIds
         * @param publicSubnetIds List of public subnet IDs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicSubnetIds(java.util.List<java.lang.String> publicSubnetIds) {
            this.publicSubnetIds = publicSubnetIds;
            return this;
        }

        /**
         * Sets the value of PublicSubnetNames
         * @param publicSubnetNames List of names for the public subnets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicSubnetNames(java.util.List<java.lang.String> publicSubnetNames) {
            this.publicSubnetNames = publicSubnetNames;
            return this;
        }

        /**
         * Sets the value of PublicSubnetRouteTableIds
         * @param publicSubnetRouteTableIds List of IDs of routing tables for the public subnets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicSubnetRouteTableIds(java.util.List<java.lang.String> publicSubnetRouteTableIds) {
            this.publicSubnetRouteTableIds = publicSubnetRouteTableIds;
            return this;
        }

        /**
         * Sets the value of VpnGatewayId
         * @param vpnGatewayId VPN gateway's identifier.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpnGatewayId(java.lang.String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpcAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public VpcAttributes build() {
            return new Jsii$Proxy(availabilityZones, vpcId, isolatedSubnetIds, isolatedSubnetNames, isolatedSubnetRouteTableIds, privateSubnetIds, privateSubnetNames, privateSubnetRouteTableIds, publicSubnetIds, publicSubnetNames, publicSubnetRouteTableIds, vpnGatewayId);
        }

    }

    /**
     * An implementation for {@link VpcAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcAttributes {
        private final java.util.List<java.lang.String> availabilityZones;
        private final java.lang.String vpcId;
        private final java.util.List<java.lang.String> isolatedSubnetIds;
        private final java.util.List<java.lang.String> isolatedSubnetNames;
        private final java.util.List<java.lang.String> isolatedSubnetRouteTableIds;
        private final java.util.List<java.lang.String> privateSubnetIds;
        private final java.util.List<java.lang.String> privateSubnetNames;
        private final java.util.List<java.lang.String> privateSubnetRouteTableIds;
        private final java.util.List<java.lang.String> publicSubnetIds;
        private final java.util.List<java.lang.String> publicSubnetNames;
        private final java.util.List<java.lang.String> publicSubnetRouteTableIds;
        private final java.lang.String vpnGatewayId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.availabilityZones = this.jsiiGet("availabilityZones", java.util.List.class);
            this.vpcId = this.jsiiGet("vpcId", java.lang.String.class);
            this.isolatedSubnetIds = this.jsiiGet("isolatedSubnetIds", java.util.List.class);
            this.isolatedSubnetNames = this.jsiiGet("isolatedSubnetNames", java.util.List.class);
            this.isolatedSubnetRouteTableIds = this.jsiiGet("isolatedSubnetRouteTableIds", java.util.List.class);
            this.privateSubnetIds = this.jsiiGet("privateSubnetIds", java.util.List.class);
            this.privateSubnetNames = this.jsiiGet("privateSubnetNames", java.util.List.class);
            this.privateSubnetRouteTableIds = this.jsiiGet("privateSubnetRouteTableIds", java.util.List.class);
            this.publicSubnetIds = this.jsiiGet("publicSubnetIds", java.util.List.class);
            this.publicSubnetNames = this.jsiiGet("publicSubnetNames", java.util.List.class);
            this.publicSubnetRouteTableIds = this.jsiiGet("publicSubnetRouteTableIds", java.util.List.class);
            this.vpnGatewayId = this.jsiiGet("vpnGatewayId", java.lang.String.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.util.List<java.lang.String> availabilityZones, java.lang.String vpcId, java.util.List<java.lang.String> isolatedSubnetIds, java.util.List<java.lang.String> isolatedSubnetNames, java.util.List<java.lang.String> isolatedSubnetRouteTableIds, java.util.List<java.lang.String> privateSubnetIds, java.util.List<java.lang.String> privateSubnetNames, java.util.List<java.lang.String> privateSubnetRouteTableIds, java.util.List<java.lang.String> publicSubnetIds, java.util.List<java.lang.String> publicSubnetNames, java.util.List<java.lang.String> publicSubnetRouteTableIds, java.lang.String vpnGatewayId) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.availabilityZones = java.util.Objects.requireNonNull(availabilityZones, "availabilityZones is required");
            this.vpcId = java.util.Objects.requireNonNull(vpcId, "vpcId is required");
            this.isolatedSubnetIds = isolatedSubnetIds;
            this.isolatedSubnetNames = isolatedSubnetNames;
            this.isolatedSubnetRouteTableIds = isolatedSubnetRouteTableIds;
            this.privateSubnetIds = privateSubnetIds;
            this.privateSubnetNames = privateSubnetNames;
            this.privateSubnetRouteTableIds = privateSubnetRouteTableIds;
            this.publicSubnetIds = publicSubnetIds;
            this.publicSubnetNames = publicSubnetNames;
            this.publicSubnetRouteTableIds = publicSubnetRouteTableIds;
            this.vpnGatewayId = vpnGatewayId;
        }

        @Override
        public java.util.List<java.lang.String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public java.lang.String getVpcId() {
            return this.vpcId;
        }

        @Override
        public java.util.List<java.lang.String> getIsolatedSubnetIds() {
            return this.isolatedSubnetIds;
        }

        @Override
        public java.util.List<java.lang.String> getIsolatedSubnetNames() {
            return this.isolatedSubnetNames;
        }

        @Override
        public java.util.List<java.lang.String> getIsolatedSubnetRouteTableIds() {
            return this.isolatedSubnetRouteTableIds;
        }

        @Override
        public java.util.List<java.lang.String> getPrivateSubnetIds() {
            return this.privateSubnetIds;
        }

        @Override
        public java.util.List<java.lang.String> getPrivateSubnetNames() {
            return this.privateSubnetNames;
        }

        @Override
        public java.util.List<java.lang.String> getPrivateSubnetRouteTableIds() {
            return this.privateSubnetRouteTableIds;
        }

        @Override
        public java.util.List<java.lang.String> getPublicSubnetIds() {
            return this.publicSubnetIds;
        }

        @Override
        public java.util.List<java.lang.String> getPublicSubnetNames() {
            return this.publicSubnetNames;
        }

        @Override
        public java.util.List<java.lang.String> getPublicSubnetRouteTableIds() {
            return this.publicSubnetRouteTableIds;
        }

        @Override
        public java.lang.String getVpnGatewayId() {
            return this.vpnGatewayId;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("availabilityZones", om.valueToTree(this.getAvailabilityZones()));
            obj.set("vpcId", om.valueToTree(this.getVpcId()));
            if (this.getIsolatedSubnetIds() != null) {
                obj.set("isolatedSubnetIds", om.valueToTree(this.getIsolatedSubnetIds()));
            }
            if (this.getIsolatedSubnetNames() != null) {
                obj.set("isolatedSubnetNames", om.valueToTree(this.getIsolatedSubnetNames()));
            }
            if (this.getIsolatedSubnetRouteTableIds() != null) {
                obj.set("isolatedSubnetRouteTableIds", om.valueToTree(this.getIsolatedSubnetRouteTableIds()));
            }
            if (this.getPrivateSubnetIds() != null) {
                obj.set("privateSubnetIds", om.valueToTree(this.getPrivateSubnetIds()));
            }
            if (this.getPrivateSubnetNames() != null) {
                obj.set("privateSubnetNames", om.valueToTree(this.getPrivateSubnetNames()));
            }
            if (this.getPrivateSubnetRouteTableIds() != null) {
                obj.set("privateSubnetRouteTableIds", om.valueToTree(this.getPrivateSubnetRouteTableIds()));
            }
            if (this.getPublicSubnetIds() != null) {
                obj.set("publicSubnetIds", om.valueToTree(this.getPublicSubnetIds()));
            }
            if (this.getPublicSubnetNames() != null) {
                obj.set("publicSubnetNames", om.valueToTree(this.getPublicSubnetNames()));
            }
            if (this.getPublicSubnetRouteTableIds() != null) {
                obj.set("publicSubnetRouteTableIds", om.valueToTree(this.getPublicSubnetRouteTableIds()));
            }
            if (this.getVpnGatewayId() != null) {
                obj.set("vpnGatewayId", om.valueToTree(this.getVpnGatewayId()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VpcAttributes.Jsii$Proxy that = (VpcAttributes.Jsii$Proxy) o;

            if (!availabilityZones.equals(that.availabilityZones)) return false;
            if (!vpcId.equals(that.vpcId)) return false;
            if (this.isolatedSubnetIds != null ? !this.isolatedSubnetIds.equals(that.isolatedSubnetIds) : that.isolatedSubnetIds != null) return false;
            if (this.isolatedSubnetNames != null ? !this.isolatedSubnetNames.equals(that.isolatedSubnetNames) : that.isolatedSubnetNames != null) return false;
            if (this.isolatedSubnetRouteTableIds != null ? !this.isolatedSubnetRouteTableIds.equals(that.isolatedSubnetRouteTableIds) : that.isolatedSubnetRouteTableIds != null) return false;
            if (this.privateSubnetIds != null ? !this.privateSubnetIds.equals(that.privateSubnetIds) : that.privateSubnetIds != null) return false;
            if (this.privateSubnetNames != null ? !this.privateSubnetNames.equals(that.privateSubnetNames) : that.privateSubnetNames != null) return false;
            if (this.privateSubnetRouteTableIds != null ? !this.privateSubnetRouteTableIds.equals(that.privateSubnetRouteTableIds) : that.privateSubnetRouteTableIds != null) return false;
            if (this.publicSubnetIds != null ? !this.publicSubnetIds.equals(that.publicSubnetIds) : that.publicSubnetIds != null) return false;
            if (this.publicSubnetNames != null ? !this.publicSubnetNames.equals(that.publicSubnetNames) : that.publicSubnetNames != null) return false;
            if (this.publicSubnetRouteTableIds != null ? !this.publicSubnetRouteTableIds.equals(that.publicSubnetRouteTableIds) : that.publicSubnetRouteTableIds != null) return false;
            return this.vpnGatewayId != null ? this.vpnGatewayId.equals(that.vpnGatewayId) : that.vpnGatewayId == null;
        }

        @Override
        public int hashCode() {
            int result = this.availabilityZones.hashCode();
            result = 31 * result + (this.vpcId.hashCode());
            result = 31 * result + (this.isolatedSubnetIds != null ? this.isolatedSubnetIds.hashCode() : 0);
            result = 31 * result + (this.isolatedSubnetNames != null ? this.isolatedSubnetNames.hashCode() : 0);
            result = 31 * result + (this.isolatedSubnetRouteTableIds != null ? this.isolatedSubnetRouteTableIds.hashCode() : 0);
            result = 31 * result + (this.privateSubnetIds != null ? this.privateSubnetIds.hashCode() : 0);
            result = 31 * result + (this.privateSubnetNames != null ? this.privateSubnetNames.hashCode() : 0);
            result = 31 * result + (this.privateSubnetRouteTableIds != null ? this.privateSubnetRouteTableIds.hashCode() : 0);
            result = 31 * result + (this.publicSubnetIds != null ? this.publicSubnetIds.hashCode() : 0);
            result = 31 * result + (this.publicSubnetNames != null ? this.publicSubnetNames.hashCode() : 0);
            result = 31 * result + (this.publicSubnetRouteTableIds != null ? this.publicSubnetRouteTableIds.hashCode() : 0);
            result = 31 * result + (this.vpnGatewayId != null ? this.vpnGatewayId.hashCode() : 0);
            return result;
        }

    }
}
