package software.amazon.awscdk.services.ec2;

/**
 * Configuration for Vpc.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.16.0 (build 98909b5)", date = "2019-09-06T01:04:14.536Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VpcProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The CIDR range to use for the VPC, e.g. '10.0.0.0/16'.
     * 
     * Should be a minimum of /28 and maximum size of /16. The range will be
     * split across all subnets per Availability Zone.
     * 
     * Default: Vpc.DEFAULT_CIDR_RANGE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getCidr();

    /**
     * The default tenancy of instances launched into the VPC.
     * 
     * By setting this to dedicated tenancy, instances will be launched on
     * hardware dedicated to a single AWS customer, unless specifically specified
     * at instance launch time. Please note, not all instance types are usable
     * with Dedicated tenancy.
     * 
     * Default: DefaultInstanceTenancy.Default (shared) tenancy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.ec2.DefaultInstanceTenancy getDefaultInstanceTenancy();

    /**
     * Indicates whether the instances launched in the VPC get public DNS hostnames.
     * 
     * If this attribute is true, instances in the VPC get public DNS hostnames,
     * but only if the enableDnsSupport attribute is also set to true.
     * 
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getEnableDnsHostnames();

    /**
     * Indicates whether the DNS resolution is supported for the VPC.
     * 
     * If this attribute is false, the Amazon-provided DNS server in the VPC that
     * resolves public DNS hostnames to IP addresses is not enabled. If this
     * attribute is true, queries to the Amazon provided DNS server at the
     * 169.254.169.253 IP address, or the reserved IP address at the base of the
     * VPC IPv4 network range plus two will succeed.
     * 
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getEnableDnsSupport();

    /**
     * Gateway endpoints to add to this VPC.
     * 
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.GatewayVpcEndpointOptions> getGatewayEndpoints();

    /**
     * Define the maximum number of AZs to use in this region.
     * 
     * If the region has more AZs than you want to use (for example, because of
     * EIP limits), pick a lower number here. The AZs will be sorted and picked
     * from the start of the list.
     * 
     * If you pick a higher number than the number of AZs in the region, all AZs
     * in the region will be selected. To use "all AZs" available to your
     * account, use a high number (such as 99).
     * 
     * Be aware that environment-agnostic stacks will be created with access to
     * only 2 AZs, so to use more than 2 AZs, be sure to specify the account and
     * region on your stack.
     * 
     * Default: 3
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getMaxAzs();

    /**
     * The number of NAT Gateways to create.
     * 
     * For example, if set this to 1 and your subnet configuration is for 3 Public subnets then only
     * one of the Public subnets will have a gateway and all Private subnets will route to this NAT Gateway.
     * 
     * Default: - One NAT gateway per Availability Zone
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getNatGateways();

    /**
     * Configures the subnets which will have NAT Gateways.
     * 
     * You can pick a specific group of subnets by specifying the group name;
     * the picked subnets must be public subnets.
     * 
     * Only necessary if you have more than one public subnet group.
     * 
     * Default: - All public subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.ec2.SubnetSelection getNatGatewaySubnets();

    /**
     * Configure the subnets to build for each AZ.
     * 
     * Each entry in this list configures a Subnet Group; each group will contain a
     * subnet for each Availability Zone.
     * 
     * For example, if you want 1 public subnet, 1 private subnet, and 1 isolated
     * subnet in each AZ provide the following:
     * 
     * ```ts
     * subnetConfiguration: [
     *     {
     *       cidrMask: 24,
     *       name: 'ingress',
     *       subnetType: SubnetType.PUBLIC,
     *     },
     *     {
     *       cidrMask: 24,
     *       name: 'application',
     *       subnetType: SubnetType.PRIVATE,
     *     },
     *     {
     *       cidrMask: 28,
     *       name: 'rds',
     *       subnetType: SubnetType.ISOLATED,
     *     }
     * ]
     * ```
     * 
     * Default: - The VPC CIDR will be evenly divided between 1 public and 1
     * private subnet per AZ.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> getSubnetConfiguration();

    /**
     * VPN connections to this VPC.
     * 
     * Default: - No connections.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.VpnConnectionOptions> getVpnConnections();

    /**
     * Indicates whether a VPN gateway should be created and attached to this VPC.
     * 
     * Default: - true when vpnGatewayAsn or vpnConnections is specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getVpnGateway();

    /**
     * The private Autonomous System Number (ASN) for the VPN gateway.
     * 
     * Default: - Amazon default ASN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getVpnGatewayAsn();

    /**
     * Where to propagate VPN routes.
     * 
     * Default: - On the route tables associated with private subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> getVpnRoutePropagation();

    /**
     * @return a {@link Builder} of {@link VpcProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link VpcProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.lang.String cidr;
        private software.amazon.awscdk.services.ec2.DefaultInstanceTenancy defaultInstanceTenancy;
        private java.lang.Boolean enableDnsHostnames;
        private java.lang.Boolean enableDnsSupport;
        private java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.GatewayVpcEndpointOptions> gatewayEndpoints;
        private java.lang.Number maxAzs;
        private java.lang.Number natGateways;
        private software.amazon.awscdk.services.ec2.SubnetSelection natGatewaySubnets;
        private java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> subnetConfiguration;
        private java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.VpnConnectionOptions> vpnConnections;
        private java.lang.Boolean vpnGateway;
        private java.lang.Number vpnGatewayAsn;
        private java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> vpnRoutePropagation;

        /**
         * Sets the value of Cidr
         * @param cidr The CIDR range to use for the VPC, e.g. '10.0.0.0/16'.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidr(java.lang.String cidr) {
            this.cidr = cidr;
            return this;
        }

        /**
         * Sets the value of DefaultInstanceTenancy
         * @param defaultInstanceTenancy The default tenancy of instances launched into the VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultInstanceTenancy(software.amazon.awscdk.services.ec2.DefaultInstanceTenancy defaultInstanceTenancy) {
            this.defaultInstanceTenancy = defaultInstanceTenancy;
            return this;
        }

        /**
         * Sets the value of EnableDnsHostnames
         * @param enableDnsHostnames Indicates whether the instances launched in the VPC get public DNS hostnames.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableDnsHostnames(java.lang.Boolean enableDnsHostnames) {
            this.enableDnsHostnames = enableDnsHostnames;
            return this;
        }

        /**
         * Sets the value of EnableDnsSupport
         * @param enableDnsSupport Indicates whether the DNS resolution is supported for the VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableDnsSupport(java.lang.Boolean enableDnsSupport) {
            this.enableDnsSupport = enableDnsSupport;
            return this;
        }

        /**
         * Sets the value of GatewayEndpoints
         * @param gatewayEndpoints Gateway endpoints to add to this VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gatewayEndpoints(java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.GatewayVpcEndpointOptions> gatewayEndpoints) {
            this.gatewayEndpoints = gatewayEndpoints;
            return this;
        }

        /**
         * Sets the value of MaxAzs
         * @param maxAzs Define the maximum number of AZs to use in this region.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxAzs(java.lang.Number maxAzs) {
            this.maxAzs = maxAzs;
            return this;
        }

        /**
         * Sets the value of NatGateways
         * @param natGateways The number of NAT Gateways to create.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder natGateways(java.lang.Number natGateways) {
            this.natGateways = natGateways;
            return this;
        }

        /**
         * Sets the value of NatGatewaySubnets
         * @param natGatewaySubnets Configures the subnets which will have NAT Gateways.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder natGatewaySubnets(software.amazon.awscdk.services.ec2.SubnetSelection natGatewaySubnets) {
            this.natGatewaySubnets = natGatewaySubnets;
            return this;
        }

        /**
         * Sets the value of SubnetConfiguration
         * @param subnetConfiguration Configure the subnets to build for each AZ.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetConfiguration(java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> subnetConfiguration) {
            this.subnetConfiguration = subnetConfiguration;
            return this;
        }

        /**
         * Sets the value of VpnConnections
         * @param vpnConnections VPN connections to this VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpnConnections(java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.VpnConnectionOptions> vpnConnections) {
            this.vpnConnections = vpnConnections;
            return this;
        }

        /**
         * Sets the value of VpnGateway
         * @param vpnGateway Indicates whether a VPN gateway should be created and attached to this VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpnGateway(java.lang.Boolean vpnGateway) {
            this.vpnGateway = vpnGateway;
            return this;
        }

        /**
         * Sets the value of VpnGatewayAsn
         * @param vpnGatewayAsn The private Autonomous System Number (ASN) for the VPN gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpnGatewayAsn(java.lang.Number vpnGatewayAsn) {
            this.vpnGatewayAsn = vpnGatewayAsn;
            return this;
        }

        /**
         * Sets the value of VpnRoutePropagation
         * @param vpnRoutePropagation Where to propagate VPN routes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpnRoutePropagation(java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> vpnRoutePropagation) {
            this.vpnRoutePropagation = vpnRoutePropagation;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpcProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public VpcProps build() {
            return new Jsii$Proxy(cidr, defaultInstanceTenancy, enableDnsHostnames, enableDnsSupport, gatewayEndpoints, maxAzs, natGateways, natGatewaySubnets, subnetConfiguration, vpnConnections, vpnGateway, vpnGatewayAsn, vpnRoutePropagation);
        }

    }

    /**
     * An implementation for {@link VpcProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcProps {
        private final java.lang.String cidr;
        private final software.amazon.awscdk.services.ec2.DefaultInstanceTenancy defaultInstanceTenancy;
        private final java.lang.Boolean enableDnsHostnames;
        private final java.lang.Boolean enableDnsSupport;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.GatewayVpcEndpointOptions> gatewayEndpoints;
        private final java.lang.Number maxAzs;
        private final java.lang.Number natGateways;
        private final software.amazon.awscdk.services.ec2.SubnetSelection natGatewaySubnets;
        private final java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> subnetConfiguration;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.VpnConnectionOptions> vpnConnections;
        private final java.lang.Boolean vpnGateway;
        private final java.lang.Number vpnGatewayAsn;
        private final java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> vpnRoutePropagation;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.cidr = this.jsiiGet("cidr", java.lang.String.class);
            this.defaultInstanceTenancy = this.jsiiGet("defaultInstanceTenancy", software.amazon.awscdk.services.ec2.DefaultInstanceTenancy.class);
            this.enableDnsHostnames = this.jsiiGet("enableDnsHostnames", java.lang.Boolean.class);
            this.enableDnsSupport = this.jsiiGet("enableDnsSupport", java.lang.Boolean.class);
            this.gatewayEndpoints = this.jsiiGet("gatewayEndpoints", java.util.Map.class);
            this.maxAzs = this.jsiiGet("maxAzs", java.lang.Number.class);
            this.natGateways = this.jsiiGet("natGateways", java.lang.Number.class);
            this.natGatewaySubnets = this.jsiiGet("natGatewaySubnets", software.amazon.awscdk.services.ec2.SubnetSelection.class);
            this.subnetConfiguration = this.jsiiGet("subnetConfiguration", java.util.List.class);
            this.vpnConnections = this.jsiiGet("vpnConnections", java.util.Map.class);
            this.vpnGateway = this.jsiiGet("vpnGateway", java.lang.Boolean.class);
            this.vpnGatewayAsn = this.jsiiGet("vpnGatewayAsn", java.lang.Number.class);
            this.vpnRoutePropagation = this.jsiiGet("vpnRoutePropagation", java.util.List.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String cidr, software.amazon.awscdk.services.ec2.DefaultInstanceTenancy defaultInstanceTenancy, java.lang.Boolean enableDnsHostnames, java.lang.Boolean enableDnsSupport, java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.GatewayVpcEndpointOptions> gatewayEndpoints, java.lang.Number maxAzs, java.lang.Number natGateways, software.amazon.awscdk.services.ec2.SubnetSelection natGatewaySubnets, java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> subnetConfiguration, java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.VpnConnectionOptions> vpnConnections, java.lang.Boolean vpnGateway, java.lang.Number vpnGatewayAsn, java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> vpnRoutePropagation) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cidr = cidr;
            this.defaultInstanceTenancy = defaultInstanceTenancy;
            this.enableDnsHostnames = enableDnsHostnames;
            this.enableDnsSupport = enableDnsSupport;
            this.gatewayEndpoints = gatewayEndpoints;
            this.maxAzs = maxAzs;
            this.natGateways = natGateways;
            this.natGatewaySubnets = natGatewaySubnets;
            this.subnetConfiguration = subnetConfiguration;
            this.vpnConnections = vpnConnections;
            this.vpnGateway = vpnGateway;
            this.vpnGatewayAsn = vpnGatewayAsn;
            this.vpnRoutePropagation = vpnRoutePropagation;
        }

        @Override
        public java.lang.String getCidr() {
            return this.cidr;
        }

        @Override
        public software.amazon.awscdk.services.ec2.DefaultInstanceTenancy getDefaultInstanceTenancy() {
            return this.defaultInstanceTenancy;
        }

        @Override
        public java.lang.Boolean getEnableDnsHostnames() {
            return this.enableDnsHostnames;
        }

        @Override
        public java.lang.Boolean getEnableDnsSupport() {
            return this.enableDnsSupport;
        }

        @Override
        public java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.GatewayVpcEndpointOptions> getGatewayEndpoints() {
            return this.gatewayEndpoints;
        }

        @Override
        public java.lang.Number getMaxAzs() {
            return this.maxAzs;
        }

        @Override
        public java.lang.Number getNatGateways() {
            return this.natGateways;
        }

        @Override
        public software.amazon.awscdk.services.ec2.SubnetSelection getNatGatewaySubnets() {
            return this.natGatewaySubnets;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> getSubnetConfiguration() {
            return this.subnetConfiguration;
        }

        @Override
        public java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.VpnConnectionOptions> getVpnConnections() {
            return this.vpnConnections;
        }

        @Override
        public java.lang.Boolean getVpnGateway() {
            return this.vpnGateway;
        }

        @Override
        public java.lang.Number getVpnGatewayAsn() {
            return this.vpnGatewayAsn;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> getVpnRoutePropagation() {
            return this.vpnRoutePropagation;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            if (this.getCidr() != null) {
                obj.set("cidr", om.valueToTree(this.getCidr()));
            }
            if (this.getDefaultInstanceTenancy() != null) {
                obj.set("defaultInstanceTenancy", om.valueToTree(this.getDefaultInstanceTenancy()));
            }
            if (this.getEnableDnsHostnames() != null) {
                obj.set("enableDnsHostnames", om.valueToTree(this.getEnableDnsHostnames()));
            }
            if (this.getEnableDnsSupport() != null) {
                obj.set("enableDnsSupport", om.valueToTree(this.getEnableDnsSupport()));
            }
            if (this.getGatewayEndpoints() != null) {
                obj.set("gatewayEndpoints", om.valueToTree(this.getGatewayEndpoints()));
            }
            if (this.getMaxAzs() != null) {
                obj.set("maxAzs", om.valueToTree(this.getMaxAzs()));
            }
            if (this.getNatGateways() != null) {
                obj.set("natGateways", om.valueToTree(this.getNatGateways()));
            }
            if (this.getNatGatewaySubnets() != null) {
                obj.set("natGatewaySubnets", om.valueToTree(this.getNatGatewaySubnets()));
            }
            if (this.getSubnetConfiguration() != null) {
                obj.set("subnetConfiguration", om.valueToTree(this.getSubnetConfiguration()));
            }
            if (this.getVpnConnections() != null) {
                obj.set("vpnConnections", om.valueToTree(this.getVpnConnections()));
            }
            if (this.getVpnGateway() != null) {
                obj.set("vpnGateway", om.valueToTree(this.getVpnGateway()));
            }
            if (this.getVpnGatewayAsn() != null) {
                obj.set("vpnGatewayAsn", om.valueToTree(this.getVpnGatewayAsn()));
            }
            if (this.getVpnRoutePropagation() != null) {
                obj.set("vpnRoutePropagation", om.valueToTree(this.getVpnRoutePropagation()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VpcProps.Jsii$Proxy that = (VpcProps.Jsii$Proxy) o;

            if (this.cidr != null ? !this.cidr.equals(that.cidr) : that.cidr != null) return false;
            if (this.defaultInstanceTenancy != null ? !this.defaultInstanceTenancy.equals(that.defaultInstanceTenancy) : that.defaultInstanceTenancy != null) return false;
            if (this.enableDnsHostnames != null ? !this.enableDnsHostnames.equals(that.enableDnsHostnames) : that.enableDnsHostnames != null) return false;
            if (this.enableDnsSupport != null ? !this.enableDnsSupport.equals(that.enableDnsSupport) : that.enableDnsSupport != null) return false;
            if (this.gatewayEndpoints != null ? !this.gatewayEndpoints.equals(that.gatewayEndpoints) : that.gatewayEndpoints != null) return false;
            if (this.maxAzs != null ? !this.maxAzs.equals(that.maxAzs) : that.maxAzs != null) return false;
            if (this.natGateways != null ? !this.natGateways.equals(that.natGateways) : that.natGateways != null) return false;
            if (this.natGatewaySubnets != null ? !this.natGatewaySubnets.equals(that.natGatewaySubnets) : that.natGatewaySubnets != null) return false;
            if (this.subnetConfiguration != null ? !this.subnetConfiguration.equals(that.subnetConfiguration) : that.subnetConfiguration != null) return false;
            if (this.vpnConnections != null ? !this.vpnConnections.equals(that.vpnConnections) : that.vpnConnections != null) return false;
            if (this.vpnGateway != null ? !this.vpnGateway.equals(that.vpnGateway) : that.vpnGateway != null) return false;
            if (this.vpnGatewayAsn != null ? !this.vpnGatewayAsn.equals(that.vpnGatewayAsn) : that.vpnGatewayAsn != null) return false;
            return this.vpnRoutePropagation != null ? this.vpnRoutePropagation.equals(that.vpnRoutePropagation) : that.vpnRoutePropagation == null;
        }

        @Override
        public int hashCode() {
            int result = this.cidr != null ? this.cidr.hashCode() : 0;
            result = 31 * result + (this.defaultInstanceTenancy != null ? this.defaultInstanceTenancy.hashCode() : 0);
            result = 31 * result + (this.enableDnsHostnames != null ? this.enableDnsHostnames.hashCode() : 0);
            result = 31 * result + (this.enableDnsSupport != null ? this.enableDnsSupport.hashCode() : 0);
            result = 31 * result + (this.gatewayEndpoints != null ? this.gatewayEndpoints.hashCode() : 0);
            result = 31 * result + (this.maxAzs != null ? this.maxAzs.hashCode() : 0);
            result = 31 * result + (this.natGateways != null ? this.natGateways.hashCode() : 0);
            result = 31 * result + (this.natGatewaySubnets != null ? this.natGatewaySubnets.hashCode() : 0);
            result = 31 * result + (this.subnetConfiguration != null ? this.subnetConfiguration.hashCode() : 0);
            result = 31 * result + (this.vpnConnections != null ? this.vpnConnections.hashCode() : 0);
            result = 31 * result + (this.vpnGateway != null ? this.vpnGateway.hashCode() : 0);
            result = 31 * result + (this.vpnGatewayAsn != null ? this.vpnGatewayAsn.hashCode() : 0);
            result = 31 * result + (this.vpnRoutePropagation != null ? this.vpnRoutePropagation.hashCode() : 0);
            return result;
        }

    }
}
