package software.amazon.awscdk.services.ec2;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.16.0 (build 98909b5)", date = "2019-09-06T01:04:14.538Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VpnTunnelOption extends software.amazon.jsii.JsiiSerializable {
    /**
     * The pre-shared key (PSK) to establish initial authentication between the virtual private gateway and customer gateway.
     * 
     * Allowed characters are alphanumeric characters
     * and ._. Must be between 8 and 64 characters in length and cannot start with zero (0).
     * 
     * Default: an Amazon generated pre-shared key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getPreSharedKey();

    /**
     * The range of inside IP addresses for the tunnel.
     * 
     * Any specified CIDR blocks must be
     * unique across all VPN connections that use the same virtual private gateway.
     * A size /30 CIDR block from the 169.254.0.0/16 range.
     * 
     * Default: an Amazon generated inside IP CIDR
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getTunnelInsideCidr();

    /**
     * @return a {@link Builder} of {@link VpnTunnelOption}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link VpnTunnelOption}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.lang.String preSharedKey;
        private java.lang.String tunnelInsideCidr;

        /**
         * Sets the value of PreSharedKey
         * @param preSharedKey The pre-shared key (PSK) to establish initial authentication between the virtual private gateway and customer gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preSharedKey(java.lang.String preSharedKey) {
            this.preSharedKey = preSharedKey;
            return this;
        }

        /**
         * Sets the value of TunnelInsideCidr
         * @param tunnelInsideCidr The range of inside IP addresses for the tunnel.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tunnelInsideCidr(java.lang.String tunnelInsideCidr) {
            this.tunnelInsideCidr = tunnelInsideCidr;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpnTunnelOption}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public VpnTunnelOption build() {
            return new Jsii$Proxy(preSharedKey, tunnelInsideCidr);
        }

    }

    /**
     * An implementation for {@link VpnTunnelOption}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpnTunnelOption {
        private final java.lang.String preSharedKey;
        private final java.lang.String tunnelInsideCidr;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.preSharedKey = this.jsiiGet("preSharedKey", java.lang.String.class);
            this.tunnelInsideCidr = this.jsiiGet("tunnelInsideCidr", java.lang.String.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String preSharedKey, java.lang.String tunnelInsideCidr) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.preSharedKey = preSharedKey;
            this.tunnelInsideCidr = tunnelInsideCidr;
        }

        @Override
        public java.lang.String getPreSharedKey() {
            return this.preSharedKey;
        }

        @Override
        public java.lang.String getTunnelInsideCidr() {
            return this.tunnelInsideCidr;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            if (this.getPreSharedKey() != null) {
                obj.set("preSharedKey", om.valueToTree(this.getPreSharedKey()));
            }
            if (this.getTunnelInsideCidr() != null) {
                obj.set("tunnelInsideCidr", om.valueToTree(this.getTunnelInsideCidr()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VpnTunnelOption.Jsii$Proxy that = (VpnTunnelOption.Jsii$Proxy) o;

            if (this.preSharedKey != null ? !this.preSharedKey.equals(that.preSharedKey) : that.preSharedKey != null) return false;
            return this.tunnelInsideCidr != null ? this.tunnelInsideCidr.equals(that.tunnelInsideCidr) : that.tunnelInsideCidr == null;
        }

        @Override
        public int hashCode() {
            int result = this.preSharedKey != null ? this.preSharedKey.hashCode() : 0;
            result = 31 * result + (this.tunnelInsideCidr != null ? this.tunnelInsideCidr.hashCode() : 0);
            return result;
        }

    }
}
