/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.services.ec2.$Module;
import software.amazon.awscdk.services.ec2.CfnLaunchTemplate;
import software.amazon.awscdk.services.ec2.CfnLaunchTemplateProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnLaunchTemplate")
public class CfnLaunchTemplate
extends CfnResource {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnLaunchTemplate.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnLaunchTemplate(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnLaunchTemplate(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnLaunchTemplate(Construct scope, String id, CfnLaunchTemplateProps props) {
        super(JsiiObject.InitializationMode.JSII);
        this.setObjRef(JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props}));
    }

    public CfnLaunchTemplate(Construct scope, String id) {
        super(JsiiObject.InitializationMode.JSII);
        this.setObjRef(JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")}));
    }

    protected Map<String, Object> renderProperties(Map<String, Object> props) {
        return (Map)this.jsiiCall("renderProperties", Map.class, new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    public String getAttrDefaultVersionNumber() {
        return (String)this.jsiiGet("attrDefaultVersionNumber", String.class);
    }

    public String getAttrLatestVersionNumber() {
        return (String)this.jsiiGet("attrLatestVersionNumber", String.class);
    }

    protected Map<String, Object> getCfnProperties() {
        return (Map)this.jsiiGet("cfnProperties", Map.class);
    }

    public Object getLaunchTemplateData() {
        return this.jsiiGet("launchTemplateData", Object.class);
    }

    public void setLaunchTemplateData(IResolvable value) {
        this.jsiiSet("launchTemplateData", value);
    }

    public void setLaunchTemplateData(LaunchTemplateDataProperty value) {
        this.jsiiSet("launchTemplateData", value);
    }

    public String getLaunchTemplateName() {
        return (String)this.jsiiGet("launchTemplateName", String.class);
    }

    public void setLaunchTemplateName(String value) {
        this.jsiiSet("launchTemplateName", value);
    }

    public static interface TagSpecificationProperty
    extends JsiiSerializable {
        public String getResourceType();

        public List<CfnTag> getTags();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String resourceType;
            private List<CfnTag> tags;

            public Builder resourceType(String resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            public Builder tags(List<CfnTag> tags) {
                this.tags = tags;
                return this;
            }

            public TagSpecificationProperty build() {
                return new Jsii.Proxy(this.resourceType, this.tags, null);
            }
        }
    }

    public static interface SpotOptionsProperty
    extends JsiiSerializable {
        public Number getBlockDurationMinutes();

        public String getInstanceInterruptionBehavior();

        public String getMaxPrice();

        public String getSpotInstanceType();

        public String getValidUntil();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Number blockDurationMinutes;
            private String instanceInterruptionBehavior;
            private String maxPrice;
            private String spotInstanceType;
            private String validUntil;

            public Builder blockDurationMinutes(Number blockDurationMinutes) {
                this.blockDurationMinutes = blockDurationMinutes;
                return this;
            }

            public Builder instanceInterruptionBehavior(String instanceInterruptionBehavior) {
                this.instanceInterruptionBehavior = instanceInterruptionBehavior;
                return this;
            }

            public Builder maxPrice(String maxPrice) {
                this.maxPrice = maxPrice;
                return this;
            }

            public Builder spotInstanceType(String spotInstanceType) {
                this.spotInstanceType = spotInstanceType;
                return this;
            }

            public Builder validUntil(String validUntil) {
                this.validUntil = validUntil;
                return this;
            }

            public SpotOptionsProperty build() {
                return new Jsii.Proxy(this.blockDurationMinutes, this.instanceInterruptionBehavior, this.maxPrice, this.spotInstanceType, this.validUntil, null);
            }
        }
    }

    public static interface PrivateIpAddProperty
    extends JsiiSerializable {
        public Object getPrimary();

        public String getPrivateIpAddress();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object primary;
            private String privateIpAddress;

            public Builder primary(Boolean primary) {
                this.primary = primary;
                return this;
            }

            public Builder primary(IResolvable primary) {
                this.primary = primary;
                return this;
            }

            public Builder privateIpAddress(String privateIpAddress) {
                this.privateIpAddress = privateIpAddress;
                return this;
            }

            public PrivateIpAddProperty build() {
                return new Jsii.Proxy(this.primary, this.privateIpAddress, null);
            }
        }
    }

    public static interface PlacementProperty
    extends JsiiSerializable {
        public String getAffinity();

        public String getAvailabilityZone();

        public String getGroupName();

        public String getHostId();

        public String getTenancy();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String affinity;
            private String availabilityZone;
            private String groupName;
            private String hostId;
            private String tenancy;

            public Builder affinity(String affinity) {
                this.affinity = affinity;
                return this;
            }

            public Builder availabilityZone(String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            public Builder groupName(String groupName) {
                this.groupName = groupName;
                return this;
            }

            public Builder hostId(String hostId) {
                this.hostId = hostId;
                return this;
            }

            public Builder tenancy(String tenancy) {
                this.tenancy = tenancy;
                return this;
            }

            public PlacementProperty build() {
                return new Jsii.Proxy(this.affinity, this.availabilityZone, this.groupName, this.hostId, this.tenancy, null);
            }
        }
    }

    public static interface NetworkInterfaceProperty
    extends JsiiSerializable {
        public Object getAssociatePublicIpAddress();

        public Object getDeleteOnTermination();

        public String getDescription();

        public Number getDeviceIndex();

        public List<String> getGroups();

        public String getInterfaceType();

        public Number getIpv6AddressCount();

        public Object getIpv6Addresses();

        public String getNetworkInterfaceId();

        public String getPrivateIpAddress();

        public Object getPrivateIpAddresses();

        public Number getSecondaryPrivateIpAddressCount();

        public String getSubnetId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object associatePublicIpAddress;
            private Object deleteOnTermination;
            private String description;
            private Number deviceIndex;
            private List<String> groups;
            private String interfaceType;
            private Number ipv6AddressCount;
            private Object ipv6Addresses;
            private String networkInterfaceId;
            private String privateIpAddress;
            private Object privateIpAddresses;
            private Number secondaryPrivateIpAddressCount;
            private String subnetId;

            public Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
                this.associatePublicIpAddress = associatePublicIpAddress;
                return this;
            }

            public Builder associatePublicIpAddress(IResolvable associatePublicIpAddress) {
                this.associatePublicIpAddress = associatePublicIpAddress;
                return this;
            }

            public Builder deleteOnTermination(Boolean deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            public Builder deleteOnTermination(IResolvable deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder deviceIndex(Number deviceIndex) {
                this.deviceIndex = deviceIndex;
                return this;
            }

            public Builder groups(List<String> groups) {
                this.groups = groups;
                return this;
            }

            public Builder interfaceType(String interfaceType) {
                this.interfaceType = interfaceType;
                return this;
            }

            public Builder ipv6AddressCount(Number ipv6AddressCount) {
                this.ipv6AddressCount = ipv6AddressCount;
                return this;
            }

            public Builder ipv6Addresses(IResolvable ipv6Addresses) {
                this.ipv6Addresses = ipv6Addresses;
                return this;
            }

            public Builder ipv6Addresses(List<Object> ipv6Addresses) {
                this.ipv6Addresses = ipv6Addresses;
                return this;
            }

            public Builder networkInterfaceId(String networkInterfaceId) {
                this.networkInterfaceId = networkInterfaceId;
                return this;
            }

            public Builder privateIpAddress(String privateIpAddress) {
                this.privateIpAddress = privateIpAddress;
                return this;
            }

            public Builder privateIpAddresses(IResolvable privateIpAddresses) {
                this.privateIpAddresses = privateIpAddresses;
                return this;
            }

            public Builder privateIpAddresses(List<Object> privateIpAddresses) {
                this.privateIpAddresses = privateIpAddresses;
                return this;
            }

            public Builder secondaryPrivateIpAddressCount(Number secondaryPrivateIpAddressCount) {
                this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
                return this;
            }

            public Builder subnetId(String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            public NetworkInterfaceProperty build() {
                return new Jsii.Proxy(this.associatePublicIpAddress, this.deleteOnTermination, this.description, this.deviceIndex, this.groups, this.interfaceType, this.ipv6AddressCount, this.ipv6Addresses, this.networkInterfaceId, this.privateIpAddress, this.privateIpAddresses, this.secondaryPrivateIpAddressCount, this.subnetId, null);
            }
        }
    }

    public static interface MonitoringProperty
    extends JsiiSerializable {
        public Object getEnabled();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object enabled;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public MonitoringProperty build() {
                return new Jsii.Proxy(this.enabled, null);
            }
        }
    }

    public static interface LicenseSpecificationProperty
    extends JsiiSerializable {
        public String getLicenseConfigurationArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String licenseConfigurationArn;

            public Builder licenseConfigurationArn(String licenseConfigurationArn) {
                this.licenseConfigurationArn = licenseConfigurationArn;
                return this;
            }

            public LicenseSpecificationProperty build() {
                return new Jsii.Proxy(this.licenseConfigurationArn, null);
            }
        }
    }

    public static interface LaunchTemplateElasticInferenceAcceleratorProperty
    extends JsiiSerializable {
        public String getType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String type;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public LaunchTemplateElasticInferenceAcceleratorProperty build() {
                return new Jsii.Proxy(this.type, null);
            }
        }
    }

    public static interface LaunchTemplateDataProperty
    extends JsiiSerializable {
        public Object getBlockDeviceMappings();

        public Object getCapacityReservationSpecification();

        public Object getCpuOptions();

        public Object getCreditSpecification();

        public Object getDisableApiTermination();

        public Object getEbsOptimized();

        public Object getElasticGpuSpecifications();

        public Object getElasticInferenceAccelerators();

        public Object getHibernationOptions();

        public Object getIamInstanceProfile();

        public String getImageId();

        public String getInstanceInitiatedShutdownBehavior();

        public Object getInstanceMarketOptions();

        public String getInstanceType();

        public String getKernelId();

        public String getKeyName();

        public Object getLicenseSpecifications();

        public Object getMonitoring();

        public Object getNetworkInterfaces();

        public Object getPlacement();

        public String getRamDiskId();

        public List<String> getSecurityGroupIds();

        public List<String> getSecurityGroups();

        public Object getTagSpecifications();

        public String getUserData();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object blockDeviceMappings;
            private Object capacityReservationSpecification;
            private Object cpuOptions;
            private Object creditSpecification;
            private Object disableApiTermination;
            private Object ebsOptimized;
            private Object elasticGpuSpecifications;
            private Object elasticInferenceAccelerators;
            private Object hibernationOptions;
            private Object iamInstanceProfile;
            private String imageId;
            private String instanceInitiatedShutdownBehavior;
            private Object instanceMarketOptions;
            private String instanceType;
            private String kernelId;
            private String keyName;
            private Object licenseSpecifications;
            private Object monitoring;
            private Object networkInterfaces;
            private Object placement;
            private String ramDiskId;
            private List<String> securityGroupIds;
            private List<String> securityGroups;
            private Object tagSpecifications;
            private String userData;

            public Builder blockDeviceMappings(IResolvable blockDeviceMappings) {
                this.blockDeviceMappings = blockDeviceMappings;
                return this;
            }

            public Builder blockDeviceMappings(List<Object> blockDeviceMappings) {
                this.blockDeviceMappings = blockDeviceMappings;
                return this;
            }

            public Builder capacityReservationSpecification(IResolvable capacityReservationSpecification) {
                this.capacityReservationSpecification = capacityReservationSpecification;
                return this;
            }

            public Builder capacityReservationSpecification(CapacityReservationSpecificationProperty capacityReservationSpecification) {
                this.capacityReservationSpecification = capacityReservationSpecification;
                return this;
            }

            public Builder cpuOptions(IResolvable cpuOptions) {
                this.cpuOptions = cpuOptions;
                return this;
            }

            public Builder cpuOptions(CpuOptionsProperty cpuOptions) {
                this.cpuOptions = cpuOptions;
                return this;
            }

            public Builder creditSpecification(IResolvable creditSpecification) {
                this.creditSpecification = creditSpecification;
                return this;
            }

            public Builder creditSpecification(CreditSpecificationProperty creditSpecification) {
                this.creditSpecification = creditSpecification;
                return this;
            }

            public Builder disableApiTermination(Boolean disableApiTermination) {
                this.disableApiTermination = disableApiTermination;
                return this;
            }

            public Builder disableApiTermination(IResolvable disableApiTermination) {
                this.disableApiTermination = disableApiTermination;
                return this;
            }

            public Builder ebsOptimized(Boolean ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            public Builder ebsOptimized(IResolvable ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            public Builder elasticGpuSpecifications(IResolvable elasticGpuSpecifications) {
                this.elasticGpuSpecifications = elasticGpuSpecifications;
                return this;
            }

            public Builder elasticGpuSpecifications(List<Object> elasticGpuSpecifications) {
                this.elasticGpuSpecifications = elasticGpuSpecifications;
                return this;
            }

            public Builder elasticInferenceAccelerators(IResolvable elasticInferenceAccelerators) {
                this.elasticInferenceAccelerators = elasticInferenceAccelerators;
                return this;
            }

            public Builder elasticInferenceAccelerators(List<Object> elasticInferenceAccelerators) {
                this.elasticInferenceAccelerators = elasticInferenceAccelerators;
                return this;
            }

            public Builder hibernationOptions(IResolvable hibernationOptions) {
                this.hibernationOptions = hibernationOptions;
                return this;
            }

            public Builder hibernationOptions(HibernationOptionsProperty hibernationOptions) {
                this.hibernationOptions = hibernationOptions;
                return this;
            }

            public Builder iamInstanceProfile(IResolvable iamInstanceProfile) {
                this.iamInstanceProfile = iamInstanceProfile;
                return this;
            }

            public Builder iamInstanceProfile(IamInstanceProfileProperty iamInstanceProfile) {
                this.iamInstanceProfile = iamInstanceProfile;
                return this;
            }

            public Builder imageId(String imageId) {
                this.imageId = imageId;
                return this;
            }

            public Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
                this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
                return this;
            }

            public Builder instanceMarketOptions(IResolvable instanceMarketOptions) {
                this.instanceMarketOptions = instanceMarketOptions;
                return this;
            }

            public Builder instanceMarketOptions(InstanceMarketOptionsProperty instanceMarketOptions) {
                this.instanceMarketOptions = instanceMarketOptions;
                return this;
            }

            public Builder instanceType(String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            public Builder kernelId(String kernelId) {
                this.kernelId = kernelId;
                return this;
            }

            public Builder keyName(String keyName) {
                this.keyName = keyName;
                return this;
            }

            public Builder licenseSpecifications(IResolvable licenseSpecifications) {
                this.licenseSpecifications = licenseSpecifications;
                return this;
            }

            public Builder licenseSpecifications(List<Object> licenseSpecifications) {
                this.licenseSpecifications = licenseSpecifications;
                return this;
            }

            public Builder monitoring(IResolvable monitoring) {
                this.monitoring = monitoring;
                return this;
            }

            public Builder monitoring(MonitoringProperty monitoring) {
                this.monitoring = monitoring;
                return this;
            }

            public Builder networkInterfaces(IResolvable networkInterfaces) {
                this.networkInterfaces = networkInterfaces;
                return this;
            }

            public Builder networkInterfaces(List<Object> networkInterfaces) {
                this.networkInterfaces = networkInterfaces;
                return this;
            }

            public Builder placement(IResolvable placement) {
                this.placement = placement;
                return this;
            }

            public Builder placement(PlacementProperty placement) {
                this.placement = placement;
                return this;
            }

            public Builder ramDiskId(String ramDiskId) {
                this.ramDiskId = ramDiskId;
                return this;
            }

            public Builder securityGroupIds(List<String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            public Builder securityGroups(List<String> securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            public Builder tagSpecifications(IResolvable tagSpecifications) {
                this.tagSpecifications = tagSpecifications;
                return this;
            }

            public Builder tagSpecifications(List<Object> tagSpecifications) {
                this.tagSpecifications = tagSpecifications;
                return this;
            }

            public Builder userData(String userData) {
                this.userData = userData;
                return this;
            }

            public LaunchTemplateDataProperty build() {
                return new Jsii.Proxy(this.blockDeviceMappings, this.capacityReservationSpecification, this.cpuOptions, this.creditSpecification, this.disableApiTermination, this.ebsOptimized, this.elasticGpuSpecifications, this.elasticInferenceAccelerators, this.hibernationOptions, this.iamInstanceProfile, this.imageId, this.instanceInitiatedShutdownBehavior, this.instanceMarketOptions, this.instanceType, this.kernelId, this.keyName, this.licenseSpecifications, this.monitoring, this.networkInterfaces, this.placement, this.ramDiskId, this.securityGroupIds, this.securityGroups, this.tagSpecifications, this.userData, null);
            }
        }
    }

    public static interface Ipv6AddProperty
    extends JsiiSerializable {
        public String getIpv6Address();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String ipv6Address;

            public Builder ipv6Address(String ipv6Address) {
                this.ipv6Address = ipv6Address;
                return this;
            }

            public Ipv6AddProperty build() {
                return new Jsii.Proxy(this.ipv6Address, null);
            }
        }
    }

    public static interface InstanceMarketOptionsProperty
    extends JsiiSerializable {
        public String getMarketType();

        public Object getSpotOptions();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String marketType;
            private Object spotOptions;

            public Builder marketType(String marketType) {
                this.marketType = marketType;
                return this;
            }

            public Builder spotOptions(IResolvable spotOptions) {
                this.spotOptions = spotOptions;
                return this;
            }

            public Builder spotOptions(SpotOptionsProperty spotOptions) {
                this.spotOptions = spotOptions;
                return this;
            }

            public InstanceMarketOptionsProperty build() {
                return new Jsii.Proxy(this.marketType, this.spotOptions, null);
            }
        }
    }

    public static interface IamInstanceProfileProperty
    extends JsiiSerializable {
        public String getArn();

        public String getName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String arn;
            private String name;

            public Builder arn(String arn) {
                this.arn = arn;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public IamInstanceProfileProperty build() {
                return new Jsii.Proxy(this.arn, this.name, null);
            }
        }
    }

    public static interface HibernationOptionsProperty
    extends JsiiSerializable {
        public Object getConfigured();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object configured;

            public Builder configured(Boolean configured) {
                this.configured = configured;
                return this;
            }

            public Builder configured(IResolvable configured) {
                this.configured = configured;
                return this;
            }

            public HibernationOptionsProperty build() {
                return new Jsii.Proxy(this.configured, null);
            }
        }
    }

    public static interface ElasticGpuSpecificationProperty
    extends JsiiSerializable {
        public String getType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String type;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public ElasticGpuSpecificationProperty build() {
                return new Jsii.Proxy(this.type, null);
            }
        }
    }

    public static interface EbsProperty
    extends JsiiSerializable {
        public Object getDeleteOnTermination();

        public Object getEncrypted();

        public Number getIops();

        public String getKmsKeyId();

        public String getSnapshotId();

        public Number getVolumeSize();

        public String getVolumeType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object deleteOnTermination;
            private Object encrypted;
            private Number iops;
            private String kmsKeyId;
            private String snapshotId;
            private Number volumeSize;
            private String volumeType;

            public Builder deleteOnTermination(Boolean deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            public Builder deleteOnTermination(IResolvable deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            public Builder encrypted(Boolean encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            public Builder encrypted(IResolvable encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            public Builder iops(Number iops) {
                this.iops = iops;
                return this;
            }

            public Builder kmsKeyId(String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            public Builder snapshotId(String snapshotId) {
                this.snapshotId = snapshotId;
                return this;
            }

            public Builder volumeSize(Number volumeSize) {
                this.volumeSize = volumeSize;
                return this;
            }

            public Builder volumeType(String volumeType) {
                this.volumeType = volumeType;
                return this;
            }

            public EbsProperty build() {
                return new Jsii.Proxy(this.deleteOnTermination, this.encrypted, this.iops, this.kmsKeyId, this.snapshotId, this.volumeSize, this.volumeType, null);
            }
        }
    }

    public static interface CreditSpecificationProperty
    extends JsiiSerializable {
        public String getCpuCredits();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String cpuCredits;

            public Builder cpuCredits(String cpuCredits) {
                this.cpuCredits = cpuCredits;
                return this;
            }

            public CreditSpecificationProperty build() {
                return new Jsii.Proxy(this.cpuCredits, null);
            }
        }
    }

    public static interface CpuOptionsProperty
    extends JsiiSerializable {
        public Number getCoreCount();

        public Number getThreadsPerCore();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Number coreCount;
            private Number threadsPerCore;

            public Builder coreCount(Number coreCount) {
                this.coreCount = coreCount;
                return this;
            }

            public Builder threadsPerCore(Number threadsPerCore) {
                this.threadsPerCore = threadsPerCore;
                return this;
            }

            public CpuOptionsProperty build() {
                return new Jsii.Proxy(this.coreCount, this.threadsPerCore, null);
            }
        }
    }

    public static interface CapacityReservationTargetProperty
    extends JsiiSerializable {
        public String getCapacityReservationId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String capacityReservationId;

            public Builder capacityReservationId(String capacityReservationId) {
                this.capacityReservationId = capacityReservationId;
                return this;
            }

            public CapacityReservationTargetProperty build() {
                return new Jsii.Proxy(this.capacityReservationId, null);
            }
        }
    }

    public static interface CapacityReservationSpecificationProperty
    extends JsiiSerializable {
        public String getCapacityReservationPreference();

        public Object getCapacityReservationTarget();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String capacityReservationPreference;
            private Object capacityReservationTarget;

            public Builder capacityReservationPreference(String capacityReservationPreference) {
                this.capacityReservationPreference = capacityReservationPreference;
                return this;
            }

            public Builder capacityReservationTarget(IResolvable capacityReservationTarget) {
                this.capacityReservationTarget = capacityReservationTarget;
                return this;
            }

            public Builder capacityReservationTarget(CapacityReservationTargetProperty capacityReservationTarget) {
                this.capacityReservationTarget = capacityReservationTarget;
                return this;
            }

            public CapacityReservationSpecificationProperty build() {
                return new Jsii.Proxy(this.capacityReservationPreference, this.capacityReservationTarget, null);
            }
        }
    }

    public static interface BlockDeviceMappingProperty
    extends JsiiSerializable {
        public String getDeviceName();

        public Object getEbs();

        public String getNoDevice();

        public String getVirtualName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String deviceName;
            private Object ebs;
            private String noDevice;
            private String virtualName;

            public Builder deviceName(String deviceName) {
                this.deviceName = deviceName;
                return this;
            }

            public Builder ebs(IResolvable ebs) {
                this.ebs = ebs;
                return this;
            }

            public Builder ebs(EbsProperty ebs) {
                this.ebs = ebs;
                return this;
            }

            public Builder noDevice(String noDevice) {
                this.noDevice = noDevice;
                return this;
            }

            public Builder virtualName(String virtualName) {
                this.virtualName = virtualName;
                return this;
            }

            public BlockDeviceMappingProperty build() {
                return new Jsii.Proxy(this.deviceName, this.ebs, this.noDevice, this.virtualName, null);
            }
        }
    }
}

