package software.amazon.awscdk.services.ec2;

/**
 * (experimental) This creates a linux bastion host you can use to connect to other instances or services in your VPC.
 * <p>
 * The recommended way to connect to the bastion host is by using AWS Systems Manager Session Manager.
 * <p>
 * The operating system is Amazon Linux 2 with the latest SSM agent installed
 * <p>
 * You can also configure this bastion host to allow connections via SSH
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.14.0 (build 729554b)", date = "2020-10-29T17:34:16.471Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.BastionHostLinux")
public class BastionHostLinux extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.ec2.IInstance {

    protected BastionHostLinux(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BastionHostLinux(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public BastionHostLinux(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.BastionHostLinuxProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Allow SSH access from the given peer or peers.
     * <p>
     * Necessary if you want to connect to the instance using ssh. If not
     * called, you should use SSM Session Manager to connect to the instance.
     * <p>
     * @param peer This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void allowSshAccessFrom(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer... peer) {
        software.amazon.jsii.Kernel.call(this, "allowSshAccessFrom", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(peer).toArray(Object[]::new));
    }

    /**
     * (experimental) Allows specify security group connections for the instance.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * (experimental) The principal to grant permissions to.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return software.amazon.jsii.Kernel.get(this, "grantPrincipal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
    }

    /**
     * (experimental) The underlying instance resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Instance getInstance() {
        return software.amazon.jsii.Kernel.get(this, "instance", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Instance.class));
    }

    /**
     * (experimental) The availability zone the instance was launched in.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstanceAvailabilityZone() {
        return software.amazon.jsii.Kernel.get(this, "instanceAvailabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The instance's ID.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstanceId() {
        return software.amazon.jsii.Kernel.get(this, "instanceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Private DNS name for this instance.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstancePrivateDnsName() {
        return software.amazon.jsii.Kernel.get(this, "instancePrivateDnsName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Private IP for this instance.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstancePrivateIp() {
        return software.amazon.jsii.Kernel.get(this, "instancePrivateIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Publicly-routable DNS name for this instance.
     * <p>
     * (May be an empty string if the instance does not have a public name).
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstancePublicDnsName() {
        return software.amazon.jsii.Kernel.get(this, "instancePublicDnsName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Publicly-routable IP  address for this instance.
     * <p>
     * (May be an empty string if the instance does not have a public IP).
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstancePublicIp() {
        return software.amazon.jsii.Kernel.get(this, "instancePublicIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The IAM role assumed by the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * (experimental) The stack in which this resource is defined.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack getStack() {
        return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Stack.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.ec2.BastionHostLinux}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.BastionHostLinux> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.BastionHostLinuxProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.BastionHostLinuxProps.Builder();
        }

        /**
         * (experimental) VPC to launch the instance in.
         * <p>
         * @return {@code this}
         * @param vpc VPC to launch the instance in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * (experimental) In which AZ to place the instance within the VPC.
         * <p>
         * Default: - Random zone.
         * <p>
         * @return {@code this}
         * @param availabilityZone In which AZ to place the instance within the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder availabilityZone(final java.lang.String availabilityZone) {
            this.props.availabilityZone(availabilityZone);
            return this;
        }

        /**
         * (experimental) Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes.
         * <p>
         * Each instance that is launched has an associated root device volume,
         * either an Amazon EBS volume or an instance store volume.
         * You can use block device mappings to specify additional EBS volumes or
         * instance store volumes to attach to an instance when it is launched.
         * <p>
         * Default: - Uses the block device mapping of the AMI
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html
         * @param blockDevices Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder blockDevices(final java.util.List<? extends software.amazon.awscdk.services.ec2.BlockDevice> blockDevices) {
            this.props.blockDevices(blockDevices);
            return this;
        }

        /**
         * (experimental) The name of the instance.
         * <p>
         * Default: 'BastionHost'
         * <p>
         * @return {@code this}
         * @param instanceName The name of the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceName(final java.lang.String instanceName) {
            this.props.instanceName(instanceName);
            return this;
        }

        /**
         * (experimental) Type of instance to launch.
         * <p>
         * Default: 't3.nano'
         * <p>
         * @return {@code this}
         * @param instanceType Type of instance to launch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceType(final software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        /**
         * (experimental) The machine image to use.
         * <p>
         * Default: - An Amazon Linux 2 image which is kept up-to-date automatically (the instance
         * may be replaced on every deployment).
         * <p>
         * @return {@code this}
         * @param machineImage The machine image to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder machineImage(final software.amazon.awscdk.services.ec2.IMachineImage machineImage) {
            this.props.machineImage(machineImage);
            return this;
        }

        /**
         * (experimental) Security Group to assign to this instance.
         * <p>
         * Default: - create new security group with no inbound and all outbound traffic allowed
         * <p>
         * @return {@code this}
         * @param securityGroup Security Group to assign to this instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder securityGroup(final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        /**
         * (experimental) Select the subnets to run the bastion host in.
         * <p>
         * Set this to PUBLIC if you need to connect to this instance via the internet and cannot use SSM.
         * You have to allow port 22 manually by using the connections field
         * <p>
         * Default: - private subnets of the supplied VPC
         * <p>
         * @return {@code this}
         * @param subnetSelection Select the subnets to run the bastion host in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder subnetSelection(final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.props.subnetSelection(subnetSelection);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.BastionHostLinux}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.ec2.BastionHostLinux build() {
            return new software.amazon.awscdk.services.ec2.BastionHostLinux(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
