package software.amazon.awscdk.services.ec2;

/**
 * Represents a public VPC subnet resource.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.14.1 (build 828de8a)", date = "2020-11-06T04:41:39.685Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.PublicSubnet")
public class PublicSubnet extends software.amazon.awscdk.services.ec2.Subnet implements software.amazon.awscdk.services.ec2.IPublicSubnet {

    protected PublicSubnet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PublicSubnet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public PublicSubnet(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.PublicSubnetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPublicSubnet fromPublicSubnetAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.PublicSubnetAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.PublicSubnet.class, "fromPublicSubnetAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IPublicSubnet.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Creates a new managed NAT gateway attached to this public subnet.
     * <p>
     * Also adds the EIP for the managed NAT.
     * <p>
     * @return A ref to the the NAT Gateway ID
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnNatGateway addNatGateway() {
        return software.amazon.jsii.Kernel.call(this, "addNatGateway", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.CfnNatGateway.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.PublicSubnet}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.PublicSubnet> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.PublicSubnetProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.PublicSubnetProps.Builder();
        }

        /**
         * The availability zone for the subnet.
         * <p>
         * @return {@code this}
         * @param availabilityZone The availability zone for the subnet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(final java.lang.String availabilityZone) {
            this.props.availabilityZone(availabilityZone);
            return this;
        }

        /**
         * The CIDR notation for this subnet.
         * <p>
         * @return {@code this}
         * @param cidrBlock The CIDR notation for this subnet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidrBlock(final java.lang.String cidrBlock) {
            this.props.cidrBlock(cidrBlock);
            return this;
        }

        /**
         * The VPC which this subnet is part of.
         * <p>
         * @return {@code this}
         * @param vpcId The VPC which this subnet is part of. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(final java.lang.String vpcId) {
            this.props.vpcId(vpcId);
            return this;
        }

        /**
         * Controls if a public IP is associated to an instance at launch.
         * <p>
         * Default: true in Subnet.Public, false in Subnet.Private or Subnet.Isolated.
         * <p>
         * @return {@code this}
         * @param mapPublicIpOnLaunch Controls if a public IP is associated to an instance at launch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mapPublicIpOnLaunch(final java.lang.Boolean mapPublicIpOnLaunch) {
            this.props.mapPublicIpOnLaunch(mapPublicIpOnLaunch);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.PublicSubnet}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.PublicSubnet build() {
            return new software.amazon.awscdk.services.ec2.PublicSubnet(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
