package software.amazon.awscdk.services.ec2;

/**
 * Manage the allowed network connections for constructs with Security Groups.
 * <p>
 * Security Groups can be thought of as a firewall for network-connected
 * devices. This class makes it easy to allow network connections to and
 * from security groups, and between security groups individually. When
 * establishing connectivity between security groups, it will automatically
 * add rules in both security groups
 * <p>
 * This object can manage one or more security groups.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.14.1 (build 828de8a)", date = "2020-11-11T12:53:03.843Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.Connections")
public class Connections extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.IConnectable {

    protected Connections(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Connections(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Connections(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.ConnectionsProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Connections() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Add a security group to the list of security groups managed by this object.
     * <p>
     * @param securityGroups This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addSecurityGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ISecurityGroup... securityGroups) {
        software.amazon.jsii.Kernel.call(this, "addSecurityGroup", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(securityGroups).toArray(Object[]::new));
    }

    /**
     * Allow connections from the peer on our default port.
     * <p>
     * Even if the peer has a default port, we will always use our default port.
     * <p>
     * @param other This parameter is required.
     * @param description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowDefaultPortFrom(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IConnectable other, final @org.jetbrains.annotations.Nullable java.lang.String description) {
        software.amazon.jsii.Kernel.call(this, "allowDefaultPortFrom", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(other, "other is required"), description });
    }

    /**
     * Allow connections from the peer on our default port.
     * <p>
     * Even if the peer has a default port, we will always use our default port.
     * <p>
     * @param other This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowDefaultPortFrom(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IConnectable other) {
        software.amazon.jsii.Kernel.call(this, "allowDefaultPortFrom", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(other, "other is required") });
    }

    /**
     * Allow default connections from all IPv4 ranges.
     * <p>
     * @param description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowDefaultPortFromAnyIpv4(final @org.jetbrains.annotations.Nullable java.lang.String description) {
        software.amazon.jsii.Kernel.call(this, "allowDefaultPortFromAnyIpv4", software.amazon.jsii.NativeType.VOID, new Object[] { description });
    }

    /**
     * Allow default connections from all IPv4 ranges.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowDefaultPortFromAnyIpv4() {
        software.amazon.jsii.Kernel.call(this, "allowDefaultPortFromAnyIpv4", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Allow hosts inside the security group to connect to each other.
     * <p>
     * @param description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowDefaultPortInternally(final @org.jetbrains.annotations.Nullable java.lang.String description) {
        software.amazon.jsii.Kernel.call(this, "allowDefaultPortInternally", software.amazon.jsii.NativeType.VOID, new Object[] { description });
    }

    /**
     * Allow hosts inside the security group to connect to each other.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowDefaultPortInternally() {
        software.amazon.jsii.Kernel.call(this, "allowDefaultPortInternally", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Allow connections from the peer on our default port.
     * <p>
     * Even if the peer has a default port, we will always use our default port.
     * <p>
     * @param other This parameter is required.
     * @param description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowDefaultPortTo(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IConnectable other, final @org.jetbrains.annotations.Nullable java.lang.String description) {
        software.amazon.jsii.Kernel.call(this, "allowDefaultPortTo", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(other, "other is required"), description });
    }

    /**
     * Allow connections from the peer on our default port.
     * <p>
     * Even if the peer has a default port, we will always use our default port.
     * <p>
     * @param other This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowDefaultPortTo(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IConnectable other) {
        software.amazon.jsii.Kernel.call(this, "allowDefaultPortTo", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(other, "other is required") });
    }

    /**
     * Allow connections from the peer on the given port.
     * <p>
     * @param other This parameter is required.
     * @param portRange This parameter is required.
     * @param description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowFrom(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IConnectable other, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port portRange, final @org.jetbrains.annotations.Nullable java.lang.String description) {
        software.amazon.jsii.Kernel.call(this, "allowFrom", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(other, "other is required"), java.util.Objects.requireNonNull(portRange, "portRange is required"), description });
    }

    /**
     * Allow connections from the peer on the given port.
     * <p>
     * @param other This parameter is required.
     * @param portRange This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowFrom(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IConnectable other, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port portRange) {
        software.amazon.jsii.Kernel.call(this, "allowFrom", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(other, "other is required"), java.util.Objects.requireNonNull(portRange, "portRange is required") });
    }

    /**
     * Allow from any IPv4 ranges.
     * <p>
     * @param portRange This parameter is required.
     * @param description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowFromAnyIpv4(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port portRange, final @org.jetbrains.annotations.Nullable java.lang.String description) {
        software.amazon.jsii.Kernel.call(this, "allowFromAnyIpv4", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(portRange, "portRange is required"), description });
    }

    /**
     * Allow from any IPv4 ranges.
     * <p>
     * @param portRange This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowFromAnyIpv4(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port portRange) {
        software.amazon.jsii.Kernel.call(this, "allowFromAnyIpv4", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(portRange, "portRange is required") });
    }

    /**
     * Allow hosts inside the security group to connect to each other on the given port.
     * <p>
     * @param portRange This parameter is required.
     * @param description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowInternally(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port portRange, final @org.jetbrains.annotations.Nullable java.lang.String description) {
        software.amazon.jsii.Kernel.call(this, "allowInternally", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(portRange, "portRange is required"), description });
    }

    /**
     * Allow hosts inside the security group to connect to each other on the given port.
     * <p>
     * @param portRange This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowInternally(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port portRange) {
        software.amazon.jsii.Kernel.call(this, "allowInternally", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(portRange, "portRange is required") });
    }

    /**
     * Allow connections to the peer on the given port.
     * <p>
     * @param other This parameter is required.
     * @param portRange This parameter is required.
     * @param description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowTo(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IConnectable other, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port portRange, final @org.jetbrains.annotations.Nullable java.lang.String description) {
        software.amazon.jsii.Kernel.call(this, "allowTo", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(other, "other is required"), java.util.Objects.requireNonNull(portRange, "portRange is required"), description });
    }

    /**
     * Allow connections to the peer on the given port.
     * <p>
     * @param other This parameter is required.
     * @param portRange This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowTo(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IConnectable other, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port portRange) {
        software.amazon.jsii.Kernel.call(this, "allowTo", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(other, "other is required"), java.util.Objects.requireNonNull(portRange, "portRange is required") });
    }

    /**
     * Allow to all IPv4 ranges.
     * <p>
     * @param portRange This parameter is required.
     * @param description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowToAnyIpv4(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port portRange, final @org.jetbrains.annotations.Nullable java.lang.String description) {
        software.amazon.jsii.Kernel.call(this, "allowToAnyIpv4", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(portRange, "portRange is required"), description });
    }

    /**
     * Allow to all IPv4 ranges.
     * <p>
     * @param portRange This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowToAnyIpv4(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port portRange) {
        software.amazon.jsii.Kernel.call(this, "allowToAnyIpv4", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(portRange, "portRange is required") });
    }

    /**
     * Allow connections to the security group on their default port.
     * <p>
     * @param other This parameter is required.
     * @param description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowToDefaultPort(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IConnectable other, final @org.jetbrains.annotations.Nullable java.lang.String description) {
        software.amazon.jsii.Kernel.call(this, "allowToDefaultPort", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(other, "other is required"), description });
    }

    /**
     * Allow connections to the security group on their default port.
     * <p>
     * @param other This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowToDefaultPort(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IConnectable other) {
        software.amazon.jsii.Kernel.call(this, "allowToDefaultPort", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(other, "other is required") });
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class))));
    }

    /**
     * The default port configured for this connection peer, if available.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.Port getDefaultPort() {
        return software.amazon.jsii.Kernel.get(this, "defaultPort", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.Connections}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.Connections> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.services.ec2.ConnectionsProps.Builder props;

        private Builder() {
        }

        /**
         * Default port range for initiating connections to and from this object.
         * <p>
         * Default: - No default port
         * <p>
         * @return {@code this}
         * @param defaultPort Default port range for initiating connections to and from this object. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultPort(final software.amazon.awscdk.services.ec2.Port defaultPort) {
            this.props().defaultPort(defaultPort);
            return this;
        }

        /**
         * Class that represents the rule by which others can connect to this connectable.
         * <p>
         * This object is required, but will be derived from securityGroup if that is passed.
         * <p>
         * Default: Derived from securityGroup if set.
         * <p>
         * @return {@code this}
         * @param peer Class that represents the rule by which others can connect to this connectable. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder peer(final software.amazon.awscdk.services.ec2.IPeer peer) {
            this.props().peer(peer);
            return this;
        }

        /**
         * What securityGroup(s) this object is managing connections for.
         * <p>
         * Default: No security groups
         * <p>
         * @return {@code this}
         * @param securityGroups What securityGroup(s) this object is managing connections for. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.props().securityGroups(securityGroups);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.Connections}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.Connections build() {
            return new software.amazon.awscdk.services.ec2.Connections(
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ec2.ConnectionsProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ec2.ConnectionsProps.Builder();
            }
            return this.props;
        }
    }
}
