package software.amazon.awscdk.services.ec2;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.14.1 (build 828de8a)", date = "2020-11-17T10:51:19.587Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.VpnTunnelOption")
@software.amazon.jsii.Jsii.Proxy(VpnTunnelOption.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VpnTunnelOption extends software.amazon.jsii.JsiiSerializable {

    /**
     * The pre-shared key (PSK) to establish initial authentication between the virtual private gateway and customer gateway.
     * <p>
     * Allowed characters are alphanumeric characters
     * and ._. Must be between 8 and 64 characters in length and cannot start with zero (0).
     * <p>
     * Default: an Amazon generated pre-shared key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreSharedKey() {
        return null;
    }

    /**
     * The range of inside IP addresses for the tunnel.
     * <p>
     * Any specified CIDR blocks must be
     * unique across all VPN connections that use the same virtual private gateway.
     * A size /30 CIDR block from the 169.254.0.0/16 range.
     * <p>
     * Default: an Amazon generated inside IP CIDR
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTunnelInsideCidr() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link VpnTunnelOption}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VpnTunnelOption}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VpnTunnelOption> {
        private java.lang.String preSharedKey;
        private java.lang.String tunnelInsideCidr;

        /**
         * Sets the value of {@link VpnTunnelOption#getPreSharedKey}
         * @param preSharedKey The pre-shared key (PSK) to establish initial authentication between the virtual private gateway and customer gateway.
         *                     Allowed characters are alphanumeric characters
         *                     and ._. Must be between 8 and 64 characters in length and cannot start with zero (0).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preSharedKey(java.lang.String preSharedKey) {
            this.preSharedKey = preSharedKey;
            return this;
        }

        /**
         * Sets the value of {@link VpnTunnelOption#getTunnelInsideCidr}
         * @param tunnelInsideCidr The range of inside IP addresses for the tunnel.
         *                         Any specified CIDR blocks must be
         *                         unique across all VPN connections that use the same virtual private gateway.
         *                         A size /30 CIDR block from the 169.254.0.0/16 range.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tunnelInsideCidr(java.lang.String tunnelInsideCidr) {
            this.tunnelInsideCidr = tunnelInsideCidr;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpnTunnelOption}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VpnTunnelOption build() {
            return new Jsii$Proxy(preSharedKey, tunnelInsideCidr);
        }
    }

    /**
     * An implementation for {@link VpnTunnelOption}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpnTunnelOption {
        private final java.lang.String preSharedKey;
        private final java.lang.String tunnelInsideCidr;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.preSharedKey = software.amazon.jsii.Kernel.get(this, "preSharedKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tunnelInsideCidr = software.amazon.jsii.Kernel.get(this, "tunnelInsideCidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String preSharedKey, final java.lang.String tunnelInsideCidr) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.preSharedKey = preSharedKey;
            this.tunnelInsideCidr = tunnelInsideCidr;
        }

        @Override
        public final java.lang.String getPreSharedKey() {
            return this.preSharedKey;
        }

        @Override
        public final java.lang.String getTunnelInsideCidr() {
            return this.tunnelInsideCidr;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getPreSharedKey() != null) {
                data.set("preSharedKey", om.valueToTree(this.getPreSharedKey()));
            }
            if (this.getTunnelInsideCidr() != null) {
                data.set("tunnelInsideCidr", om.valueToTree(this.getTunnelInsideCidr()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.VpnTunnelOption"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VpnTunnelOption.Jsii$Proxy that = (VpnTunnelOption.Jsii$Proxy) o;

            if (this.preSharedKey != null ? !this.preSharedKey.equals(that.preSharedKey) : that.preSharedKey != null) return false;
            return this.tunnelInsideCidr != null ? this.tunnelInsideCidr.equals(that.tunnelInsideCidr) : that.tunnelInsideCidr == null;
        }

        @Override
        public final int hashCode() {
            int result = this.preSharedKey != null ? this.preSharedKey.hashCode() : 0;
            result = 31 * result + (this.tunnelInsideCidr != null ? this.tunnelInsideCidr.hashCode() : 0);
            return result;
        }
    }
}
