/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.ec2.;
import software.amazon.awscdk.services.ec2.FlowLogDestination;
import software.amazon.awscdk.services.ec2.FlowLogProps;
import software.amazon.awscdk.services.ec2.FlowLogResourceType;
import software.amazon.awscdk.services.ec2.FlowLogTrafficType;
import software.amazon.awscdk.services.ec2.IFlowLog;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.logs.ILogGroup;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.FlowLog")
public class FlowLog
extends Resource
implements IFlowLog {
    protected FlowLog(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FlowLog(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public FlowLog(@NotNull Construct scope, @NotNull String id, @NotNull FlowLogProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IFlowLog fromFlowLogId(@NotNull Construct scope, @NotNull String id, @NotNull String flowLogId) {
        return (IFlowLog)JsiiObject.jsiiStaticCall(FlowLog.class, (String)"fromFlowLogId", (NativeType)NativeType.forClass(IFlowLog.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(flowLogId, "flowLogId is required")});
    }

    @Override
    @NotNull
    public String getFlowLogId() {
        return (String)Kernel.get((Object)this, (String)"flowLogId", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public IBucket getBucket() {
        return (IBucket)Kernel.get((Object)this, (String)"bucket", (NativeType)NativeType.forClass(IBucket.class));
    }

    @Nullable
    public IRole getIamRole() {
        return (IRole)Kernel.get((Object)this, (String)"iamRole", (NativeType)NativeType.forClass(IRole.class));
    }

    @Nullable
    public String getKeyPrefix() {
        return (String)Kernel.get((Object)this, (String)"keyPrefix", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public ILogGroup getLogGroup() {
        return (ILogGroup)Kernel.get((Object)this, (String)"logGroup", (NativeType)NativeType.forClass(ILogGroup.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<FlowLog> {
        private final Construct scope;
        private final String id;
        private final FlowLogProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new FlowLogProps.Builder();
        }

        public Builder destination(FlowLogDestination destination) {
            this.props.destination(destination);
            return this;
        }

        public Builder trafficType(FlowLogTrafficType trafficType) {
            this.props.trafficType(trafficType);
            return this;
        }

        public Builder resourceType(FlowLogResourceType resourceType) {
            this.props.resourceType(resourceType);
            return this;
        }

        public Builder flowLogName(String flowLogName) {
            this.props.flowLogName(flowLogName);
            return this;
        }

        public FlowLog build() {
            return new FlowLog(this.scope, this.id, this.props.build());
        }
    }
}

