package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::CustomerGateway`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.16.0 (build 98909b5)", date = "2019-09-10T21:16:48.716Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnCustomerGatewayProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::EC2::CustomerGateway.BgpAsn`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-bgpasn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Number getBgpAsn();

    /**
     * `AWS::EC2::CustomerGateway.IpAddress`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-ipaddress
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getIpAddress();

    /**
     * `AWS::EC2::CustomerGateway.Type`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-type
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getType();

    /**
     * `AWS::EC2::CustomerGateway.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.util.List<software.amazon.awscdk.core.CfnTag> getTags();

    /**
     * @return a {@link Builder} of {@link CfnCustomerGatewayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnCustomerGatewayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Builder {
        private java.lang.Number bgpAsn;
        private java.lang.String ipAddress;
        private java.lang.String type;
        private java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of BgpAsn
         * @param bgpAsn `AWS::EC2::CustomerGateway.BgpAsn`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder bgpAsn(java.lang.Number bgpAsn) {
            this.bgpAsn = bgpAsn;
            return this;
        }

        /**
         * Sets the value of IpAddress
         * @param ipAddress `AWS::EC2::CustomerGateway.IpAddress`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder ipAddress(java.lang.String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        /**
         * Sets the value of Type
         * @param type `AWS::EC2::CustomerGateway.Type`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of Tags
         * @param tags `AWS::EC2::CustomerGateway.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tags(java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCustomerGatewayProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnCustomerGatewayProps build() {
            return new Jsii$Proxy(bgpAsn, ipAddress, type, tags);
        }

    }

    /**
     * An implementation for {@link CfnCustomerGatewayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCustomerGatewayProps {
        private final java.lang.Number bgpAsn;
        private final java.lang.String ipAddress;
        private final java.lang.String type;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.bgpAsn = this.jsiiGet("bgpAsn", java.lang.Number.class);
            this.ipAddress = this.jsiiGet("ipAddress", java.lang.String.class);
            this.type = this.jsiiGet("type", java.lang.String.class);
            this.tags = this.jsiiGet("tags", java.util.List.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.Number bgpAsn, java.lang.String ipAddress, java.lang.String type, java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bgpAsn = java.util.Objects.requireNonNull(bgpAsn, "bgpAsn is required");
            this.ipAddress = java.util.Objects.requireNonNull(ipAddress, "ipAddress is required");
            this.type = java.util.Objects.requireNonNull(type, "type is required");
            this.tags = tags;
        }

        @Override
        public java.lang.Number getBgpAsn() {
            return this.bgpAsn;
        }

        @Override
        public java.lang.String getIpAddress() {
            return this.ipAddress;
        }

        @Override
        public java.lang.String getType() {
            return this.type;
        }

        @Override
        public java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("bgpAsn", om.valueToTree(this.getBgpAsn()));
            obj.set("ipAddress", om.valueToTree(this.getIpAddress()));
            obj.set("type", om.valueToTree(this.getType()));
            if (this.getTags() != null) {
                obj.set("tags", om.valueToTree(this.getTags()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCustomerGatewayProps.Jsii$Proxy that = (CfnCustomerGatewayProps.Jsii$Proxy) o;

            if (!bgpAsn.equals(that.bgpAsn)) return false;
            if (!ipAddress.equals(that.ipAddress)) return false;
            if (!type.equals(that.type)) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public int hashCode() {
            int result = this.bgpAsn.hashCode();
            result = 31 * result + (this.ipAddress.hashCode());
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }

    }
}
