package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.16.0 (build 98909b5)", date = "2019-09-10T21:16:48.741Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate")
public class CfnLaunchTemplate extends software.amazon.awscdk.core.CfnResource {

    protected CfnLaunchTemplate(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnLaunchTemplate(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }
    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }
    /**
     * Create a new `AWS::EC2::LaunchTemplate`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnLaunchTemplate(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.ec2.CfnLaunchTemplateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props }));
    }
    /**
     * Create a new `AWS::EC2::LaunchTemplate`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnLaunchTemplate(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") }));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrDefaultVersionNumber() {
        return this.jsiiGet("attrDefaultVersionNumber", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrLatestVersionNumber() {
        return this.jsiiGet("attrLatestVersionNumber", java.lang.String.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return this.jsiiGet("cfnProperties", java.util.Map.class);
    }

    /**
     * `AWS::EC2::LaunchTemplate.LaunchTemplateData`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-launchtemplatedata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getLaunchTemplateData() {
        return this.jsiiGet("launchTemplateData", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::LaunchTemplate.LaunchTemplateData`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-launchtemplatedata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setLaunchTemplateData(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("launchTemplateData", value);
    }

    /**
     * `AWS::EC2::LaunchTemplate.LaunchTemplateData`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-launchtemplatedata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setLaunchTemplateData(final software.amazon.awscdk.services.ec2.CfnLaunchTemplate.LaunchTemplateDataProperty value) {
        this.jsiiSet("launchTemplateData", value);
    }

    /**
     * `AWS::EC2::LaunchTemplate.LaunchTemplateName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-launchtemplatename
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getLaunchTemplateName() {
        return this.jsiiGet("launchTemplateName", java.lang.String.class);
    }

    /**
     * `AWS::EC2::LaunchTemplate.LaunchTemplateName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-launchtemplatename
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setLaunchTemplateName(final java.lang.String value) {
        this.jsiiSet("launchTemplateName", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface BlockDeviceMappingProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.BlockDeviceMappingProperty.DeviceName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-devicename
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getDeviceName();

        /**
         * `CfnLaunchTemplate.BlockDeviceMappingProperty.Ebs`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getEbs();

        /**
         * `CfnLaunchTemplate.BlockDeviceMappingProperty.NoDevice`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-nodevice
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getNoDevice();

        /**
         * `CfnLaunchTemplate.BlockDeviceMappingProperty.VirtualName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-virtualname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getVirtualName();

        /**
         * @return a {@link Builder} of {@link BlockDeviceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link BlockDeviceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String deviceName;
            private java.lang.Object ebs;
            private java.lang.String noDevice;
            private java.lang.String virtualName;

            /**
             * Sets the value of DeviceName
             * @param deviceName `CfnLaunchTemplate.BlockDeviceMappingProperty.DeviceName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder deviceName(java.lang.String deviceName) {
                this.deviceName = deviceName;
                return this;
            }

            /**
             * Sets the value of Ebs
             * @param ebs `CfnLaunchTemplate.BlockDeviceMappingProperty.Ebs`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder ebs(software.amazon.awscdk.core.IResolvable ebs) {
                this.ebs = ebs;
                return this;
            }

            /**
             * Sets the value of Ebs
             * @param ebs `CfnLaunchTemplate.BlockDeviceMappingProperty.Ebs`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder ebs(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.EbsProperty ebs) {
                this.ebs = ebs;
                return this;
            }

            /**
             * Sets the value of NoDevice
             * @param noDevice `CfnLaunchTemplate.BlockDeviceMappingProperty.NoDevice`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder noDevice(java.lang.String noDevice) {
                this.noDevice = noDevice;
                return this;
            }

            /**
             * Sets the value of VirtualName
             * @param virtualName `CfnLaunchTemplate.BlockDeviceMappingProperty.VirtualName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder virtualName(java.lang.String virtualName) {
                this.virtualName = virtualName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BlockDeviceMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public BlockDeviceMappingProperty build() {
                return new Jsii$Proxy(deviceName, ebs, noDevice, virtualName);
            }

        }

        /**
         * An implementation for {@link BlockDeviceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BlockDeviceMappingProperty {
            private final java.lang.String deviceName;
            private final java.lang.Object ebs;
            private final java.lang.String noDevice;
            private final java.lang.String virtualName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.deviceName = this.jsiiGet("deviceName", java.lang.String.class);
                this.ebs = this.jsiiGet("ebs", java.lang.Object.class);
                this.noDevice = this.jsiiGet("noDevice", java.lang.String.class);
                this.virtualName = this.jsiiGet("virtualName", java.lang.String.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String deviceName, java.lang.Object ebs, java.lang.String noDevice, java.lang.String virtualName) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deviceName = deviceName;
                this.ebs = ebs;
                this.noDevice = noDevice;
                this.virtualName = virtualName;
            }

            @Override
            public java.lang.String getDeviceName() {
                return this.deviceName;
            }

            @Override
            public java.lang.Object getEbs() {
                return this.ebs;
            }

            @Override
            public java.lang.String getNoDevice() {
                return this.noDevice;
            }

            @Override
            public java.lang.String getVirtualName() {
                return this.virtualName;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getDeviceName() != null) {
                    obj.set("deviceName", om.valueToTree(this.getDeviceName()));
                }
                if (this.getEbs() != null) {
                    obj.set("ebs", om.valueToTree(this.getEbs()));
                }
                if (this.getNoDevice() != null) {
                    obj.set("noDevice", om.valueToTree(this.getNoDevice()));
                }
                if (this.getVirtualName() != null) {
                    obj.set("virtualName", om.valueToTree(this.getVirtualName()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BlockDeviceMappingProperty.Jsii$Proxy that = (BlockDeviceMappingProperty.Jsii$Proxy) o;

                if (this.deviceName != null ? !this.deviceName.equals(that.deviceName) : that.deviceName != null) return false;
                if (this.ebs != null ? !this.ebs.equals(that.ebs) : that.ebs != null) return false;
                if (this.noDevice != null ? !this.noDevice.equals(that.noDevice) : that.noDevice != null) return false;
                return this.virtualName != null ? this.virtualName.equals(that.virtualName) : that.virtualName == null;
            }

            @Override
            public int hashCode() {
                int result = this.deviceName != null ? this.deviceName.hashCode() : 0;
                result = 31 * result + (this.ebs != null ? this.ebs.hashCode() : 0);
                result = 31 * result + (this.noDevice != null ? this.noDevice.hashCode() : 0);
                result = 31 * result + (this.virtualName != null ? this.virtualName.hashCode() : 0);
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface CapacityReservationSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.CapacityReservationSpecificationProperty.CapacityReservationPreference`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification-capacityreservationpreference
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getCapacityReservationPreference();

        /**
         * `CfnLaunchTemplate.CapacityReservationSpecificationProperty.CapacityReservationTarget`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification-capacityreservationtarget
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getCapacityReservationTarget();

        /**
         * @return a {@link Builder} of {@link CapacityReservationSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CapacityReservationSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String capacityReservationPreference;
            private java.lang.Object capacityReservationTarget;

            /**
             * Sets the value of CapacityReservationPreference
             * @param capacityReservationPreference `CfnLaunchTemplate.CapacityReservationSpecificationProperty.CapacityReservationPreference`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder capacityReservationPreference(java.lang.String capacityReservationPreference) {
                this.capacityReservationPreference = capacityReservationPreference;
                return this;
            }

            /**
             * Sets the value of CapacityReservationTarget
             * @param capacityReservationTarget `CfnLaunchTemplate.CapacityReservationSpecificationProperty.CapacityReservationTarget`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder capacityReservationTarget(software.amazon.awscdk.core.IResolvable capacityReservationTarget) {
                this.capacityReservationTarget = capacityReservationTarget;
                return this;
            }

            /**
             * Sets the value of CapacityReservationTarget
             * @param capacityReservationTarget `CfnLaunchTemplate.CapacityReservationSpecificationProperty.CapacityReservationTarget`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder capacityReservationTarget(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.CapacityReservationTargetProperty capacityReservationTarget) {
                this.capacityReservationTarget = capacityReservationTarget;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CapacityReservationSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public CapacityReservationSpecificationProperty build() {
                return new Jsii$Proxy(capacityReservationPreference, capacityReservationTarget);
            }

        }

        /**
         * An implementation for {@link CapacityReservationSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CapacityReservationSpecificationProperty {
            private final java.lang.String capacityReservationPreference;
            private final java.lang.Object capacityReservationTarget;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.capacityReservationPreference = this.jsiiGet("capacityReservationPreference", java.lang.String.class);
                this.capacityReservationTarget = this.jsiiGet("capacityReservationTarget", java.lang.Object.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String capacityReservationPreference, java.lang.Object capacityReservationTarget) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.capacityReservationPreference = capacityReservationPreference;
                this.capacityReservationTarget = capacityReservationTarget;
            }

            @Override
            public java.lang.String getCapacityReservationPreference() {
                return this.capacityReservationPreference;
            }

            @Override
            public java.lang.Object getCapacityReservationTarget() {
                return this.capacityReservationTarget;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getCapacityReservationPreference() != null) {
                    obj.set("capacityReservationPreference", om.valueToTree(this.getCapacityReservationPreference()));
                }
                if (this.getCapacityReservationTarget() != null) {
                    obj.set("capacityReservationTarget", om.valueToTree(this.getCapacityReservationTarget()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CapacityReservationSpecificationProperty.Jsii$Proxy that = (CapacityReservationSpecificationProperty.Jsii$Proxy) o;

                if (this.capacityReservationPreference != null ? !this.capacityReservationPreference.equals(that.capacityReservationPreference) : that.capacityReservationPreference != null) return false;
                return this.capacityReservationTarget != null ? this.capacityReservationTarget.equals(that.capacityReservationTarget) : that.capacityReservationTarget == null;
            }

            @Override
            public int hashCode() {
                int result = this.capacityReservationPreference != null ? this.capacityReservationPreference.hashCode() : 0;
                result = 31 * result + (this.capacityReservationTarget != null ? this.capacityReservationTarget.hashCode() : 0);
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-capacityreservationtarget.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface CapacityReservationTargetProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.CapacityReservationTargetProperty.CapacityReservationId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-capacityreservationtarget.html#cfn-ec2-launchtemplate-capacityreservationtarget-capacityreservationid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getCapacityReservationId();

        /**
         * @return a {@link Builder} of {@link CapacityReservationTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CapacityReservationTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String capacityReservationId;

            /**
             * Sets the value of CapacityReservationId
             * @param capacityReservationId `CfnLaunchTemplate.CapacityReservationTargetProperty.CapacityReservationId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder capacityReservationId(java.lang.String capacityReservationId) {
                this.capacityReservationId = capacityReservationId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CapacityReservationTargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public CapacityReservationTargetProperty build() {
                return new Jsii$Proxy(capacityReservationId);
            }

        }

        /**
         * An implementation for {@link CapacityReservationTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CapacityReservationTargetProperty {
            private final java.lang.String capacityReservationId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.capacityReservationId = this.jsiiGet("capacityReservationId", java.lang.String.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String capacityReservationId) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.capacityReservationId = capacityReservationId;
            }

            @Override
            public java.lang.String getCapacityReservationId() {
                return this.capacityReservationId;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getCapacityReservationId() != null) {
                    obj.set("capacityReservationId", om.valueToTree(this.getCapacityReservationId()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CapacityReservationTargetProperty.Jsii$Proxy that = (CapacityReservationTargetProperty.Jsii$Proxy) o;

                return this.capacityReservationId != null ? this.capacityReservationId.equals(that.capacityReservationId) : that.capacityReservationId == null;
            }

            @Override
            public int hashCode() {
                int result = this.capacityReservationId != null ? this.capacityReservationId.hashCode() : 0;
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-cpuoptions.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface CpuOptionsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.CpuOptionsProperty.CoreCount`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-cpuoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-cpuoptions-corecount
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getCoreCount();

        /**
         * `CfnLaunchTemplate.CpuOptionsProperty.ThreadsPerCore`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-cpuoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-cpuoptions-threadspercore
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getThreadsPerCore();

        /**
         * @return a {@link Builder} of {@link CpuOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CpuOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.Number coreCount;
            private java.lang.Number threadsPerCore;

            /**
             * Sets the value of CoreCount
             * @param coreCount `CfnLaunchTemplate.CpuOptionsProperty.CoreCount`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder coreCount(java.lang.Number coreCount) {
                this.coreCount = coreCount;
                return this;
            }

            /**
             * Sets the value of ThreadsPerCore
             * @param threadsPerCore `CfnLaunchTemplate.CpuOptionsProperty.ThreadsPerCore`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder threadsPerCore(java.lang.Number threadsPerCore) {
                this.threadsPerCore = threadsPerCore;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CpuOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public CpuOptionsProperty build() {
                return new Jsii$Proxy(coreCount, threadsPerCore);
            }

        }

        /**
         * An implementation for {@link CpuOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CpuOptionsProperty {
            private final java.lang.Number coreCount;
            private final java.lang.Number threadsPerCore;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.coreCount = this.jsiiGet("coreCount", java.lang.Number.class);
                this.threadsPerCore = this.jsiiGet("threadsPerCore", java.lang.Number.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Number coreCount, java.lang.Number threadsPerCore) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.coreCount = coreCount;
                this.threadsPerCore = threadsPerCore;
            }

            @Override
            public java.lang.Number getCoreCount() {
                return this.coreCount;
            }

            @Override
            public java.lang.Number getThreadsPerCore() {
                return this.threadsPerCore;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getCoreCount() != null) {
                    obj.set("coreCount", om.valueToTree(this.getCoreCount()));
                }
                if (this.getThreadsPerCore() != null) {
                    obj.set("threadsPerCore", om.valueToTree(this.getThreadsPerCore()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CpuOptionsProperty.Jsii$Proxy that = (CpuOptionsProperty.Jsii$Proxy) o;

                if (this.coreCount != null ? !this.coreCount.equals(that.coreCount) : that.coreCount != null) return false;
                return this.threadsPerCore != null ? this.threadsPerCore.equals(that.threadsPerCore) : that.threadsPerCore == null;
            }

            @Override
            public int hashCode() {
                int result = this.coreCount != null ? this.coreCount.hashCode() : 0;
                result = 31 * result + (this.threadsPerCore != null ? this.threadsPerCore.hashCode() : 0);
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-creditspecification.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface CreditSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.CreditSpecificationProperty.CpuCredits`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-creditspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification-cpucredits
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getCpuCredits();

        /**
         * @return a {@link Builder} of {@link CreditSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CreditSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String cpuCredits;

            /**
             * Sets the value of CpuCredits
             * @param cpuCredits `CfnLaunchTemplate.CreditSpecificationProperty.CpuCredits`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder cpuCredits(java.lang.String cpuCredits) {
                this.cpuCredits = cpuCredits;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CreditSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public CreditSpecificationProperty build() {
                return new Jsii$Proxy(cpuCredits);
            }

        }

        /**
         * An implementation for {@link CreditSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CreditSpecificationProperty {
            private final java.lang.String cpuCredits;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.cpuCredits = this.jsiiGet("cpuCredits", java.lang.String.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String cpuCredits) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cpuCredits = cpuCredits;
            }

            @Override
            public java.lang.String getCpuCredits() {
                return this.cpuCredits;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getCpuCredits() != null) {
                    obj.set("cpuCredits", om.valueToTree(this.getCpuCredits()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CreditSpecificationProperty.Jsii$Proxy that = (CreditSpecificationProperty.Jsii$Proxy) o;

                return this.cpuCredits != null ? this.cpuCredits.equals(that.cpuCredits) : that.cpuCredits == null;
            }

            @Override
            public int hashCode() {
                int result = this.cpuCredits != null ? this.cpuCredits.hashCode() : 0;
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface EbsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.EbsProperty.DeleteOnTermination`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-deleteontermination
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getDeleteOnTermination();

        /**
         * `CfnLaunchTemplate.EbsProperty.Encrypted`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-encrypted
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getEncrypted();

        /**
         * `CfnLaunchTemplate.EbsProperty.Iops`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-iops
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getIops();

        /**
         * `CfnLaunchTemplate.EbsProperty.KmsKeyId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-kmskeyid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getKmsKeyId();

        /**
         * `CfnLaunchTemplate.EbsProperty.SnapshotId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-snapshotid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getSnapshotId();

        /**
         * `CfnLaunchTemplate.EbsProperty.VolumeSize`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumesize
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getVolumeSize();

        /**
         * `CfnLaunchTemplate.EbsProperty.VolumeType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getVolumeType();

        /**
         * @return a {@link Builder} of {@link EbsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link EbsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.Object deleteOnTermination;
            private java.lang.Object encrypted;
            private java.lang.Number iops;
            private java.lang.String kmsKeyId;
            private java.lang.String snapshotId;
            private java.lang.Number volumeSize;
            private java.lang.String volumeType;

            /**
             * Sets the value of DeleteOnTermination
             * @param deleteOnTermination `CfnLaunchTemplate.EbsProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder deleteOnTermination(java.lang.Boolean deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            /**
             * Sets the value of DeleteOnTermination
             * @param deleteOnTermination `CfnLaunchTemplate.EbsProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder deleteOnTermination(software.amazon.awscdk.core.IResolvable deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            /**
             * Sets the value of Encrypted
             * @param encrypted `CfnLaunchTemplate.EbsProperty.Encrypted`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder encrypted(java.lang.Boolean encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            /**
             * Sets the value of Encrypted
             * @param encrypted `CfnLaunchTemplate.EbsProperty.Encrypted`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder encrypted(software.amazon.awscdk.core.IResolvable encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            /**
             * Sets the value of Iops
             * @param iops `CfnLaunchTemplate.EbsProperty.Iops`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder iops(java.lang.Number iops) {
                this.iops = iops;
                return this;
            }

            /**
             * Sets the value of KmsKeyId
             * @param kmsKeyId `CfnLaunchTemplate.EbsProperty.KmsKeyId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Sets the value of SnapshotId
             * @param snapshotId `CfnLaunchTemplate.EbsProperty.SnapshotId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder snapshotId(java.lang.String snapshotId) {
                this.snapshotId = snapshotId;
                return this;
            }

            /**
             * Sets the value of VolumeSize
             * @param volumeSize `CfnLaunchTemplate.EbsProperty.VolumeSize`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder volumeSize(java.lang.Number volumeSize) {
                this.volumeSize = volumeSize;
                return this;
            }

            /**
             * Sets the value of VolumeType
             * @param volumeType `CfnLaunchTemplate.EbsProperty.VolumeType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder volumeType(java.lang.String volumeType) {
                this.volumeType = volumeType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EbsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public EbsProperty build() {
                return new Jsii$Proxy(deleteOnTermination, encrypted, iops, kmsKeyId, snapshotId, volumeSize, volumeType);
            }

        }

        /**
         * An implementation for {@link EbsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EbsProperty {
            private final java.lang.Object deleteOnTermination;
            private final java.lang.Object encrypted;
            private final java.lang.Number iops;
            private final java.lang.String kmsKeyId;
            private final java.lang.String snapshotId;
            private final java.lang.Number volumeSize;
            private final java.lang.String volumeType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.deleteOnTermination = this.jsiiGet("deleteOnTermination", java.lang.Object.class);
                this.encrypted = this.jsiiGet("encrypted", java.lang.Object.class);
                this.iops = this.jsiiGet("iops", java.lang.Number.class);
                this.kmsKeyId = this.jsiiGet("kmsKeyId", java.lang.String.class);
                this.snapshotId = this.jsiiGet("snapshotId", java.lang.String.class);
                this.volumeSize = this.jsiiGet("volumeSize", java.lang.Number.class);
                this.volumeType = this.jsiiGet("volumeType", java.lang.String.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object deleteOnTermination, java.lang.Object encrypted, java.lang.Number iops, java.lang.String kmsKeyId, java.lang.String snapshotId, java.lang.Number volumeSize, java.lang.String volumeType) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deleteOnTermination = deleteOnTermination;
                this.encrypted = encrypted;
                this.iops = iops;
                this.kmsKeyId = kmsKeyId;
                this.snapshotId = snapshotId;
                this.volumeSize = volumeSize;
                this.volumeType = volumeType;
            }

            @Override
            public java.lang.Object getDeleteOnTermination() {
                return this.deleteOnTermination;
            }

            @Override
            public java.lang.Object getEncrypted() {
                return this.encrypted;
            }

            @Override
            public java.lang.Number getIops() {
                return this.iops;
            }

            @Override
            public java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            public java.lang.String getSnapshotId() {
                return this.snapshotId;
            }

            @Override
            public java.lang.Number getVolumeSize() {
                return this.volumeSize;
            }

            @Override
            public java.lang.String getVolumeType() {
                return this.volumeType;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getDeleteOnTermination() != null) {
                    obj.set("deleteOnTermination", om.valueToTree(this.getDeleteOnTermination()));
                }
                if (this.getEncrypted() != null) {
                    obj.set("encrypted", om.valueToTree(this.getEncrypted()));
                }
                if (this.getIops() != null) {
                    obj.set("iops", om.valueToTree(this.getIops()));
                }
                if (this.getKmsKeyId() != null) {
                    obj.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }
                if (this.getSnapshotId() != null) {
                    obj.set("snapshotId", om.valueToTree(this.getSnapshotId()));
                }
                if (this.getVolumeSize() != null) {
                    obj.set("volumeSize", om.valueToTree(this.getVolumeSize()));
                }
                if (this.getVolumeType() != null) {
                    obj.set("volumeType", om.valueToTree(this.getVolumeType()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EbsProperty.Jsii$Proxy that = (EbsProperty.Jsii$Proxy) o;

                if (this.deleteOnTermination != null ? !this.deleteOnTermination.equals(that.deleteOnTermination) : that.deleteOnTermination != null) return false;
                if (this.encrypted != null ? !this.encrypted.equals(that.encrypted) : that.encrypted != null) return false;
                if (this.iops != null ? !this.iops.equals(that.iops) : that.iops != null) return false;
                if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
                if (this.snapshotId != null ? !this.snapshotId.equals(that.snapshotId) : that.snapshotId != null) return false;
                if (this.volumeSize != null ? !this.volumeSize.equals(that.volumeSize) : that.volumeSize != null) return false;
                return this.volumeType != null ? this.volumeType.equals(that.volumeType) : that.volumeType == null;
            }

            @Override
            public int hashCode() {
                int result = this.deleteOnTermination != null ? this.deleteOnTermination.hashCode() : 0;
                result = 31 * result + (this.encrypted != null ? this.encrypted.hashCode() : 0);
                result = 31 * result + (this.iops != null ? this.iops.hashCode() : 0);
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                result = 31 * result + (this.snapshotId != null ? this.snapshotId.hashCode() : 0);
                result = 31 * result + (this.volumeSize != null ? this.volumeSize.hashCode() : 0);
                result = 31 * result + (this.volumeType != null ? this.volumeType.hashCode() : 0);
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-elasticgpuspecification.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ElasticGpuSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.ElasticGpuSpecificationProperty.Type`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-elasticgpuspecification.html#cfn-ec2-launchtemplate-elasticgpuspecification-type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link ElasticGpuSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ElasticGpuSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String type;

            /**
             * Sets the value of Type
             * @param type `CfnLaunchTemplate.ElasticGpuSpecificationProperty.Type`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ElasticGpuSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ElasticGpuSpecificationProperty build() {
                return new Jsii$Proxy(type);
            }

        }

        /**
         * An implementation for {@link ElasticGpuSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ElasticGpuSpecificationProperty {
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.type = this.jsiiGet("type", java.lang.String.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String type) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = type;
            }

            @Override
            public java.lang.String getType() {
                return this.type;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getType() != null) {
                    obj.set("type", om.valueToTree(this.getType()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ElasticGpuSpecificationProperty.Jsii$Proxy that = (ElasticGpuSpecificationProperty.Jsii$Proxy) o;

                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public int hashCode() {
                int result = this.type != null ? this.type.hashCode() : 0;
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-hibernationoptions.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface HibernationOptionsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.HibernationOptionsProperty.Configured`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-hibernationoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-hibernationoptions-configured
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getConfigured();

        /**
         * @return a {@link Builder} of {@link HibernationOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link HibernationOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.Object configured;

            /**
             * Sets the value of Configured
             * @param configured `CfnLaunchTemplate.HibernationOptionsProperty.Configured`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder configured(java.lang.Boolean configured) {
                this.configured = configured;
                return this;
            }

            /**
             * Sets the value of Configured
             * @param configured `CfnLaunchTemplate.HibernationOptionsProperty.Configured`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder configured(software.amazon.awscdk.core.IResolvable configured) {
                this.configured = configured;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HibernationOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public HibernationOptionsProperty build() {
                return new Jsii$Proxy(configured);
            }

        }

        /**
         * An implementation for {@link HibernationOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HibernationOptionsProperty {
            private final java.lang.Object configured;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.configured = this.jsiiGet("configured", java.lang.Object.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object configured) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.configured = configured;
            }

            @Override
            public java.lang.Object getConfigured() {
                return this.configured;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getConfigured() != null) {
                    obj.set("configured", om.valueToTree(this.getConfigured()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HibernationOptionsProperty.Jsii$Proxy that = (HibernationOptionsProperty.Jsii$Proxy) o;

                return this.configured != null ? this.configured.equals(that.configured) : that.configured == null;
            }

            @Override
            public int hashCode() {
                int result = this.configured != null ? this.configured.hashCode() : 0;
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface IamInstanceProfileProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.IamInstanceProfileProperty.Arn`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-arn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getArn();

        /**
         * `CfnLaunchTemplate.IamInstanceProfileProperty.Name`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-name
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getName();

        /**
         * @return a {@link Builder} of {@link IamInstanceProfileProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link IamInstanceProfileProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String arn;
            private java.lang.String name;

            /**
             * Sets the value of Arn
             * @param arn `CfnLaunchTemplate.IamInstanceProfileProperty.Arn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Sets the value of Name
             * @param name `CfnLaunchTemplate.IamInstanceProfileProperty.Name`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IamInstanceProfileProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public IamInstanceProfileProperty build() {
                return new Jsii$Proxy(arn, name);
            }

        }

        /**
         * An implementation for {@link IamInstanceProfileProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IamInstanceProfileProperty {
            private final java.lang.String arn;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.arn = this.jsiiGet("arn", java.lang.String.class);
                this.name = this.jsiiGet("name", java.lang.String.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String arn, java.lang.String name) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = arn;
                this.name = name;
            }

            @Override
            public java.lang.String getArn() {
                return this.arn;
            }

            @Override
            public java.lang.String getName() {
                return this.name;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getArn() != null) {
                    obj.set("arn", om.valueToTree(this.getArn()));
                }
                if (this.getName() != null) {
                    obj.set("name", om.valueToTree(this.getName()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IamInstanceProfileProperty.Jsii$Proxy that = (IamInstanceProfileProperty.Jsii$Proxy) o;

                if (this.arn != null ? !this.arn.equals(that.arn) : that.arn != null) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public int hashCode() {
                int result = this.arn != null ? this.arn.hashCode() : 0;
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface InstanceMarketOptionsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.InstanceMarketOptionsProperty.MarketType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-markettype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getMarketType();

        /**
         * `CfnLaunchTemplate.InstanceMarketOptionsProperty.SpotOptions`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getSpotOptions();

        /**
         * @return a {@link Builder} of {@link InstanceMarketOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link InstanceMarketOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String marketType;
            private java.lang.Object spotOptions;

            /**
             * Sets the value of MarketType
             * @param marketType `CfnLaunchTemplate.InstanceMarketOptionsProperty.MarketType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder marketType(java.lang.String marketType) {
                this.marketType = marketType;
                return this;
            }

            /**
             * Sets the value of SpotOptions
             * @param spotOptions `CfnLaunchTemplate.InstanceMarketOptionsProperty.SpotOptions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder spotOptions(software.amazon.awscdk.core.IResolvable spotOptions) {
                this.spotOptions = spotOptions;
                return this;
            }

            /**
             * Sets the value of SpotOptions
             * @param spotOptions `CfnLaunchTemplate.InstanceMarketOptionsProperty.SpotOptions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder spotOptions(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.SpotOptionsProperty spotOptions) {
                this.spotOptions = spotOptions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceMarketOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public InstanceMarketOptionsProperty build() {
                return new Jsii$Proxy(marketType, spotOptions);
            }

        }

        /**
         * An implementation for {@link InstanceMarketOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceMarketOptionsProperty {
            private final java.lang.String marketType;
            private final java.lang.Object spotOptions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.marketType = this.jsiiGet("marketType", java.lang.String.class);
                this.spotOptions = this.jsiiGet("spotOptions", java.lang.Object.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String marketType, java.lang.Object spotOptions) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.marketType = marketType;
                this.spotOptions = spotOptions;
            }

            @Override
            public java.lang.String getMarketType() {
                return this.marketType;
            }

            @Override
            public java.lang.Object getSpotOptions() {
                return this.spotOptions;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getMarketType() != null) {
                    obj.set("marketType", om.valueToTree(this.getMarketType()));
                }
                if (this.getSpotOptions() != null) {
                    obj.set("spotOptions", om.valueToTree(this.getSpotOptions()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceMarketOptionsProperty.Jsii$Proxy that = (InstanceMarketOptionsProperty.Jsii$Proxy) o;

                if (this.marketType != null ? !this.marketType.equals(that.marketType) : that.marketType != null) return false;
                return this.spotOptions != null ? this.spotOptions.equals(that.spotOptions) : that.spotOptions == null;
            }

            @Override
            public int hashCode() {
                int result = this.marketType != null ? this.marketType.hashCode() : 0;
                result = 31 * result + (this.spotOptions != null ? this.spotOptions.hashCode() : 0);
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-ipv6add.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface Ipv6AddProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.Ipv6AddProperty.Ipv6Address`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-ipv6add.html#cfn-ec2-launchtemplate-ipv6add-ipv6address
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getIpv6Address();

        /**
         * @return a {@link Builder} of {@link Ipv6AddProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link Ipv6AddProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String ipv6Address;

            /**
             * Sets the value of Ipv6Address
             * @param ipv6Address `CfnLaunchTemplate.Ipv6AddProperty.Ipv6Address`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder ipv6Address(java.lang.String ipv6Address) {
                this.ipv6Address = ipv6Address;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link Ipv6AddProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Ipv6AddProperty build() {
                return new Jsii$Proxy(ipv6Address);
            }

        }

        /**
         * An implementation for {@link Ipv6AddProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Ipv6AddProperty {
            private final java.lang.String ipv6Address;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.ipv6Address = this.jsiiGet("ipv6Address", java.lang.String.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String ipv6Address) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ipv6Address = ipv6Address;
            }

            @Override
            public java.lang.String getIpv6Address() {
                return this.ipv6Address;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getIpv6Address() != null) {
                    obj.set("ipv6Address", om.valueToTree(this.getIpv6Address()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                Ipv6AddProperty.Jsii$Proxy that = (Ipv6AddProperty.Jsii$Proxy) o;

                return this.ipv6Address != null ? this.ipv6Address.equals(that.ipv6Address) : that.ipv6Address == null;
            }

            @Override
            public int hashCode() {
                int result = this.ipv6Address != null ? this.ipv6Address.hashCode() : 0;
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface LaunchTemplateDataProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.BlockDeviceMappings`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-blockdevicemappings
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getBlockDeviceMappings();

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.CapacityReservationSpecification`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getCapacityReservationSpecification();

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.CpuOptions`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-cpuoptions
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getCpuOptions();

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.CreditSpecification`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getCreditSpecification();

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.DisableApiTermination`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-disableapitermination
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getDisableApiTermination();

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.EbsOptimized`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ebsoptimized
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getEbsOptimized();

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticGpuSpecifications`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-elasticgpuspecifications
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getElasticGpuSpecifications();

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticInferenceAccelerators`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-elasticinferenceaccelerators
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getElasticInferenceAccelerators();

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.HibernationOptions`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-hibernationoptions
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getHibernationOptions();

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.IamInstanceProfile`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getIamInstanceProfile();

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.ImageId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-imageid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getImageId();

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceInitiatedShutdownBehavior`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instanceinitiatedshutdownbehavior
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getInstanceInitiatedShutdownBehavior();

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceMarketOptions`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getInstanceMarketOptions();

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getInstanceType();

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.KernelId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-kernelid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getKernelId();

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.KeyName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-keyname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getKeyName();

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.LicenseSpecifications`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-licensespecifications
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getLicenseSpecifications();

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.Monitoring`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getMonitoring();

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.NetworkInterfaces`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-networkinterfaces
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getNetworkInterfaces();

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.Placement`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-placement
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getPlacement();

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.RamDiskId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ramdiskid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getRamDiskId();

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.SecurityGroupIds`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroupids
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.util.List<java.lang.String> getSecurityGroupIds();

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.SecurityGroups`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroups
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.util.List<java.lang.String> getSecurityGroups();

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.TagSpecifications`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-tagspecifications
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getTagSpecifications();

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.UserData`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-userdata
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getUserData();

        /**
         * @return a {@link Builder} of {@link LaunchTemplateDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LaunchTemplateDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.Object blockDeviceMappings;
            private java.lang.Object capacityReservationSpecification;
            private java.lang.Object cpuOptions;
            private java.lang.Object creditSpecification;
            private java.lang.Object disableApiTermination;
            private java.lang.Object ebsOptimized;
            private java.lang.Object elasticGpuSpecifications;
            private java.lang.Object elasticInferenceAccelerators;
            private java.lang.Object hibernationOptions;
            private java.lang.Object iamInstanceProfile;
            private java.lang.String imageId;
            private java.lang.String instanceInitiatedShutdownBehavior;
            private java.lang.Object instanceMarketOptions;
            private java.lang.String instanceType;
            private java.lang.String kernelId;
            private java.lang.String keyName;
            private java.lang.Object licenseSpecifications;
            private java.lang.Object monitoring;
            private java.lang.Object networkInterfaces;
            private java.lang.Object placement;
            private java.lang.String ramDiskId;
            private java.util.List<java.lang.String> securityGroupIds;
            private java.util.List<java.lang.String> securityGroups;
            private java.lang.Object tagSpecifications;
            private java.lang.String userData;

            /**
             * Sets the value of BlockDeviceMappings
             * @param blockDeviceMappings `CfnLaunchTemplate.LaunchTemplateDataProperty.BlockDeviceMappings`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder blockDeviceMappings(software.amazon.awscdk.core.IResolvable blockDeviceMappings) {
                this.blockDeviceMappings = blockDeviceMappings;
                return this;
            }

            /**
             * Sets the value of BlockDeviceMappings
             * @param blockDeviceMappings `CfnLaunchTemplate.LaunchTemplateDataProperty.BlockDeviceMappings`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder blockDeviceMappings(java.util.List<java.lang.Object> blockDeviceMappings) {
                this.blockDeviceMappings = blockDeviceMappings;
                return this;
            }

            /**
             * Sets the value of CapacityReservationSpecification
             * @param capacityReservationSpecification `CfnLaunchTemplate.LaunchTemplateDataProperty.CapacityReservationSpecification`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder capacityReservationSpecification(software.amazon.awscdk.core.IResolvable capacityReservationSpecification) {
                this.capacityReservationSpecification = capacityReservationSpecification;
                return this;
            }

            /**
             * Sets the value of CapacityReservationSpecification
             * @param capacityReservationSpecification `CfnLaunchTemplate.LaunchTemplateDataProperty.CapacityReservationSpecification`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder capacityReservationSpecification(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.CapacityReservationSpecificationProperty capacityReservationSpecification) {
                this.capacityReservationSpecification = capacityReservationSpecification;
                return this;
            }

            /**
             * Sets the value of CpuOptions
             * @param cpuOptions `CfnLaunchTemplate.LaunchTemplateDataProperty.CpuOptions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder cpuOptions(software.amazon.awscdk.core.IResolvable cpuOptions) {
                this.cpuOptions = cpuOptions;
                return this;
            }

            /**
             * Sets the value of CpuOptions
             * @param cpuOptions `CfnLaunchTemplate.LaunchTemplateDataProperty.CpuOptions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder cpuOptions(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.CpuOptionsProperty cpuOptions) {
                this.cpuOptions = cpuOptions;
                return this;
            }

            /**
             * Sets the value of CreditSpecification
             * @param creditSpecification `CfnLaunchTemplate.LaunchTemplateDataProperty.CreditSpecification`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder creditSpecification(software.amazon.awscdk.core.IResolvable creditSpecification) {
                this.creditSpecification = creditSpecification;
                return this;
            }

            /**
             * Sets the value of CreditSpecification
             * @param creditSpecification `CfnLaunchTemplate.LaunchTemplateDataProperty.CreditSpecification`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder creditSpecification(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.CreditSpecificationProperty creditSpecification) {
                this.creditSpecification = creditSpecification;
                return this;
            }

            /**
             * Sets the value of DisableApiTermination
             * @param disableApiTermination `CfnLaunchTemplate.LaunchTemplateDataProperty.DisableApiTermination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder disableApiTermination(java.lang.Boolean disableApiTermination) {
                this.disableApiTermination = disableApiTermination;
                return this;
            }

            /**
             * Sets the value of DisableApiTermination
             * @param disableApiTermination `CfnLaunchTemplate.LaunchTemplateDataProperty.DisableApiTermination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder disableApiTermination(software.amazon.awscdk.core.IResolvable disableApiTermination) {
                this.disableApiTermination = disableApiTermination;
                return this;
            }

            /**
             * Sets the value of EbsOptimized
             * @param ebsOptimized `CfnLaunchTemplate.LaunchTemplateDataProperty.EbsOptimized`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder ebsOptimized(java.lang.Boolean ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            /**
             * Sets the value of EbsOptimized
             * @param ebsOptimized `CfnLaunchTemplate.LaunchTemplateDataProperty.EbsOptimized`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder ebsOptimized(software.amazon.awscdk.core.IResolvable ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            /**
             * Sets the value of ElasticGpuSpecifications
             * @param elasticGpuSpecifications `CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticGpuSpecifications`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder elasticGpuSpecifications(software.amazon.awscdk.core.IResolvable elasticGpuSpecifications) {
                this.elasticGpuSpecifications = elasticGpuSpecifications;
                return this;
            }

            /**
             * Sets the value of ElasticGpuSpecifications
             * @param elasticGpuSpecifications `CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticGpuSpecifications`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder elasticGpuSpecifications(java.util.List<java.lang.Object> elasticGpuSpecifications) {
                this.elasticGpuSpecifications = elasticGpuSpecifications;
                return this;
            }

            /**
             * Sets the value of ElasticInferenceAccelerators
             * @param elasticInferenceAccelerators `CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticInferenceAccelerators`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder elasticInferenceAccelerators(software.amazon.awscdk.core.IResolvable elasticInferenceAccelerators) {
                this.elasticInferenceAccelerators = elasticInferenceAccelerators;
                return this;
            }

            /**
             * Sets the value of ElasticInferenceAccelerators
             * @param elasticInferenceAccelerators `CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticInferenceAccelerators`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder elasticInferenceAccelerators(java.util.List<java.lang.Object> elasticInferenceAccelerators) {
                this.elasticInferenceAccelerators = elasticInferenceAccelerators;
                return this;
            }

            /**
             * Sets the value of HibernationOptions
             * @param hibernationOptions `CfnLaunchTemplate.LaunchTemplateDataProperty.HibernationOptions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder hibernationOptions(software.amazon.awscdk.core.IResolvable hibernationOptions) {
                this.hibernationOptions = hibernationOptions;
                return this;
            }

            /**
             * Sets the value of HibernationOptions
             * @param hibernationOptions `CfnLaunchTemplate.LaunchTemplateDataProperty.HibernationOptions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder hibernationOptions(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.HibernationOptionsProperty hibernationOptions) {
                this.hibernationOptions = hibernationOptions;
                return this;
            }

            /**
             * Sets the value of IamInstanceProfile
             * @param iamInstanceProfile `CfnLaunchTemplate.LaunchTemplateDataProperty.IamInstanceProfile`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder iamInstanceProfile(software.amazon.awscdk.core.IResolvable iamInstanceProfile) {
                this.iamInstanceProfile = iamInstanceProfile;
                return this;
            }

            /**
             * Sets the value of IamInstanceProfile
             * @param iamInstanceProfile `CfnLaunchTemplate.LaunchTemplateDataProperty.IamInstanceProfile`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder iamInstanceProfile(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.IamInstanceProfileProperty iamInstanceProfile) {
                this.iamInstanceProfile = iamInstanceProfile;
                return this;
            }

            /**
             * Sets the value of ImageId
             * @param imageId `CfnLaunchTemplate.LaunchTemplateDataProperty.ImageId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder imageId(java.lang.String imageId) {
                this.imageId = imageId;
                return this;
            }

            /**
             * Sets the value of InstanceInitiatedShutdownBehavior
             * @param instanceInitiatedShutdownBehavior `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceInitiatedShutdownBehavior`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder instanceInitiatedShutdownBehavior(java.lang.String instanceInitiatedShutdownBehavior) {
                this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
                return this;
            }

            /**
             * Sets the value of InstanceMarketOptions
             * @param instanceMarketOptions `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceMarketOptions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder instanceMarketOptions(software.amazon.awscdk.core.IResolvable instanceMarketOptions) {
                this.instanceMarketOptions = instanceMarketOptions;
                return this;
            }

            /**
             * Sets the value of InstanceMarketOptions
             * @param instanceMarketOptions `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceMarketOptions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder instanceMarketOptions(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.InstanceMarketOptionsProperty instanceMarketOptions) {
                this.instanceMarketOptions = instanceMarketOptions;
                return this;
            }

            /**
             * Sets the value of InstanceType
             * @param instanceType `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of KernelId
             * @param kernelId `CfnLaunchTemplate.LaunchTemplateDataProperty.KernelId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder kernelId(java.lang.String kernelId) {
                this.kernelId = kernelId;
                return this;
            }

            /**
             * Sets the value of KeyName
             * @param keyName `CfnLaunchTemplate.LaunchTemplateDataProperty.KeyName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder keyName(java.lang.String keyName) {
                this.keyName = keyName;
                return this;
            }

            /**
             * Sets the value of LicenseSpecifications
             * @param licenseSpecifications `CfnLaunchTemplate.LaunchTemplateDataProperty.LicenseSpecifications`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder licenseSpecifications(software.amazon.awscdk.core.IResolvable licenseSpecifications) {
                this.licenseSpecifications = licenseSpecifications;
                return this;
            }

            /**
             * Sets the value of LicenseSpecifications
             * @param licenseSpecifications `CfnLaunchTemplate.LaunchTemplateDataProperty.LicenseSpecifications`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder licenseSpecifications(java.util.List<java.lang.Object> licenseSpecifications) {
                this.licenseSpecifications = licenseSpecifications;
                return this;
            }

            /**
             * Sets the value of Monitoring
             * @param monitoring `CfnLaunchTemplate.LaunchTemplateDataProperty.Monitoring`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder monitoring(software.amazon.awscdk.core.IResolvable monitoring) {
                this.monitoring = monitoring;
                return this;
            }

            /**
             * Sets the value of Monitoring
             * @param monitoring `CfnLaunchTemplate.LaunchTemplateDataProperty.Monitoring`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder monitoring(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.MonitoringProperty monitoring) {
                this.monitoring = monitoring;
                return this;
            }

            /**
             * Sets the value of NetworkInterfaces
             * @param networkInterfaces `CfnLaunchTemplate.LaunchTemplateDataProperty.NetworkInterfaces`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder networkInterfaces(software.amazon.awscdk.core.IResolvable networkInterfaces) {
                this.networkInterfaces = networkInterfaces;
                return this;
            }

            /**
             * Sets the value of NetworkInterfaces
             * @param networkInterfaces `CfnLaunchTemplate.LaunchTemplateDataProperty.NetworkInterfaces`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder networkInterfaces(java.util.List<java.lang.Object> networkInterfaces) {
                this.networkInterfaces = networkInterfaces;
                return this;
            }

            /**
             * Sets the value of Placement
             * @param placement `CfnLaunchTemplate.LaunchTemplateDataProperty.Placement`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder placement(software.amazon.awscdk.core.IResolvable placement) {
                this.placement = placement;
                return this;
            }

            /**
             * Sets the value of Placement
             * @param placement `CfnLaunchTemplate.LaunchTemplateDataProperty.Placement`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder placement(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.PlacementProperty placement) {
                this.placement = placement;
                return this;
            }

            /**
             * Sets the value of RamDiskId
             * @param ramDiskId `CfnLaunchTemplate.LaunchTemplateDataProperty.RamDiskId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder ramDiskId(java.lang.String ramDiskId) {
                this.ramDiskId = ramDiskId;
                return this;
            }

            /**
             * Sets the value of SecurityGroupIds
             * @param securityGroupIds `CfnLaunchTemplate.LaunchTemplateDataProperty.SecurityGroupIds`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of SecurityGroups
             * @param securityGroups `CfnLaunchTemplate.LaunchTemplateDataProperty.SecurityGroups`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder securityGroups(java.util.List<java.lang.String> securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            /**
             * Sets the value of TagSpecifications
             * @param tagSpecifications `CfnLaunchTemplate.LaunchTemplateDataProperty.TagSpecifications`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder tagSpecifications(software.amazon.awscdk.core.IResolvable tagSpecifications) {
                this.tagSpecifications = tagSpecifications;
                return this;
            }

            /**
             * Sets the value of TagSpecifications
             * @param tagSpecifications `CfnLaunchTemplate.LaunchTemplateDataProperty.TagSpecifications`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder tagSpecifications(java.util.List<java.lang.Object> tagSpecifications) {
                this.tagSpecifications = tagSpecifications;
                return this;
            }

            /**
             * Sets the value of UserData
             * @param userData `CfnLaunchTemplate.LaunchTemplateDataProperty.UserData`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder userData(java.lang.String userData) {
                this.userData = userData;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LaunchTemplateDataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public LaunchTemplateDataProperty build() {
                return new Jsii$Proxy(blockDeviceMappings, capacityReservationSpecification, cpuOptions, creditSpecification, disableApiTermination, ebsOptimized, elasticGpuSpecifications, elasticInferenceAccelerators, hibernationOptions, iamInstanceProfile, imageId, instanceInitiatedShutdownBehavior, instanceMarketOptions, instanceType, kernelId, keyName, licenseSpecifications, monitoring, networkInterfaces, placement, ramDiskId, securityGroupIds, securityGroups, tagSpecifications, userData);
            }

        }

        /**
         * An implementation for {@link LaunchTemplateDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LaunchTemplateDataProperty {
            private final java.lang.Object blockDeviceMappings;
            private final java.lang.Object capacityReservationSpecification;
            private final java.lang.Object cpuOptions;
            private final java.lang.Object creditSpecification;
            private final java.lang.Object disableApiTermination;
            private final java.lang.Object ebsOptimized;
            private final java.lang.Object elasticGpuSpecifications;
            private final java.lang.Object elasticInferenceAccelerators;
            private final java.lang.Object hibernationOptions;
            private final java.lang.Object iamInstanceProfile;
            private final java.lang.String imageId;
            private final java.lang.String instanceInitiatedShutdownBehavior;
            private final java.lang.Object instanceMarketOptions;
            private final java.lang.String instanceType;
            private final java.lang.String kernelId;
            private final java.lang.String keyName;
            private final java.lang.Object licenseSpecifications;
            private final java.lang.Object monitoring;
            private final java.lang.Object networkInterfaces;
            private final java.lang.Object placement;
            private final java.lang.String ramDiskId;
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.util.List<java.lang.String> securityGroups;
            private final java.lang.Object tagSpecifications;
            private final java.lang.String userData;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.blockDeviceMappings = this.jsiiGet("blockDeviceMappings", java.lang.Object.class);
                this.capacityReservationSpecification = this.jsiiGet("capacityReservationSpecification", java.lang.Object.class);
                this.cpuOptions = this.jsiiGet("cpuOptions", java.lang.Object.class);
                this.creditSpecification = this.jsiiGet("creditSpecification", java.lang.Object.class);
                this.disableApiTermination = this.jsiiGet("disableApiTermination", java.lang.Object.class);
                this.ebsOptimized = this.jsiiGet("ebsOptimized", java.lang.Object.class);
                this.elasticGpuSpecifications = this.jsiiGet("elasticGpuSpecifications", java.lang.Object.class);
                this.elasticInferenceAccelerators = this.jsiiGet("elasticInferenceAccelerators", java.lang.Object.class);
                this.hibernationOptions = this.jsiiGet("hibernationOptions", java.lang.Object.class);
                this.iamInstanceProfile = this.jsiiGet("iamInstanceProfile", java.lang.Object.class);
                this.imageId = this.jsiiGet("imageId", java.lang.String.class);
                this.instanceInitiatedShutdownBehavior = this.jsiiGet("instanceInitiatedShutdownBehavior", java.lang.String.class);
                this.instanceMarketOptions = this.jsiiGet("instanceMarketOptions", java.lang.Object.class);
                this.instanceType = this.jsiiGet("instanceType", java.lang.String.class);
                this.kernelId = this.jsiiGet("kernelId", java.lang.String.class);
                this.keyName = this.jsiiGet("keyName", java.lang.String.class);
                this.licenseSpecifications = this.jsiiGet("licenseSpecifications", java.lang.Object.class);
                this.monitoring = this.jsiiGet("monitoring", java.lang.Object.class);
                this.networkInterfaces = this.jsiiGet("networkInterfaces", java.lang.Object.class);
                this.placement = this.jsiiGet("placement", java.lang.Object.class);
                this.ramDiskId = this.jsiiGet("ramDiskId", java.lang.String.class);
                this.securityGroupIds = this.jsiiGet("securityGroupIds", java.util.List.class);
                this.securityGroups = this.jsiiGet("securityGroups", java.util.List.class);
                this.tagSpecifications = this.jsiiGet("tagSpecifications", java.lang.Object.class);
                this.userData = this.jsiiGet("userData", java.lang.String.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object blockDeviceMappings, java.lang.Object capacityReservationSpecification, java.lang.Object cpuOptions, java.lang.Object creditSpecification, java.lang.Object disableApiTermination, java.lang.Object ebsOptimized, java.lang.Object elasticGpuSpecifications, java.lang.Object elasticInferenceAccelerators, java.lang.Object hibernationOptions, java.lang.Object iamInstanceProfile, java.lang.String imageId, java.lang.String instanceInitiatedShutdownBehavior, java.lang.Object instanceMarketOptions, java.lang.String instanceType, java.lang.String kernelId, java.lang.String keyName, java.lang.Object licenseSpecifications, java.lang.Object monitoring, java.lang.Object networkInterfaces, java.lang.Object placement, java.lang.String ramDiskId, java.util.List<java.lang.String> securityGroupIds, java.util.List<java.lang.String> securityGroups, java.lang.Object tagSpecifications, java.lang.String userData) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.blockDeviceMappings = blockDeviceMappings;
                this.capacityReservationSpecification = capacityReservationSpecification;
                this.cpuOptions = cpuOptions;
                this.creditSpecification = creditSpecification;
                this.disableApiTermination = disableApiTermination;
                this.ebsOptimized = ebsOptimized;
                this.elasticGpuSpecifications = elasticGpuSpecifications;
                this.elasticInferenceAccelerators = elasticInferenceAccelerators;
                this.hibernationOptions = hibernationOptions;
                this.iamInstanceProfile = iamInstanceProfile;
                this.imageId = imageId;
                this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
                this.instanceMarketOptions = instanceMarketOptions;
                this.instanceType = instanceType;
                this.kernelId = kernelId;
                this.keyName = keyName;
                this.licenseSpecifications = licenseSpecifications;
                this.monitoring = monitoring;
                this.networkInterfaces = networkInterfaces;
                this.placement = placement;
                this.ramDiskId = ramDiskId;
                this.securityGroupIds = securityGroupIds;
                this.securityGroups = securityGroups;
                this.tagSpecifications = tagSpecifications;
                this.userData = userData;
            }

            @Override
            public java.lang.Object getBlockDeviceMappings() {
                return this.blockDeviceMappings;
            }

            @Override
            public java.lang.Object getCapacityReservationSpecification() {
                return this.capacityReservationSpecification;
            }

            @Override
            public java.lang.Object getCpuOptions() {
                return this.cpuOptions;
            }

            @Override
            public java.lang.Object getCreditSpecification() {
                return this.creditSpecification;
            }

            @Override
            public java.lang.Object getDisableApiTermination() {
                return this.disableApiTermination;
            }

            @Override
            public java.lang.Object getEbsOptimized() {
                return this.ebsOptimized;
            }

            @Override
            public java.lang.Object getElasticGpuSpecifications() {
                return this.elasticGpuSpecifications;
            }

            @Override
            public java.lang.Object getElasticInferenceAccelerators() {
                return this.elasticInferenceAccelerators;
            }

            @Override
            public java.lang.Object getHibernationOptions() {
                return this.hibernationOptions;
            }

            @Override
            public java.lang.Object getIamInstanceProfile() {
                return this.iamInstanceProfile;
            }

            @Override
            public java.lang.String getImageId() {
                return this.imageId;
            }

            @Override
            public java.lang.String getInstanceInitiatedShutdownBehavior() {
                return this.instanceInitiatedShutdownBehavior;
            }

            @Override
            public java.lang.Object getInstanceMarketOptions() {
                return this.instanceMarketOptions;
            }

            @Override
            public java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public java.lang.String getKernelId() {
                return this.kernelId;
            }

            @Override
            public java.lang.String getKeyName() {
                return this.keyName;
            }

            @Override
            public java.lang.Object getLicenseSpecifications() {
                return this.licenseSpecifications;
            }

            @Override
            public java.lang.Object getMonitoring() {
                return this.monitoring;
            }

            @Override
            public java.lang.Object getNetworkInterfaces() {
                return this.networkInterfaces;
            }

            @Override
            public java.lang.Object getPlacement() {
                return this.placement;
            }

            @Override
            public java.lang.String getRamDiskId() {
                return this.ramDiskId;
            }

            @Override
            public java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public java.util.List<java.lang.String> getSecurityGroups() {
                return this.securityGroups;
            }

            @Override
            public java.lang.Object getTagSpecifications() {
                return this.tagSpecifications;
            }

            @Override
            public java.lang.String getUserData() {
                return this.userData;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getBlockDeviceMappings() != null) {
                    obj.set("blockDeviceMappings", om.valueToTree(this.getBlockDeviceMappings()));
                }
                if (this.getCapacityReservationSpecification() != null) {
                    obj.set("capacityReservationSpecification", om.valueToTree(this.getCapacityReservationSpecification()));
                }
                if (this.getCpuOptions() != null) {
                    obj.set("cpuOptions", om.valueToTree(this.getCpuOptions()));
                }
                if (this.getCreditSpecification() != null) {
                    obj.set("creditSpecification", om.valueToTree(this.getCreditSpecification()));
                }
                if (this.getDisableApiTermination() != null) {
                    obj.set("disableApiTermination", om.valueToTree(this.getDisableApiTermination()));
                }
                if (this.getEbsOptimized() != null) {
                    obj.set("ebsOptimized", om.valueToTree(this.getEbsOptimized()));
                }
                if (this.getElasticGpuSpecifications() != null) {
                    obj.set("elasticGpuSpecifications", om.valueToTree(this.getElasticGpuSpecifications()));
                }
                if (this.getElasticInferenceAccelerators() != null) {
                    obj.set("elasticInferenceAccelerators", om.valueToTree(this.getElasticInferenceAccelerators()));
                }
                if (this.getHibernationOptions() != null) {
                    obj.set("hibernationOptions", om.valueToTree(this.getHibernationOptions()));
                }
                if (this.getIamInstanceProfile() != null) {
                    obj.set("iamInstanceProfile", om.valueToTree(this.getIamInstanceProfile()));
                }
                if (this.getImageId() != null) {
                    obj.set("imageId", om.valueToTree(this.getImageId()));
                }
                if (this.getInstanceInitiatedShutdownBehavior() != null) {
                    obj.set("instanceInitiatedShutdownBehavior", om.valueToTree(this.getInstanceInitiatedShutdownBehavior()));
                }
                if (this.getInstanceMarketOptions() != null) {
                    obj.set("instanceMarketOptions", om.valueToTree(this.getInstanceMarketOptions()));
                }
                if (this.getInstanceType() != null) {
                    obj.set("instanceType", om.valueToTree(this.getInstanceType()));
                }
                if (this.getKernelId() != null) {
                    obj.set("kernelId", om.valueToTree(this.getKernelId()));
                }
                if (this.getKeyName() != null) {
                    obj.set("keyName", om.valueToTree(this.getKeyName()));
                }
                if (this.getLicenseSpecifications() != null) {
                    obj.set("licenseSpecifications", om.valueToTree(this.getLicenseSpecifications()));
                }
                if (this.getMonitoring() != null) {
                    obj.set("monitoring", om.valueToTree(this.getMonitoring()));
                }
                if (this.getNetworkInterfaces() != null) {
                    obj.set("networkInterfaces", om.valueToTree(this.getNetworkInterfaces()));
                }
                if (this.getPlacement() != null) {
                    obj.set("placement", om.valueToTree(this.getPlacement()));
                }
                if (this.getRamDiskId() != null) {
                    obj.set("ramDiskId", om.valueToTree(this.getRamDiskId()));
                }
                if (this.getSecurityGroupIds() != null) {
                    obj.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                }
                if (this.getSecurityGroups() != null) {
                    obj.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
                }
                if (this.getTagSpecifications() != null) {
                    obj.set("tagSpecifications", om.valueToTree(this.getTagSpecifications()));
                }
                if (this.getUserData() != null) {
                    obj.set("userData", om.valueToTree(this.getUserData()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LaunchTemplateDataProperty.Jsii$Proxy that = (LaunchTemplateDataProperty.Jsii$Proxy) o;

                if (this.blockDeviceMappings != null ? !this.blockDeviceMappings.equals(that.blockDeviceMappings) : that.blockDeviceMappings != null) return false;
                if (this.capacityReservationSpecification != null ? !this.capacityReservationSpecification.equals(that.capacityReservationSpecification) : that.capacityReservationSpecification != null) return false;
                if (this.cpuOptions != null ? !this.cpuOptions.equals(that.cpuOptions) : that.cpuOptions != null) return false;
                if (this.creditSpecification != null ? !this.creditSpecification.equals(that.creditSpecification) : that.creditSpecification != null) return false;
                if (this.disableApiTermination != null ? !this.disableApiTermination.equals(that.disableApiTermination) : that.disableApiTermination != null) return false;
                if (this.ebsOptimized != null ? !this.ebsOptimized.equals(that.ebsOptimized) : that.ebsOptimized != null) return false;
                if (this.elasticGpuSpecifications != null ? !this.elasticGpuSpecifications.equals(that.elasticGpuSpecifications) : that.elasticGpuSpecifications != null) return false;
                if (this.elasticInferenceAccelerators != null ? !this.elasticInferenceAccelerators.equals(that.elasticInferenceAccelerators) : that.elasticInferenceAccelerators != null) return false;
                if (this.hibernationOptions != null ? !this.hibernationOptions.equals(that.hibernationOptions) : that.hibernationOptions != null) return false;
                if (this.iamInstanceProfile != null ? !this.iamInstanceProfile.equals(that.iamInstanceProfile) : that.iamInstanceProfile != null) return false;
                if (this.imageId != null ? !this.imageId.equals(that.imageId) : that.imageId != null) return false;
                if (this.instanceInitiatedShutdownBehavior != null ? !this.instanceInitiatedShutdownBehavior.equals(that.instanceInitiatedShutdownBehavior) : that.instanceInitiatedShutdownBehavior != null) return false;
                if (this.instanceMarketOptions != null ? !this.instanceMarketOptions.equals(that.instanceMarketOptions) : that.instanceMarketOptions != null) return false;
                if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
                if (this.kernelId != null ? !this.kernelId.equals(that.kernelId) : that.kernelId != null) return false;
                if (this.keyName != null ? !this.keyName.equals(that.keyName) : that.keyName != null) return false;
                if (this.licenseSpecifications != null ? !this.licenseSpecifications.equals(that.licenseSpecifications) : that.licenseSpecifications != null) return false;
                if (this.monitoring != null ? !this.monitoring.equals(that.monitoring) : that.monitoring != null) return false;
                if (this.networkInterfaces != null ? !this.networkInterfaces.equals(that.networkInterfaces) : that.networkInterfaces != null) return false;
                if (this.placement != null ? !this.placement.equals(that.placement) : that.placement != null) return false;
                if (this.ramDiskId != null ? !this.ramDiskId.equals(that.ramDiskId) : that.ramDiskId != null) return false;
                if (this.securityGroupIds != null ? !this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds != null) return false;
                if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
                if (this.tagSpecifications != null ? !this.tagSpecifications.equals(that.tagSpecifications) : that.tagSpecifications != null) return false;
                return this.userData != null ? this.userData.equals(that.userData) : that.userData == null;
            }

            @Override
            public int hashCode() {
                int result = this.blockDeviceMappings != null ? this.blockDeviceMappings.hashCode() : 0;
                result = 31 * result + (this.capacityReservationSpecification != null ? this.capacityReservationSpecification.hashCode() : 0);
                result = 31 * result + (this.cpuOptions != null ? this.cpuOptions.hashCode() : 0);
                result = 31 * result + (this.creditSpecification != null ? this.creditSpecification.hashCode() : 0);
                result = 31 * result + (this.disableApiTermination != null ? this.disableApiTermination.hashCode() : 0);
                result = 31 * result + (this.ebsOptimized != null ? this.ebsOptimized.hashCode() : 0);
                result = 31 * result + (this.elasticGpuSpecifications != null ? this.elasticGpuSpecifications.hashCode() : 0);
                result = 31 * result + (this.elasticInferenceAccelerators != null ? this.elasticInferenceAccelerators.hashCode() : 0);
                result = 31 * result + (this.hibernationOptions != null ? this.hibernationOptions.hashCode() : 0);
                result = 31 * result + (this.iamInstanceProfile != null ? this.iamInstanceProfile.hashCode() : 0);
                result = 31 * result + (this.imageId != null ? this.imageId.hashCode() : 0);
                result = 31 * result + (this.instanceInitiatedShutdownBehavior != null ? this.instanceInitiatedShutdownBehavior.hashCode() : 0);
                result = 31 * result + (this.instanceMarketOptions != null ? this.instanceMarketOptions.hashCode() : 0);
                result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
                result = 31 * result + (this.kernelId != null ? this.kernelId.hashCode() : 0);
                result = 31 * result + (this.keyName != null ? this.keyName.hashCode() : 0);
                result = 31 * result + (this.licenseSpecifications != null ? this.licenseSpecifications.hashCode() : 0);
                result = 31 * result + (this.monitoring != null ? this.monitoring.hashCode() : 0);
                result = 31 * result + (this.networkInterfaces != null ? this.networkInterfaces.hashCode() : 0);
                result = 31 * result + (this.placement != null ? this.placement.hashCode() : 0);
                result = 31 * result + (this.ramDiskId != null ? this.ramDiskId.hashCode() : 0);
                result = 31 * result + (this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0);
                result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
                result = 31 * result + (this.tagSpecifications != null ? this.tagSpecifications.hashCode() : 0);
                result = 31 * result + (this.userData != null ? this.userData.hashCode() : 0);
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplateelasticinferenceaccelerator.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface LaunchTemplateElasticInferenceAcceleratorProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.LaunchTemplateElasticInferenceAcceleratorProperty.Type`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplateelasticinferenceaccelerator.html#cfn-ec2-launchtemplate-launchtemplateelasticinferenceaccelerator-type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link LaunchTemplateElasticInferenceAcceleratorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LaunchTemplateElasticInferenceAcceleratorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String type;

            /**
             * Sets the value of Type
             * @param type `CfnLaunchTemplate.LaunchTemplateElasticInferenceAcceleratorProperty.Type`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LaunchTemplateElasticInferenceAcceleratorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public LaunchTemplateElasticInferenceAcceleratorProperty build() {
                return new Jsii$Proxy(type);
            }

        }

        /**
         * An implementation for {@link LaunchTemplateElasticInferenceAcceleratorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LaunchTemplateElasticInferenceAcceleratorProperty {
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.type = this.jsiiGet("type", java.lang.String.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String type) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = type;
            }

            @Override
            public java.lang.String getType() {
                return this.type;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getType() != null) {
                    obj.set("type", om.valueToTree(this.getType()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LaunchTemplateElasticInferenceAcceleratorProperty.Jsii$Proxy that = (LaunchTemplateElasticInferenceAcceleratorProperty.Jsii$Proxy) o;

                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public int hashCode() {
                int result = this.type != null ? this.type.hashCode() : 0;
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-licensespecification.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface LicenseSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.LicenseSpecificationProperty.LicenseConfigurationArn`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-licensespecification.html#cfn-ec2-launchtemplate-licensespecification-licenseconfigurationarn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getLicenseConfigurationArn();

        /**
         * @return a {@link Builder} of {@link LicenseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LicenseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String licenseConfigurationArn;

            /**
             * Sets the value of LicenseConfigurationArn
             * @param licenseConfigurationArn `CfnLaunchTemplate.LicenseSpecificationProperty.LicenseConfigurationArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder licenseConfigurationArn(java.lang.String licenseConfigurationArn) {
                this.licenseConfigurationArn = licenseConfigurationArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LicenseSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public LicenseSpecificationProperty build() {
                return new Jsii$Proxy(licenseConfigurationArn);
            }

        }

        /**
         * An implementation for {@link LicenseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LicenseSpecificationProperty {
            private final java.lang.String licenseConfigurationArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.licenseConfigurationArn = this.jsiiGet("licenseConfigurationArn", java.lang.String.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String licenseConfigurationArn) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.licenseConfigurationArn = licenseConfigurationArn;
            }

            @Override
            public java.lang.String getLicenseConfigurationArn() {
                return this.licenseConfigurationArn;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getLicenseConfigurationArn() != null) {
                    obj.set("licenseConfigurationArn", om.valueToTree(this.getLicenseConfigurationArn()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LicenseSpecificationProperty.Jsii$Proxy that = (LicenseSpecificationProperty.Jsii$Proxy) o;

                return this.licenseConfigurationArn != null ? this.licenseConfigurationArn.equals(that.licenseConfigurationArn) : that.licenseConfigurationArn == null;
            }

            @Override
            public int hashCode() {
                int result = this.licenseConfigurationArn != null ? this.licenseConfigurationArn.hashCode() : 0;
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-monitoring.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface MonitoringProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.MonitoringProperty.Enabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-monitoring.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring-enabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getEnabled();

        /**
         * @return a {@link Builder} of {@link MonitoringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link MonitoringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.Object enabled;

            /**
             * Sets the value of Enabled
             * @param enabled `CfnLaunchTemplate.MonitoringProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of Enabled
             * @param enabled `CfnLaunchTemplate.MonitoringProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoringProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public MonitoringProperty build() {
                return new Jsii$Proxy(enabled);
            }

        }

        /**
         * An implementation for {@link MonitoringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonitoringProperty {
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.enabled = this.jsiiGet("enabled", java.lang.Object.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object enabled) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = enabled;
            }

            @Override
            public java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getEnabled() != null) {
                    obj.set("enabled", om.valueToTree(this.getEnabled()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MonitoringProperty.Jsii$Proxy that = (MonitoringProperty.Jsii$Proxy) o;

                return this.enabled != null ? this.enabled.equals(that.enabled) : that.enabled == null;
            }

            @Override
            public int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface NetworkInterfaceProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.AssociatePublicIpAddress`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-associatepublicipaddress
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getAssociatePublicIpAddress();

        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.DeleteOnTermination`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deleteontermination
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getDeleteOnTermination();

        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.Description`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-description
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getDescription();

        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.DeviceIndex`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deviceindex
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getDeviceIndex();

        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.Groups`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-groups
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.util.List<java.lang.String> getGroups();

        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.InterfaceType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-interfacetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getInterfaceType();

        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.Ipv6AddressCount`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresscount
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getIpv6AddressCount();

        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.Ipv6Addresses`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresses
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getIpv6Addresses();

        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.NetworkInterfaceId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-networkinterfaceid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getNetworkInterfaceId();

        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.PrivateIpAddress`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddress
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getPrivateIpAddress();

        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.PrivateIpAddresses`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddresses
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getPrivateIpAddresses();

        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-secondaryprivateipaddresscount
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getSecondaryPrivateIpAddressCount();

        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.SubnetId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-subnetid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getSubnetId();

        /**
         * @return a {@link Builder} of {@link NetworkInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link NetworkInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.Object associatePublicIpAddress;
            private java.lang.Object deleteOnTermination;
            private java.lang.String description;
            private java.lang.Number deviceIndex;
            private java.util.List<java.lang.String> groups;
            private java.lang.String interfaceType;
            private java.lang.Number ipv6AddressCount;
            private java.lang.Object ipv6Addresses;
            private java.lang.String networkInterfaceId;
            private java.lang.String privateIpAddress;
            private java.lang.Object privateIpAddresses;
            private java.lang.Number secondaryPrivateIpAddressCount;
            private java.lang.String subnetId;

            /**
             * Sets the value of AssociatePublicIpAddress
             * @param associatePublicIpAddress `CfnLaunchTemplate.NetworkInterfaceProperty.AssociatePublicIpAddress`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder associatePublicIpAddress(java.lang.Boolean associatePublicIpAddress) {
                this.associatePublicIpAddress = associatePublicIpAddress;
                return this;
            }

            /**
             * Sets the value of AssociatePublicIpAddress
             * @param associatePublicIpAddress `CfnLaunchTemplate.NetworkInterfaceProperty.AssociatePublicIpAddress`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder associatePublicIpAddress(software.amazon.awscdk.core.IResolvable associatePublicIpAddress) {
                this.associatePublicIpAddress = associatePublicIpAddress;
                return this;
            }

            /**
             * Sets the value of DeleteOnTermination
             * @param deleteOnTermination `CfnLaunchTemplate.NetworkInterfaceProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder deleteOnTermination(java.lang.Boolean deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            /**
             * Sets the value of DeleteOnTermination
             * @param deleteOnTermination `CfnLaunchTemplate.NetworkInterfaceProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder deleteOnTermination(software.amazon.awscdk.core.IResolvable deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            /**
             * Sets the value of Description
             * @param description `CfnLaunchTemplate.NetworkInterfaceProperty.Description`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of DeviceIndex
             * @param deviceIndex `CfnLaunchTemplate.NetworkInterfaceProperty.DeviceIndex`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder deviceIndex(java.lang.Number deviceIndex) {
                this.deviceIndex = deviceIndex;
                return this;
            }

            /**
             * Sets the value of Groups
             * @param groups `CfnLaunchTemplate.NetworkInterfaceProperty.Groups`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder groups(java.util.List<java.lang.String> groups) {
                this.groups = groups;
                return this;
            }

            /**
             * Sets the value of InterfaceType
             * @param interfaceType `CfnLaunchTemplate.NetworkInterfaceProperty.InterfaceType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder interfaceType(java.lang.String interfaceType) {
                this.interfaceType = interfaceType;
                return this;
            }

            /**
             * Sets the value of Ipv6AddressCount
             * @param ipv6AddressCount `CfnLaunchTemplate.NetworkInterfaceProperty.Ipv6AddressCount`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder ipv6AddressCount(java.lang.Number ipv6AddressCount) {
                this.ipv6AddressCount = ipv6AddressCount;
                return this;
            }

            /**
             * Sets the value of Ipv6Addresses
             * @param ipv6Addresses `CfnLaunchTemplate.NetworkInterfaceProperty.Ipv6Addresses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder ipv6Addresses(software.amazon.awscdk.core.IResolvable ipv6Addresses) {
                this.ipv6Addresses = ipv6Addresses;
                return this;
            }

            /**
             * Sets the value of Ipv6Addresses
             * @param ipv6Addresses `CfnLaunchTemplate.NetworkInterfaceProperty.Ipv6Addresses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder ipv6Addresses(java.util.List<java.lang.Object> ipv6Addresses) {
                this.ipv6Addresses = ipv6Addresses;
                return this;
            }

            /**
             * Sets the value of NetworkInterfaceId
             * @param networkInterfaceId `CfnLaunchTemplate.NetworkInterfaceProperty.NetworkInterfaceId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder networkInterfaceId(java.lang.String networkInterfaceId) {
                this.networkInterfaceId = networkInterfaceId;
                return this;
            }

            /**
             * Sets the value of PrivateIpAddress
             * @param privateIpAddress `CfnLaunchTemplate.NetworkInterfaceProperty.PrivateIpAddress`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder privateIpAddress(java.lang.String privateIpAddress) {
                this.privateIpAddress = privateIpAddress;
                return this;
            }

            /**
             * Sets the value of PrivateIpAddresses
             * @param privateIpAddresses `CfnLaunchTemplate.NetworkInterfaceProperty.PrivateIpAddresses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder privateIpAddresses(software.amazon.awscdk.core.IResolvable privateIpAddresses) {
                this.privateIpAddresses = privateIpAddresses;
                return this;
            }

            /**
             * Sets the value of PrivateIpAddresses
             * @param privateIpAddresses `CfnLaunchTemplate.NetworkInterfaceProperty.PrivateIpAddresses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder privateIpAddresses(java.util.List<java.lang.Object> privateIpAddresses) {
                this.privateIpAddresses = privateIpAddresses;
                return this;
            }

            /**
             * Sets the value of SecondaryPrivateIpAddressCount
             * @param secondaryPrivateIpAddressCount `CfnLaunchTemplate.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder secondaryPrivateIpAddressCount(java.lang.Number secondaryPrivateIpAddressCount) {
                this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
                return this;
            }

            /**
             * Sets the value of SubnetId
             * @param subnetId `CfnLaunchTemplate.NetworkInterfaceProperty.SubnetId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder subnetId(java.lang.String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkInterfaceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public NetworkInterfaceProperty build() {
                return new Jsii$Proxy(associatePublicIpAddress, deleteOnTermination, description, deviceIndex, groups, interfaceType, ipv6AddressCount, ipv6Addresses, networkInterfaceId, privateIpAddress, privateIpAddresses, secondaryPrivateIpAddressCount, subnetId);
            }

        }

        /**
         * An implementation for {@link NetworkInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkInterfaceProperty {
            private final java.lang.Object associatePublicIpAddress;
            private final java.lang.Object deleteOnTermination;
            private final java.lang.String description;
            private final java.lang.Number deviceIndex;
            private final java.util.List<java.lang.String> groups;
            private final java.lang.String interfaceType;
            private final java.lang.Number ipv6AddressCount;
            private final java.lang.Object ipv6Addresses;
            private final java.lang.String networkInterfaceId;
            private final java.lang.String privateIpAddress;
            private final java.lang.Object privateIpAddresses;
            private final java.lang.Number secondaryPrivateIpAddressCount;
            private final java.lang.String subnetId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.associatePublicIpAddress = this.jsiiGet("associatePublicIpAddress", java.lang.Object.class);
                this.deleteOnTermination = this.jsiiGet("deleteOnTermination", java.lang.Object.class);
                this.description = this.jsiiGet("description", java.lang.String.class);
                this.deviceIndex = this.jsiiGet("deviceIndex", java.lang.Number.class);
                this.groups = this.jsiiGet("groups", java.util.List.class);
                this.interfaceType = this.jsiiGet("interfaceType", java.lang.String.class);
                this.ipv6AddressCount = this.jsiiGet("ipv6AddressCount", java.lang.Number.class);
                this.ipv6Addresses = this.jsiiGet("ipv6Addresses", java.lang.Object.class);
                this.networkInterfaceId = this.jsiiGet("networkInterfaceId", java.lang.String.class);
                this.privateIpAddress = this.jsiiGet("privateIpAddress", java.lang.String.class);
                this.privateIpAddresses = this.jsiiGet("privateIpAddresses", java.lang.Object.class);
                this.secondaryPrivateIpAddressCount = this.jsiiGet("secondaryPrivateIpAddressCount", java.lang.Number.class);
                this.subnetId = this.jsiiGet("subnetId", java.lang.String.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object associatePublicIpAddress, java.lang.Object deleteOnTermination, java.lang.String description, java.lang.Number deviceIndex, java.util.List<java.lang.String> groups, java.lang.String interfaceType, java.lang.Number ipv6AddressCount, java.lang.Object ipv6Addresses, java.lang.String networkInterfaceId, java.lang.String privateIpAddress, java.lang.Object privateIpAddresses, java.lang.Number secondaryPrivateIpAddressCount, java.lang.String subnetId) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.associatePublicIpAddress = associatePublicIpAddress;
                this.deleteOnTermination = deleteOnTermination;
                this.description = description;
                this.deviceIndex = deviceIndex;
                this.groups = groups;
                this.interfaceType = interfaceType;
                this.ipv6AddressCount = ipv6AddressCount;
                this.ipv6Addresses = ipv6Addresses;
                this.networkInterfaceId = networkInterfaceId;
                this.privateIpAddress = privateIpAddress;
                this.privateIpAddresses = privateIpAddresses;
                this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
                this.subnetId = subnetId;
            }

            @Override
            public java.lang.Object getAssociatePublicIpAddress() {
                return this.associatePublicIpAddress;
            }

            @Override
            public java.lang.Object getDeleteOnTermination() {
                return this.deleteOnTermination;
            }

            @Override
            public java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public java.lang.Number getDeviceIndex() {
                return this.deviceIndex;
            }

            @Override
            public java.util.List<java.lang.String> getGroups() {
                return this.groups;
            }

            @Override
            public java.lang.String getInterfaceType() {
                return this.interfaceType;
            }

            @Override
            public java.lang.Number getIpv6AddressCount() {
                return this.ipv6AddressCount;
            }

            @Override
            public java.lang.Object getIpv6Addresses() {
                return this.ipv6Addresses;
            }

            @Override
            public java.lang.String getNetworkInterfaceId() {
                return this.networkInterfaceId;
            }

            @Override
            public java.lang.String getPrivateIpAddress() {
                return this.privateIpAddress;
            }

            @Override
            public java.lang.Object getPrivateIpAddresses() {
                return this.privateIpAddresses;
            }

            @Override
            public java.lang.Number getSecondaryPrivateIpAddressCount() {
                return this.secondaryPrivateIpAddressCount;
            }

            @Override
            public java.lang.String getSubnetId() {
                return this.subnetId;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getAssociatePublicIpAddress() != null) {
                    obj.set("associatePublicIpAddress", om.valueToTree(this.getAssociatePublicIpAddress()));
                }
                if (this.getDeleteOnTermination() != null) {
                    obj.set("deleteOnTermination", om.valueToTree(this.getDeleteOnTermination()));
                }
                if (this.getDescription() != null) {
                    obj.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getDeviceIndex() != null) {
                    obj.set("deviceIndex", om.valueToTree(this.getDeviceIndex()));
                }
                if (this.getGroups() != null) {
                    obj.set("groups", om.valueToTree(this.getGroups()));
                }
                if (this.getInterfaceType() != null) {
                    obj.set("interfaceType", om.valueToTree(this.getInterfaceType()));
                }
                if (this.getIpv6AddressCount() != null) {
                    obj.set("ipv6AddressCount", om.valueToTree(this.getIpv6AddressCount()));
                }
                if (this.getIpv6Addresses() != null) {
                    obj.set("ipv6Addresses", om.valueToTree(this.getIpv6Addresses()));
                }
                if (this.getNetworkInterfaceId() != null) {
                    obj.set("networkInterfaceId", om.valueToTree(this.getNetworkInterfaceId()));
                }
                if (this.getPrivateIpAddress() != null) {
                    obj.set("privateIpAddress", om.valueToTree(this.getPrivateIpAddress()));
                }
                if (this.getPrivateIpAddresses() != null) {
                    obj.set("privateIpAddresses", om.valueToTree(this.getPrivateIpAddresses()));
                }
                if (this.getSecondaryPrivateIpAddressCount() != null) {
                    obj.set("secondaryPrivateIpAddressCount", om.valueToTree(this.getSecondaryPrivateIpAddressCount()));
                }
                if (this.getSubnetId() != null) {
                    obj.set("subnetId", om.valueToTree(this.getSubnetId()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkInterfaceProperty.Jsii$Proxy that = (NetworkInterfaceProperty.Jsii$Proxy) o;

                if (this.associatePublicIpAddress != null ? !this.associatePublicIpAddress.equals(that.associatePublicIpAddress) : that.associatePublicIpAddress != null) return false;
                if (this.deleteOnTermination != null ? !this.deleteOnTermination.equals(that.deleteOnTermination) : that.deleteOnTermination != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.deviceIndex != null ? !this.deviceIndex.equals(that.deviceIndex) : that.deviceIndex != null) return false;
                if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) return false;
                if (this.interfaceType != null ? !this.interfaceType.equals(that.interfaceType) : that.interfaceType != null) return false;
                if (this.ipv6AddressCount != null ? !this.ipv6AddressCount.equals(that.ipv6AddressCount) : that.ipv6AddressCount != null) return false;
                if (this.ipv6Addresses != null ? !this.ipv6Addresses.equals(that.ipv6Addresses) : that.ipv6Addresses != null) return false;
                if (this.networkInterfaceId != null ? !this.networkInterfaceId.equals(that.networkInterfaceId) : that.networkInterfaceId != null) return false;
                if (this.privateIpAddress != null ? !this.privateIpAddress.equals(that.privateIpAddress) : that.privateIpAddress != null) return false;
                if (this.privateIpAddresses != null ? !this.privateIpAddresses.equals(that.privateIpAddresses) : that.privateIpAddresses != null) return false;
                if (this.secondaryPrivateIpAddressCount != null ? !this.secondaryPrivateIpAddressCount.equals(that.secondaryPrivateIpAddressCount) : that.secondaryPrivateIpAddressCount != null) return false;
                return this.subnetId != null ? this.subnetId.equals(that.subnetId) : that.subnetId == null;
            }

            @Override
            public int hashCode() {
                int result = this.associatePublicIpAddress != null ? this.associatePublicIpAddress.hashCode() : 0;
                result = 31 * result + (this.deleteOnTermination != null ? this.deleteOnTermination.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.deviceIndex != null ? this.deviceIndex.hashCode() : 0);
                result = 31 * result + (this.groups != null ? this.groups.hashCode() : 0);
                result = 31 * result + (this.interfaceType != null ? this.interfaceType.hashCode() : 0);
                result = 31 * result + (this.ipv6AddressCount != null ? this.ipv6AddressCount.hashCode() : 0);
                result = 31 * result + (this.ipv6Addresses != null ? this.ipv6Addresses.hashCode() : 0);
                result = 31 * result + (this.networkInterfaceId != null ? this.networkInterfaceId.hashCode() : 0);
                result = 31 * result + (this.privateIpAddress != null ? this.privateIpAddress.hashCode() : 0);
                result = 31 * result + (this.privateIpAddresses != null ? this.privateIpAddresses.hashCode() : 0);
                result = 31 * result + (this.secondaryPrivateIpAddressCount != null ? this.secondaryPrivateIpAddressCount.hashCode() : 0);
                result = 31 * result + (this.subnetId != null ? this.subnetId.hashCode() : 0);
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface PlacementProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.PlacementProperty.Affinity`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-affinity
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getAffinity();

        /**
         * `CfnLaunchTemplate.PlacementProperty.AvailabilityZone`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-availabilityzone
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getAvailabilityZone();

        /**
         * `CfnLaunchTemplate.PlacementProperty.GroupName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-groupname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getGroupName();

        /**
         * `CfnLaunchTemplate.PlacementProperty.HostId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-hostid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getHostId();

        /**
         * `CfnLaunchTemplate.PlacementProperty.Tenancy`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-tenancy
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getTenancy();

        /**
         * @return a {@link Builder} of {@link PlacementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link PlacementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String affinity;
            private java.lang.String availabilityZone;
            private java.lang.String groupName;
            private java.lang.String hostId;
            private java.lang.String tenancy;

            /**
             * Sets the value of Affinity
             * @param affinity `CfnLaunchTemplate.PlacementProperty.Affinity`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder affinity(java.lang.String affinity) {
                this.affinity = affinity;
                return this;
            }

            /**
             * Sets the value of AvailabilityZone
             * @param availabilityZone `CfnLaunchTemplate.PlacementProperty.AvailabilityZone`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder availabilityZone(java.lang.String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            /**
             * Sets the value of GroupName
             * @param groupName `CfnLaunchTemplate.PlacementProperty.GroupName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder groupName(java.lang.String groupName) {
                this.groupName = groupName;
                return this;
            }

            /**
             * Sets the value of HostId
             * @param hostId `CfnLaunchTemplate.PlacementProperty.HostId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder hostId(java.lang.String hostId) {
                this.hostId = hostId;
                return this;
            }

            /**
             * Sets the value of Tenancy
             * @param tenancy `CfnLaunchTemplate.PlacementProperty.Tenancy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder tenancy(java.lang.String tenancy) {
                this.tenancy = tenancy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PlacementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public PlacementProperty build() {
                return new Jsii$Proxy(affinity, availabilityZone, groupName, hostId, tenancy);
            }

        }

        /**
         * An implementation for {@link PlacementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PlacementProperty {
            private final java.lang.String affinity;
            private final java.lang.String availabilityZone;
            private final java.lang.String groupName;
            private final java.lang.String hostId;
            private final java.lang.String tenancy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.affinity = this.jsiiGet("affinity", java.lang.String.class);
                this.availabilityZone = this.jsiiGet("availabilityZone", java.lang.String.class);
                this.groupName = this.jsiiGet("groupName", java.lang.String.class);
                this.hostId = this.jsiiGet("hostId", java.lang.String.class);
                this.tenancy = this.jsiiGet("tenancy", java.lang.String.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String affinity, java.lang.String availabilityZone, java.lang.String groupName, java.lang.String hostId, java.lang.String tenancy) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.affinity = affinity;
                this.availabilityZone = availabilityZone;
                this.groupName = groupName;
                this.hostId = hostId;
                this.tenancy = tenancy;
            }

            @Override
            public java.lang.String getAffinity() {
                return this.affinity;
            }

            @Override
            public java.lang.String getAvailabilityZone() {
                return this.availabilityZone;
            }

            @Override
            public java.lang.String getGroupName() {
                return this.groupName;
            }

            @Override
            public java.lang.String getHostId() {
                return this.hostId;
            }

            @Override
            public java.lang.String getTenancy() {
                return this.tenancy;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getAffinity() != null) {
                    obj.set("affinity", om.valueToTree(this.getAffinity()));
                }
                if (this.getAvailabilityZone() != null) {
                    obj.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                }
                if (this.getGroupName() != null) {
                    obj.set("groupName", om.valueToTree(this.getGroupName()));
                }
                if (this.getHostId() != null) {
                    obj.set("hostId", om.valueToTree(this.getHostId()));
                }
                if (this.getTenancy() != null) {
                    obj.set("tenancy", om.valueToTree(this.getTenancy()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PlacementProperty.Jsii$Proxy that = (PlacementProperty.Jsii$Proxy) o;

                if (this.affinity != null ? !this.affinity.equals(that.affinity) : that.affinity != null) return false;
                if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
                if (this.groupName != null ? !this.groupName.equals(that.groupName) : that.groupName != null) return false;
                if (this.hostId != null ? !this.hostId.equals(that.hostId) : that.hostId != null) return false;
                return this.tenancy != null ? this.tenancy.equals(that.tenancy) : that.tenancy == null;
            }

            @Override
            public int hashCode() {
                int result = this.affinity != null ? this.affinity.hashCode() : 0;
                result = 31 * result + (this.availabilityZone != null ? this.availabilityZone.hashCode() : 0);
                result = 31 * result + (this.groupName != null ? this.groupName.hashCode() : 0);
                result = 31 * result + (this.hostId != null ? this.hostId.hashCode() : 0);
                result = 31 * result + (this.tenancy != null ? this.tenancy.hashCode() : 0);
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface PrivateIpAddProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.PrivateIpAddProperty.Primary`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-primary
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getPrimary();

        /**
         * `CfnLaunchTemplate.PrivateIpAddProperty.PrivateIpAddress`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-privateipaddress
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getPrivateIpAddress();

        /**
         * @return a {@link Builder} of {@link PrivateIpAddProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link PrivateIpAddProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.Object primary;
            private java.lang.String privateIpAddress;

            /**
             * Sets the value of Primary
             * @param primary `CfnLaunchTemplate.PrivateIpAddProperty.Primary`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder primary(java.lang.Boolean primary) {
                this.primary = primary;
                return this;
            }

            /**
             * Sets the value of Primary
             * @param primary `CfnLaunchTemplate.PrivateIpAddProperty.Primary`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder primary(software.amazon.awscdk.core.IResolvable primary) {
                this.primary = primary;
                return this;
            }

            /**
             * Sets the value of PrivateIpAddress
             * @param privateIpAddress `CfnLaunchTemplate.PrivateIpAddProperty.PrivateIpAddress`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder privateIpAddress(java.lang.String privateIpAddress) {
                this.privateIpAddress = privateIpAddress;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PrivateIpAddProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public PrivateIpAddProperty build() {
                return new Jsii$Proxy(primary, privateIpAddress);
            }

        }

        /**
         * An implementation for {@link PrivateIpAddProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PrivateIpAddProperty {
            private final java.lang.Object primary;
            private final java.lang.String privateIpAddress;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.primary = this.jsiiGet("primary", java.lang.Object.class);
                this.privateIpAddress = this.jsiiGet("privateIpAddress", java.lang.String.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object primary, java.lang.String privateIpAddress) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.primary = primary;
                this.privateIpAddress = privateIpAddress;
            }

            @Override
            public java.lang.Object getPrimary() {
                return this.primary;
            }

            @Override
            public java.lang.String getPrivateIpAddress() {
                return this.privateIpAddress;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getPrimary() != null) {
                    obj.set("primary", om.valueToTree(this.getPrimary()));
                }
                if (this.getPrivateIpAddress() != null) {
                    obj.set("privateIpAddress", om.valueToTree(this.getPrivateIpAddress()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PrivateIpAddProperty.Jsii$Proxy that = (PrivateIpAddProperty.Jsii$Proxy) o;

                if (this.primary != null ? !this.primary.equals(that.primary) : that.primary != null) return false;
                return this.privateIpAddress != null ? this.privateIpAddress.equals(that.privateIpAddress) : that.privateIpAddress == null;
            }

            @Override
            public int hashCode() {
                int result = this.primary != null ? this.primary.hashCode() : 0;
                result = 31 * result + (this.privateIpAddress != null ? this.privateIpAddress.hashCode() : 0);
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface SpotOptionsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.SpotOptionsProperty.BlockDurationMinutes`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-blockdurationminutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getBlockDurationMinutes();

        /**
         * `CfnLaunchTemplate.SpotOptionsProperty.InstanceInterruptionBehavior`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-instanceinterruptionbehavior
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getInstanceInterruptionBehavior();

        /**
         * `CfnLaunchTemplate.SpotOptionsProperty.MaxPrice`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-maxprice
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getMaxPrice();

        /**
         * `CfnLaunchTemplate.SpotOptionsProperty.SpotInstanceType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-spotinstancetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getSpotInstanceType();

        /**
         * `CfnLaunchTemplate.SpotOptionsProperty.ValidUntil`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-validuntil
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getValidUntil();

        /**
         * @return a {@link Builder} of {@link SpotOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SpotOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.Number blockDurationMinutes;
            private java.lang.String instanceInterruptionBehavior;
            private java.lang.String maxPrice;
            private java.lang.String spotInstanceType;
            private java.lang.String validUntil;

            /**
             * Sets the value of BlockDurationMinutes
             * @param blockDurationMinutes `CfnLaunchTemplate.SpotOptionsProperty.BlockDurationMinutes`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder blockDurationMinutes(java.lang.Number blockDurationMinutes) {
                this.blockDurationMinutes = blockDurationMinutes;
                return this;
            }

            /**
             * Sets the value of InstanceInterruptionBehavior
             * @param instanceInterruptionBehavior `CfnLaunchTemplate.SpotOptionsProperty.InstanceInterruptionBehavior`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder instanceInterruptionBehavior(java.lang.String instanceInterruptionBehavior) {
                this.instanceInterruptionBehavior = instanceInterruptionBehavior;
                return this;
            }

            /**
             * Sets the value of MaxPrice
             * @param maxPrice `CfnLaunchTemplate.SpotOptionsProperty.MaxPrice`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder maxPrice(java.lang.String maxPrice) {
                this.maxPrice = maxPrice;
                return this;
            }

            /**
             * Sets the value of SpotInstanceType
             * @param spotInstanceType `CfnLaunchTemplate.SpotOptionsProperty.SpotInstanceType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder spotInstanceType(java.lang.String spotInstanceType) {
                this.spotInstanceType = spotInstanceType;
                return this;
            }

            /**
             * Sets the value of ValidUntil
             * @param validUntil `CfnLaunchTemplate.SpotOptionsProperty.ValidUntil`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder validUntil(java.lang.String validUntil) {
                this.validUntil = validUntil;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public SpotOptionsProperty build() {
                return new Jsii$Proxy(blockDurationMinutes, instanceInterruptionBehavior, maxPrice, spotInstanceType, validUntil);
            }

        }

        /**
         * An implementation for {@link SpotOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpotOptionsProperty {
            private final java.lang.Number blockDurationMinutes;
            private final java.lang.String instanceInterruptionBehavior;
            private final java.lang.String maxPrice;
            private final java.lang.String spotInstanceType;
            private final java.lang.String validUntil;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.blockDurationMinutes = this.jsiiGet("blockDurationMinutes", java.lang.Number.class);
                this.instanceInterruptionBehavior = this.jsiiGet("instanceInterruptionBehavior", java.lang.String.class);
                this.maxPrice = this.jsiiGet("maxPrice", java.lang.String.class);
                this.spotInstanceType = this.jsiiGet("spotInstanceType", java.lang.String.class);
                this.validUntil = this.jsiiGet("validUntil", java.lang.String.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Number blockDurationMinutes, java.lang.String instanceInterruptionBehavior, java.lang.String maxPrice, java.lang.String spotInstanceType, java.lang.String validUntil) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.blockDurationMinutes = blockDurationMinutes;
                this.instanceInterruptionBehavior = instanceInterruptionBehavior;
                this.maxPrice = maxPrice;
                this.spotInstanceType = spotInstanceType;
                this.validUntil = validUntil;
            }

            @Override
            public java.lang.Number getBlockDurationMinutes() {
                return this.blockDurationMinutes;
            }

            @Override
            public java.lang.String getInstanceInterruptionBehavior() {
                return this.instanceInterruptionBehavior;
            }

            @Override
            public java.lang.String getMaxPrice() {
                return this.maxPrice;
            }

            @Override
            public java.lang.String getSpotInstanceType() {
                return this.spotInstanceType;
            }

            @Override
            public java.lang.String getValidUntil() {
                return this.validUntil;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getBlockDurationMinutes() != null) {
                    obj.set("blockDurationMinutes", om.valueToTree(this.getBlockDurationMinutes()));
                }
                if (this.getInstanceInterruptionBehavior() != null) {
                    obj.set("instanceInterruptionBehavior", om.valueToTree(this.getInstanceInterruptionBehavior()));
                }
                if (this.getMaxPrice() != null) {
                    obj.set("maxPrice", om.valueToTree(this.getMaxPrice()));
                }
                if (this.getSpotInstanceType() != null) {
                    obj.set("spotInstanceType", om.valueToTree(this.getSpotInstanceType()));
                }
                if (this.getValidUntil() != null) {
                    obj.set("validUntil", om.valueToTree(this.getValidUntil()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SpotOptionsProperty.Jsii$Proxy that = (SpotOptionsProperty.Jsii$Proxy) o;

                if (this.blockDurationMinutes != null ? !this.blockDurationMinutes.equals(that.blockDurationMinutes) : that.blockDurationMinutes != null) return false;
                if (this.instanceInterruptionBehavior != null ? !this.instanceInterruptionBehavior.equals(that.instanceInterruptionBehavior) : that.instanceInterruptionBehavior != null) return false;
                if (this.maxPrice != null ? !this.maxPrice.equals(that.maxPrice) : that.maxPrice != null) return false;
                if (this.spotInstanceType != null ? !this.spotInstanceType.equals(that.spotInstanceType) : that.spotInstanceType != null) return false;
                return this.validUntil != null ? this.validUntil.equals(that.validUntil) : that.validUntil == null;
            }

            @Override
            public int hashCode() {
                int result = this.blockDurationMinutes != null ? this.blockDurationMinutes.hashCode() : 0;
                result = 31 * result + (this.instanceInterruptionBehavior != null ? this.instanceInterruptionBehavior.hashCode() : 0);
                result = 31 * result + (this.maxPrice != null ? this.maxPrice.hashCode() : 0);
                result = 31 * result + (this.spotInstanceType != null ? this.spotInstanceType.hashCode() : 0);
                result = 31 * result + (this.validUntil != null ? this.validUntil.hashCode() : 0);
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface TagSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.TagSpecificationProperty.ResourceType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-resourcetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getResourceType();

        /**
         * `CfnLaunchTemplate.TagSpecificationProperty.Tags`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-tags
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.util.List<software.amazon.awscdk.core.CfnTag> getTags();

        /**
         * @return a {@link Builder} of {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String resourceType;
            private java.util.List<software.amazon.awscdk.core.CfnTag> tags;

            /**
             * Sets the value of ResourceType
             * @param resourceType `CfnLaunchTemplate.TagSpecificationProperty.ResourceType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder resourceType(java.lang.String resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            /**
             * Sets the value of Tags
             * @param tags `CfnLaunchTemplate.TagSpecificationProperty.Tags`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder tags(java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
                this.tags = tags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public TagSpecificationProperty build() {
                return new Jsii$Proxy(resourceType, tags);
            }

        }

        /**
         * An implementation for {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagSpecificationProperty {
            private final java.lang.String resourceType;
            private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.resourceType = this.jsiiGet("resourceType", java.lang.String.class);
                this.tags = this.jsiiGet("tags", java.util.List.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String resourceType, java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceType = resourceType;
                this.tags = tags;
            }

            @Override
            public java.lang.String getResourceType() {
                return this.resourceType;
            }

            @Override
            public java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
                return this.tags;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getResourceType() != null) {
                    obj.set("resourceType", om.valueToTree(this.getResourceType()));
                }
                if (this.getTags() != null) {
                    obj.set("tags", om.valueToTree(this.getTags()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TagSpecificationProperty.Jsii$Proxy that = (TagSpecificationProperty.Jsii$Proxy) o;

                if (this.resourceType != null ? !this.resourceType.equals(that.resourceType) : that.resourceType != null) return false;
                return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
            }

            @Override
            public int hashCode() {
                int result = this.resourceType != null ? this.resourceType.hashCode() : 0;
                result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
                return result;
            }

        }
    }
}
