package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::FlowLog`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.15.0 (build 585166b)", date = "2021-01-06T15:17:33.641Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnFlowLogProps")
@software.amazon.jsii.Jsii.Proxy(CfnFlowLogProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnFlowLogProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::EC2::FlowLog.ResourceId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-resourceid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceId();

    /**
     * `AWS::EC2::FlowLog.ResourceType`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-resourcetype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceType();

    /**
     * `AWS::EC2::FlowLog.TrafficType`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-traffictype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTrafficType();

    /**
     * `AWS::EC2::FlowLog.DeliverLogsPermissionArn`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-deliverlogspermissionarn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeliverLogsPermissionArn() {
        return null;
    }

    /**
     * `AWS::EC2::FlowLog.LogDestination`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logdestination
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLogDestination() {
        return null;
    }

    /**
     * `AWS::EC2::FlowLog.LogDestinationType`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logdestinationtype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLogDestinationType() {
        return null;
    }

    /**
     * `AWS::EC2::FlowLog.LogFormat`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logformat
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLogFormat() {
        return null;
    }

    /**
     * `AWS::EC2::FlowLog.LogGroupName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-loggroupname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLogGroupName() {
        return null;
    }

    /**
     * `AWS::EC2::FlowLog.MaxAggregationInterval`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-maxaggregationinterval
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxAggregationInterval() {
        return null;
    }

    /**
     * `AWS::EC2::FlowLog.Tags`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnFlowLogProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnFlowLogProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnFlowLogProps> {
        private java.lang.String resourceId;
        private java.lang.String resourceType;
        private java.lang.String trafficType;
        private java.lang.String deliverLogsPermissionArn;
        private java.lang.String logDestination;
        private java.lang.String logDestinationType;
        private java.lang.String logFormat;
        private java.lang.String logGroupName;
        private java.lang.Number maxAggregationInterval;
        private java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnFlowLogProps#getResourceId}
         * @param resourceId `AWS::EC2::FlowLog.ResourceId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceId(java.lang.String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowLogProps#getResourceType}
         * @param resourceType `AWS::EC2::FlowLog.ResourceType`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceType(java.lang.String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowLogProps#getTrafficType}
         * @param trafficType `AWS::EC2::FlowLog.TrafficType`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trafficType(java.lang.String trafficType) {
            this.trafficType = trafficType;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowLogProps#getDeliverLogsPermissionArn}
         * @param deliverLogsPermissionArn `AWS::EC2::FlowLog.DeliverLogsPermissionArn`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliverLogsPermissionArn(java.lang.String deliverLogsPermissionArn) {
            this.deliverLogsPermissionArn = deliverLogsPermissionArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowLogProps#getLogDestination}
         * @param logDestination `AWS::EC2::FlowLog.LogDestination`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDestination(java.lang.String logDestination) {
            this.logDestination = logDestination;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowLogProps#getLogDestinationType}
         * @param logDestinationType `AWS::EC2::FlowLog.LogDestinationType`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDestinationType(java.lang.String logDestinationType) {
            this.logDestinationType = logDestinationType;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowLogProps#getLogFormat}
         * @param logFormat `AWS::EC2::FlowLog.LogFormat`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logFormat(java.lang.String logFormat) {
            this.logFormat = logFormat;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowLogProps#getLogGroupName}
         * @param logGroupName `AWS::EC2::FlowLog.LogGroupName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroupName(java.lang.String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowLogProps#getMaxAggregationInterval}
         * @param maxAggregationInterval `AWS::EC2::FlowLog.MaxAggregationInterval`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxAggregationInterval(java.lang.Number maxAggregationInterval) {
            this.maxAggregationInterval = maxAggregationInterval;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowLogProps#getTags}
         * @param tags `AWS::EC2::FlowLog.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnFlowLogProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnFlowLogProps build() {
            return new Jsii$Proxy(resourceId, resourceType, trafficType, deliverLogsPermissionArn, logDestination, logDestinationType, logFormat, logGroupName, maxAggregationInterval, tags);
        }
    }

    /**
     * An implementation for {@link CfnFlowLogProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnFlowLogProps {
        private final java.lang.String resourceId;
        private final java.lang.String resourceType;
        private final java.lang.String trafficType;
        private final java.lang.String deliverLogsPermissionArn;
        private final java.lang.String logDestination;
        private final java.lang.String logDestinationType;
        private final java.lang.String logFormat;
        private final java.lang.String logGroupName;
        private final java.lang.Number maxAggregationInterval;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.resourceId = software.amazon.jsii.Kernel.get(this, "resourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resourceType = software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.trafficType = software.amazon.jsii.Kernel.get(this, "trafficType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deliverLogsPermissionArn = software.amazon.jsii.Kernel.get(this, "deliverLogsPermissionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logDestination = software.amazon.jsii.Kernel.get(this, "logDestination", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logDestinationType = software.amazon.jsii.Kernel.get(this, "logDestinationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logFormat = software.amazon.jsii.Kernel.get(this, "logFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logGroupName = software.amazon.jsii.Kernel.get(this, "logGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxAggregationInterval = software.amazon.jsii.Kernel.get(this, "maxAggregationInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final java.lang.String resourceId, final java.lang.String resourceType, final java.lang.String trafficType, final java.lang.String deliverLogsPermissionArn, final java.lang.String logDestination, final java.lang.String logDestinationType, final java.lang.String logFormat, final java.lang.String logGroupName, final java.lang.Number maxAggregationInterval, final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.resourceId = java.util.Objects.requireNonNull(resourceId, "resourceId is required");
            this.resourceType = java.util.Objects.requireNonNull(resourceType, "resourceType is required");
            this.trafficType = java.util.Objects.requireNonNull(trafficType, "trafficType is required");
            this.deliverLogsPermissionArn = deliverLogsPermissionArn;
            this.logDestination = logDestination;
            this.logDestinationType = logDestinationType;
            this.logFormat = logFormat;
            this.logGroupName = logGroupName;
            this.maxAggregationInterval = maxAggregationInterval;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
        }

        @Override
        public final java.lang.String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final java.lang.String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final java.lang.String getTrafficType() {
            return this.trafficType;
        }

        @Override
        public final java.lang.String getDeliverLogsPermissionArn() {
            return this.deliverLogsPermissionArn;
        }

        @Override
        public final java.lang.String getLogDestination() {
            return this.logDestination;
        }

        @Override
        public final java.lang.String getLogDestinationType() {
            return this.logDestinationType;
        }

        @Override
        public final java.lang.String getLogFormat() {
            return this.logFormat;
        }

        @Override
        public final java.lang.String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final java.lang.Number getMaxAggregationInterval() {
            return this.maxAggregationInterval;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("resourceId", om.valueToTree(this.getResourceId()));
            data.set("resourceType", om.valueToTree(this.getResourceType()));
            data.set("trafficType", om.valueToTree(this.getTrafficType()));
            if (this.getDeliverLogsPermissionArn() != null) {
                data.set("deliverLogsPermissionArn", om.valueToTree(this.getDeliverLogsPermissionArn()));
            }
            if (this.getLogDestination() != null) {
                data.set("logDestination", om.valueToTree(this.getLogDestination()));
            }
            if (this.getLogDestinationType() != null) {
                data.set("logDestinationType", om.valueToTree(this.getLogDestinationType()));
            }
            if (this.getLogFormat() != null) {
                data.set("logFormat", om.valueToTree(this.getLogFormat()));
            }
            if (this.getLogGroupName() != null) {
                data.set("logGroupName", om.valueToTree(this.getLogGroupName()));
            }
            if (this.getMaxAggregationInterval() != null) {
                data.set("maxAggregationInterval", om.valueToTree(this.getMaxAggregationInterval()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnFlowLogProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnFlowLogProps.Jsii$Proxy that = (CfnFlowLogProps.Jsii$Proxy) o;

            if (!resourceId.equals(that.resourceId)) return false;
            if (!resourceType.equals(that.resourceType)) return false;
            if (!trafficType.equals(that.trafficType)) return false;
            if (this.deliverLogsPermissionArn != null ? !this.deliverLogsPermissionArn.equals(that.deliverLogsPermissionArn) : that.deliverLogsPermissionArn != null) return false;
            if (this.logDestination != null ? !this.logDestination.equals(that.logDestination) : that.logDestination != null) return false;
            if (this.logDestinationType != null ? !this.logDestinationType.equals(that.logDestinationType) : that.logDestinationType != null) return false;
            if (this.logFormat != null ? !this.logFormat.equals(that.logFormat) : that.logFormat != null) return false;
            if (this.logGroupName != null ? !this.logGroupName.equals(that.logGroupName) : that.logGroupName != null) return false;
            if (this.maxAggregationInterval != null ? !this.maxAggregationInterval.equals(that.maxAggregationInterval) : that.maxAggregationInterval != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.resourceId.hashCode();
            result = 31 * result + (this.resourceType.hashCode());
            result = 31 * result + (this.trafficType.hashCode());
            result = 31 * result + (this.deliverLogsPermissionArn != null ? this.deliverLogsPermissionArn.hashCode() : 0);
            result = 31 * result + (this.logDestination != null ? this.logDestination.hashCode() : 0);
            result = 31 * result + (this.logDestinationType != null ? this.logDestinationType.hashCode() : 0);
            result = 31 * result + (this.logFormat != null ? this.logFormat.hashCode() : 0);
            result = 31 * result + (this.logGroupName != null ? this.logGroupName.hashCode() : 0);
            result = 31 * result + (this.maxAggregationInterval != null ? this.maxAggregationInterval.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
