package software.amazon.awscdk.services.ec2;

/**
 * NAT provider which uses NAT Instances.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.15.0 (build 585166b)", date = "2021-01-28T16:33:09.250Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.NatInstanceProvider")
public class NatInstanceProvider extends software.amazon.awscdk.services.ec2.NatProvider implements software.amazon.awscdk.services.ec2.IConnectable {

    protected NatInstanceProvider(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NatInstanceProvider(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public NatInstanceProvider(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.NatInstanceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Called by the VPC to configure NAT.
     * <p>
     * Don't call this directly, the VPC will call it automatically.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void configureNat(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ConfigureNatOptions options) {
        software.amazon.jsii.Kernel.call(this, "configureNat", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Configures subnet with the gateway.
     * <p>
     * Don't call this directly, the VPC will call it automatically.
     * <p>
     * @param subnet This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void configureSubnet(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.PrivateSubnet subnet) {
        software.amazon.jsii.Kernel.call(this, "configureSubnet", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(subnet, "subnet is required") });
    }

    /**
     * Return list of gateways spawned by the provider.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.GatewayConfig> getConfiguredGateways() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "configuredGateways", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.GatewayConfig.class))));
    }

    /**
     * Manage the Security Groups associated with the NAT instances.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * The Security Group associated with the NAT instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
        return software.amazon.jsii.Kernel.get(this, "securityGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.NatInstanceProvider}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.NatInstanceProvider> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.ec2.NatInstanceProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.ec2.NatInstanceProps.Builder();
        }

        /**
         * (experimental) Instance type of the NAT instance.
         * <p>
         * @return {@code this}
         * @param instanceType Instance type of the NAT instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceType(final software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        /**
         * (experimental) Allow all traffic through the NAT instance.
         * <p>
         * If you set this to false, you must configure the NAT instance's security
         * groups in another way, either by passing in a fully configured Security
         * Group using the <code>securityGroup</code> property, or by configuring it using the
         * <code>.securityGroup</code> or <code>.connections</code> members after passing the NAT Instance
         * Provider to a Vpc.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param allowAllTraffic Allow all traffic through the NAT instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder allowAllTraffic(final java.lang.Boolean allowAllTraffic) {
            this.props.allowAllTraffic(allowAllTraffic);
            return this;
        }

        /**
         * (experimental) Name of SSH keypair to grant access to instance.
         * <p>
         * Default: - No SSH access will be possible.
         * <p>
         * @return {@code this}
         * @param keyName Name of SSH keypair to grant access to instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder keyName(final java.lang.String keyName) {
            this.props.keyName(keyName);
            return this;
        }

        /**
         * (experimental) The machine image (AMI) to use.
         * <p>
         * By default, will do an AMI lookup for the latest NAT instance image.
         * <p>
         * If you have a specific AMI ID you want to use, pass a <code>GenericLinuxImage</code>. For example:
         * <p>
         * <blockquote><pre>
         * // Example automatically generated. See https://github.com/aws/jsii/issues/826
         * ec2.NatProvider.instance(Map.of(
         *         "instanceType", new InstanceType("t3.micro"),
         *         "machineImage", GenericLinuxImage.Builder.create()
         *                 .us-east-2("ami-0f9c61b5a562a16af")
         *                 .build()));
         * </pre></blockquote>
         * <p>
         * Default: - Latest NAT instance image
         * <p>
         * @return {@code this}
         * @param machineImage The machine image (AMI) to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder machineImage(final software.amazon.awscdk.services.ec2.IMachineImage machineImage) {
            this.props.machineImage(machineImage);
            return this;
        }

        /**
         * (experimental) Security Group for NAT instances.
         * <p>
         * Default: - A new security group will be created
         * <p>
         * @return {@code this}
         * @param securityGroup Security Group for NAT instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder securityGroup(final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.NatInstanceProvider}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.NatInstanceProvider build() {
            return new software.amazon.awscdk.services.ec2.NatInstanceProvider(
                this.props.build()
            );
        }
    }
}
