package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.15.0 (build 585166b)", date = "2021-02-03T23:38:07.610Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate")
public class CfnLaunchTemplate extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnLaunchTemplate(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnLaunchTemplate(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::EC2::LaunchTemplate`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnLaunchTemplate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.CfnLaunchTemplateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::EC2::LaunchTemplate`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnLaunchTemplate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDefaultVersionNumber() {
        return software.amazon.jsii.Kernel.get(this, "attrDefaultVersionNumber", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLatestVersionNumber() {
        return software.amazon.jsii.Kernel.get(this, "attrLatestVersionNumber", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::EC2::LaunchTemplate.LaunchTemplateData`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-launchtemplatedata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLaunchTemplateData() {
        return software.amazon.jsii.Kernel.get(this, "launchTemplateData", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::EC2::LaunchTemplate.LaunchTemplateData`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-launchtemplatedata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLaunchTemplateData(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "launchTemplateData", value);
    }

    /**
     * `AWS::EC2::LaunchTemplate.LaunchTemplateData`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-launchtemplatedata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLaunchTemplateData(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.CfnLaunchTemplate.LaunchTemplateDataProperty value) {
        software.amazon.jsii.Kernel.set(this, "launchTemplateData", value);
    }

    /**
     * `AWS::EC2::LaunchTemplate.LaunchTemplateName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-launchtemplatename
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLaunchTemplateName() {
        return software.amazon.jsii.Kernel.get(this, "launchTemplateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::EC2::LaunchTemplate.LaunchTemplateName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-launchtemplatename
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLaunchTemplateName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "launchTemplateName", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.BlockDeviceMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(BlockDeviceMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BlockDeviceMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLaunchTemplate.BlockDeviceMappingProperty.DeviceName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-devicename
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDeviceName() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.BlockDeviceMappingProperty.Ebs`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEbs() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.BlockDeviceMappingProperty.NoDevice`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-nodevice
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNoDevice() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.BlockDeviceMappingProperty.VirtualName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-virtualname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVirtualName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BlockDeviceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BlockDeviceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BlockDeviceMappingProperty> {
            private java.lang.String deviceName;
            private java.lang.Object ebs;
            private java.lang.String noDevice;
            private java.lang.String virtualName;

            /**
             * Sets the value of {@link BlockDeviceMappingProperty#getDeviceName}
             * @param deviceName `CfnLaunchTemplate.BlockDeviceMappingProperty.DeviceName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deviceName(java.lang.String deviceName) {
                this.deviceName = deviceName;
                return this;
            }

            /**
             * Sets the value of {@link BlockDeviceMappingProperty#getEbs}
             * @param ebs `CfnLaunchTemplate.BlockDeviceMappingProperty.Ebs`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebs(software.amazon.awscdk.core.IResolvable ebs) {
                this.ebs = ebs;
                return this;
            }

            /**
             * Sets the value of {@link BlockDeviceMappingProperty#getEbs}
             * @param ebs `CfnLaunchTemplate.BlockDeviceMappingProperty.Ebs`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebs(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.EbsProperty ebs) {
                this.ebs = ebs;
                return this;
            }

            /**
             * Sets the value of {@link BlockDeviceMappingProperty#getNoDevice}
             * @param noDevice `CfnLaunchTemplate.BlockDeviceMappingProperty.NoDevice`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noDevice(java.lang.String noDevice) {
                this.noDevice = noDevice;
                return this;
            }

            /**
             * Sets the value of {@link BlockDeviceMappingProperty#getVirtualName}
             * @param virtualName `CfnLaunchTemplate.BlockDeviceMappingProperty.VirtualName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder virtualName(java.lang.String virtualName) {
                this.virtualName = virtualName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BlockDeviceMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BlockDeviceMappingProperty build() {
                return new Jsii$Proxy(deviceName, ebs, noDevice, virtualName);
            }
        }

        /**
         * An implementation for {@link BlockDeviceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BlockDeviceMappingProperty {
            private final java.lang.String deviceName;
            private final java.lang.Object ebs;
            private final java.lang.String noDevice;
            private final java.lang.String virtualName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deviceName = software.amazon.jsii.Kernel.get(this, "deviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ebs = software.amazon.jsii.Kernel.get(this, "ebs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.noDevice = software.amazon.jsii.Kernel.get(this, "noDevice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.virtualName = software.amazon.jsii.Kernel.get(this, "virtualName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String deviceName, final java.lang.Object ebs, final java.lang.String noDevice, final java.lang.String virtualName) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deviceName = deviceName;
                this.ebs = ebs;
                this.noDevice = noDevice;
                this.virtualName = virtualName;
            }

            @Override
            public final java.lang.String getDeviceName() {
                return this.deviceName;
            }

            @Override
            public final java.lang.Object getEbs() {
                return this.ebs;
            }

            @Override
            public final java.lang.String getNoDevice() {
                return this.noDevice;
            }

            @Override
            public final java.lang.String getVirtualName() {
                return this.virtualName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDeviceName() != null) {
                    data.set("deviceName", om.valueToTree(this.getDeviceName()));
                }
                if (this.getEbs() != null) {
                    data.set("ebs", om.valueToTree(this.getEbs()));
                }
                if (this.getNoDevice() != null) {
                    data.set("noDevice", om.valueToTree(this.getNoDevice()));
                }
                if (this.getVirtualName() != null) {
                    data.set("virtualName", om.valueToTree(this.getVirtualName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.BlockDeviceMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BlockDeviceMappingProperty.Jsii$Proxy that = (BlockDeviceMappingProperty.Jsii$Proxy) o;

                if (this.deviceName != null ? !this.deviceName.equals(that.deviceName) : that.deviceName != null) return false;
                if (this.ebs != null ? !this.ebs.equals(that.ebs) : that.ebs != null) return false;
                if (this.noDevice != null ? !this.noDevice.equals(that.noDevice) : that.noDevice != null) return false;
                return this.virtualName != null ? this.virtualName.equals(that.virtualName) : that.virtualName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.deviceName != null ? this.deviceName.hashCode() : 0;
                result = 31 * result + (this.ebs != null ? this.ebs.hashCode() : 0);
                result = 31 * result + (this.noDevice != null ? this.noDevice.hashCode() : 0);
                result = 31 * result + (this.virtualName != null ? this.virtualName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.CapacityReservationSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(CapacityReservationSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CapacityReservationSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLaunchTemplate.CapacityReservationSpecificationProperty.CapacityReservationPreference`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification-capacityreservationpreference
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCapacityReservationPreference() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.CapacityReservationSpecificationProperty.CapacityReservationTarget`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification-capacityreservationtarget
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCapacityReservationTarget() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CapacityReservationSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CapacityReservationSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CapacityReservationSpecificationProperty> {
            private java.lang.String capacityReservationPreference;
            private java.lang.Object capacityReservationTarget;

            /**
             * Sets the value of {@link CapacityReservationSpecificationProperty#getCapacityReservationPreference}
             * @param capacityReservationPreference `CfnLaunchTemplate.CapacityReservationSpecificationProperty.CapacityReservationPreference`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityReservationPreference(java.lang.String capacityReservationPreference) {
                this.capacityReservationPreference = capacityReservationPreference;
                return this;
            }

            /**
             * Sets the value of {@link CapacityReservationSpecificationProperty#getCapacityReservationTarget}
             * @param capacityReservationTarget `CfnLaunchTemplate.CapacityReservationSpecificationProperty.CapacityReservationTarget`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityReservationTarget(software.amazon.awscdk.core.IResolvable capacityReservationTarget) {
                this.capacityReservationTarget = capacityReservationTarget;
                return this;
            }

            /**
             * Sets the value of {@link CapacityReservationSpecificationProperty#getCapacityReservationTarget}
             * @param capacityReservationTarget `CfnLaunchTemplate.CapacityReservationSpecificationProperty.CapacityReservationTarget`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityReservationTarget(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.CapacityReservationTargetProperty capacityReservationTarget) {
                this.capacityReservationTarget = capacityReservationTarget;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CapacityReservationSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CapacityReservationSpecificationProperty build() {
                return new Jsii$Proxy(capacityReservationPreference, capacityReservationTarget);
            }
        }

        /**
         * An implementation for {@link CapacityReservationSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CapacityReservationSpecificationProperty {
            private final java.lang.String capacityReservationPreference;
            private final java.lang.Object capacityReservationTarget;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.capacityReservationPreference = software.amazon.jsii.Kernel.get(this, "capacityReservationPreference", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.capacityReservationTarget = software.amazon.jsii.Kernel.get(this, "capacityReservationTarget", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String capacityReservationPreference, final java.lang.Object capacityReservationTarget) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.capacityReservationPreference = capacityReservationPreference;
                this.capacityReservationTarget = capacityReservationTarget;
            }

            @Override
            public final java.lang.String getCapacityReservationPreference() {
                return this.capacityReservationPreference;
            }

            @Override
            public final java.lang.Object getCapacityReservationTarget() {
                return this.capacityReservationTarget;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCapacityReservationPreference() != null) {
                    data.set("capacityReservationPreference", om.valueToTree(this.getCapacityReservationPreference()));
                }
                if (this.getCapacityReservationTarget() != null) {
                    data.set("capacityReservationTarget", om.valueToTree(this.getCapacityReservationTarget()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.CapacityReservationSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CapacityReservationSpecificationProperty.Jsii$Proxy that = (CapacityReservationSpecificationProperty.Jsii$Proxy) o;

                if (this.capacityReservationPreference != null ? !this.capacityReservationPreference.equals(that.capacityReservationPreference) : that.capacityReservationPreference != null) return false;
                return this.capacityReservationTarget != null ? this.capacityReservationTarget.equals(that.capacityReservationTarget) : that.capacityReservationTarget == null;
            }

            @Override
            public final int hashCode() {
                int result = this.capacityReservationPreference != null ? this.capacityReservationPreference.hashCode() : 0;
                result = 31 * result + (this.capacityReservationTarget != null ? this.capacityReservationTarget.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-capacityreservationtarget.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.CapacityReservationTargetProperty")
    @software.amazon.jsii.Jsii.Proxy(CapacityReservationTargetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CapacityReservationTargetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLaunchTemplate.CapacityReservationTargetProperty.CapacityReservationId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-capacityreservationtarget.html#cfn-ec2-launchtemplate-capacityreservationtarget-capacityreservationid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCapacityReservationId() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.CapacityReservationTargetProperty.CapacityReservationResourceGroupArn`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-capacityreservationtarget.html#cfn-ec2-launchtemplate-capacityreservationtarget-capacityreservationresourcegrouparn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCapacityReservationResourceGroupArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CapacityReservationTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CapacityReservationTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CapacityReservationTargetProperty> {
            private java.lang.String capacityReservationId;
            private java.lang.String capacityReservationResourceGroupArn;

            /**
             * Sets the value of {@link CapacityReservationTargetProperty#getCapacityReservationId}
             * @param capacityReservationId `CfnLaunchTemplate.CapacityReservationTargetProperty.CapacityReservationId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityReservationId(java.lang.String capacityReservationId) {
                this.capacityReservationId = capacityReservationId;
                return this;
            }

            /**
             * Sets the value of {@link CapacityReservationTargetProperty#getCapacityReservationResourceGroupArn}
             * @param capacityReservationResourceGroupArn `CfnLaunchTemplate.CapacityReservationTargetProperty.CapacityReservationResourceGroupArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityReservationResourceGroupArn(java.lang.String capacityReservationResourceGroupArn) {
                this.capacityReservationResourceGroupArn = capacityReservationResourceGroupArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CapacityReservationTargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CapacityReservationTargetProperty build() {
                return new Jsii$Proxy(capacityReservationId, capacityReservationResourceGroupArn);
            }
        }

        /**
         * An implementation for {@link CapacityReservationTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CapacityReservationTargetProperty {
            private final java.lang.String capacityReservationId;
            private final java.lang.String capacityReservationResourceGroupArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.capacityReservationId = software.amazon.jsii.Kernel.get(this, "capacityReservationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.capacityReservationResourceGroupArn = software.amazon.jsii.Kernel.get(this, "capacityReservationResourceGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String capacityReservationId, final java.lang.String capacityReservationResourceGroupArn) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.capacityReservationId = capacityReservationId;
                this.capacityReservationResourceGroupArn = capacityReservationResourceGroupArn;
            }

            @Override
            public final java.lang.String getCapacityReservationId() {
                return this.capacityReservationId;
            }

            @Override
            public final java.lang.String getCapacityReservationResourceGroupArn() {
                return this.capacityReservationResourceGroupArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCapacityReservationId() != null) {
                    data.set("capacityReservationId", om.valueToTree(this.getCapacityReservationId()));
                }
                if (this.getCapacityReservationResourceGroupArn() != null) {
                    data.set("capacityReservationResourceGroupArn", om.valueToTree(this.getCapacityReservationResourceGroupArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.CapacityReservationTargetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CapacityReservationTargetProperty.Jsii$Proxy that = (CapacityReservationTargetProperty.Jsii$Proxy) o;

                if (this.capacityReservationId != null ? !this.capacityReservationId.equals(that.capacityReservationId) : that.capacityReservationId != null) return false;
                return this.capacityReservationResourceGroupArn != null ? this.capacityReservationResourceGroupArn.equals(that.capacityReservationResourceGroupArn) : that.capacityReservationResourceGroupArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.capacityReservationId != null ? this.capacityReservationId.hashCode() : 0;
                result = 31 * result + (this.capacityReservationResourceGroupArn != null ? this.capacityReservationResourceGroupArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-cpuoptions.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.CpuOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(CpuOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CpuOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLaunchTemplate.CpuOptionsProperty.CoreCount`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-cpuoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-cpuoptions-corecount
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCoreCount() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.CpuOptionsProperty.ThreadsPerCore`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-cpuoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-cpuoptions-threadspercore
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThreadsPerCore() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CpuOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CpuOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CpuOptionsProperty> {
            private java.lang.Number coreCount;
            private java.lang.Number threadsPerCore;

            /**
             * Sets the value of {@link CpuOptionsProperty#getCoreCount}
             * @param coreCount `CfnLaunchTemplate.CpuOptionsProperty.CoreCount`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder coreCount(java.lang.Number coreCount) {
                this.coreCount = coreCount;
                return this;
            }

            /**
             * Sets the value of {@link CpuOptionsProperty#getThreadsPerCore}
             * @param threadsPerCore `CfnLaunchTemplate.CpuOptionsProperty.ThreadsPerCore`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder threadsPerCore(java.lang.Number threadsPerCore) {
                this.threadsPerCore = threadsPerCore;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CpuOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CpuOptionsProperty build() {
                return new Jsii$Proxy(coreCount, threadsPerCore);
            }
        }

        /**
         * An implementation for {@link CpuOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CpuOptionsProperty {
            private final java.lang.Number coreCount;
            private final java.lang.Number threadsPerCore;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.coreCount = software.amazon.jsii.Kernel.get(this, "coreCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.threadsPerCore = software.amazon.jsii.Kernel.get(this, "threadsPerCore", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Number coreCount, final java.lang.Number threadsPerCore) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.coreCount = coreCount;
                this.threadsPerCore = threadsPerCore;
            }

            @Override
            public final java.lang.Number getCoreCount() {
                return this.coreCount;
            }

            @Override
            public final java.lang.Number getThreadsPerCore() {
                return this.threadsPerCore;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCoreCount() != null) {
                    data.set("coreCount", om.valueToTree(this.getCoreCount()));
                }
                if (this.getThreadsPerCore() != null) {
                    data.set("threadsPerCore", om.valueToTree(this.getThreadsPerCore()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.CpuOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CpuOptionsProperty.Jsii$Proxy that = (CpuOptionsProperty.Jsii$Proxy) o;

                if (this.coreCount != null ? !this.coreCount.equals(that.coreCount) : that.coreCount != null) return false;
                return this.threadsPerCore != null ? this.threadsPerCore.equals(that.threadsPerCore) : that.threadsPerCore == null;
            }

            @Override
            public final int hashCode() {
                int result = this.coreCount != null ? this.coreCount.hashCode() : 0;
                result = 31 * result + (this.threadsPerCore != null ? this.threadsPerCore.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-creditspecification.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.CreditSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(CreditSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CreditSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLaunchTemplate.CreditSpecificationProperty.CpuCredits`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-creditspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification-cpucredits
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCpuCredits() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CreditSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CreditSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CreditSpecificationProperty> {
            private java.lang.String cpuCredits;

            /**
             * Sets the value of {@link CreditSpecificationProperty#getCpuCredits}
             * @param cpuCredits `CfnLaunchTemplate.CreditSpecificationProperty.CpuCredits`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cpuCredits(java.lang.String cpuCredits) {
                this.cpuCredits = cpuCredits;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CreditSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CreditSpecificationProperty build() {
                return new Jsii$Proxy(cpuCredits);
            }
        }

        /**
         * An implementation for {@link CreditSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CreditSpecificationProperty {
            private final java.lang.String cpuCredits;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cpuCredits = software.amazon.jsii.Kernel.get(this, "cpuCredits", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String cpuCredits) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cpuCredits = cpuCredits;
            }

            @Override
            public final java.lang.String getCpuCredits() {
                return this.cpuCredits;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCpuCredits() != null) {
                    data.set("cpuCredits", om.valueToTree(this.getCpuCredits()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.CreditSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CreditSpecificationProperty.Jsii$Proxy that = (CreditSpecificationProperty.Jsii$Proxy) o;

                return this.cpuCredits != null ? this.cpuCredits.equals(that.cpuCredits) : that.cpuCredits == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cpuCredits != null ? this.cpuCredits.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.EbsProperty")
    @software.amazon.jsii.Jsii.Proxy(EbsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EbsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLaunchTemplate.EbsProperty.DeleteOnTermination`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-deleteontermination
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeleteOnTermination() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.EbsProperty.Encrypted`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-encrypted
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncrypted() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.EbsProperty.Iops`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-iops
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIops() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.EbsProperty.KmsKeyId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-kmskeyid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.EbsProperty.SnapshotId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-snapshotid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSnapshotId() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.EbsProperty.Throughput`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-throughput
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThroughput() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.EbsProperty.VolumeSize`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumesize
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getVolumeSize() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.EbsProperty.VolumeType`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVolumeType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EbsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EbsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EbsProperty> {
            private java.lang.Object deleteOnTermination;
            private java.lang.Object encrypted;
            private java.lang.Number iops;
            private java.lang.String kmsKeyId;
            private java.lang.String snapshotId;
            private java.lang.Number throughput;
            private java.lang.Number volumeSize;
            private java.lang.String volumeType;

            /**
             * Sets the value of {@link EbsProperty#getDeleteOnTermination}
             * @param deleteOnTermination `CfnLaunchTemplate.EbsProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteOnTermination(java.lang.Boolean deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            /**
             * Sets the value of {@link EbsProperty#getDeleteOnTermination}
             * @param deleteOnTermination `CfnLaunchTemplate.EbsProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteOnTermination(software.amazon.awscdk.core.IResolvable deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            /**
             * Sets the value of {@link EbsProperty#getEncrypted}
             * @param encrypted `CfnLaunchTemplate.EbsProperty.Encrypted`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encrypted(java.lang.Boolean encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            /**
             * Sets the value of {@link EbsProperty#getEncrypted}
             * @param encrypted `CfnLaunchTemplate.EbsProperty.Encrypted`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encrypted(software.amazon.awscdk.core.IResolvable encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            /**
             * Sets the value of {@link EbsProperty#getIops}
             * @param iops `CfnLaunchTemplate.EbsProperty.Iops`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iops(java.lang.Number iops) {
                this.iops = iops;
                return this;
            }

            /**
             * Sets the value of {@link EbsProperty#getKmsKeyId}
             * @param kmsKeyId `CfnLaunchTemplate.EbsProperty.KmsKeyId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Sets the value of {@link EbsProperty#getSnapshotId}
             * @param snapshotId `CfnLaunchTemplate.EbsProperty.SnapshotId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snapshotId(java.lang.String snapshotId) {
                this.snapshotId = snapshotId;
                return this;
            }

            /**
             * Sets the value of {@link EbsProperty#getThroughput}
             * @param throughput `CfnLaunchTemplate.EbsProperty.Throughput`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder throughput(java.lang.Number throughput) {
                this.throughput = throughput;
                return this;
            }

            /**
             * Sets the value of {@link EbsProperty#getVolumeSize}
             * @param volumeSize `CfnLaunchTemplate.EbsProperty.VolumeSize`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeSize(java.lang.Number volumeSize) {
                this.volumeSize = volumeSize;
                return this;
            }

            /**
             * Sets the value of {@link EbsProperty#getVolumeType}
             * @param volumeType `CfnLaunchTemplate.EbsProperty.VolumeType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeType(java.lang.String volumeType) {
                this.volumeType = volumeType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EbsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EbsProperty build() {
                return new Jsii$Proxy(deleteOnTermination, encrypted, iops, kmsKeyId, snapshotId, throughput, volumeSize, volumeType);
            }
        }

        /**
         * An implementation for {@link EbsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EbsProperty {
            private final java.lang.Object deleteOnTermination;
            private final java.lang.Object encrypted;
            private final java.lang.Number iops;
            private final java.lang.String kmsKeyId;
            private final java.lang.String snapshotId;
            private final java.lang.Number throughput;
            private final java.lang.Number volumeSize;
            private final java.lang.String volumeType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deleteOnTermination = software.amazon.jsii.Kernel.get(this, "deleteOnTermination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.encrypted = software.amazon.jsii.Kernel.get(this, "encrypted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.iops = software.amazon.jsii.Kernel.get(this, "iops", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.snapshotId = software.amazon.jsii.Kernel.get(this, "snapshotId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.throughput = software.amazon.jsii.Kernel.get(this, "throughput", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.volumeSize = software.amazon.jsii.Kernel.get(this, "volumeSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.volumeType = software.amazon.jsii.Kernel.get(this, "volumeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Object deleteOnTermination, final java.lang.Object encrypted, final java.lang.Number iops, final java.lang.String kmsKeyId, final java.lang.String snapshotId, final java.lang.Number throughput, final java.lang.Number volumeSize, final java.lang.String volumeType) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deleteOnTermination = deleteOnTermination;
                this.encrypted = encrypted;
                this.iops = iops;
                this.kmsKeyId = kmsKeyId;
                this.snapshotId = snapshotId;
                this.throughput = throughput;
                this.volumeSize = volumeSize;
                this.volumeType = volumeType;
            }

            @Override
            public final java.lang.Object getDeleteOnTermination() {
                return this.deleteOnTermination;
            }

            @Override
            public final java.lang.Object getEncrypted() {
                return this.encrypted;
            }

            @Override
            public final java.lang.Number getIops() {
                return this.iops;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            public final java.lang.String getSnapshotId() {
                return this.snapshotId;
            }

            @Override
            public final java.lang.Number getThroughput() {
                return this.throughput;
            }

            @Override
            public final java.lang.Number getVolumeSize() {
                return this.volumeSize;
            }

            @Override
            public final java.lang.String getVolumeType() {
                return this.volumeType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDeleteOnTermination() != null) {
                    data.set("deleteOnTermination", om.valueToTree(this.getDeleteOnTermination()));
                }
                if (this.getEncrypted() != null) {
                    data.set("encrypted", om.valueToTree(this.getEncrypted()));
                }
                if (this.getIops() != null) {
                    data.set("iops", om.valueToTree(this.getIops()));
                }
                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }
                if (this.getSnapshotId() != null) {
                    data.set("snapshotId", om.valueToTree(this.getSnapshotId()));
                }
                if (this.getThroughput() != null) {
                    data.set("throughput", om.valueToTree(this.getThroughput()));
                }
                if (this.getVolumeSize() != null) {
                    data.set("volumeSize", om.valueToTree(this.getVolumeSize()));
                }
                if (this.getVolumeType() != null) {
                    data.set("volumeType", om.valueToTree(this.getVolumeType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.EbsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EbsProperty.Jsii$Proxy that = (EbsProperty.Jsii$Proxy) o;

                if (this.deleteOnTermination != null ? !this.deleteOnTermination.equals(that.deleteOnTermination) : that.deleteOnTermination != null) return false;
                if (this.encrypted != null ? !this.encrypted.equals(that.encrypted) : that.encrypted != null) return false;
                if (this.iops != null ? !this.iops.equals(that.iops) : that.iops != null) return false;
                if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
                if (this.snapshotId != null ? !this.snapshotId.equals(that.snapshotId) : that.snapshotId != null) return false;
                if (this.throughput != null ? !this.throughput.equals(that.throughput) : that.throughput != null) return false;
                if (this.volumeSize != null ? !this.volumeSize.equals(that.volumeSize) : that.volumeSize != null) return false;
                return this.volumeType != null ? this.volumeType.equals(that.volumeType) : that.volumeType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.deleteOnTermination != null ? this.deleteOnTermination.hashCode() : 0;
                result = 31 * result + (this.encrypted != null ? this.encrypted.hashCode() : 0);
                result = 31 * result + (this.iops != null ? this.iops.hashCode() : 0);
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                result = 31 * result + (this.snapshotId != null ? this.snapshotId.hashCode() : 0);
                result = 31 * result + (this.throughput != null ? this.throughput.hashCode() : 0);
                result = 31 * result + (this.volumeSize != null ? this.volumeSize.hashCode() : 0);
                result = 31 * result + (this.volumeType != null ? this.volumeType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-elasticgpuspecification.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.ElasticGpuSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(ElasticGpuSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ElasticGpuSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLaunchTemplate.ElasticGpuSpecificationProperty.Type`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-elasticgpuspecification.html#cfn-ec2-launchtemplate-elasticgpuspecification-type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ElasticGpuSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ElasticGpuSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ElasticGpuSpecificationProperty> {
            private java.lang.String type;

            /**
             * Sets the value of {@link ElasticGpuSpecificationProperty#getType}
             * @param type `CfnLaunchTemplate.ElasticGpuSpecificationProperty.Type`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ElasticGpuSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ElasticGpuSpecificationProperty build() {
                return new Jsii$Proxy(type);
            }
        }

        /**
         * An implementation for {@link ElasticGpuSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ElasticGpuSpecificationProperty {
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String type) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = type;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.ElasticGpuSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ElasticGpuSpecificationProperty.Jsii$Proxy that = (ElasticGpuSpecificationProperty.Jsii$Proxy) o;

                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type != null ? this.type.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-enclaveoptions.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.EnclaveOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(EnclaveOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EnclaveOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLaunchTemplate.EnclaveOptionsProperty.Enabled`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-enclaveoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-enclaveoptions-enabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EnclaveOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EnclaveOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EnclaveOptionsProperty> {
            private java.lang.Object enabled;

            /**
             * Sets the value of {@link EnclaveOptionsProperty#getEnabled}
             * @param enabled `CfnLaunchTemplate.EnclaveOptionsProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link EnclaveOptionsProperty#getEnabled}
             * @param enabled `CfnLaunchTemplate.EnclaveOptionsProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EnclaveOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EnclaveOptionsProperty build() {
                return new Jsii$Proxy(enabled);
            }
        }

        /**
         * An implementation for {@link EnclaveOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EnclaveOptionsProperty {
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Object enabled) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = enabled;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.EnclaveOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EnclaveOptionsProperty.Jsii$Proxy that = (EnclaveOptionsProperty.Jsii$Proxy) o;

                return this.enabled != null ? this.enabled.equals(that.enabled) : that.enabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-hibernationoptions.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.HibernationOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(HibernationOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HibernationOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLaunchTemplate.HibernationOptionsProperty.Configured`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-hibernationoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-hibernationoptions-configured
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfigured() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HibernationOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HibernationOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HibernationOptionsProperty> {
            private java.lang.Object configured;

            /**
             * Sets the value of {@link HibernationOptionsProperty#getConfigured}
             * @param configured `CfnLaunchTemplate.HibernationOptionsProperty.Configured`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configured(java.lang.Boolean configured) {
                this.configured = configured;
                return this;
            }

            /**
             * Sets the value of {@link HibernationOptionsProperty#getConfigured}
             * @param configured `CfnLaunchTemplate.HibernationOptionsProperty.Configured`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configured(software.amazon.awscdk.core.IResolvable configured) {
                this.configured = configured;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HibernationOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HibernationOptionsProperty build() {
                return new Jsii$Proxy(configured);
            }
        }

        /**
         * An implementation for {@link HibernationOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HibernationOptionsProperty {
            private final java.lang.Object configured;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.configured = software.amazon.jsii.Kernel.get(this, "configured", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Object configured) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.configured = configured;
            }

            @Override
            public final java.lang.Object getConfigured() {
                return this.configured;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConfigured() != null) {
                    data.set("configured", om.valueToTree(this.getConfigured()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.HibernationOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HibernationOptionsProperty.Jsii$Proxy that = (HibernationOptionsProperty.Jsii$Proxy) o;

                return this.configured != null ? this.configured.equals(that.configured) : that.configured == null;
            }

            @Override
            public final int hashCode() {
                int result = this.configured != null ? this.configured.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.IamInstanceProfileProperty")
    @software.amazon.jsii.Jsii.Proxy(IamInstanceProfileProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IamInstanceProfileProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLaunchTemplate.IamInstanceProfileProperty.Arn`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-arn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getArn() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.IamInstanceProfileProperty.Name`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-name
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IamInstanceProfileProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IamInstanceProfileProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IamInstanceProfileProperty> {
            private java.lang.String arn;
            private java.lang.String name;

            /**
             * Sets the value of {@link IamInstanceProfileProperty#getArn}
             * @param arn `CfnLaunchTemplate.IamInstanceProfileProperty.Arn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Sets the value of {@link IamInstanceProfileProperty#getName}
             * @param name `CfnLaunchTemplate.IamInstanceProfileProperty.Name`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IamInstanceProfileProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IamInstanceProfileProperty build() {
                return new Jsii$Proxy(arn, name);
            }
        }

        /**
         * An implementation for {@link IamInstanceProfileProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IamInstanceProfileProperty {
            private final java.lang.String arn;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String arn, final java.lang.String name) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = arn;
                this.name = name;
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getArn() != null) {
                    data.set("arn", om.valueToTree(this.getArn()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.IamInstanceProfileProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IamInstanceProfileProperty.Jsii$Proxy that = (IamInstanceProfileProperty.Jsii$Proxy) o;

                if (this.arn != null ? !this.arn.equals(that.arn) : that.arn != null) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.arn != null ? this.arn.hashCode() : 0;
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.InstanceMarketOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceMarketOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InstanceMarketOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLaunchTemplate.InstanceMarketOptionsProperty.MarketType`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-markettype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMarketType() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.InstanceMarketOptionsProperty.SpotOptions`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSpotOptions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceMarketOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceMarketOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceMarketOptionsProperty> {
            private java.lang.String marketType;
            private java.lang.Object spotOptions;

            /**
             * Sets the value of {@link InstanceMarketOptionsProperty#getMarketType}
             * @param marketType `CfnLaunchTemplate.InstanceMarketOptionsProperty.MarketType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder marketType(java.lang.String marketType) {
                this.marketType = marketType;
                return this;
            }

            /**
             * Sets the value of {@link InstanceMarketOptionsProperty#getSpotOptions}
             * @param spotOptions `CfnLaunchTemplate.InstanceMarketOptionsProperty.SpotOptions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spotOptions(software.amazon.awscdk.core.IResolvable spotOptions) {
                this.spotOptions = spotOptions;
                return this;
            }

            /**
             * Sets the value of {@link InstanceMarketOptionsProperty#getSpotOptions}
             * @param spotOptions `CfnLaunchTemplate.InstanceMarketOptionsProperty.SpotOptions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spotOptions(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.SpotOptionsProperty spotOptions) {
                this.spotOptions = spotOptions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceMarketOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InstanceMarketOptionsProperty build() {
                return new Jsii$Proxy(marketType, spotOptions);
            }
        }

        /**
         * An implementation for {@link InstanceMarketOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceMarketOptionsProperty {
            private final java.lang.String marketType;
            private final java.lang.Object spotOptions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.marketType = software.amazon.jsii.Kernel.get(this, "marketType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.spotOptions = software.amazon.jsii.Kernel.get(this, "spotOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String marketType, final java.lang.Object spotOptions) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.marketType = marketType;
                this.spotOptions = spotOptions;
            }

            @Override
            public final java.lang.String getMarketType() {
                return this.marketType;
            }

            @Override
            public final java.lang.Object getSpotOptions() {
                return this.spotOptions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMarketType() != null) {
                    data.set("marketType", om.valueToTree(this.getMarketType()));
                }
                if (this.getSpotOptions() != null) {
                    data.set("spotOptions", om.valueToTree(this.getSpotOptions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.InstanceMarketOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceMarketOptionsProperty.Jsii$Proxy that = (InstanceMarketOptionsProperty.Jsii$Proxy) o;

                if (this.marketType != null ? !this.marketType.equals(that.marketType) : that.marketType != null) return false;
                return this.spotOptions != null ? this.spotOptions.equals(that.spotOptions) : that.spotOptions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.marketType != null ? this.marketType.hashCode() : 0;
                result = 31 * result + (this.spotOptions != null ? this.spotOptions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-ipv6add.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.Ipv6AddProperty")
    @software.amazon.jsii.Jsii.Proxy(Ipv6AddProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface Ipv6AddProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLaunchTemplate.Ipv6AddProperty.Ipv6Address`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-ipv6add.html#cfn-ec2-launchtemplate-ipv6add-ipv6address
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIpv6Address() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link Ipv6AddProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link Ipv6AddProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<Ipv6AddProperty> {
            private java.lang.String ipv6Address;

            /**
             * Sets the value of {@link Ipv6AddProperty#getIpv6Address}
             * @param ipv6Address `CfnLaunchTemplate.Ipv6AddProperty.Ipv6Address`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv6Address(java.lang.String ipv6Address) {
                this.ipv6Address = ipv6Address;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link Ipv6AddProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public Ipv6AddProperty build() {
                return new Jsii$Proxy(ipv6Address);
            }
        }

        /**
         * An implementation for {@link Ipv6AddProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Ipv6AddProperty {
            private final java.lang.String ipv6Address;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ipv6Address = software.amazon.jsii.Kernel.get(this, "ipv6Address", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String ipv6Address) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ipv6Address = ipv6Address;
            }

            @Override
            public final java.lang.String getIpv6Address() {
                return this.ipv6Address;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIpv6Address() != null) {
                    data.set("ipv6Address", om.valueToTree(this.getIpv6Address()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.Ipv6AddProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                Ipv6AddProperty.Jsii$Proxy that = (Ipv6AddProperty.Jsii$Proxy) o;

                return this.ipv6Address != null ? this.ipv6Address.equals(that.ipv6Address) : that.ipv6Address == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ipv6Address != null ? this.ipv6Address.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.LaunchTemplateDataProperty")
    @software.amazon.jsii.Jsii.Proxy(LaunchTemplateDataProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LaunchTemplateDataProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.BlockDeviceMappings`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-blockdevicemappings
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBlockDeviceMappings() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.CapacityReservationSpecification`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCapacityReservationSpecification() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.CpuOptions`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-cpuoptions
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCpuOptions() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.CreditSpecification`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCreditSpecification() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.DisableApiTermination`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-disableapitermination
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDisableApiTermination() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.EbsOptimized`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ebsoptimized
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEbsOptimized() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticGpuSpecifications`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-elasticgpuspecifications
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getElasticGpuSpecifications() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticInferenceAccelerators`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-elasticinferenceaccelerators
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getElasticInferenceAccelerators() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.EnclaveOptions`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-enclaveoptions
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnclaveOptions() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.HibernationOptions`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-hibernationoptions
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHibernationOptions() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.IamInstanceProfile`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIamInstanceProfile() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.ImageId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-imageid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getImageId() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceInitiatedShutdownBehavior`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instanceinitiatedshutdownbehavior
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceInitiatedShutdownBehavior() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceMarketOptions`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInstanceMarketOptions() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceType`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceType() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.KernelId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-kernelid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKernelId() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.KeyName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-keyname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKeyName() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.LicenseSpecifications`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-licensespecifications
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLicenseSpecifications() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.MetadataOptions`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMetadataOptions() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.Monitoring`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMonitoring() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.NetworkInterfaces`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-networkinterfaces
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkInterfaces() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.Placement`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-placement
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPlacement() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.RamDiskId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ramdiskid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRamDiskId() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.SecurityGroupIds`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroupids
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.SecurityGroups`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroups
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroups() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.TagSpecifications`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-tagspecifications
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTagSpecifications() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.UserData`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-userdata
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUserData() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LaunchTemplateDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LaunchTemplateDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LaunchTemplateDataProperty> {
            private java.lang.Object blockDeviceMappings;
            private java.lang.Object capacityReservationSpecification;
            private java.lang.Object cpuOptions;
            private java.lang.Object creditSpecification;
            private java.lang.Object disableApiTermination;
            private java.lang.Object ebsOptimized;
            private java.lang.Object elasticGpuSpecifications;
            private java.lang.Object elasticInferenceAccelerators;
            private java.lang.Object enclaveOptions;
            private java.lang.Object hibernationOptions;
            private java.lang.Object iamInstanceProfile;
            private java.lang.String imageId;
            private java.lang.String instanceInitiatedShutdownBehavior;
            private java.lang.Object instanceMarketOptions;
            private java.lang.String instanceType;
            private java.lang.String kernelId;
            private java.lang.String keyName;
            private java.lang.Object licenseSpecifications;
            private java.lang.Object metadataOptions;
            private java.lang.Object monitoring;
            private java.lang.Object networkInterfaces;
            private java.lang.Object placement;
            private java.lang.String ramDiskId;
            private java.util.List<java.lang.String> securityGroupIds;
            private java.util.List<java.lang.String> securityGroups;
            private java.lang.Object tagSpecifications;
            private java.lang.String userData;

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getBlockDeviceMappings}
             * @param blockDeviceMappings `CfnLaunchTemplate.LaunchTemplateDataProperty.BlockDeviceMappings`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockDeviceMappings(software.amazon.awscdk.core.IResolvable blockDeviceMappings) {
                this.blockDeviceMappings = blockDeviceMappings;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getBlockDeviceMappings}
             * @param blockDeviceMappings `CfnLaunchTemplate.LaunchTemplateDataProperty.BlockDeviceMappings`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockDeviceMappings(java.util.List<? extends java.lang.Object> blockDeviceMappings) {
                this.blockDeviceMappings = blockDeviceMappings;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getCapacityReservationSpecification}
             * @param capacityReservationSpecification `CfnLaunchTemplate.LaunchTemplateDataProperty.CapacityReservationSpecification`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityReservationSpecification(software.amazon.awscdk.core.IResolvable capacityReservationSpecification) {
                this.capacityReservationSpecification = capacityReservationSpecification;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getCapacityReservationSpecification}
             * @param capacityReservationSpecification `CfnLaunchTemplate.LaunchTemplateDataProperty.CapacityReservationSpecification`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityReservationSpecification(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.CapacityReservationSpecificationProperty capacityReservationSpecification) {
                this.capacityReservationSpecification = capacityReservationSpecification;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getCpuOptions}
             * @param cpuOptions `CfnLaunchTemplate.LaunchTemplateDataProperty.CpuOptions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cpuOptions(software.amazon.awscdk.core.IResolvable cpuOptions) {
                this.cpuOptions = cpuOptions;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getCpuOptions}
             * @param cpuOptions `CfnLaunchTemplate.LaunchTemplateDataProperty.CpuOptions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cpuOptions(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.CpuOptionsProperty cpuOptions) {
                this.cpuOptions = cpuOptions;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getCreditSpecification}
             * @param creditSpecification `CfnLaunchTemplate.LaunchTemplateDataProperty.CreditSpecification`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder creditSpecification(software.amazon.awscdk.core.IResolvable creditSpecification) {
                this.creditSpecification = creditSpecification;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getCreditSpecification}
             * @param creditSpecification `CfnLaunchTemplate.LaunchTemplateDataProperty.CreditSpecification`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder creditSpecification(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.CreditSpecificationProperty creditSpecification) {
                this.creditSpecification = creditSpecification;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getDisableApiTermination}
             * @param disableApiTermination `CfnLaunchTemplate.LaunchTemplateDataProperty.DisableApiTermination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableApiTermination(java.lang.Boolean disableApiTermination) {
                this.disableApiTermination = disableApiTermination;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getDisableApiTermination}
             * @param disableApiTermination `CfnLaunchTemplate.LaunchTemplateDataProperty.DisableApiTermination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableApiTermination(software.amazon.awscdk.core.IResolvable disableApiTermination) {
                this.disableApiTermination = disableApiTermination;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getEbsOptimized}
             * @param ebsOptimized `CfnLaunchTemplate.LaunchTemplateDataProperty.EbsOptimized`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsOptimized(java.lang.Boolean ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getEbsOptimized}
             * @param ebsOptimized `CfnLaunchTemplate.LaunchTemplateDataProperty.EbsOptimized`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsOptimized(software.amazon.awscdk.core.IResolvable ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getElasticGpuSpecifications}
             * @param elasticGpuSpecifications `CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticGpuSpecifications`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder elasticGpuSpecifications(software.amazon.awscdk.core.IResolvable elasticGpuSpecifications) {
                this.elasticGpuSpecifications = elasticGpuSpecifications;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getElasticGpuSpecifications}
             * @param elasticGpuSpecifications `CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticGpuSpecifications`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder elasticGpuSpecifications(java.util.List<? extends java.lang.Object> elasticGpuSpecifications) {
                this.elasticGpuSpecifications = elasticGpuSpecifications;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getElasticInferenceAccelerators}
             * @param elasticInferenceAccelerators `CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticInferenceAccelerators`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder elasticInferenceAccelerators(software.amazon.awscdk.core.IResolvable elasticInferenceAccelerators) {
                this.elasticInferenceAccelerators = elasticInferenceAccelerators;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getElasticInferenceAccelerators}
             * @param elasticInferenceAccelerators `CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticInferenceAccelerators`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder elasticInferenceAccelerators(java.util.List<? extends java.lang.Object> elasticInferenceAccelerators) {
                this.elasticInferenceAccelerators = elasticInferenceAccelerators;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getEnclaveOptions}
             * @param enclaveOptions `CfnLaunchTemplate.LaunchTemplateDataProperty.EnclaveOptions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enclaveOptions(software.amazon.awscdk.core.IResolvable enclaveOptions) {
                this.enclaveOptions = enclaveOptions;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getEnclaveOptions}
             * @param enclaveOptions `CfnLaunchTemplate.LaunchTemplateDataProperty.EnclaveOptions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enclaveOptions(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.EnclaveOptionsProperty enclaveOptions) {
                this.enclaveOptions = enclaveOptions;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getHibernationOptions}
             * @param hibernationOptions `CfnLaunchTemplate.LaunchTemplateDataProperty.HibernationOptions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hibernationOptions(software.amazon.awscdk.core.IResolvable hibernationOptions) {
                this.hibernationOptions = hibernationOptions;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getHibernationOptions}
             * @param hibernationOptions `CfnLaunchTemplate.LaunchTemplateDataProperty.HibernationOptions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hibernationOptions(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.HibernationOptionsProperty hibernationOptions) {
                this.hibernationOptions = hibernationOptions;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getIamInstanceProfile}
             * @param iamInstanceProfile `CfnLaunchTemplate.LaunchTemplateDataProperty.IamInstanceProfile`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iamInstanceProfile(software.amazon.awscdk.core.IResolvable iamInstanceProfile) {
                this.iamInstanceProfile = iamInstanceProfile;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getIamInstanceProfile}
             * @param iamInstanceProfile `CfnLaunchTemplate.LaunchTemplateDataProperty.IamInstanceProfile`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iamInstanceProfile(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.IamInstanceProfileProperty iamInstanceProfile) {
                this.iamInstanceProfile = iamInstanceProfile;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getImageId}
             * @param imageId `CfnLaunchTemplate.LaunchTemplateDataProperty.ImageId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageId(java.lang.String imageId) {
                this.imageId = imageId;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getInstanceInitiatedShutdownBehavior}
             * @param instanceInitiatedShutdownBehavior `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceInitiatedShutdownBehavior`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceInitiatedShutdownBehavior(java.lang.String instanceInitiatedShutdownBehavior) {
                this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getInstanceMarketOptions}
             * @param instanceMarketOptions `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceMarketOptions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceMarketOptions(software.amazon.awscdk.core.IResolvable instanceMarketOptions) {
                this.instanceMarketOptions = instanceMarketOptions;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getInstanceMarketOptions}
             * @param instanceMarketOptions `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceMarketOptions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceMarketOptions(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.InstanceMarketOptionsProperty instanceMarketOptions) {
                this.instanceMarketOptions = instanceMarketOptions;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getInstanceType}
             * @param instanceType `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getKernelId}
             * @param kernelId `CfnLaunchTemplate.LaunchTemplateDataProperty.KernelId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kernelId(java.lang.String kernelId) {
                this.kernelId = kernelId;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getKeyName}
             * @param keyName `CfnLaunchTemplate.LaunchTemplateDataProperty.KeyName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyName(java.lang.String keyName) {
                this.keyName = keyName;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getLicenseSpecifications}
             * @param licenseSpecifications `CfnLaunchTemplate.LaunchTemplateDataProperty.LicenseSpecifications`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder licenseSpecifications(software.amazon.awscdk.core.IResolvable licenseSpecifications) {
                this.licenseSpecifications = licenseSpecifications;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getLicenseSpecifications}
             * @param licenseSpecifications `CfnLaunchTemplate.LaunchTemplateDataProperty.LicenseSpecifications`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder licenseSpecifications(java.util.List<? extends java.lang.Object> licenseSpecifications) {
                this.licenseSpecifications = licenseSpecifications;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getMetadataOptions}
             * @param metadataOptions `CfnLaunchTemplate.LaunchTemplateDataProperty.MetadataOptions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metadataOptions(software.amazon.awscdk.core.IResolvable metadataOptions) {
                this.metadataOptions = metadataOptions;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getMetadataOptions}
             * @param metadataOptions `CfnLaunchTemplate.LaunchTemplateDataProperty.MetadataOptions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metadataOptions(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.MetadataOptionsProperty metadataOptions) {
                this.metadataOptions = metadataOptions;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getMonitoring}
             * @param monitoring `CfnLaunchTemplate.LaunchTemplateDataProperty.Monitoring`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoring(software.amazon.awscdk.core.IResolvable monitoring) {
                this.monitoring = monitoring;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getMonitoring}
             * @param monitoring `CfnLaunchTemplate.LaunchTemplateDataProperty.Monitoring`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoring(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.MonitoringProperty monitoring) {
                this.monitoring = monitoring;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getNetworkInterfaces}
             * @param networkInterfaces `CfnLaunchTemplate.LaunchTemplateDataProperty.NetworkInterfaces`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkInterfaces(software.amazon.awscdk.core.IResolvable networkInterfaces) {
                this.networkInterfaces = networkInterfaces;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getNetworkInterfaces}
             * @param networkInterfaces `CfnLaunchTemplate.LaunchTemplateDataProperty.NetworkInterfaces`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkInterfaces(java.util.List<? extends java.lang.Object> networkInterfaces) {
                this.networkInterfaces = networkInterfaces;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getPlacement}
             * @param placement `CfnLaunchTemplate.LaunchTemplateDataProperty.Placement`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder placement(software.amazon.awscdk.core.IResolvable placement) {
                this.placement = placement;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getPlacement}
             * @param placement `CfnLaunchTemplate.LaunchTemplateDataProperty.Placement`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder placement(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.PlacementProperty placement) {
                this.placement = placement;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getRamDiskId}
             * @param ramDiskId `CfnLaunchTemplate.LaunchTemplateDataProperty.RamDiskId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ramDiskId(java.lang.String ramDiskId) {
                this.ramDiskId = ramDiskId;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getSecurityGroupIds}
             * @param securityGroupIds `CfnLaunchTemplate.LaunchTemplateDataProperty.SecurityGroupIds`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getSecurityGroups}
             * @param securityGroups `CfnLaunchTemplate.LaunchTemplateDataProperty.SecurityGroups`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroups(java.util.List<java.lang.String> securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getTagSpecifications}
             * @param tagSpecifications `CfnLaunchTemplate.LaunchTemplateDataProperty.TagSpecifications`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagSpecifications(software.amazon.awscdk.core.IResolvable tagSpecifications) {
                this.tagSpecifications = tagSpecifications;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getTagSpecifications}
             * @param tagSpecifications `CfnLaunchTemplate.LaunchTemplateDataProperty.TagSpecifications`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagSpecifications(java.util.List<? extends java.lang.Object> tagSpecifications) {
                this.tagSpecifications = tagSpecifications;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getUserData}
             * @param userData `CfnLaunchTemplate.LaunchTemplateDataProperty.UserData`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userData(java.lang.String userData) {
                this.userData = userData;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LaunchTemplateDataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LaunchTemplateDataProperty build() {
                return new Jsii$Proxy(blockDeviceMappings, capacityReservationSpecification, cpuOptions, creditSpecification, disableApiTermination, ebsOptimized, elasticGpuSpecifications, elasticInferenceAccelerators, enclaveOptions, hibernationOptions, iamInstanceProfile, imageId, instanceInitiatedShutdownBehavior, instanceMarketOptions, instanceType, kernelId, keyName, licenseSpecifications, metadataOptions, monitoring, networkInterfaces, placement, ramDiskId, securityGroupIds, securityGroups, tagSpecifications, userData);
            }
        }

        /**
         * An implementation for {@link LaunchTemplateDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LaunchTemplateDataProperty {
            private final java.lang.Object blockDeviceMappings;
            private final java.lang.Object capacityReservationSpecification;
            private final java.lang.Object cpuOptions;
            private final java.lang.Object creditSpecification;
            private final java.lang.Object disableApiTermination;
            private final java.lang.Object ebsOptimized;
            private final java.lang.Object elasticGpuSpecifications;
            private final java.lang.Object elasticInferenceAccelerators;
            private final java.lang.Object enclaveOptions;
            private final java.lang.Object hibernationOptions;
            private final java.lang.Object iamInstanceProfile;
            private final java.lang.String imageId;
            private final java.lang.String instanceInitiatedShutdownBehavior;
            private final java.lang.Object instanceMarketOptions;
            private final java.lang.String instanceType;
            private final java.lang.String kernelId;
            private final java.lang.String keyName;
            private final java.lang.Object licenseSpecifications;
            private final java.lang.Object metadataOptions;
            private final java.lang.Object monitoring;
            private final java.lang.Object networkInterfaces;
            private final java.lang.Object placement;
            private final java.lang.String ramDiskId;
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.util.List<java.lang.String> securityGroups;
            private final java.lang.Object tagSpecifications;
            private final java.lang.String userData;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.blockDeviceMappings = software.amazon.jsii.Kernel.get(this, "blockDeviceMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.capacityReservationSpecification = software.amazon.jsii.Kernel.get(this, "capacityReservationSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cpuOptions = software.amazon.jsii.Kernel.get(this, "cpuOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.creditSpecification = software.amazon.jsii.Kernel.get(this, "creditSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.disableApiTermination = software.amazon.jsii.Kernel.get(this, "disableApiTermination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ebsOptimized = software.amazon.jsii.Kernel.get(this, "ebsOptimized", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.elasticGpuSpecifications = software.amazon.jsii.Kernel.get(this, "elasticGpuSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.elasticInferenceAccelerators = software.amazon.jsii.Kernel.get(this, "elasticInferenceAccelerators", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enclaveOptions = software.amazon.jsii.Kernel.get(this, "enclaveOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.hibernationOptions = software.amazon.jsii.Kernel.get(this, "hibernationOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.iamInstanceProfile = software.amazon.jsii.Kernel.get(this, "iamInstanceProfile", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.imageId = software.amazon.jsii.Kernel.get(this, "imageId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceInitiatedShutdownBehavior = software.amazon.jsii.Kernel.get(this, "instanceInitiatedShutdownBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceMarketOptions = software.amazon.jsii.Kernel.get(this, "instanceMarketOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kernelId = software.amazon.jsii.Kernel.get(this, "kernelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keyName = software.amazon.jsii.Kernel.get(this, "keyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.licenseSpecifications = software.amazon.jsii.Kernel.get(this, "licenseSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.metadataOptions = software.amazon.jsii.Kernel.get(this, "metadataOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.monitoring = software.amazon.jsii.Kernel.get(this, "monitoring", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkInterfaces = software.amazon.jsii.Kernel.get(this, "networkInterfaces", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.placement = software.amazon.jsii.Kernel.get(this, "placement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ramDiskId = software.amazon.jsii.Kernel.get(this, "ramDiskId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.tagSpecifications = software.amazon.jsii.Kernel.get(this, "tagSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.userData = software.amazon.jsii.Kernel.get(this, "userData", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Object blockDeviceMappings, final java.lang.Object capacityReservationSpecification, final java.lang.Object cpuOptions, final java.lang.Object creditSpecification, final java.lang.Object disableApiTermination, final java.lang.Object ebsOptimized, final java.lang.Object elasticGpuSpecifications, final java.lang.Object elasticInferenceAccelerators, final java.lang.Object enclaveOptions, final java.lang.Object hibernationOptions, final java.lang.Object iamInstanceProfile, final java.lang.String imageId, final java.lang.String instanceInitiatedShutdownBehavior, final java.lang.Object instanceMarketOptions, final java.lang.String instanceType, final java.lang.String kernelId, final java.lang.String keyName, final java.lang.Object licenseSpecifications, final java.lang.Object metadataOptions, final java.lang.Object monitoring, final java.lang.Object networkInterfaces, final java.lang.Object placement, final java.lang.String ramDiskId, final java.util.List<java.lang.String> securityGroupIds, final java.util.List<java.lang.String> securityGroups, final java.lang.Object tagSpecifications, final java.lang.String userData) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.blockDeviceMappings = blockDeviceMappings;
                this.capacityReservationSpecification = capacityReservationSpecification;
                this.cpuOptions = cpuOptions;
                this.creditSpecification = creditSpecification;
                this.disableApiTermination = disableApiTermination;
                this.ebsOptimized = ebsOptimized;
                this.elasticGpuSpecifications = elasticGpuSpecifications;
                this.elasticInferenceAccelerators = elasticInferenceAccelerators;
                this.enclaveOptions = enclaveOptions;
                this.hibernationOptions = hibernationOptions;
                this.iamInstanceProfile = iamInstanceProfile;
                this.imageId = imageId;
                this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
                this.instanceMarketOptions = instanceMarketOptions;
                this.instanceType = instanceType;
                this.kernelId = kernelId;
                this.keyName = keyName;
                this.licenseSpecifications = licenseSpecifications;
                this.metadataOptions = metadataOptions;
                this.monitoring = monitoring;
                this.networkInterfaces = networkInterfaces;
                this.placement = placement;
                this.ramDiskId = ramDiskId;
                this.securityGroupIds = securityGroupIds;
                this.securityGroups = securityGroups;
                this.tagSpecifications = tagSpecifications;
                this.userData = userData;
            }

            @Override
            public final java.lang.Object getBlockDeviceMappings() {
                return this.blockDeviceMappings;
            }

            @Override
            public final java.lang.Object getCapacityReservationSpecification() {
                return this.capacityReservationSpecification;
            }

            @Override
            public final java.lang.Object getCpuOptions() {
                return this.cpuOptions;
            }

            @Override
            public final java.lang.Object getCreditSpecification() {
                return this.creditSpecification;
            }

            @Override
            public final java.lang.Object getDisableApiTermination() {
                return this.disableApiTermination;
            }

            @Override
            public final java.lang.Object getEbsOptimized() {
                return this.ebsOptimized;
            }

            @Override
            public final java.lang.Object getElasticGpuSpecifications() {
                return this.elasticGpuSpecifications;
            }

            @Override
            public final java.lang.Object getElasticInferenceAccelerators() {
                return this.elasticInferenceAccelerators;
            }

            @Override
            public final java.lang.Object getEnclaveOptions() {
                return this.enclaveOptions;
            }

            @Override
            public final java.lang.Object getHibernationOptions() {
                return this.hibernationOptions;
            }

            @Override
            public final java.lang.Object getIamInstanceProfile() {
                return this.iamInstanceProfile;
            }

            @Override
            public final java.lang.String getImageId() {
                return this.imageId;
            }

            @Override
            public final java.lang.String getInstanceInitiatedShutdownBehavior() {
                return this.instanceInitiatedShutdownBehavior;
            }

            @Override
            public final java.lang.Object getInstanceMarketOptions() {
                return this.instanceMarketOptions;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final java.lang.String getKernelId() {
                return this.kernelId;
            }

            @Override
            public final java.lang.String getKeyName() {
                return this.keyName;
            }

            @Override
            public final java.lang.Object getLicenseSpecifications() {
                return this.licenseSpecifications;
            }

            @Override
            public final java.lang.Object getMetadataOptions() {
                return this.metadataOptions;
            }

            @Override
            public final java.lang.Object getMonitoring() {
                return this.monitoring;
            }

            @Override
            public final java.lang.Object getNetworkInterfaces() {
                return this.networkInterfaces;
            }

            @Override
            public final java.lang.Object getPlacement() {
                return this.placement;
            }

            @Override
            public final java.lang.String getRamDiskId() {
                return this.ramDiskId;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroups() {
                return this.securityGroups;
            }

            @Override
            public final java.lang.Object getTagSpecifications() {
                return this.tagSpecifications;
            }

            @Override
            public final java.lang.String getUserData() {
                return this.userData;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBlockDeviceMappings() != null) {
                    data.set("blockDeviceMappings", om.valueToTree(this.getBlockDeviceMappings()));
                }
                if (this.getCapacityReservationSpecification() != null) {
                    data.set("capacityReservationSpecification", om.valueToTree(this.getCapacityReservationSpecification()));
                }
                if (this.getCpuOptions() != null) {
                    data.set("cpuOptions", om.valueToTree(this.getCpuOptions()));
                }
                if (this.getCreditSpecification() != null) {
                    data.set("creditSpecification", om.valueToTree(this.getCreditSpecification()));
                }
                if (this.getDisableApiTermination() != null) {
                    data.set("disableApiTermination", om.valueToTree(this.getDisableApiTermination()));
                }
                if (this.getEbsOptimized() != null) {
                    data.set("ebsOptimized", om.valueToTree(this.getEbsOptimized()));
                }
                if (this.getElasticGpuSpecifications() != null) {
                    data.set("elasticGpuSpecifications", om.valueToTree(this.getElasticGpuSpecifications()));
                }
                if (this.getElasticInferenceAccelerators() != null) {
                    data.set("elasticInferenceAccelerators", om.valueToTree(this.getElasticInferenceAccelerators()));
                }
                if (this.getEnclaveOptions() != null) {
                    data.set("enclaveOptions", om.valueToTree(this.getEnclaveOptions()));
                }
                if (this.getHibernationOptions() != null) {
                    data.set("hibernationOptions", om.valueToTree(this.getHibernationOptions()));
                }
                if (this.getIamInstanceProfile() != null) {
                    data.set("iamInstanceProfile", om.valueToTree(this.getIamInstanceProfile()));
                }
                if (this.getImageId() != null) {
                    data.set("imageId", om.valueToTree(this.getImageId()));
                }
                if (this.getInstanceInitiatedShutdownBehavior() != null) {
                    data.set("instanceInitiatedShutdownBehavior", om.valueToTree(this.getInstanceInitiatedShutdownBehavior()));
                }
                if (this.getInstanceMarketOptions() != null) {
                    data.set("instanceMarketOptions", om.valueToTree(this.getInstanceMarketOptions()));
                }
                if (this.getInstanceType() != null) {
                    data.set("instanceType", om.valueToTree(this.getInstanceType()));
                }
                if (this.getKernelId() != null) {
                    data.set("kernelId", om.valueToTree(this.getKernelId()));
                }
                if (this.getKeyName() != null) {
                    data.set("keyName", om.valueToTree(this.getKeyName()));
                }
                if (this.getLicenseSpecifications() != null) {
                    data.set("licenseSpecifications", om.valueToTree(this.getLicenseSpecifications()));
                }
                if (this.getMetadataOptions() != null) {
                    data.set("metadataOptions", om.valueToTree(this.getMetadataOptions()));
                }
                if (this.getMonitoring() != null) {
                    data.set("monitoring", om.valueToTree(this.getMonitoring()));
                }
                if (this.getNetworkInterfaces() != null) {
                    data.set("networkInterfaces", om.valueToTree(this.getNetworkInterfaces()));
                }
                if (this.getPlacement() != null) {
                    data.set("placement", om.valueToTree(this.getPlacement()));
                }
                if (this.getRamDiskId() != null) {
                    data.set("ramDiskId", om.valueToTree(this.getRamDiskId()));
                }
                if (this.getSecurityGroupIds() != null) {
                    data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                }
                if (this.getSecurityGroups() != null) {
                    data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
                }
                if (this.getTagSpecifications() != null) {
                    data.set("tagSpecifications", om.valueToTree(this.getTagSpecifications()));
                }
                if (this.getUserData() != null) {
                    data.set("userData", om.valueToTree(this.getUserData()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.LaunchTemplateDataProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LaunchTemplateDataProperty.Jsii$Proxy that = (LaunchTemplateDataProperty.Jsii$Proxy) o;

                if (this.blockDeviceMappings != null ? !this.blockDeviceMappings.equals(that.blockDeviceMappings) : that.blockDeviceMappings != null) return false;
                if (this.capacityReservationSpecification != null ? !this.capacityReservationSpecification.equals(that.capacityReservationSpecification) : that.capacityReservationSpecification != null) return false;
                if (this.cpuOptions != null ? !this.cpuOptions.equals(that.cpuOptions) : that.cpuOptions != null) return false;
                if (this.creditSpecification != null ? !this.creditSpecification.equals(that.creditSpecification) : that.creditSpecification != null) return false;
                if (this.disableApiTermination != null ? !this.disableApiTermination.equals(that.disableApiTermination) : that.disableApiTermination != null) return false;
                if (this.ebsOptimized != null ? !this.ebsOptimized.equals(that.ebsOptimized) : that.ebsOptimized != null) return false;
                if (this.elasticGpuSpecifications != null ? !this.elasticGpuSpecifications.equals(that.elasticGpuSpecifications) : that.elasticGpuSpecifications != null) return false;
                if (this.elasticInferenceAccelerators != null ? !this.elasticInferenceAccelerators.equals(that.elasticInferenceAccelerators) : that.elasticInferenceAccelerators != null) return false;
                if (this.enclaveOptions != null ? !this.enclaveOptions.equals(that.enclaveOptions) : that.enclaveOptions != null) return false;
                if (this.hibernationOptions != null ? !this.hibernationOptions.equals(that.hibernationOptions) : that.hibernationOptions != null) return false;
                if (this.iamInstanceProfile != null ? !this.iamInstanceProfile.equals(that.iamInstanceProfile) : that.iamInstanceProfile != null) return false;
                if (this.imageId != null ? !this.imageId.equals(that.imageId) : that.imageId != null) return false;
                if (this.instanceInitiatedShutdownBehavior != null ? !this.instanceInitiatedShutdownBehavior.equals(that.instanceInitiatedShutdownBehavior) : that.instanceInitiatedShutdownBehavior != null) return false;
                if (this.instanceMarketOptions != null ? !this.instanceMarketOptions.equals(that.instanceMarketOptions) : that.instanceMarketOptions != null) return false;
                if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
                if (this.kernelId != null ? !this.kernelId.equals(that.kernelId) : that.kernelId != null) return false;
                if (this.keyName != null ? !this.keyName.equals(that.keyName) : that.keyName != null) return false;
                if (this.licenseSpecifications != null ? !this.licenseSpecifications.equals(that.licenseSpecifications) : that.licenseSpecifications != null) return false;
                if (this.metadataOptions != null ? !this.metadataOptions.equals(that.metadataOptions) : that.metadataOptions != null) return false;
                if (this.monitoring != null ? !this.monitoring.equals(that.monitoring) : that.monitoring != null) return false;
                if (this.networkInterfaces != null ? !this.networkInterfaces.equals(that.networkInterfaces) : that.networkInterfaces != null) return false;
                if (this.placement != null ? !this.placement.equals(that.placement) : that.placement != null) return false;
                if (this.ramDiskId != null ? !this.ramDiskId.equals(that.ramDiskId) : that.ramDiskId != null) return false;
                if (this.securityGroupIds != null ? !this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds != null) return false;
                if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
                if (this.tagSpecifications != null ? !this.tagSpecifications.equals(that.tagSpecifications) : that.tagSpecifications != null) return false;
                return this.userData != null ? this.userData.equals(that.userData) : that.userData == null;
            }

            @Override
            public final int hashCode() {
                int result = this.blockDeviceMappings != null ? this.blockDeviceMappings.hashCode() : 0;
                result = 31 * result + (this.capacityReservationSpecification != null ? this.capacityReservationSpecification.hashCode() : 0);
                result = 31 * result + (this.cpuOptions != null ? this.cpuOptions.hashCode() : 0);
                result = 31 * result + (this.creditSpecification != null ? this.creditSpecification.hashCode() : 0);
                result = 31 * result + (this.disableApiTermination != null ? this.disableApiTermination.hashCode() : 0);
                result = 31 * result + (this.ebsOptimized != null ? this.ebsOptimized.hashCode() : 0);
                result = 31 * result + (this.elasticGpuSpecifications != null ? this.elasticGpuSpecifications.hashCode() : 0);
                result = 31 * result + (this.elasticInferenceAccelerators != null ? this.elasticInferenceAccelerators.hashCode() : 0);
                result = 31 * result + (this.enclaveOptions != null ? this.enclaveOptions.hashCode() : 0);
                result = 31 * result + (this.hibernationOptions != null ? this.hibernationOptions.hashCode() : 0);
                result = 31 * result + (this.iamInstanceProfile != null ? this.iamInstanceProfile.hashCode() : 0);
                result = 31 * result + (this.imageId != null ? this.imageId.hashCode() : 0);
                result = 31 * result + (this.instanceInitiatedShutdownBehavior != null ? this.instanceInitiatedShutdownBehavior.hashCode() : 0);
                result = 31 * result + (this.instanceMarketOptions != null ? this.instanceMarketOptions.hashCode() : 0);
                result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
                result = 31 * result + (this.kernelId != null ? this.kernelId.hashCode() : 0);
                result = 31 * result + (this.keyName != null ? this.keyName.hashCode() : 0);
                result = 31 * result + (this.licenseSpecifications != null ? this.licenseSpecifications.hashCode() : 0);
                result = 31 * result + (this.metadataOptions != null ? this.metadataOptions.hashCode() : 0);
                result = 31 * result + (this.monitoring != null ? this.monitoring.hashCode() : 0);
                result = 31 * result + (this.networkInterfaces != null ? this.networkInterfaces.hashCode() : 0);
                result = 31 * result + (this.placement != null ? this.placement.hashCode() : 0);
                result = 31 * result + (this.ramDiskId != null ? this.ramDiskId.hashCode() : 0);
                result = 31 * result + (this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0);
                result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
                result = 31 * result + (this.tagSpecifications != null ? this.tagSpecifications.hashCode() : 0);
                result = 31 * result + (this.userData != null ? this.userData.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplateelasticinferenceaccelerator.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.LaunchTemplateElasticInferenceAcceleratorProperty")
    @software.amazon.jsii.Jsii.Proxy(LaunchTemplateElasticInferenceAcceleratorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LaunchTemplateElasticInferenceAcceleratorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLaunchTemplate.LaunchTemplateElasticInferenceAcceleratorProperty.Count`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplateelasticinferenceaccelerator.html#cfn-ec2-launchtemplate-launchtemplateelasticinferenceaccelerator-count
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCount() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.LaunchTemplateElasticInferenceAcceleratorProperty.Type`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplateelasticinferenceaccelerator.html#cfn-ec2-launchtemplate-launchtemplateelasticinferenceaccelerator-type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LaunchTemplateElasticInferenceAcceleratorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LaunchTemplateElasticInferenceAcceleratorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LaunchTemplateElasticInferenceAcceleratorProperty> {
            private java.lang.Number count;
            private java.lang.String type;

            /**
             * Sets the value of {@link LaunchTemplateElasticInferenceAcceleratorProperty#getCount}
             * @param count `CfnLaunchTemplate.LaunchTemplateElasticInferenceAcceleratorProperty.Count`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder count(java.lang.Number count) {
                this.count = count;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateElasticInferenceAcceleratorProperty#getType}
             * @param type `CfnLaunchTemplate.LaunchTemplateElasticInferenceAcceleratorProperty.Type`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LaunchTemplateElasticInferenceAcceleratorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LaunchTemplateElasticInferenceAcceleratorProperty build() {
                return new Jsii$Proxy(count, type);
            }
        }

        /**
         * An implementation for {@link LaunchTemplateElasticInferenceAcceleratorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LaunchTemplateElasticInferenceAcceleratorProperty {
            private final java.lang.Number count;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.count = software.amazon.jsii.Kernel.get(this, "count", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Number count, final java.lang.String type) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.count = count;
                this.type = type;
            }

            @Override
            public final java.lang.Number getCount() {
                return this.count;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCount() != null) {
                    data.set("count", om.valueToTree(this.getCount()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.LaunchTemplateElasticInferenceAcceleratorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LaunchTemplateElasticInferenceAcceleratorProperty.Jsii$Proxy that = (LaunchTemplateElasticInferenceAcceleratorProperty.Jsii$Proxy) o;

                if (this.count != null ? !this.count.equals(that.count) : that.count != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.count != null ? this.count.hashCode() : 0;
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-licensespecification.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.LicenseSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(LicenseSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LicenseSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLaunchTemplate.LicenseSpecificationProperty.LicenseConfigurationArn`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-licensespecification.html#cfn-ec2-launchtemplate-licensespecification-licenseconfigurationarn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLicenseConfigurationArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LicenseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LicenseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LicenseSpecificationProperty> {
            private java.lang.String licenseConfigurationArn;

            /**
             * Sets the value of {@link LicenseSpecificationProperty#getLicenseConfigurationArn}
             * @param licenseConfigurationArn `CfnLaunchTemplate.LicenseSpecificationProperty.LicenseConfigurationArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder licenseConfigurationArn(java.lang.String licenseConfigurationArn) {
                this.licenseConfigurationArn = licenseConfigurationArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LicenseSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LicenseSpecificationProperty build() {
                return new Jsii$Proxy(licenseConfigurationArn);
            }
        }

        /**
         * An implementation for {@link LicenseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LicenseSpecificationProperty {
            private final java.lang.String licenseConfigurationArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.licenseConfigurationArn = software.amazon.jsii.Kernel.get(this, "licenseConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String licenseConfigurationArn) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.licenseConfigurationArn = licenseConfigurationArn;
            }

            @Override
            public final java.lang.String getLicenseConfigurationArn() {
                return this.licenseConfigurationArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLicenseConfigurationArn() != null) {
                    data.set("licenseConfigurationArn", om.valueToTree(this.getLicenseConfigurationArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.LicenseSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LicenseSpecificationProperty.Jsii$Proxy that = (LicenseSpecificationProperty.Jsii$Proxy) o;

                return this.licenseConfigurationArn != null ? this.licenseConfigurationArn.equals(that.licenseConfigurationArn) : that.licenseConfigurationArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.licenseConfigurationArn != null ? this.licenseConfigurationArn.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.MetadataOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(MetadataOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetadataOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLaunchTemplate.MetadataOptionsProperty.HttpEndpoint`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions-httpendpoint
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHttpEndpoint() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.MetadataOptionsProperty.HttpPutResponseHopLimit`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions-httpputresponsehoplimit
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getHttpPutResponseHopLimit() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.MetadataOptionsProperty.HttpTokens`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions-httptokens
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHttpTokens() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MetadataOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetadataOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetadataOptionsProperty> {
            private java.lang.String httpEndpoint;
            private java.lang.Number httpPutResponseHopLimit;
            private java.lang.String httpTokens;

            /**
             * Sets the value of {@link MetadataOptionsProperty#getHttpEndpoint}
             * @param httpEndpoint `CfnLaunchTemplate.MetadataOptionsProperty.HttpEndpoint`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpEndpoint(java.lang.String httpEndpoint) {
                this.httpEndpoint = httpEndpoint;
                return this;
            }

            /**
             * Sets the value of {@link MetadataOptionsProperty#getHttpPutResponseHopLimit}
             * @param httpPutResponseHopLimit `CfnLaunchTemplate.MetadataOptionsProperty.HttpPutResponseHopLimit`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpPutResponseHopLimit(java.lang.Number httpPutResponseHopLimit) {
                this.httpPutResponseHopLimit = httpPutResponseHopLimit;
                return this;
            }

            /**
             * Sets the value of {@link MetadataOptionsProperty#getHttpTokens}
             * @param httpTokens `CfnLaunchTemplate.MetadataOptionsProperty.HttpTokens`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpTokens(java.lang.String httpTokens) {
                this.httpTokens = httpTokens;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetadataOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetadataOptionsProperty build() {
                return new Jsii$Proxy(httpEndpoint, httpPutResponseHopLimit, httpTokens);
            }
        }

        /**
         * An implementation for {@link MetadataOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetadataOptionsProperty {
            private final java.lang.String httpEndpoint;
            private final java.lang.Number httpPutResponseHopLimit;
            private final java.lang.String httpTokens;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.httpEndpoint = software.amazon.jsii.Kernel.get(this, "httpEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.httpPutResponseHopLimit = software.amazon.jsii.Kernel.get(this, "httpPutResponseHopLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.httpTokens = software.amazon.jsii.Kernel.get(this, "httpTokens", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String httpEndpoint, final java.lang.Number httpPutResponseHopLimit, final java.lang.String httpTokens) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.httpEndpoint = httpEndpoint;
                this.httpPutResponseHopLimit = httpPutResponseHopLimit;
                this.httpTokens = httpTokens;
            }

            @Override
            public final java.lang.String getHttpEndpoint() {
                return this.httpEndpoint;
            }

            @Override
            public final java.lang.Number getHttpPutResponseHopLimit() {
                return this.httpPutResponseHopLimit;
            }

            @Override
            public final java.lang.String getHttpTokens() {
                return this.httpTokens;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHttpEndpoint() != null) {
                    data.set("httpEndpoint", om.valueToTree(this.getHttpEndpoint()));
                }
                if (this.getHttpPutResponseHopLimit() != null) {
                    data.set("httpPutResponseHopLimit", om.valueToTree(this.getHttpPutResponseHopLimit()));
                }
                if (this.getHttpTokens() != null) {
                    data.set("httpTokens", om.valueToTree(this.getHttpTokens()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.MetadataOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetadataOptionsProperty.Jsii$Proxy that = (MetadataOptionsProperty.Jsii$Proxy) o;

                if (this.httpEndpoint != null ? !this.httpEndpoint.equals(that.httpEndpoint) : that.httpEndpoint != null) return false;
                if (this.httpPutResponseHopLimit != null ? !this.httpPutResponseHopLimit.equals(that.httpPutResponseHopLimit) : that.httpPutResponseHopLimit != null) return false;
                return this.httpTokens != null ? this.httpTokens.equals(that.httpTokens) : that.httpTokens == null;
            }

            @Override
            public final int hashCode() {
                int result = this.httpEndpoint != null ? this.httpEndpoint.hashCode() : 0;
                result = 31 * result + (this.httpPutResponseHopLimit != null ? this.httpPutResponseHopLimit.hashCode() : 0);
                result = 31 * result + (this.httpTokens != null ? this.httpTokens.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-monitoring.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.MonitoringProperty")
    @software.amazon.jsii.Jsii.Proxy(MonitoringProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MonitoringProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLaunchTemplate.MonitoringProperty.Enabled`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-monitoring.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring-enabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MonitoringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MonitoringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MonitoringProperty> {
            private java.lang.Object enabled;

            /**
             * Sets the value of {@link MonitoringProperty#getEnabled}
             * @param enabled `CfnLaunchTemplate.MonitoringProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringProperty#getEnabled}
             * @param enabled `CfnLaunchTemplate.MonitoringProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoringProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MonitoringProperty build() {
                return new Jsii$Proxy(enabled);
            }
        }

        /**
         * An implementation for {@link MonitoringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonitoringProperty {
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Object enabled) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = enabled;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.MonitoringProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MonitoringProperty.Jsii$Proxy that = (MonitoringProperty.Jsii$Proxy) o;

                return this.enabled != null ? this.enabled.equals(that.enabled) : that.enabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.NetworkInterfaceProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkInterfaceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkInterfaceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.AssociateCarrierIpAddress`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-associatecarrieripaddress
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAssociateCarrierIpAddress() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.AssociatePublicIpAddress`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-associatepublicipaddress
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAssociatePublicIpAddress() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.DeleteOnTermination`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deleteontermination
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeleteOnTermination() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.Description`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-description
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.DeviceIndex`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deviceindex
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDeviceIndex() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.Groups`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-groups
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getGroups() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.InterfaceType`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-interfacetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInterfaceType() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.Ipv6AddressCount`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresscount
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIpv6AddressCount() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.Ipv6Addresses`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresses
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIpv6Addresses() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.NetworkCardIndex`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-networkcardindex
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getNetworkCardIndex() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.NetworkInterfaceId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-networkinterfaceid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNetworkInterfaceId() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.PrivateIpAddress`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddress
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrivateIpAddress() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.PrivateIpAddresses`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddresses
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrivateIpAddresses() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-secondaryprivateipaddresscount
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSecondaryPrivateIpAddressCount() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.SubnetId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-subnetid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubnetId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkInterfaceProperty> {
            private java.lang.Object associateCarrierIpAddress;
            private java.lang.Object associatePublicIpAddress;
            private java.lang.Object deleteOnTermination;
            private java.lang.String description;
            private java.lang.Number deviceIndex;
            private java.util.List<java.lang.String> groups;
            private java.lang.String interfaceType;
            private java.lang.Number ipv6AddressCount;
            private java.lang.Object ipv6Addresses;
            private java.lang.Number networkCardIndex;
            private java.lang.String networkInterfaceId;
            private java.lang.String privateIpAddress;
            private java.lang.Object privateIpAddresses;
            private java.lang.Number secondaryPrivateIpAddressCount;
            private java.lang.String subnetId;

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getAssociateCarrierIpAddress}
             * @param associateCarrierIpAddress `CfnLaunchTemplate.NetworkInterfaceProperty.AssociateCarrierIpAddress`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder associateCarrierIpAddress(java.lang.Boolean associateCarrierIpAddress) {
                this.associateCarrierIpAddress = associateCarrierIpAddress;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getAssociateCarrierIpAddress}
             * @param associateCarrierIpAddress `CfnLaunchTemplate.NetworkInterfaceProperty.AssociateCarrierIpAddress`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder associateCarrierIpAddress(software.amazon.awscdk.core.IResolvable associateCarrierIpAddress) {
                this.associateCarrierIpAddress = associateCarrierIpAddress;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getAssociatePublicIpAddress}
             * @param associatePublicIpAddress `CfnLaunchTemplate.NetworkInterfaceProperty.AssociatePublicIpAddress`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder associatePublicIpAddress(java.lang.Boolean associatePublicIpAddress) {
                this.associatePublicIpAddress = associatePublicIpAddress;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getAssociatePublicIpAddress}
             * @param associatePublicIpAddress `CfnLaunchTemplate.NetworkInterfaceProperty.AssociatePublicIpAddress`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder associatePublicIpAddress(software.amazon.awscdk.core.IResolvable associatePublicIpAddress) {
                this.associatePublicIpAddress = associatePublicIpAddress;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getDeleteOnTermination}
             * @param deleteOnTermination `CfnLaunchTemplate.NetworkInterfaceProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteOnTermination(java.lang.Boolean deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getDeleteOnTermination}
             * @param deleteOnTermination `CfnLaunchTemplate.NetworkInterfaceProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteOnTermination(software.amazon.awscdk.core.IResolvable deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getDescription}
             * @param description `CfnLaunchTemplate.NetworkInterfaceProperty.Description`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getDeviceIndex}
             * @param deviceIndex `CfnLaunchTemplate.NetworkInterfaceProperty.DeviceIndex`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deviceIndex(java.lang.Number deviceIndex) {
                this.deviceIndex = deviceIndex;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getGroups}
             * @param groups `CfnLaunchTemplate.NetworkInterfaceProperty.Groups`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groups(java.util.List<java.lang.String> groups) {
                this.groups = groups;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getInterfaceType}
             * @param interfaceType `CfnLaunchTemplate.NetworkInterfaceProperty.InterfaceType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interfaceType(java.lang.String interfaceType) {
                this.interfaceType = interfaceType;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getIpv6AddressCount}
             * @param ipv6AddressCount `CfnLaunchTemplate.NetworkInterfaceProperty.Ipv6AddressCount`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv6AddressCount(java.lang.Number ipv6AddressCount) {
                this.ipv6AddressCount = ipv6AddressCount;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getIpv6Addresses}
             * @param ipv6Addresses `CfnLaunchTemplate.NetworkInterfaceProperty.Ipv6Addresses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv6Addresses(software.amazon.awscdk.core.IResolvable ipv6Addresses) {
                this.ipv6Addresses = ipv6Addresses;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getIpv6Addresses}
             * @param ipv6Addresses `CfnLaunchTemplate.NetworkInterfaceProperty.Ipv6Addresses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv6Addresses(java.util.List<? extends java.lang.Object> ipv6Addresses) {
                this.ipv6Addresses = ipv6Addresses;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getNetworkCardIndex}
             * @param networkCardIndex `CfnLaunchTemplate.NetworkInterfaceProperty.NetworkCardIndex`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkCardIndex(java.lang.Number networkCardIndex) {
                this.networkCardIndex = networkCardIndex;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getNetworkInterfaceId}
             * @param networkInterfaceId `CfnLaunchTemplate.NetworkInterfaceProperty.NetworkInterfaceId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkInterfaceId(java.lang.String networkInterfaceId) {
                this.networkInterfaceId = networkInterfaceId;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getPrivateIpAddress}
             * @param privateIpAddress `CfnLaunchTemplate.NetworkInterfaceProperty.PrivateIpAddress`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateIpAddress(java.lang.String privateIpAddress) {
                this.privateIpAddress = privateIpAddress;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getPrivateIpAddresses}
             * @param privateIpAddresses `CfnLaunchTemplate.NetworkInterfaceProperty.PrivateIpAddresses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateIpAddresses(software.amazon.awscdk.core.IResolvable privateIpAddresses) {
                this.privateIpAddresses = privateIpAddresses;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getPrivateIpAddresses}
             * @param privateIpAddresses `CfnLaunchTemplate.NetworkInterfaceProperty.PrivateIpAddresses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateIpAddresses(java.util.List<? extends java.lang.Object> privateIpAddresses) {
                this.privateIpAddresses = privateIpAddresses;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getSecondaryPrivateIpAddressCount}
             * @param secondaryPrivateIpAddressCount `CfnLaunchTemplate.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secondaryPrivateIpAddressCount(java.lang.Number secondaryPrivateIpAddressCount) {
                this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getSubnetId}
             * @param subnetId `CfnLaunchTemplate.NetworkInterfaceProperty.SubnetId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetId(java.lang.String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkInterfaceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkInterfaceProperty build() {
                return new Jsii$Proxy(associateCarrierIpAddress, associatePublicIpAddress, deleteOnTermination, description, deviceIndex, groups, interfaceType, ipv6AddressCount, ipv6Addresses, networkCardIndex, networkInterfaceId, privateIpAddress, privateIpAddresses, secondaryPrivateIpAddressCount, subnetId);
            }
        }

        /**
         * An implementation for {@link NetworkInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkInterfaceProperty {
            private final java.lang.Object associateCarrierIpAddress;
            private final java.lang.Object associatePublicIpAddress;
            private final java.lang.Object deleteOnTermination;
            private final java.lang.String description;
            private final java.lang.Number deviceIndex;
            private final java.util.List<java.lang.String> groups;
            private final java.lang.String interfaceType;
            private final java.lang.Number ipv6AddressCount;
            private final java.lang.Object ipv6Addresses;
            private final java.lang.Number networkCardIndex;
            private final java.lang.String networkInterfaceId;
            private final java.lang.String privateIpAddress;
            private final java.lang.Object privateIpAddresses;
            private final java.lang.Number secondaryPrivateIpAddressCount;
            private final java.lang.String subnetId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.associateCarrierIpAddress = software.amazon.jsii.Kernel.get(this, "associateCarrierIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.associatePublicIpAddress = software.amazon.jsii.Kernel.get(this, "associatePublicIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.deleteOnTermination = software.amazon.jsii.Kernel.get(this, "deleteOnTermination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.deviceIndex = software.amazon.jsii.Kernel.get(this, "deviceIndex", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.groups = software.amazon.jsii.Kernel.get(this, "groups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.interfaceType = software.amazon.jsii.Kernel.get(this, "interfaceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ipv6AddressCount = software.amazon.jsii.Kernel.get(this, "ipv6AddressCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.ipv6Addresses = software.amazon.jsii.Kernel.get(this, "ipv6Addresses", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkCardIndex = software.amazon.jsii.Kernel.get(this, "networkCardIndex", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.networkInterfaceId = software.amazon.jsii.Kernel.get(this, "networkInterfaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.privateIpAddress = software.amazon.jsii.Kernel.get(this, "privateIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.privateIpAddresses = software.amazon.jsii.Kernel.get(this, "privateIpAddresses", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.secondaryPrivateIpAddressCount = software.amazon.jsii.Kernel.get(this, "secondaryPrivateIpAddressCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.subnetId = software.amazon.jsii.Kernel.get(this, "subnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Object associateCarrierIpAddress, final java.lang.Object associatePublicIpAddress, final java.lang.Object deleteOnTermination, final java.lang.String description, final java.lang.Number deviceIndex, final java.util.List<java.lang.String> groups, final java.lang.String interfaceType, final java.lang.Number ipv6AddressCount, final java.lang.Object ipv6Addresses, final java.lang.Number networkCardIndex, final java.lang.String networkInterfaceId, final java.lang.String privateIpAddress, final java.lang.Object privateIpAddresses, final java.lang.Number secondaryPrivateIpAddressCount, final java.lang.String subnetId) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.associateCarrierIpAddress = associateCarrierIpAddress;
                this.associatePublicIpAddress = associatePublicIpAddress;
                this.deleteOnTermination = deleteOnTermination;
                this.description = description;
                this.deviceIndex = deviceIndex;
                this.groups = groups;
                this.interfaceType = interfaceType;
                this.ipv6AddressCount = ipv6AddressCount;
                this.ipv6Addresses = ipv6Addresses;
                this.networkCardIndex = networkCardIndex;
                this.networkInterfaceId = networkInterfaceId;
                this.privateIpAddress = privateIpAddress;
                this.privateIpAddresses = privateIpAddresses;
                this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
                this.subnetId = subnetId;
            }

            @Override
            public final java.lang.Object getAssociateCarrierIpAddress() {
                return this.associateCarrierIpAddress;
            }

            @Override
            public final java.lang.Object getAssociatePublicIpAddress() {
                return this.associatePublicIpAddress;
            }

            @Override
            public final java.lang.Object getDeleteOnTermination() {
                return this.deleteOnTermination;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Number getDeviceIndex() {
                return this.deviceIndex;
            }

            @Override
            public final java.util.List<java.lang.String> getGroups() {
                return this.groups;
            }

            @Override
            public final java.lang.String getInterfaceType() {
                return this.interfaceType;
            }

            @Override
            public final java.lang.Number getIpv6AddressCount() {
                return this.ipv6AddressCount;
            }

            @Override
            public final java.lang.Object getIpv6Addresses() {
                return this.ipv6Addresses;
            }

            @Override
            public final java.lang.Number getNetworkCardIndex() {
                return this.networkCardIndex;
            }

            @Override
            public final java.lang.String getNetworkInterfaceId() {
                return this.networkInterfaceId;
            }

            @Override
            public final java.lang.String getPrivateIpAddress() {
                return this.privateIpAddress;
            }

            @Override
            public final java.lang.Object getPrivateIpAddresses() {
                return this.privateIpAddresses;
            }

            @Override
            public final java.lang.Number getSecondaryPrivateIpAddressCount() {
                return this.secondaryPrivateIpAddressCount;
            }

            @Override
            public final java.lang.String getSubnetId() {
                return this.subnetId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAssociateCarrierIpAddress() != null) {
                    data.set("associateCarrierIpAddress", om.valueToTree(this.getAssociateCarrierIpAddress()));
                }
                if (this.getAssociatePublicIpAddress() != null) {
                    data.set("associatePublicIpAddress", om.valueToTree(this.getAssociatePublicIpAddress()));
                }
                if (this.getDeleteOnTermination() != null) {
                    data.set("deleteOnTermination", om.valueToTree(this.getDeleteOnTermination()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getDeviceIndex() != null) {
                    data.set("deviceIndex", om.valueToTree(this.getDeviceIndex()));
                }
                if (this.getGroups() != null) {
                    data.set("groups", om.valueToTree(this.getGroups()));
                }
                if (this.getInterfaceType() != null) {
                    data.set("interfaceType", om.valueToTree(this.getInterfaceType()));
                }
                if (this.getIpv6AddressCount() != null) {
                    data.set("ipv6AddressCount", om.valueToTree(this.getIpv6AddressCount()));
                }
                if (this.getIpv6Addresses() != null) {
                    data.set("ipv6Addresses", om.valueToTree(this.getIpv6Addresses()));
                }
                if (this.getNetworkCardIndex() != null) {
                    data.set("networkCardIndex", om.valueToTree(this.getNetworkCardIndex()));
                }
                if (this.getNetworkInterfaceId() != null) {
                    data.set("networkInterfaceId", om.valueToTree(this.getNetworkInterfaceId()));
                }
                if (this.getPrivateIpAddress() != null) {
                    data.set("privateIpAddress", om.valueToTree(this.getPrivateIpAddress()));
                }
                if (this.getPrivateIpAddresses() != null) {
                    data.set("privateIpAddresses", om.valueToTree(this.getPrivateIpAddresses()));
                }
                if (this.getSecondaryPrivateIpAddressCount() != null) {
                    data.set("secondaryPrivateIpAddressCount", om.valueToTree(this.getSecondaryPrivateIpAddressCount()));
                }
                if (this.getSubnetId() != null) {
                    data.set("subnetId", om.valueToTree(this.getSubnetId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.NetworkInterfaceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkInterfaceProperty.Jsii$Proxy that = (NetworkInterfaceProperty.Jsii$Proxy) o;

                if (this.associateCarrierIpAddress != null ? !this.associateCarrierIpAddress.equals(that.associateCarrierIpAddress) : that.associateCarrierIpAddress != null) return false;
                if (this.associatePublicIpAddress != null ? !this.associatePublicIpAddress.equals(that.associatePublicIpAddress) : that.associatePublicIpAddress != null) return false;
                if (this.deleteOnTermination != null ? !this.deleteOnTermination.equals(that.deleteOnTermination) : that.deleteOnTermination != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.deviceIndex != null ? !this.deviceIndex.equals(that.deviceIndex) : that.deviceIndex != null) return false;
                if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) return false;
                if (this.interfaceType != null ? !this.interfaceType.equals(that.interfaceType) : that.interfaceType != null) return false;
                if (this.ipv6AddressCount != null ? !this.ipv6AddressCount.equals(that.ipv6AddressCount) : that.ipv6AddressCount != null) return false;
                if (this.ipv6Addresses != null ? !this.ipv6Addresses.equals(that.ipv6Addresses) : that.ipv6Addresses != null) return false;
                if (this.networkCardIndex != null ? !this.networkCardIndex.equals(that.networkCardIndex) : that.networkCardIndex != null) return false;
                if (this.networkInterfaceId != null ? !this.networkInterfaceId.equals(that.networkInterfaceId) : that.networkInterfaceId != null) return false;
                if (this.privateIpAddress != null ? !this.privateIpAddress.equals(that.privateIpAddress) : that.privateIpAddress != null) return false;
                if (this.privateIpAddresses != null ? !this.privateIpAddresses.equals(that.privateIpAddresses) : that.privateIpAddresses != null) return false;
                if (this.secondaryPrivateIpAddressCount != null ? !this.secondaryPrivateIpAddressCount.equals(that.secondaryPrivateIpAddressCount) : that.secondaryPrivateIpAddressCount != null) return false;
                return this.subnetId != null ? this.subnetId.equals(that.subnetId) : that.subnetId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.associateCarrierIpAddress != null ? this.associateCarrierIpAddress.hashCode() : 0;
                result = 31 * result + (this.associatePublicIpAddress != null ? this.associatePublicIpAddress.hashCode() : 0);
                result = 31 * result + (this.deleteOnTermination != null ? this.deleteOnTermination.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.deviceIndex != null ? this.deviceIndex.hashCode() : 0);
                result = 31 * result + (this.groups != null ? this.groups.hashCode() : 0);
                result = 31 * result + (this.interfaceType != null ? this.interfaceType.hashCode() : 0);
                result = 31 * result + (this.ipv6AddressCount != null ? this.ipv6AddressCount.hashCode() : 0);
                result = 31 * result + (this.ipv6Addresses != null ? this.ipv6Addresses.hashCode() : 0);
                result = 31 * result + (this.networkCardIndex != null ? this.networkCardIndex.hashCode() : 0);
                result = 31 * result + (this.networkInterfaceId != null ? this.networkInterfaceId.hashCode() : 0);
                result = 31 * result + (this.privateIpAddress != null ? this.privateIpAddress.hashCode() : 0);
                result = 31 * result + (this.privateIpAddresses != null ? this.privateIpAddresses.hashCode() : 0);
                result = 31 * result + (this.secondaryPrivateIpAddressCount != null ? this.secondaryPrivateIpAddressCount.hashCode() : 0);
                result = 31 * result + (this.subnetId != null ? this.subnetId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.PlacementProperty")
    @software.amazon.jsii.Jsii.Proxy(PlacementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PlacementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLaunchTemplate.PlacementProperty.Affinity`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-affinity
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAffinity() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.PlacementProperty.AvailabilityZone`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-availabilityzone
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.PlacementProperty.GroupName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-groupname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGroupName() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.PlacementProperty.HostId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-hostid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHostId() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.PlacementProperty.HostResourceGroupArn`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-hostresourcegrouparn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHostResourceGroupArn() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.PlacementProperty.PartitionNumber`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-partitionnumber
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPartitionNumber() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.PlacementProperty.SpreadDomain`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-spreaddomain
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSpreadDomain() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.PlacementProperty.Tenancy`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-tenancy
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTenancy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PlacementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PlacementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PlacementProperty> {
            private java.lang.String affinity;
            private java.lang.String availabilityZone;
            private java.lang.String groupName;
            private java.lang.String hostId;
            private java.lang.String hostResourceGroupArn;
            private java.lang.Number partitionNumber;
            private java.lang.String spreadDomain;
            private java.lang.String tenancy;

            /**
             * Sets the value of {@link PlacementProperty#getAffinity}
             * @param affinity `CfnLaunchTemplate.PlacementProperty.Affinity`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder affinity(java.lang.String affinity) {
                this.affinity = affinity;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getAvailabilityZone}
             * @param availabilityZone `CfnLaunchTemplate.PlacementProperty.AvailabilityZone`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityZone(java.lang.String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getGroupName}
             * @param groupName `CfnLaunchTemplate.PlacementProperty.GroupName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupName(java.lang.String groupName) {
                this.groupName = groupName;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getHostId}
             * @param hostId `CfnLaunchTemplate.PlacementProperty.HostId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostId(java.lang.String hostId) {
                this.hostId = hostId;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getHostResourceGroupArn}
             * @param hostResourceGroupArn `CfnLaunchTemplate.PlacementProperty.HostResourceGroupArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostResourceGroupArn(java.lang.String hostResourceGroupArn) {
                this.hostResourceGroupArn = hostResourceGroupArn;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getPartitionNumber}
             * @param partitionNumber `CfnLaunchTemplate.PlacementProperty.PartitionNumber`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder partitionNumber(java.lang.Number partitionNumber) {
                this.partitionNumber = partitionNumber;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getSpreadDomain}
             * @param spreadDomain `CfnLaunchTemplate.PlacementProperty.SpreadDomain`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spreadDomain(java.lang.String spreadDomain) {
                this.spreadDomain = spreadDomain;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getTenancy}
             * @param tenancy `CfnLaunchTemplate.PlacementProperty.Tenancy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tenancy(java.lang.String tenancy) {
                this.tenancy = tenancy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PlacementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PlacementProperty build() {
                return new Jsii$Proxy(affinity, availabilityZone, groupName, hostId, hostResourceGroupArn, partitionNumber, spreadDomain, tenancy);
            }
        }

        /**
         * An implementation for {@link PlacementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PlacementProperty {
            private final java.lang.String affinity;
            private final java.lang.String availabilityZone;
            private final java.lang.String groupName;
            private final java.lang.String hostId;
            private final java.lang.String hostResourceGroupArn;
            private final java.lang.Number partitionNumber;
            private final java.lang.String spreadDomain;
            private final java.lang.String tenancy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.affinity = software.amazon.jsii.Kernel.get(this, "affinity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.groupName = software.amazon.jsii.Kernel.get(this, "groupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hostId = software.amazon.jsii.Kernel.get(this, "hostId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hostResourceGroupArn = software.amazon.jsii.Kernel.get(this, "hostResourceGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.partitionNumber = software.amazon.jsii.Kernel.get(this, "partitionNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.spreadDomain = software.amazon.jsii.Kernel.get(this, "spreadDomain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tenancy = software.amazon.jsii.Kernel.get(this, "tenancy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String affinity, final java.lang.String availabilityZone, final java.lang.String groupName, final java.lang.String hostId, final java.lang.String hostResourceGroupArn, final java.lang.Number partitionNumber, final java.lang.String spreadDomain, final java.lang.String tenancy) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.affinity = affinity;
                this.availabilityZone = availabilityZone;
                this.groupName = groupName;
                this.hostId = hostId;
                this.hostResourceGroupArn = hostResourceGroupArn;
                this.partitionNumber = partitionNumber;
                this.spreadDomain = spreadDomain;
                this.tenancy = tenancy;
            }

            @Override
            public final java.lang.String getAffinity() {
                return this.affinity;
            }

            @Override
            public final java.lang.String getAvailabilityZone() {
                return this.availabilityZone;
            }

            @Override
            public final java.lang.String getGroupName() {
                return this.groupName;
            }

            @Override
            public final java.lang.String getHostId() {
                return this.hostId;
            }

            @Override
            public final java.lang.String getHostResourceGroupArn() {
                return this.hostResourceGroupArn;
            }

            @Override
            public final java.lang.Number getPartitionNumber() {
                return this.partitionNumber;
            }

            @Override
            public final java.lang.String getSpreadDomain() {
                return this.spreadDomain;
            }

            @Override
            public final java.lang.String getTenancy() {
                return this.tenancy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAffinity() != null) {
                    data.set("affinity", om.valueToTree(this.getAffinity()));
                }
                if (this.getAvailabilityZone() != null) {
                    data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                }
                if (this.getGroupName() != null) {
                    data.set("groupName", om.valueToTree(this.getGroupName()));
                }
                if (this.getHostId() != null) {
                    data.set("hostId", om.valueToTree(this.getHostId()));
                }
                if (this.getHostResourceGroupArn() != null) {
                    data.set("hostResourceGroupArn", om.valueToTree(this.getHostResourceGroupArn()));
                }
                if (this.getPartitionNumber() != null) {
                    data.set("partitionNumber", om.valueToTree(this.getPartitionNumber()));
                }
                if (this.getSpreadDomain() != null) {
                    data.set("spreadDomain", om.valueToTree(this.getSpreadDomain()));
                }
                if (this.getTenancy() != null) {
                    data.set("tenancy", om.valueToTree(this.getTenancy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.PlacementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PlacementProperty.Jsii$Proxy that = (PlacementProperty.Jsii$Proxy) o;

                if (this.affinity != null ? !this.affinity.equals(that.affinity) : that.affinity != null) return false;
                if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
                if (this.groupName != null ? !this.groupName.equals(that.groupName) : that.groupName != null) return false;
                if (this.hostId != null ? !this.hostId.equals(that.hostId) : that.hostId != null) return false;
                if (this.hostResourceGroupArn != null ? !this.hostResourceGroupArn.equals(that.hostResourceGroupArn) : that.hostResourceGroupArn != null) return false;
                if (this.partitionNumber != null ? !this.partitionNumber.equals(that.partitionNumber) : that.partitionNumber != null) return false;
                if (this.spreadDomain != null ? !this.spreadDomain.equals(that.spreadDomain) : that.spreadDomain != null) return false;
                return this.tenancy != null ? this.tenancy.equals(that.tenancy) : that.tenancy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.affinity != null ? this.affinity.hashCode() : 0;
                result = 31 * result + (this.availabilityZone != null ? this.availabilityZone.hashCode() : 0);
                result = 31 * result + (this.groupName != null ? this.groupName.hashCode() : 0);
                result = 31 * result + (this.hostId != null ? this.hostId.hashCode() : 0);
                result = 31 * result + (this.hostResourceGroupArn != null ? this.hostResourceGroupArn.hashCode() : 0);
                result = 31 * result + (this.partitionNumber != null ? this.partitionNumber.hashCode() : 0);
                result = 31 * result + (this.spreadDomain != null ? this.spreadDomain.hashCode() : 0);
                result = 31 * result + (this.tenancy != null ? this.tenancy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.PrivateIpAddProperty")
    @software.amazon.jsii.Jsii.Proxy(PrivateIpAddProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PrivateIpAddProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLaunchTemplate.PrivateIpAddProperty.Primary`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-primary
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrimary() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.PrivateIpAddProperty.PrivateIpAddress`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-privateipaddress
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrivateIpAddress() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PrivateIpAddProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PrivateIpAddProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PrivateIpAddProperty> {
            private java.lang.Object primary;
            private java.lang.String privateIpAddress;

            /**
             * Sets the value of {@link PrivateIpAddProperty#getPrimary}
             * @param primary `CfnLaunchTemplate.PrivateIpAddProperty.Primary`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primary(java.lang.Boolean primary) {
                this.primary = primary;
                return this;
            }

            /**
             * Sets the value of {@link PrivateIpAddProperty#getPrimary}
             * @param primary `CfnLaunchTemplate.PrivateIpAddProperty.Primary`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primary(software.amazon.awscdk.core.IResolvable primary) {
                this.primary = primary;
                return this;
            }

            /**
             * Sets the value of {@link PrivateIpAddProperty#getPrivateIpAddress}
             * @param privateIpAddress `CfnLaunchTemplate.PrivateIpAddProperty.PrivateIpAddress`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateIpAddress(java.lang.String privateIpAddress) {
                this.privateIpAddress = privateIpAddress;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PrivateIpAddProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PrivateIpAddProperty build() {
                return new Jsii$Proxy(primary, privateIpAddress);
            }
        }

        /**
         * An implementation for {@link PrivateIpAddProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PrivateIpAddProperty {
            private final java.lang.Object primary;
            private final java.lang.String privateIpAddress;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.primary = software.amazon.jsii.Kernel.get(this, "primary", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.privateIpAddress = software.amazon.jsii.Kernel.get(this, "privateIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Object primary, final java.lang.String privateIpAddress) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.primary = primary;
                this.privateIpAddress = privateIpAddress;
            }

            @Override
            public final java.lang.Object getPrimary() {
                return this.primary;
            }

            @Override
            public final java.lang.String getPrivateIpAddress() {
                return this.privateIpAddress;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPrimary() != null) {
                    data.set("primary", om.valueToTree(this.getPrimary()));
                }
                if (this.getPrivateIpAddress() != null) {
                    data.set("privateIpAddress", om.valueToTree(this.getPrivateIpAddress()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.PrivateIpAddProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PrivateIpAddProperty.Jsii$Proxy that = (PrivateIpAddProperty.Jsii$Proxy) o;

                if (this.primary != null ? !this.primary.equals(that.primary) : that.primary != null) return false;
                return this.privateIpAddress != null ? this.privateIpAddress.equals(that.privateIpAddress) : that.privateIpAddress == null;
            }

            @Override
            public final int hashCode() {
                int result = this.primary != null ? this.primary.hashCode() : 0;
                result = 31 * result + (this.privateIpAddress != null ? this.privateIpAddress.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.SpotOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(SpotOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpotOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLaunchTemplate.SpotOptionsProperty.BlockDurationMinutes`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-blockdurationminutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBlockDurationMinutes() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.SpotOptionsProperty.InstanceInterruptionBehavior`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-instanceinterruptionbehavior
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceInterruptionBehavior() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.SpotOptionsProperty.MaxPrice`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-maxprice
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMaxPrice() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.SpotOptionsProperty.SpotInstanceType`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-spotinstancetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSpotInstanceType() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.SpotOptionsProperty.ValidUntil`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-validuntil
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValidUntil() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SpotOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SpotOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SpotOptionsProperty> {
            private java.lang.Number blockDurationMinutes;
            private java.lang.String instanceInterruptionBehavior;
            private java.lang.String maxPrice;
            private java.lang.String spotInstanceType;
            private java.lang.String validUntil;

            /**
             * Sets the value of {@link SpotOptionsProperty#getBlockDurationMinutes}
             * @param blockDurationMinutes `CfnLaunchTemplate.SpotOptionsProperty.BlockDurationMinutes`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockDurationMinutes(java.lang.Number blockDurationMinutes) {
                this.blockDurationMinutes = blockDurationMinutes;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsProperty#getInstanceInterruptionBehavior}
             * @param instanceInterruptionBehavior `CfnLaunchTemplate.SpotOptionsProperty.InstanceInterruptionBehavior`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceInterruptionBehavior(java.lang.String instanceInterruptionBehavior) {
                this.instanceInterruptionBehavior = instanceInterruptionBehavior;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsProperty#getMaxPrice}
             * @param maxPrice `CfnLaunchTemplate.SpotOptionsProperty.MaxPrice`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxPrice(java.lang.String maxPrice) {
                this.maxPrice = maxPrice;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsProperty#getSpotInstanceType}
             * @param spotInstanceType `CfnLaunchTemplate.SpotOptionsProperty.SpotInstanceType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spotInstanceType(java.lang.String spotInstanceType) {
                this.spotInstanceType = spotInstanceType;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsProperty#getValidUntil}
             * @param validUntil `CfnLaunchTemplate.SpotOptionsProperty.ValidUntil`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validUntil(java.lang.String validUntil) {
                this.validUntil = validUntil;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SpotOptionsProperty build() {
                return new Jsii$Proxy(blockDurationMinutes, instanceInterruptionBehavior, maxPrice, spotInstanceType, validUntil);
            }
        }

        /**
         * An implementation for {@link SpotOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpotOptionsProperty {
            private final java.lang.Number blockDurationMinutes;
            private final java.lang.String instanceInterruptionBehavior;
            private final java.lang.String maxPrice;
            private final java.lang.String spotInstanceType;
            private final java.lang.String validUntil;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.blockDurationMinutes = software.amazon.jsii.Kernel.get(this, "blockDurationMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.instanceInterruptionBehavior = software.amazon.jsii.Kernel.get(this, "instanceInterruptionBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.maxPrice = software.amazon.jsii.Kernel.get(this, "maxPrice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.spotInstanceType = software.amazon.jsii.Kernel.get(this, "spotInstanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.validUntil = software.amazon.jsii.Kernel.get(this, "validUntil", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Number blockDurationMinutes, final java.lang.String instanceInterruptionBehavior, final java.lang.String maxPrice, final java.lang.String spotInstanceType, final java.lang.String validUntil) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.blockDurationMinutes = blockDurationMinutes;
                this.instanceInterruptionBehavior = instanceInterruptionBehavior;
                this.maxPrice = maxPrice;
                this.spotInstanceType = spotInstanceType;
                this.validUntil = validUntil;
            }

            @Override
            public final java.lang.Number getBlockDurationMinutes() {
                return this.blockDurationMinutes;
            }

            @Override
            public final java.lang.String getInstanceInterruptionBehavior() {
                return this.instanceInterruptionBehavior;
            }

            @Override
            public final java.lang.String getMaxPrice() {
                return this.maxPrice;
            }

            @Override
            public final java.lang.String getSpotInstanceType() {
                return this.spotInstanceType;
            }

            @Override
            public final java.lang.String getValidUntil() {
                return this.validUntil;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBlockDurationMinutes() != null) {
                    data.set("blockDurationMinutes", om.valueToTree(this.getBlockDurationMinutes()));
                }
                if (this.getInstanceInterruptionBehavior() != null) {
                    data.set("instanceInterruptionBehavior", om.valueToTree(this.getInstanceInterruptionBehavior()));
                }
                if (this.getMaxPrice() != null) {
                    data.set("maxPrice", om.valueToTree(this.getMaxPrice()));
                }
                if (this.getSpotInstanceType() != null) {
                    data.set("spotInstanceType", om.valueToTree(this.getSpotInstanceType()));
                }
                if (this.getValidUntil() != null) {
                    data.set("validUntil", om.valueToTree(this.getValidUntil()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.SpotOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SpotOptionsProperty.Jsii$Proxy that = (SpotOptionsProperty.Jsii$Proxy) o;

                if (this.blockDurationMinutes != null ? !this.blockDurationMinutes.equals(that.blockDurationMinutes) : that.blockDurationMinutes != null) return false;
                if (this.instanceInterruptionBehavior != null ? !this.instanceInterruptionBehavior.equals(that.instanceInterruptionBehavior) : that.instanceInterruptionBehavior != null) return false;
                if (this.maxPrice != null ? !this.maxPrice.equals(that.maxPrice) : that.maxPrice != null) return false;
                if (this.spotInstanceType != null ? !this.spotInstanceType.equals(that.spotInstanceType) : that.spotInstanceType != null) return false;
                return this.validUntil != null ? this.validUntil.equals(that.validUntil) : that.validUntil == null;
            }

            @Override
            public final int hashCode() {
                int result = this.blockDurationMinutes != null ? this.blockDurationMinutes.hashCode() : 0;
                result = 31 * result + (this.instanceInterruptionBehavior != null ? this.instanceInterruptionBehavior.hashCode() : 0);
                result = 31 * result + (this.maxPrice != null ? this.maxPrice.hashCode() : 0);
                result = 31 * result + (this.spotInstanceType != null ? this.spotInstanceType.hashCode() : 0);
                result = 31 * result + (this.validUntil != null ? this.validUntil.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.TagSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(TagSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TagSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLaunchTemplate.TagSpecificationProperty.ResourceType`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-resourcetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceType() {
            return null;
        }

        /**
         * `CfnLaunchTemplate.TagSpecificationProperty.Tags`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-tags
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TagSpecificationProperty> {
            private java.lang.String resourceType;
            private java.util.List<software.amazon.awscdk.core.CfnTag> tags;

            /**
             * Sets the value of {@link TagSpecificationProperty#getResourceType}
             * @param resourceType `CfnLaunchTemplate.TagSpecificationProperty.ResourceType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceType(java.lang.String resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            /**
             * Sets the value of {@link TagSpecificationProperty#getTags}
             * @param tags `CfnLaunchTemplate.TagSpecificationProperty.Tags`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @SuppressWarnings("unchecked")
            public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
                this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TagSpecificationProperty build() {
                return new Jsii$Proxy(resourceType, tags);
            }
        }

        /**
         * An implementation for {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagSpecificationProperty {
            private final java.lang.String resourceType;
            private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceType = software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            protected Jsii$Proxy(final java.lang.String resourceType, final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceType = resourceType;
                this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            }

            @Override
            public final java.lang.String getResourceType() {
                return this.resourceType;
            }

            @Override
            public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
                return this.tags;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getResourceType() != null) {
                    data.set("resourceType", om.valueToTree(this.getResourceType()));
                }
                if (this.getTags() != null) {
                    data.set("tags", om.valueToTree(this.getTags()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.TagSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TagSpecificationProperty.Jsii$Proxy that = (TagSpecificationProperty.Jsii$Proxy) o;

                if (this.resourceType != null ? !this.resourceType.equals(that.resourceType) : that.resourceType != null) return false;
                return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
            }

            @Override
            public final int hashCode() {
                int result = this.resourceType != null ? this.resourceType.hashCode() : 0;
                result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnLaunchTemplate}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.CfnLaunchTemplate> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ec2.CfnLaunchTemplateProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * `AWS::EC2::LaunchTemplate.LaunchTemplateData`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-launchtemplatedata
         * @param launchTemplateData `AWS::EC2::LaunchTemplate.LaunchTemplateData`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchTemplateData(final software.amazon.awscdk.core.IResolvable launchTemplateData) {
            this.props().launchTemplateData(launchTemplateData);
            return this;
        }
        /**
         * `AWS::EC2::LaunchTemplate.LaunchTemplateData`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-launchtemplatedata
         * @param launchTemplateData `AWS::EC2::LaunchTemplate.LaunchTemplateData`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchTemplateData(final software.amazon.awscdk.services.ec2.CfnLaunchTemplate.LaunchTemplateDataProperty launchTemplateData) {
            this.props().launchTemplateData(launchTemplateData);
            return this;
        }

        /**
         * `AWS::EC2::LaunchTemplate.LaunchTemplateName`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-launchtemplatename
         * @param launchTemplateName `AWS::EC2::LaunchTemplate.LaunchTemplateName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchTemplateName(final java.lang.String launchTemplateName) {
            this.props().launchTemplateName(launchTemplateName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnLaunchTemplate}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.CfnLaunchTemplate build() {
            return new software.amazon.awscdk.services.ec2.CfnLaunchTemplate(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ec2.CfnLaunchTemplateProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ec2.CfnLaunchTemplateProps.Builder();
            }
            return this.props;
        }
    }
}
