package software.amazon.awscdk.services.ec2;

/**
 * Acl Configuration for traffic.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.17.0 (build 7d5d104)", date = "2019-09-20T09:56:18.895Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface AclTrafficConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The protocol number.
     * 
     * A value of "-1" means all protocols.
     * 
     * If you specify "-1" or a protocol number other than "6" (TCP), "17" (UDP),
     * or "1" (ICMP), traffic on all ports is allowed, regardless of any ports or
     * ICMP types or codes that you specify.
     * 
     * If you specify protocol "58" (ICMPv6) and specify an IPv4 CIDR
     * block, traffic for all ICMP types and codes allowed, regardless of any that
     * you specify. If you specify protocol "58" (ICMPv6) and specify an IPv6 CIDR
     * block, you must specify an ICMP type and code.
     * 
     * Default: 17
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.Number getProtocol();

    /**
     * The Internet Control Message Protocol (ICMP) code and type. Requirement is conditional: Required if specifying 1 (ICMP) for the protocol parameter.
     * 
     * Default: undefined
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.ec2.AclIcmp getIcmp();

    /**
     * The range of port numbers for the UDP/TCP protocol. Conditional required if specifying 6 (TCP) or 17 (UDP) for the protocol parameter.
     * 
     * Default: undefined
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.ec2.AclPortRange getPortRange();

    /**
     * @return a {@link Builder} of {@link AclTrafficConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AclTrafficConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        private java.lang.Number protocol;
        private software.amazon.awscdk.services.ec2.AclIcmp icmp;
        private software.amazon.awscdk.services.ec2.AclPortRange portRange;

        /**
         * Sets the value of Protocol
         * @param protocol The protocol number. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder protocol(java.lang.Number protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of Icmp
         * @param icmp The Internet Control Message Protocol (ICMP) code and type. Requirement is conditional: Required if specifying 1 (ICMP) for the protocol parameter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder icmp(software.amazon.awscdk.services.ec2.AclIcmp icmp) {
            this.icmp = icmp;
            return this;
        }

        /**
         * Sets the value of PortRange
         * @param portRange The range of port numbers for the UDP/TCP protocol. Conditional required if specifying 6 (TCP) or 17 (UDP) for the protocol parameter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder portRange(software.amazon.awscdk.services.ec2.AclPortRange portRange) {
            this.portRange = portRange;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AclTrafficConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public AclTrafficConfig build() {
            return new Jsii$Proxy(protocol, icmp, portRange);
        }
    }

    /**
     * An implementation for {@link AclTrafficConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AclTrafficConfig {
        private final java.lang.Number protocol;
        private final software.amazon.awscdk.services.ec2.AclIcmp icmp;
        private final software.amazon.awscdk.services.ec2.AclPortRange portRange;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.protocol = this.jsiiGet("protocol", java.lang.Number.class);
            this.icmp = this.jsiiGet("icmp", software.amazon.awscdk.services.ec2.AclIcmp.class);
            this.portRange = this.jsiiGet("portRange", software.amazon.awscdk.services.ec2.AclPortRange.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.Number protocol, software.amazon.awscdk.services.ec2.AclIcmp icmp, software.amazon.awscdk.services.ec2.AclPortRange portRange) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.protocol = java.util.Objects.requireNonNull(protocol, "protocol is required");
            this.icmp = icmp;
            this.portRange = portRange;
        }

        @Override
        public java.lang.Number getProtocol() {
            return this.protocol;
        }

        @Override
        public software.amazon.awscdk.services.ec2.AclIcmp getIcmp() {
            return this.icmp;
        }

        @Override
        public software.amazon.awscdk.services.ec2.AclPortRange getPortRange() {
            return this.portRange;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("protocol", om.valueToTree(this.getProtocol()));
            if (this.getIcmp() != null) {
                obj.set("icmp", om.valueToTree(this.getIcmp()));
            }
            if (this.getPortRange() != null) {
                obj.set("portRange", om.valueToTree(this.getPortRange()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AclTrafficConfig.Jsii$Proxy that = (AclTrafficConfig.Jsii$Proxy) o;

            if (!protocol.equals(that.protocol)) return false;
            if (this.icmp != null ? !this.icmp.equals(that.icmp) : that.icmp != null) return false;
            return this.portRange != null ? this.portRange.equals(that.portRange) : that.portRange == null;
        }

        @Override
        public int hashCode() {
            int result = this.protocol.hashCode();
            result = 31 * result + (this.icmp != null ? this.icmp.hashCode() : 0);
            result = 31 * result + (this.portRange != null ? this.portRange.hashCode() : 0);
            return result;
        }
    }
}
