package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::ClientVpnRoute`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.17.0 (build 7d5d104)", date = "2019-09-20T09:56:18.908Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnClientVpnRouteProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::EC2::ClientVpnRoute.ClientVpnEndpointId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html#cfn-ec2-clientvpnroute-clientvpnendpointid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getClientVpnEndpointId();

    /**
     * `AWS::EC2::ClientVpnRoute.DestinationCidrBlock`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html#cfn-ec2-clientvpnroute-destinationcidrblock
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getDestinationCidrBlock();

    /**
     * `AWS::EC2::ClientVpnRoute.TargetVpcSubnetId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html#cfn-ec2-clientvpnroute-targetvpcsubnetid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getTargetVpcSubnetId();

    /**
     * `AWS::EC2::ClientVpnRoute.Description`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html#cfn-ec2-clientvpnroute-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getDescription();

    /**
     * @return a {@link Builder} of {@link CfnClientVpnRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnClientVpnRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.String clientVpnEndpointId;
        private java.lang.String destinationCidrBlock;
        private java.lang.String targetVpcSubnetId;
        private java.lang.String description;

        /**
         * Sets the value of ClientVpnEndpointId
         * @param clientVpnEndpointId `AWS::EC2::ClientVpnRoute.ClientVpnEndpointId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder clientVpnEndpointId(java.lang.String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
            return this;
        }

        /**
         * Sets the value of DestinationCidrBlock
         * @param destinationCidrBlock `AWS::EC2::ClientVpnRoute.DestinationCidrBlock`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder destinationCidrBlock(java.lang.String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        /**
         * Sets the value of TargetVpcSubnetId
         * @param targetVpcSubnetId `AWS::EC2::ClientVpnRoute.TargetVpcSubnetId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder targetVpcSubnetId(java.lang.String targetVpcSubnetId) {
            this.targetVpcSubnetId = targetVpcSubnetId;
            return this;
        }

        /**
         * Sets the value of Description
         * @param description `AWS::EC2::ClientVpnRoute.Description`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnClientVpnRouteProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnClientVpnRouteProps build() {
            return new Jsii$Proxy(clientVpnEndpointId, destinationCidrBlock, targetVpcSubnetId, description);
        }
    }

    /**
     * An implementation for {@link CfnClientVpnRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnClientVpnRouteProps {
        private final java.lang.String clientVpnEndpointId;
        private final java.lang.String destinationCidrBlock;
        private final java.lang.String targetVpcSubnetId;
        private final java.lang.String description;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.clientVpnEndpointId = this.jsiiGet("clientVpnEndpointId", java.lang.String.class);
            this.destinationCidrBlock = this.jsiiGet("destinationCidrBlock", java.lang.String.class);
            this.targetVpcSubnetId = this.jsiiGet("targetVpcSubnetId", java.lang.String.class);
            this.description = this.jsiiGet("description", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String clientVpnEndpointId, java.lang.String destinationCidrBlock, java.lang.String targetVpcSubnetId, java.lang.String description) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clientVpnEndpointId = java.util.Objects.requireNonNull(clientVpnEndpointId, "clientVpnEndpointId is required");
            this.destinationCidrBlock = java.util.Objects.requireNonNull(destinationCidrBlock, "destinationCidrBlock is required");
            this.targetVpcSubnetId = java.util.Objects.requireNonNull(targetVpcSubnetId, "targetVpcSubnetId is required");
            this.description = description;
        }

        @Override
        public java.lang.String getClientVpnEndpointId() {
            return this.clientVpnEndpointId;
        }

        @Override
        public java.lang.String getDestinationCidrBlock() {
            return this.destinationCidrBlock;
        }

        @Override
        public java.lang.String getTargetVpcSubnetId() {
            return this.targetVpcSubnetId;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("clientVpnEndpointId", om.valueToTree(this.getClientVpnEndpointId()));
            obj.set("destinationCidrBlock", om.valueToTree(this.getDestinationCidrBlock()));
            obj.set("targetVpcSubnetId", om.valueToTree(this.getTargetVpcSubnetId()));
            if (this.getDescription() != null) {
                obj.set("description", om.valueToTree(this.getDescription()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnClientVpnRouteProps.Jsii$Proxy that = (CfnClientVpnRouteProps.Jsii$Proxy) o;

            if (!clientVpnEndpointId.equals(that.clientVpnEndpointId)) return false;
            if (!destinationCidrBlock.equals(that.destinationCidrBlock)) return false;
            if (!targetVpcSubnetId.equals(that.targetVpcSubnetId)) return false;
            return this.description != null ? this.description.equals(that.description) : that.description == null;
        }

        @Override
        public int hashCode() {
            int result = this.clientVpnEndpointId.hashCode();
            result = 31 * result + (this.destinationCidrBlock.hashCode());
            result = 31 * result + (this.targetVpcSubnetId.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            return result;
        }
    }
}
